// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/vision/v1/product_search_service.proto

#include "google/cloud/vision/v1/product_search_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace vision_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

ProductSearchConnectionIdempotencyPolicy::
    ~ProductSearchConnectionIdempotencyPolicy() = default;

std::unique_ptr<ProductSearchConnectionIdempotencyPolicy>
ProductSearchConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<ProductSearchConnectionIdempotencyPolicy>(*this);
}

Idempotency ProductSearchConnectionIdempotencyPolicy::CreateProductSet(
    google::cloud::vision::v1::CreateProductSetRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ProductSearchConnectionIdempotencyPolicy::ListProductSets(
    google::cloud::vision::v1::ListProductSetsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency ProductSearchConnectionIdempotencyPolicy::GetProductSet(
    google::cloud::vision::v1::GetProductSetRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency ProductSearchConnectionIdempotencyPolicy::UpdateProductSet(
    google::cloud::vision::v1::UpdateProductSetRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ProductSearchConnectionIdempotencyPolicy::DeleteProductSet(
    google::cloud::vision::v1::DeleteProductSetRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ProductSearchConnectionIdempotencyPolicy::CreateProduct(
    google::cloud::vision::v1::CreateProductRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ProductSearchConnectionIdempotencyPolicy::ListProducts(
    google::cloud::vision::v1::ListProductsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency ProductSearchConnectionIdempotencyPolicy::GetProduct(
    google::cloud::vision::v1::GetProductRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency ProductSearchConnectionIdempotencyPolicy::UpdateProduct(
    google::cloud::vision::v1::UpdateProductRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ProductSearchConnectionIdempotencyPolicy::DeleteProduct(
    google::cloud::vision::v1::DeleteProductRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ProductSearchConnectionIdempotencyPolicy::CreateReferenceImage(
    google::cloud::vision::v1::CreateReferenceImageRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ProductSearchConnectionIdempotencyPolicy::DeleteReferenceImage(
    google::cloud::vision::v1::DeleteReferenceImageRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ProductSearchConnectionIdempotencyPolicy::ListReferenceImages(
    google::cloud::vision::v1::ListReferenceImagesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency ProductSearchConnectionIdempotencyPolicy::GetReferenceImage(
    google::cloud::vision::v1::GetReferenceImageRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency ProductSearchConnectionIdempotencyPolicy::AddProductToProductSet(
    google::cloud::vision::v1::AddProductToProductSetRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
ProductSearchConnectionIdempotencyPolicy::RemoveProductFromProductSet(
    google::cloud::vision::v1::RemoveProductFromProductSetRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ProductSearchConnectionIdempotencyPolicy::ListProductsInProductSet(
    google::cloud::vision::v1::ListProductsInProductSetRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency ProductSearchConnectionIdempotencyPolicy::ImportProductSets(
    google::cloud::vision::v1::ImportProductSetsRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ProductSearchConnectionIdempotencyPolicy::PurgeProducts(
    google::cloud::vision::v1::PurgeProductsRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ProductSearchConnectionIdempotencyPolicy::GetOperation(
    google::longrunning::GetOperationRequest const&) {
  return Idempotency::kIdempotent;
}

std::unique_ptr<ProductSearchConnectionIdempotencyPolicy>
MakeDefaultProductSearchConnectionIdempotencyPolicy() {
  return std::make_unique<ProductSearchConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace vision_v1
}  // namespace cloud
}  // namespace google
