// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/vision/v1/product_search_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_VISION_V1_PRODUCT_SEARCH_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_VISION_V1_PRODUCT_SEARCH_CLIENT_H

#include "google/cloud/vision/v1/product_search_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace vision_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Manages Products and ProductSets of reference images for use in product
/// search. It uses the following resource model:
///
/// - The API has a collection of
/// [ProductSet][google.cloud.vision.v1.ProductSet] resources, named
/// `projects/*/locations/*/productSets/*`, which acts as a way to put different
/// products into groups to limit identification.
///
/// In parallel,
///
/// - The API has a collection of [Product][google.cloud.vision.v1.Product]
/// resources, named
///   `projects/*/locations/*/products/*`
///
/// - Each [Product][google.cloud.vision.v1.Product] has a collection of
/// [ReferenceImage][google.cloud.vision.v1.ReferenceImage] resources, named
///   `projects/*/locations/*/products/*/referenceImages/*`
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
/// [google.cloud.vision.v1.Product]:
/// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L378}
/// [google.cloud.vision.v1.ProductSet]:
/// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L437}
/// [google.cloud.vision.v1.ReferenceImage]:
/// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L473}
///
class ProductSearchClient {
 public:
  explicit ProductSearchClient(
      std::shared_ptr<ProductSearchConnection> connection, Options opts = {});
  ~ProductSearchClient();

  ///@{
  /// @name Copy and move support
  ProductSearchClient(ProductSearchClient const&) = default;
  ProductSearchClient& operator=(ProductSearchClient const&) = default;
  ProductSearchClient(ProductSearchClient&&) = default;
  ProductSearchClient& operator=(ProductSearchClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(ProductSearchClient const& a,
                         ProductSearchClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(ProductSearchClient const& a,
                         ProductSearchClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Creates and returns a new ProductSet resource.
  ///
  /// Possible errors:
  ///
  /// * Returns INVALID_ARGUMENT if display_name is missing, or is longer than
  ///   4096 characters.
  ///
  /// @param parent  Required. The project in which the ProductSet should be created.
  ///  @n
  ///  Format is `projects/PROJECT_ID/locations/LOC_ID`.
  /// @param product_set  Required. The ProductSet to create.
  /// @param product_set_id  A user-supplied resource id for this ProductSet. If set, the server will
  ///  attempt to use this value as the resource id. If it is already in use, an
  ///  error is returned with code ALREADY_EXISTS. Must be at most 128 characters
  ///  long. It cannot contain the character `/`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vision.v1.ProductSet])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vision.v1.CreateProductSetRequest]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L596}
  /// [google.cloud.vision.v1.ProductSet]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L437}
  ///
  // clang-format on
  StatusOr<google::cloud::vision::v1::ProductSet> CreateProductSet(
      std::string const& parent,
      google::cloud::vision::v1::ProductSet const& product_set,
      std::string const& product_set_id, Options opts = {});

  // clang-format off
  ///
  /// Creates and returns a new ProductSet resource.
  ///
  /// Possible errors:
  ///
  /// * Returns INVALID_ARGUMENT if display_name is missing, or is longer than
  ///   4096 characters.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vision.v1.CreateProductSetRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vision.v1.ProductSet])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vision.v1.CreateProductSetRequest]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L596}
  /// [google.cloud.vision.v1.ProductSet]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L437}
  ///
  // clang-format on
  StatusOr<google::cloud::vision::v1::ProductSet> CreateProductSet(
      google::cloud::vision::v1::CreateProductSetRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists ProductSets in an unspecified order.
  ///
  /// Possible errors:
  ///
  /// * Returns INVALID_ARGUMENT if page_size is greater than 100, or less
  ///   than 1.
  ///
  /// @param parent  Required. The project from which ProductSets should be listed.
  ///  @n
  ///  Format is `projects/PROJECT_ID/locations/LOC_ID`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.vision.v1.ProductSet], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vision.v1.ListProductSetsRequest]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L618}
  /// [google.cloud.vision.v1.ProductSet]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L437}
  ///
  // clang-format on
  StreamRange<google::cloud::vision::v1::ProductSet> ListProductSets(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists ProductSets in an unspecified order.
  ///
  /// Possible errors:
  ///
  /// * Returns INVALID_ARGUMENT if page_size is greater than 100, or less
  ///   than 1.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vision.v1.ListProductSetsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.vision.v1.ProductSet], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vision.v1.ListProductSetsRequest]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L618}
  /// [google.cloud.vision.v1.ProductSet]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L437}
  ///
  // clang-format on
  StreamRange<google::cloud::vision::v1::ProductSet> ListProductSets(
      google::cloud::vision::v1::ListProductSetsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets information associated with a ProductSet.
  ///
  /// Possible errors:
  ///
  /// * Returns NOT_FOUND if the ProductSet does not exist.
  ///
  /// @param name  Required. Resource name of the ProductSet to get.
  ///  @n
  ///  Format is:
  ///  `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vision.v1.ProductSet])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vision.v1.GetProductSetRequest]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L647}
  /// [google.cloud.vision.v1.ProductSet]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L437}
  ///
  // clang-format on
  StatusOr<google::cloud::vision::v1::ProductSet> GetProductSet(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets information associated with a ProductSet.
  ///
  /// Possible errors:
  ///
  /// * Returns NOT_FOUND if the ProductSet does not exist.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vision.v1.GetProductSetRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vision.v1.ProductSet])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vision.v1.GetProductSetRequest]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L647}
  /// [google.cloud.vision.v1.ProductSet]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L437}
  ///
  // clang-format on
  StatusOr<google::cloud::vision::v1::ProductSet> GetProductSet(
      google::cloud::vision::v1::GetProductSetRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Makes changes to a ProductSet resource.
  /// Only display_name can be updated currently.
  ///
  /// Possible errors:
  ///
  /// * Returns NOT_FOUND if the ProductSet does not exist.
  /// * Returns INVALID_ARGUMENT if display_name is present in update_mask but
  ///   missing from the request or longer than 4096 characters.
  ///
  /// @param product_set  Required. The ProductSet resource which replaces the one on the server.
  /// @param update_mask  The [FieldMask][google.protobuf.FieldMask] that specifies which fields to
  ///  update.
  ///  If update_mask isn't specified, all mutable fields are to be updated.
  ///  Valid mask path is `display_name`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vision.v1.ProductSet])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vision.v1.ProductSet]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L437}
  /// [google.cloud.vision.v1.UpdateProductSetRequest]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L661}
  /// [google.protobuf.FieldMask]: @googleapis_reference_link{google/protobuf/field_mask.proto#L242}
  ///
  // clang-format on
  StatusOr<google::cloud::vision::v1::ProductSet> UpdateProductSet(
      google::cloud::vision::v1::ProductSet const& product_set,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Makes changes to a ProductSet resource.
  /// Only display_name can be updated currently.
  ///
  /// Possible errors:
  ///
  /// * Returns NOT_FOUND if the ProductSet does not exist.
  /// * Returns INVALID_ARGUMENT if display_name is present in update_mask but
  ///   missing from the request or longer than 4096 characters.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vision.v1.UpdateProductSetRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vision.v1.ProductSet])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vision.v1.ProductSet]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L437}
  /// [google.cloud.vision.v1.UpdateProductSetRequest]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L661}
  ///
  // clang-format on
  StatusOr<google::cloud::vision::v1::ProductSet> UpdateProductSet(
      google::cloud::vision::v1::UpdateProductSetRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Permanently deletes a ProductSet. Products and ReferenceImages in the
  /// ProductSet are not deleted.
  ///
  /// The actual image files are not deleted from Google Cloud Storage.
  ///
  /// @param name  Required. Resource name of the ProductSet to delete.
  ///  @n
  ///  Format is:
  ///  `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vision.v1.DeleteProductSetRequest]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L673}
  ///
  // clang-format on
  Status DeleteProductSet(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Permanently deletes a ProductSet. Products and ReferenceImages in the
  /// ProductSet are not deleted.
  ///
  /// The actual image files are not deleted from Google Cloud Storage.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vision.v1.DeleteProductSetRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vision.v1.DeleteProductSetRequest]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L673}
  ///
  // clang-format on
  Status DeleteProductSet(
      google::cloud::vision::v1::DeleteProductSetRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates and returns a new product resource.
  ///
  /// Possible errors:
  ///
  /// * Returns INVALID_ARGUMENT if display_name is missing or longer than 4096
  ///   characters.
  /// * Returns INVALID_ARGUMENT if description is longer than 4096 characters.
  /// * Returns INVALID_ARGUMENT if product_category is missing or invalid.
  ///
  /// @param parent  Required. The project in which the Product should be created.
  ///  @n
  ///  Format is
  ///  `projects/PROJECT_ID/locations/LOC_ID`.
  /// @param product  Required. The product to create.
  /// @param product_id  A user-supplied resource id for this Product. If set, the server will
  ///  attempt to use this value as the resource id. If it is already in use, an
  ///  error is returned with code ALREADY_EXISTS. Must be at most 128 characters
  ///  long. It cannot contain the character `/`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vision.v1.Product])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vision.v1.CreateProductRequest]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L505}
  /// [google.cloud.vision.v1.Product]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L378}
  ///
  // clang-format on
  StatusOr<google::cloud::vision::v1::Product> CreateProduct(
      std::string const& parent,
      google::cloud::vision::v1::Product const& product,
      std::string const& product_id, Options opts = {});

  // clang-format off
  ///
  /// Creates and returns a new product resource.
  ///
  /// Possible errors:
  ///
  /// * Returns INVALID_ARGUMENT if display_name is missing or longer than 4096
  ///   characters.
  /// * Returns INVALID_ARGUMENT if description is longer than 4096 characters.
  /// * Returns INVALID_ARGUMENT if product_category is missing or invalid.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vision.v1.CreateProductRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vision.v1.Product])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vision.v1.CreateProductRequest]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L505}
  /// [google.cloud.vision.v1.Product]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L378}
  ///
  // clang-format on
  StatusOr<google::cloud::vision::v1::Product> CreateProduct(
      google::cloud::vision::v1::CreateProductRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists products in an unspecified order.
  ///
  /// Possible errors:
  ///
  /// * Returns INVALID_ARGUMENT if page_size is greater than 100 or less than 1.
  ///
  /// @param parent  Required. The project OR ProductSet from which Products should be listed.
  ///  @n
  ///  Format:
  ///  `projects/PROJECT_ID/locations/LOC_ID`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.vision.v1.Product], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vision.v1.ListProductsRequest]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L528}
  /// [google.cloud.vision.v1.Product]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L378}
  ///
  // clang-format on
  StreamRange<google::cloud::vision::v1::Product> ListProducts(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists products in an unspecified order.
  ///
  /// Possible errors:
  ///
  /// * Returns INVALID_ARGUMENT if page_size is greater than 100 or less than 1.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vision.v1.ListProductsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.vision.v1.Product], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vision.v1.ListProductsRequest]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L528}
  /// [google.cloud.vision.v1.Product]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L378}
  ///
  // clang-format on
  StreamRange<google::cloud::vision::v1::Product> ListProducts(
      google::cloud::vision::v1::ListProductsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets information associated with a Product.
  ///
  /// Possible errors:
  ///
  /// * Returns NOT_FOUND if the Product does not exist.
  ///
  /// @param name  Required. Resource name of the Product to get.
  ///  @n
  ///  Format is:
  ///  `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vision.v1.Product])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vision.v1.GetProductRequest]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L558}
  /// [google.cloud.vision.v1.Product]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L378}
  ///
  // clang-format on
  StatusOr<google::cloud::vision::v1::Product> GetProduct(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets information associated with a Product.
  ///
  /// Possible errors:
  ///
  /// * Returns NOT_FOUND if the Product does not exist.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vision.v1.GetProductRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vision.v1.Product])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vision.v1.GetProductRequest]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L558}
  /// [google.cloud.vision.v1.Product]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L378}
  ///
  // clang-format on
  StatusOr<google::cloud::vision::v1::Product> GetProduct(
      google::cloud::vision::v1::GetProductRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Makes changes to a Product resource.
  /// Only the `display_name`, `description`, and `labels` fields can be updated
  /// right now.
  ///
  /// If labels are updated, the change will not be reflected in queries until
  /// the next index time.
  ///
  /// Possible errors:
  ///
  /// * Returns NOT_FOUND if the Product does not exist.
  /// * Returns INVALID_ARGUMENT if display_name is present in update_mask but is
  ///   missing from the request or longer than 4096 characters.
  /// * Returns INVALID_ARGUMENT if description is present in update_mask but is
  ///   longer than 4096 characters.
  /// * Returns INVALID_ARGUMENT if product_category is present in update_mask.
  ///
  /// @param product  Required. The Product resource which replaces the one on the server.
  ///  product.name is immutable.
  /// @param update_mask  The [FieldMask][google.protobuf.FieldMask] that specifies which fields
  ///  to update.
  ///  If update_mask isn't specified, all mutable fields are to be updated.
  ///  Valid mask paths include `product_labels`, `display_name`, and
  ///  `description`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vision.v1.Product])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vision.v1.Product]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L378}
  /// [google.cloud.vision.v1.UpdateProductRequest]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L570}
  /// [google.protobuf.FieldMask]: @googleapis_reference_link{google/protobuf/field_mask.proto#L242}
  ///
  // clang-format on
  StatusOr<google::cloud::vision::v1::Product> UpdateProduct(
      google::cloud::vision::v1::Product const& product,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Makes changes to a Product resource.
  /// Only the `display_name`, `description`, and `labels` fields can be updated
  /// right now.
  ///
  /// If labels are updated, the change will not be reflected in queries until
  /// the next index time.
  ///
  /// Possible errors:
  ///
  /// * Returns NOT_FOUND if the Product does not exist.
  /// * Returns INVALID_ARGUMENT if display_name is present in update_mask but is
  ///   missing from the request or longer than 4096 characters.
  /// * Returns INVALID_ARGUMENT if description is present in update_mask but is
  ///   longer than 4096 characters.
  /// * Returns INVALID_ARGUMENT if product_category is present in update_mask.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vision.v1.UpdateProductRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vision.v1.Product])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vision.v1.Product]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L378}
  /// [google.cloud.vision.v1.UpdateProductRequest]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L570}
  ///
  // clang-format on
  StatusOr<google::cloud::vision::v1::Product> UpdateProduct(
      google::cloud::vision::v1::UpdateProductRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Permanently deletes a product and its reference images.
  ///
  /// Metadata of the product and all its images will be deleted right away, but
  /// search queries against ProductSets containing the product may still work
  /// until all related caches are refreshed.
  ///
  /// @param name  Required. Resource name of product to delete.
  ///  @n
  ///  Format is:
  ///  `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vision.v1.DeleteProductRequest]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L584}
  ///
  // clang-format on
  Status DeleteProduct(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Permanently deletes a product and its reference images.
  ///
  /// Metadata of the product and all its images will be deleted right away, but
  /// search queries against ProductSets containing the product may still work
  /// until all related caches are refreshed.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vision.v1.DeleteProductRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vision.v1.DeleteProductRequest]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L584}
  ///
  // clang-format on
  Status DeleteProduct(
      google::cloud::vision::v1::DeleteProductRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates and returns a new ReferenceImage resource.
  ///
  /// The `bounding_poly` field is optional. If `bounding_poly` is not specified,
  /// the system will try to detect regions of interest in the image that are
  /// compatible with the product_category on the parent product. If it is
  /// specified, detection is ALWAYS skipped. The system converts polygons into
  /// non-rotated rectangles.
  ///
  /// Note that the pipeline will resize the image if the image resolution is too
  /// large to process (above 50MP).
  ///
  /// Possible errors:
  ///
  /// * Returns INVALID_ARGUMENT if the image_uri is missing or longer than 4096
  ///   characters.
  /// * Returns INVALID_ARGUMENT if the product does not exist.
  /// * Returns INVALID_ARGUMENT if bounding_poly is not provided, and nothing
  ///   compatible with the parent product's product_category is detected.
  /// * Returns INVALID_ARGUMENT if bounding_poly contains more than 10 polygons.
  ///
  /// @param parent  Required. Resource name of the product in which to create the reference
  ///  image.
  ///  @n
  ///  Format is
  ///  `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`.
  /// @param reference_image  Required. The reference image to create.
  ///  If an image ID is specified, it is ignored.
  /// @param reference_image_id  A user-supplied resource id for the ReferenceImage to be added. If set,
  ///  the server will attempt to use this value as the resource id. If it is
  ///  already in use, an error is returned with code ALREADY_EXISTS. Must be at
  ///  most 128 characters long. It cannot contain the character `/`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vision.v1.ReferenceImage])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vision.v1.CreateReferenceImageRequest]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L687}
  /// [google.cloud.vision.v1.ReferenceImage]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L473}
  ///
  // clang-format on
  StatusOr<google::cloud::vision::v1::ReferenceImage> CreateReferenceImage(
      std::string const& parent,
      google::cloud::vision::v1::ReferenceImage const& reference_image,
      std::string const& reference_image_id, Options opts = {});

  // clang-format off
  ///
  /// Creates and returns a new ReferenceImage resource.
  ///
  /// The `bounding_poly` field is optional. If `bounding_poly` is not specified,
  /// the system will try to detect regions of interest in the image that are
  /// compatible with the product_category on the parent product. If it is
  /// specified, detection is ALWAYS skipped. The system converts polygons into
  /// non-rotated rectangles.
  ///
  /// Note that the pipeline will resize the image if the image resolution is too
  /// large to process (above 50MP).
  ///
  /// Possible errors:
  ///
  /// * Returns INVALID_ARGUMENT if the image_uri is missing or longer than 4096
  ///   characters.
  /// * Returns INVALID_ARGUMENT if the product does not exist.
  /// * Returns INVALID_ARGUMENT if bounding_poly is not provided, and nothing
  ///   compatible with the parent product's product_category is detected.
  /// * Returns INVALID_ARGUMENT if bounding_poly contains more than 10 polygons.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vision.v1.CreateReferenceImageRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vision.v1.ReferenceImage])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vision.v1.CreateReferenceImageRequest]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L687}
  /// [google.cloud.vision.v1.ReferenceImage]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L473}
  ///
  // clang-format on
  StatusOr<google::cloud::vision::v1::ReferenceImage> CreateReferenceImage(
      google::cloud::vision::v1::CreateReferenceImageRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Permanently deletes a reference image.
  ///
  /// The image metadata will be deleted right away, but search queries
  /// against ProductSets containing the image may still work until all related
  /// caches are refreshed.
  ///
  /// The actual image files are not deleted from Google Cloud Storage.
  ///
  /// @param name  Required. The resource name of the reference image to delete.
  ///  @n
  ///  Format is:
  ///  `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID/referenceImages/IMAGE_ID`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vision.v1.DeleteReferenceImageRequest]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L757}
  ///
  // clang-format on
  Status DeleteReferenceImage(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Permanently deletes a reference image.
  ///
  /// The image metadata will be deleted right away, but search queries
  /// against ProductSets containing the image may still work until all related
  /// caches are refreshed.
  ///
  /// The actual image files are not deleted from Google Cloud Storage.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vision.v1.DeleteReferenceImageRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vision.v1.DeleteReferenceImageRequest]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L757}
  ///
  // clang-format on
  Status DeleteReferenceImage(
      google::cloud::vision::v1::DeleteReferenceImageRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists reference images.
  ///
  /// Possible errors:
  ///
  /// * Returns NOT_FOUND if the parent product does not exist.
  /// * Returns INVALID_ARGUMENT if the page_size is greater than 100, or less
  ///   than 1.
  ///
  /// @param parent  Required. Resource name of the product containing the reference images.
  ///  @n
  ///  Format is
  ///  `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.vision.v1.ReferenceImage], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vision.v1.ListReferenceImagesRequest]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L710}
  /// [google.cloud.vision.v1.ReferenceImage]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L473}
  ///
  // clang-format on
  StreamRange<google::cloud::vision::v1::ReferenceImage> ListReferenceImages(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists reference images.
  ///
  /// Possible errors:
  ///
  /// * Returns NOT_FOUND if the parent product does not exist.
  /// * Returns INVALID_ARGUMENT if the page_size is greater than 100, or less
  ///   than 1.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vision.v1.ListReferenceImagesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.vision.v1.ReferenceImage], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vision.v1.ListReferenceImagesRequest]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L710}
  /// [google.cloud.vision.v1.ReferenceImage]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L473}
  ///
  // clang-format on
  StreamRange<google::cloud::vision::v1::ReferenceImage> ListReferenceImages(
      google::cloud::vision::v1::ListReferenceImagesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets information associated with a ReferenceImage.
  ///
  /// Possible errors:
  ///
  /// * Returns NOT_FOUND if the specified image does not exist.
  ///
  /// @param name  Required. The resource name of the ReferenceImage to get.
  ///  @n
  ///  Format is:
  ///  `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID/referenceImages/IMAGE_ID`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vision.v1.ReferenceImage])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vision.v1.GetReferenceImageRequest]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L743}
  /// [google.cloud.vision.v1.ReferenceImage]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L473}
  ///
  // clang-format on
  StatusOr<google::cloud::vision::v1::ReferenceImage> GetReferenceImage(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets information associated with a ReferenceImage.
  ///
  /// Possible errors:
  ///
  /// * Returns NOT_FOUND if the specified image does not exist.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vision.v1.GetReferenceImageRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.vision.v1.ReferenceImage])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vision.v1.GetReferenceImageRequest]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L743}
  /// [google.cloud.vision.v1.ReferenceImage]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L473}
  ///
  // clang-format on
  StatusOr<google::cloud::vision::v1::ReferenceImage> GetReferenceImage(
      google::cloud::vision::v1::GetReferenceImageRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Adds a Product to the specified ProductSet. If the Product is already
  /// present, no change is made.
  ///
  /// One Product can be added to at most 100 ProductSets.
  ///
  /// Possible errors:
  ///
  /// * Returns NOT_FOUND if the Product or the ProductSet doesn't exist.
  ///
  /// @param name  Required. The resource name for the ProductSet to modify.
  ///  @n
  ///  Format is:
  ///  `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`
  /// @param product  Required. The resource name for the Product to be added to this ProductSet.
  ///  @n
  ///  Format is:
  ///  `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vision.v1.AddProductToProductSetRequest]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L771}
  ///
  // clang-format on
  Status AddProductToProductSet(std::string const& name,
                                std::string const& product, Options opts = {});

  // clang-format off
  ///
  /// Adds a Product to the specified ProductSet. If the Product is already
  /// present, no change is made.
  ///
  /// One Product can be added to at most 100 ProductSets.
  ///
  /// Possible errors:
  ///
  /// * Returns NOT_FOUND if the Product or the ProductSet doesn't exist.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vision.v1.AddProductToProductSetRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vision.v1.AddProductToProductSetRequest]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L771}
  ///
  // clang-format on
  Status AddProductToProductSet(
      google::cloud::vision::v1::AddProductToProductSetRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Removes a Product from the specified ProductSet.
  ///
  /// @param name  Required. The resource name for the ProductSet to modify.
  ///  @n
  ///  Format is:
  ///  `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`
  /// @param product  Required. The resource name for the Product to be removed from this
  ///  ProductSet.
  ///  @n
  ///  Format is:
  ///  `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vision.v1.RemoveProductFromProductSetRequest]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L794}
  ///
  // clang-format on
  Status RemoveProductFromProductSet(std::string const& name,
                                     std::string const& product,
                                     Options opts = {});

  // clang-format off
  ///
  /// Removes a Product from the specified ProductSet.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vision.v1.RemoveProductFromProductSetRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vision.v1.RemoveProductFromProductSetRequest]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L794}
  ///
  // clang-format on
  Status RemoveProductFromProductSet(
      google::cloud::vision::v1::RemoveProductFromProductSetRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists the Products in a ProductSet, in an unspecified order. If the
  /// ProductSet does not exist, the products field of the response will be
  /// empty.
  ///
  /// Possible errors:
  ///
  /// * Returns INVALID_ARGUMENT if page_size is greater than 100 or less than 1.
  ///
  /// @param name  Required. The ProductSet resource for which to retrieve Products.
  ///  @n
  ///  Format is:
  ///  `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.vision.v1.Product], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vision.v1.ListProductsInProductSetRequest]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L818}
  /// [google.cloud.vision.v1.Product]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L378}
  ///
  // clang-format on
  StreamRange<google::cloud::vision::v1::Product> ListProductsInProductSet(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Lists the Products in a ProductSet, in an unspecified order. If the
  /// ProductSet does not exist, the products field of the response will be
  /// empty.
  ///
  /// Possible errors:
  ///
  /// * Returns INVALID_ARGUMENT if page_size is greater than 100 or less than 1.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vision.v1.ListProductsInProductSetRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.vision.v1.Product], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vision.v1.ListProductsInProductSetRequest]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L818}
  /// [google.cloud.vision.v1.Product]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L378}
  ///
  // clang-format on
  StreamRange<google::cloud::vision::v1::Product> ListProductsInProductSet(
      google::cloud::vision::v1::ListProductsInProductSetRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Asynchronous API that imports a list of reference images to specified
  /// product sets based on a list of image information.
  ///
  /// The [google.longrunning.Operation][google.longrunning.Operation] API can be
  /// used to keep track of the progress and results of the request.
  /// `Operation.metadata` contains `BatchOperationMetadata`. (progress)
  /// `Operation.response` contains `ImportProductSetsResponse`. (results)
  ///
  /// The input source of this method is a csv file on Google Cloud Storage.
  /// For the format of the csv file please see
  /// [ImportProductSetsGcsSource.csv_file_uri][google.cloud.vision.v1.ImportProductSetsGcsSource.csv_file_uri].
  ///
  /// @param parent  Required. The project in which the ProductSets should be imported.
  ///  @n
  ///  Format is `projects/PROJECT_ID/locations/LOC_ID`.
  /// @param input_config  Required. The input content for the list of requests.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vision.v1.ImportProductSetsResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vision.v1.ImportProductSetsGcsSource.csv_file_uri]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L913}
  /// [google.cloud.vision.v1.ImportProductSetsRequest]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L927}
  /// [google.cloud.vision.v1.ImportProductSetsResponse]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L950}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vision::v1::ImportProductSetsResponse>>
  ImportProductSets(
      std::string const& parent,
      google::cloud::vision::v1::ImportProductSetsInputConfig const&
          input_config,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief ImportProductSets
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> ImportProductSets(
      NoAwaitTag, std::string const& parent,
      google::cloud::vision::v1::ImportProductSetsInputConfig const&
          input_config,
      Options opts = {});

  // clang-format off
  ///
  /// Asynchronous API that imports a list of reference images to specified
  /// product sets based on a list of image information.
  ///
  /// The [google.longrunning.Operation][google.longrunning.Operation] API can be
  /// used to keep track of the progress and results of the request.
  /// `Operation.metadata` contains `BatchOperationMetadata`. (progress)
  /// `Operation.response` contains `ImportProductSetsResponse`. (results)
  ///
  /// The input source of this method is a csv file on Google Cloud Storage.
  /// For the format of the csv file please see
  /// [ImportProductSetsGcsSource.csv_file_uri][google.cloud.vision.v1.ImportProductSetsGcsSource.csv_file_uri].
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vision.v1.ImportProductSetsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vision.v1.ImportProductSetsResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vision.v1.ImportProductSetsGcsSource.csv_file_uri]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L913}
  /// [google.cloud.vision.v1.ImportProductSetsRequest]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L927}
  /// [google.cloud.vision.v1.ImportProductSetsResponse]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L950}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vision::v1::ImportProductSetsResponse>>
  ImportProductSets(
      google::cloud::vision::v1::ImportProductSetsRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief ImportProductSets
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> ImportProductSets(
      NoAwaitTag,
      google::cloud::vision::v1::ImportProductSetsRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief ImportProductSets
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::vision::v1::ImportProductSetsResponse>>
  ImportProductSets(google::longrunning::Operation const& operation,
                    Options opts = {});

  // clang-format off
  ///
  /// Asynchronous API to delete all Products in a ProductSet or all Products
  /// that are in no ProductSet.
  ///
  /// If a Product is a member of the specified ProductSet in addition to other
  /// ProductSets, the Product will still be deleted.
  ///
  /// It is recommended to not delete the specified ProductSet until after this
  /// operation has completed. It is also recommended to not add any of the
  /// Products involved in the batch delete to a new ProductSet while this
  /// operation is running because those Products may still end up deleted.
  ///
  /// It's not possible to undo the PurgeProducts operation. Therefore, it is
  /// recommended to keep the csv files used in ImportProductSets (if that was
  /// how you originally built the Product Set) before starting PurgeProducts, in
  /// case you need to re-import the data after deletion.
  ///
  /// If the plan is to purge all of the Products from a ProductSet and then
  /// re-use the empty ProductSet to re-import new Products into the empty
  /// ProductSet, you must wait until the PurgeProducts operation has finished
  /// for that ProductSet.
  ///
  /// The [google.longrunning.Operation][google.longrunning.Operation] API can be
  /// used to keep track of the progress and results of the request.
  /// `Operation.metadata` contains `BatchOperationMetadata`. (progress)
  ///
  /// @param parent  Required. The project and location in which the Products should be deleted.
  ///  @n
  ///  Format is `projects/PROJECT_ID/locations/LOC_ID`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vision.v1.BatchOperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vision.v1.BatchOperationMetadata]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L967}
  /// [google.cloud.vision.v1.PurgeProductsRequest]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L1010}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vision::v1::BatchOperationMetadata>>
  PurgeProducts(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// @copybrief PurgeProducts
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> PurgeProducts(
      NoAwaitTag, std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Asynchronous API to delete all Products in a ProductSet or all Products
  /// that are in no ProductSet.
  ///
  /// If a Product is a member of the specified ProductSet in addition to other
  /// ProductSets, the Product will still be deleted.
  ///
  /// It is recommended to not delete the specified ProductSet until after this
  /// operation has completed. It is also recommended to not add any of the
  /// Products involved in the batch delete to a new ProductSet while this
  /// operation is running because those Products may still end up deleted.
  ///
  /// It's not possible to undo the PurgeProducts operation. Therefore, it is
  /// recommended to keep the csv files used in ImportProductSets (if that was
  /// how you originally built the Product Set) before starting PurgeProducts, in
  /// case you need to re-import the data after deletion.
  ///
  /// If the plan is to purge all of the Products from a ProductSet and then
  /// re-use the empty ProductSet to re-import new Products into the empty
  /// ProductSet, you must wait until the PurgeProducts operation has finished
  /// for that ProductSet.
  ///
  /// The [google.longrunning.Operation][google.longrunning.Operation] API can be
  /// used to keep track of the progress and results of the request.
  /// `Operation.metadata` contains `BatchOperationMetadata`. (progress)
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.vision.v1.PurgeProductsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.vision.v1.BatchOperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.vision.v1.BatchOperationMetadata]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L967}
  /// [google.cloud.vision.v1.PurgeProductsRequest]: @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L1010}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  future<StatusOr<google::cloud::vision::v1::BatchOperationMetadata>>
  PurgeProducts(google::cloud::vision::v1::PurgeProductsRequest const& request,
                Options opts = {});

  // clang-format off
  ///
  /// @copybrief PurgeProducts
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> PurgeProducts(
      NoAwaitTag,
      google::cloud::vision::v1::PurgeProductsRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief PurgeProducts
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::vision::v1::BatchOperationMetadata>>
  PurgeProducts(google::longrunning::Operation const& operation,
                Options opts = {});

  // clang-format off
  ///
  /// Gets the latest state of a long-running operation.  Clients can use this
  /// method to poll the operation result at intervals as recommended by the API
  /// service.
  ///
  /// @param name  The name of the operation resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.longrunning.Operation])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.longrunning.GetOperationRequest]: @googleapis_reference_link{google/longrunning/operations.proto#L165}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> GetOperation(std::string const& name,
                                                        Options opts = {});

  // clang-format off
  ///
  /// Gets the latest state of a long-running operation.  Clients can use this
  /// method to poll the operation result at intervals as recommended by the API
  /// service.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.longrunning.GetOperationRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.longrunning.Operation])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.longrunning.GetOperationRequest]: @googleapis_reference_link{google/longrunning/operations.proto#L165}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> GetOperation(
      google::longrunning::GetOperationRequest const& request,
      Options opts = {});

 private:
  std::shared_ptr<ProductSearchConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace vision_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_VISION_V1_PRODUCT_SEARCH_CLIENT_H
