// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/vision/v1/image_annotator.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_VISION_V1_IMAGE_ANNOTATOR_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_VISION_V1_IMAGE_ANNOTATOR_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/version.h"
#include <google/cloud/vision/v1/image_annotator.grpc.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace vision_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class ImageAnnotatorConnectionIdempotencyPolicy {
 public:
  virtual ~ImageAnnotatorConnectionIdempotencyPolicy();

  /// Create a new copy of this object.
  virtual std::unique_ptr<ImageAnnotatorConnectionIdempotencyPolicy> clone()
      const;

  virtual google::cloud::Idempotency BatchAnnotateImages(
      google::cloud::vision::v1::BatchAnnotateImagesRequest const& request);

  virtual google::cloud::Idempotency BatchAnnotateFiles(
      google::cloud::vision::v1::BatchAnnotateFilesRequest const& request);

  virtual google::cloud::Idempotency AsyncBatchAnnotateImages(
      google::cloud::vision::v1::AsyncBatchAnnotateImagesRequest const&
          request);

  virtual google::cloud::Idempotency AsyncBatchAnnotateFiles(
      google::cloud::vision::v1::AsyncBatchAnnotateFilesRequest const& request);

  virtual google::cloud::Idempotency GetOperation(
      google::longrunning::GetOperationRequest const& request);
};

std::unique_ptr<ImageAnnotatorConnectionIdempotencyPolicy>
MakeDefaultImageAnnotatorConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace vision_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_VISION_V1_IMAGE_ANNOTATOR_CONNECTION_IDEMPOTENCY_POLICY_H
