// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/video/stitcher/v1/video_stitcher_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_VIDEO_STITCHER_V1_VIDEO_STITCHER_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_VIDEO_STITCHER_V1_VIDEO_STITCHER_CLIENT_H

#include "google/cloud/video/stitcher/v1/video_stitcher_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <map>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace video_stitcher_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Video-On-Demand content stitching API allows you to insert ads
/// into (VoD) video on demand files. You will be able to render custom
/// scrubber bars with highlighted ads, enforce ad policies, allow
/// seamless playback and tracking on native players and monetize
/// content with any standard VMAP compliant ad server.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class VideoStitcherServiceClient {
 public:
  explicit VideoStitcherServiceClient(
      std::shared_ptr<VideoStitcherServiceConnection> connection,
      Options opts = {});
  ~VideoStitcherServiceClient();

  ///@{
  /// @name Copy and move support
  VideoStitcherServiceClient(VideoStitcherServiceClient const&) = default;
  VideoStitcherServiceClient& operator=(VideoStitcherServiceClient const&) =
      default;
  VideoStitcherServiceClient(VideoStitcherServiceClient&&) = default;
  VideoStitcherServiceClient& operator=(VideoStitcherServiceClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(VideoStitcherServiceClient const& a,
                         VideoStitcherServiceClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(VideoStitcherServiceClient const& a,
                         VideoStitcherServiceClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Creates a new CDN key.
  ///
  /// @param parent  Required. The project in which the CDN key should be created, in the form
  ///  of `projects/{project_number}/locations/{location}`.
  /// @param cdn_key  Required. The CDN key resource to create.
  /// @param cdn_key_id  Required. The ID to use for the CDN key, which will become the final
  ///  component of the CDN key's resource name.
  ///  @n
  ///  This value should conform to RFC-1034, which restricts to
  ///  lower-case letters, numbers, and hyphen, with the first character a
  ///  letter, the last a letter or a number, and a 63 character maximum.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.video.stitcher.v1.CdnKey] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.stitcher.v1.CdnKey]: @googleapis_reference_link{google/cloud/video/stitcher/v1/cdn_keys.proto#L30}
  /// [google.cloud.video.stitcher.v1.CreateCdnKeyRequest]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L372}
  ///
  // clang-format on
  future<StatusOr<google::cloud::video::stitcher::v1::CdnKey>> CreateCdnKey(
      std::string const& parent,
      google::cloud::video::stitcher::v1::CdnKey const& cdn_key,
      std::string const& cdn_key_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateCdnKey
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateCdnKey(
      NoAwaitTag, std::string const& parent,
      google::cloud::video::stitcher::v1::CdnKey const& cdn_key,
      std::string const& cdn_key_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new CDN key.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.video.stitcher.v1.CreateCdnKeyRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.video.stitcher.v1.CdnKey] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.stitcher.v1.CdnKey]: @googleapis_reference_link{google/cloud/video/stitcher/v1/cdn_keys.proto#L30}
  /// [google.cloud.video.stitcher.v1.CreateCdnKeyRequest]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L372}
  ///
  // clang-format on
  future<StatusOr<google::cloud::video::stitcher::v1::CdnKey>> CreateCdnKey(
      google::cloud::video::stitcher::v1::CreateCdnKeyRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateCdnKey
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateCdnKey(
      NoAwaitTag,
      google::cloud::video::stitcher::v1::CreateCdnKeyRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateCdnKey
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::video::stitcher::v1::CdnKey>> CreateCdnKey(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Lists all CDN keys in the specified project and location.
  ///
  /// @param parent  Required. The project that contains the list of CDN keys, in the form of
  ///  `projects/{project_number}/locations/{location}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.video.stitcher.v1.CdnKey], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.stitcher.v1.CdnKey]: @googleapis_reference_link{google/cloud/video/stitcher/v1/cdn_keys.proto#L30}
  /// [google.cloud.video.stitcher.v1.ListCdnKeysRequest]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L395}
  ///
  // clang-format on
  StreamRange<google::cloud::video::stitcher::v1::CdnKey> ListCdnKeys(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists all CDN keys in the specified project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.video.stitcher.v1.ListCdnKeysRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.video.stitcher.v1.CdnKey], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.stitcher.v1.CdnKey]: @googleapis_reference_link{google/cloud/video/stitcher/v1/cdn_keys.proto#L30}
  /// [google.cloud.video.stitcher.v1.ListCdnKeysRequest]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L395}
  ///
  // clang-format on
  StreamRange<google::cloud::video::stitcher::v1::CdnKey> ListCdnKeys(
      google::cloud::video::stitcher::v1::ListCdnKeysRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Returns the specified CDN key.
  ///
  /// @param name  Required. The name of the CDN key to be retrieved, in the form of
  ///  `projects/{project}/locations/{location}/cdnKeys/{id}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.video.stitcher.v1.CdnKey])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.stitcher.v1.CdnKey]: @googleapis_reference_link{google/cloud/video/stitcher/v1/cdn_keys.proto#L30}
  /// [google.cloud.video.stitcher.v1.GetCdnKeyRequest]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L432}
  ///
  // clang-format on
  StatusOr<google::cloud::video::stitcher::v1::CdnKey> GetCdnKey(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Returns the specified CDN key.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.video.stitcher.v1.GetCdnKeyRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.video.stitcher.v1.CdnKey])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.stitcher.v1.CdnKey]: @googleapis_reference_link{google/cloud/video/stitcher/v1/cdn_keys.proto#L30}
  /// [google.cloud.video.stitcher.v1.GetCdnKeyRequest]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L432}
  ///
  // clang-format on
  StatusOr<google::cloud::video::stitcher::v1::CdnKey> GetCdnKey(
      google::cloud::video::stitcher::v1::GetCdnKeyRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes the specified CDN key.
  ///
  /// @param name  Required. The name of the CDN key to be deleted, in the form of
  ///  `projects/{project_number}/locations/{location}/cdnKeys/{id}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.video.stitcher.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.stitcher.v1.DeleteCdnKeyRequest]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L444}
  /// [google.cloud.video.stitcher.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L968}
  ///
  // clang-format on
  future<StatusOr<google::cloud::video::stitcher::v1::OperationMetadata>>
  DeleteCdnKey(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteCdnKey
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteCdnKey(NoAwaitTag,
                                                        std::string const& name,
                                                        Options opts = {});

  // clang-format off
  ///
  /// Deletes the specified CDN key.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.video.stitcher.v1.DeleteCdnKeyRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.video.stitcher.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.stitcher.v1.DeleteCdnKeyRequest]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L444}
  /// [google.cloud.video.stitcher.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L968}
  ///
  // clang-format on
  future<StatusOr<google::cloud::video::stitcher::v1::OperationMetadata>>
  DeleteCdnKey(
      google::cloud::video::stitcher::v1::DeleteCdnKeyRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteCdnKey
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteCdnKey(
      NoAwaitTag,
      google::cloud::video::stitcher::v1::DeleteCdnKeyRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteCdnKey
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::video::stitcher::v1::OperationMetadata>>
  DeleteCdnKey(google::longrunning::Operation const& operation,
               Options opts = {});

  // clang-format off
  ///
  /// Updates the specified CDN key. Only update fields specified
  /// in the call method body.
  ///
  /// @param cdn_key  Required. The CDN key resource which replaces the resource on the server.
  /// @param update_mask  Required. The update mask applies to the resource.
  ///  For the `FieldMask` definition, see
  ///  https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.video.stitcher.v1.CdnKey] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.stitcher.v1.CdnKey]: @googleapis_reference_link{google/cloud/video/stitcher/v1/cdn_keys.proto#L30}
  /// [google.cloud.video.stitcher.v1.UpdateCdnKeyRequest]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L456}
  ///
  // clang-format on
  future<StatusOr<google::cloud::video::stitcher::v1::CdnKey>> UpdateCdnKey(
      google::cloud::video::stitcher::v1::CdnKey const& cdn_key,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateCdnKey
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateCdnKey(
      NoAwaitTag, google::cloud::video::stitcher::v1::CdnKey const& cdn_key,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates the specified CDN key. Only update fields specified
  /// in the call method body.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.video.stitcher.v1.UpdateCdnKeyRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.video.stitcher.v1.CdnKey] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.stitcher.v1.CdnKey]: @googleapis_reference_link{google/cloud/video/stitcher/v1/cdn_keys.proto#L30}
  /// [google.cloud.video.stitcher.v1.UpdateCdnKeyRequest]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L456}
  ///
  // clang-format on
  future<StatusOr<google::cloud::video::stitcher::v1::CdnKey>> UpdateCdnKey(
      google::cloud::video::stitcher::v1::UpdateCdnKeyRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateCdnKey
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateCdnKey(
      NoAwaitTag,
      google::cloud::video::stitcher::v1::UpdateCdnKeyRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateCdnKey
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::video::stitcher::v1::CdnKey>> UpdateCdnKey(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Creates a client side playback VOD session and returns the full
  /// tracking and playback metadata of the session.
  ///
  /// @param parent  Required. The project and location in which the VOD session should be
  ///  created, in the form of `projects/{project_number}/locations/{location}`.
  /// @param vod_session  Required. Parameters for creating a session.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.video.stitcher.v1.VodSession])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.stitcher.v1.CreateVodSessionRequest]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L468}
  /// [google.cloud.video.stitcher.v1.VodSession]: @googleapis_reference_link{google/cloud/video/stitcher/v1/sessions.proto#L32}
  ///
  // clang-format on
  StatusOr<google::cloud::video::stitcher::v1::VodSession> CreateVodSession(
      std::string const& parent,
      google::cloud::video::stitcher::v1::VodSession const& vod_session,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a client side playback VOD session and returns the full
  /// tracking and playback metadata of the session.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.video.stitcher.v1.CreateVodSessionRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.video.stitcher.v1.VodSession])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.stitcher.v1.CreateVodSessionRequest]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L468}
  /// [google.cloud.video.stitcher.v1.VodSession]: @googleapis_reference_link{google/cloud/video/stitcher/v1/sessions.proto#L32}
  ///
  // clang-format on
  StatusOr<google::cloud::video::stitcher::v1::VodSession> CreateVodSession(
      google::cloud::video::stitcher::v1::CreateVodSessionRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Returns the full tracking, playback metadata, and relevant ad-ops
  /// logs for the specified VOD session.
  ///
  /// @param name  Required. The name of the VOD session to be retrieved, in the form of
  ///  `projects/{project_number}/locations/{location}/vodSessions/{id}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.video.stitcher.v1.VodSession])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.stitcher.v1.GetVodSessionRequest]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L483}
  /// [google.cloud.video.stitcher.v1.VodSession]: @googleapis_reference_link{google/cloud/video/stitcher/v1/sessions.proto#L32}
  ///
  // clang-format on
  StatusOr<google::cloud::video::stitcher::v1::VodSession> GetVodSession(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Returns the full tracking, playback metadata, and relevant ad-ops
  /// logs for the specified VOD session.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.video.stitcher.v1.GetVodSessionRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.video.stitcher.v1.VodSession])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.stitcher.v1.GetVodSessionRequest]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L483}
  /// [google.cloud.video.stitcher.v1.VodSession]: @googleapis_reference_link{google/cloud/video/stitcher/v1/sessions.proto#L32}
  ///
  // clang-format on
  StatusOr<google::cloud::video::stitcher::v1::VodSession> GetVodSession(
      google::cloud::video::stitcher::v1::GetVodSessionRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Returns a list of detailed stitching information of the specified VOD
  /// session.
  ///
  /// @param parent  Required. The VOD session where the stitch details belong to, in the form
  ///  of `projects/{project}/locations/{location}/vodSessions/{id}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.video.stitcher.v1.VodStitchDetail], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.stitcher.v1.ListVodStitchDetailsRequest]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L495}
  /// [google.cloud.video.stitcher.v1.VodStitchDetail]: @googleapis_reference_link{google/cloud/video/stitcher/v1/stitch_details.proto#L32}
  ///
  // clang-format on
  StreamRange<google::cloud::video::stitcher::v1::VodStitchDetail>
  ListVodStitchDetails(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Returns a list of detailed stitching information of the specified VOD
  /// session.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.video.stitcher.v1.ListVodStitchDetailsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.video.stitcher.v1.VodStitchDetail], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.stitcher.v1.ListVodStitchDetailsRequest]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L495}
  /// [google.cloud.video.stitcher.v1.VodStitchDetail]: @googleapis_reference_link{google/cloud/video/stitcher/v1/stitch_details.proto#L32}
  ///
  // clang-format on
  StreamRange<google::cloud::video::stitcher::v1::VodStitchDetail>
  ListVodStitchDetails(
      google::cloud::video::stitcher::v1::ListVodStitchDetailsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Returns the specified stitching information for the specified VOD session.
  ///
  /// @param name  Required. The name of the stitch detail in the specified VOD session, in
  ///  the form of
  ///  `projects/{project}/locations/{location}/vodSessions/{vod_session_id}/vodStitchDetails/{id}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.video.stitcher.v1.VodStitchDetail])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.stitcher.v1.GetVodStitchDetailRequest]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L522}
  /// [google.cloud.video.stitcher.v1.VodStitchDetail]: @googleapis_reference_link{google/cloud/video/stitcher/v1/stitch_details.proto#L32}
  ///
  // clang-format on
  StatusOr<google::cloud::video::stitcher::v1::VodStitchDetail>
  GetVodStitchDetail(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Returns the specified stitching information for the specified VOD session.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.video.stitcher.v1.GetVodStitchDetailRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.video.stitcher.v1.VodStitchDetail])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.stitcher.v1.GetVodStitchDetailRequest]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L522}
  /// [google.cloud.video.stitcher.v1.VodStitchDetail]: @googleapis_reference_link{google/cloud/video/stitcher/v1/stitch_details.proto#L32}
  ///
  // clang-format on
  StatusOr<google::cloud::video::stitcher::v1::VodStitchDetail>
  GetVodStitchDetail(
      google::cloud::video::stitcher::v1::GetVodStitchDetailRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Return the list of ad tag details for the specified VOD session.
  ///
  /// @param parent  Required. The VOD session which the ad tag details belong to, in the form
  ///  of `projects/{project}/locations/{location}/vodSessions/{vod_session_id}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.video.stitcher.v1.VodAdTagDetail], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.stitcher.v1.ListVodAdTagDetailsRequest]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L535}
  /// [google.cloud.video.stitcher.v1.VodAdTagDetail]: @googleapis_reference_link{google/cloud/video/stitcher/v1/ad_tag_details.proto#L48}
  ///
  // clang-format on
  StreamRange<google::cloud::video::stitcher::v1::VodAdTagDetail>
  ListVodAdTagDetails(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Return the list of ad tag details for the specified VOD session.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.video.stitcher.v1.ListVodAdTagDetailsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.video.stitcher.v1.VodAdTagDetail], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.stitcher.v1.ListVodAdTagDetailsRequest]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L535}
  /// [google.cloud.video.stitcher.v1.VodAdTagDetail]: @googleapis_reference_link{google/cloud/video/stitcher/v1/ad_tag_details.proto#L48}
  ///
  // clang-format on
  StreamRange<google::cloud::video::stitcher::v1::VodAdTagDetail>
  ListVodAdTagDetails(
      google::cloud::video::stitcher::v1::ListVodAdTagDetailsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Returns the specified ad tag detail for the specified VOD session.
  ///
  /// @param name  Required. The name of the ad tag detail for the specified VOD session, in
  ///  the form of
  ///  `projects/{project}/locations/{location}/vodSessions/{vod_session_id}/vodAdTagDetails/{vod_ad_tag_detail}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.video.stitcher.v1.VodAdTagDetail])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.stitcher.v1.GetVodAdTagDetailRequest]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L562}
  /// [google.cloud.video.stitcher.v1.VodAdTagDetail]: @googleapis_reference_link{google/cloud/video/stitcher/v1/ad_tag_details.proto#L48}
  ///
  // clang-format on
  StatusOr<google::cloud::video::stitcher::v1::VodAdTagDetail>
  GetVodAdTagDetail(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Returns the specified ad tag detail for the specified VOD session.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.video.stitcher.v1.GetVodAdTagDetailRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.video.stitcher.v1.VodAdTagDetail])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.stitcher.v1.GetVodAdTagDetailRequest]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L562}
  /// [google.cloud.video.stitcher.v1.VodAdTagDetail]: @googleapis_reference_link{google/cloud/video/stitcher/v1/ad_tag_details.proto#L48}
  ///
  // clang-format on
  StatusOr<google::cloud::video::stitcher::v1::VodAdTagDetail>
  GetVodAdTagDetail(
      google::cloud::video::stitcher::v1::GetVodAdTagDetailRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Return the list of ad tag details for the specified live session.
  ///
  /// @param parent  Required. The resource parent in the form of
  ///  `projects/{project}/locations/{location}/liveSessions/{live_session}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.video.stitcher.v1.LiveAdTagDetail], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.stitcher.v1.ListLiveAdTagDetailsRequest]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L575}
  /// [google.cloud.video.stitcher.v1.LiveAdTagDetail]: @googleapis_reference_link{google/cloud/video/stitcher/v1/ad_tag_details.proto#L31}
  ///
  // clang-format on
  StreamRange<google::cloud::video::stitcher::v1::LiveAdTagDetail>
  ListLiveAdTagDetails(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Return the list of ad tag details for the specified live session.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.video.stitcher.v1.ListLiveAdTagDetailsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.video.stitcher.v1.LiveAdTagDetail], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.stitcher.v1.ListLiveAdTagDetailsRequest]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L575}
  /// [google.cloud.video.stitcher.v1.LiveAdTagDetail]: @googleapis_reference_link{google/cloud/video/stitcher/v1/ad_tag_details.proto#L31}
  ///
  // clang-format on
  StreamRange<google::cloud::video::stitcher::v1::LiveAdTagDetail>
  ListLiveAdTagDetails(
      google::cloud::video::stitcher::v1::ListLiveAdTagDetailsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Returns the specified ad tag detail for the specified live session.
  ///
  /// @param name  Required. The resource name in the form of
  ///  `projects/{project}/locations/{location}/liveSessions/{live_session}/liveAdTagDetails/{live_ad_tag_detail}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.video.stitcher.v1.LiveAdTagDetail])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.stitcher.v1.GetLiveAdTagDetailRequest]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L602}
  /// [google.cloud.video.stitcher.v1.LiveAdTagDetail]: @googleapis_reference_link{google/cloud/video/stitcher/v1/ad_tag_details.proto#L31}
  ///
  // clang-format on
  StatusOr<google::cloud::video::stitcher::v1::LiveAdTagDetail>
  GetLiveAdTagDetail(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Returns the specified ad tag detail for the specified live session.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.video.stitcher.v1.GetLiveAdTagDetailRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.video.stitcher.v1.LiveAdTagDetail])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.stitcher.v1.GetLiveAdTagDetailRequest]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L602}
  /// [google.cloud.video.stitcher.v1.LiveAdTagDetail]: @googleapis_reference_link{google/cloud/video/stitcher/v1/ad_tag_details.proto#L31}
  ///
  // clang-format on
  StatusOr<google::cloud::video::stitcher::v1::LiveAdTagDetail>
  GetLiveAdTagDetail(
      google::cloud::video::stitcher::v1::GetLiveAdTagDetailRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a slate.
  ///
  /// @param parent  Required. The project in which the slate should be created, in the form of
  ///  `projects/{project_number}/locations/{location}`.
  /// @param slate  Required. The slate to create.
  /// @param slate_id  Required. The unique identifier for the slate.
  ///  This value should conform to RFC-1034, which restricts to
  ///  lower-case letters, numbers, and hyphen, with the first character a
  ///  letter, the last a letter or a number, and a 63 character maximum.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.video.stitcher.v1.Slate] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.stitcher.v1.CreateSlateRequest]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L614}
  /// [google.cloud.video.stitcher.v1.Slate]: @googleapis_reference_link{google/cloud/video/stitcher/v1/slates.proto#L28}
  ///
  // clang-format on
  future<StatusOr<google::cloud::video::stitcher::v1::Slate>> CreateSlate(
      std::string const& parent,
      google::cloud::video::stitcher::v1::Slate const& slate,
      std::string const& slate_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateSlate
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateSlate(
      NoAwaitTag, std::string const& parent,
      google::cloud::video::stitcher::v1::Slate const& slate,
      std::string const& slate_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a slate.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.video.stitcher.v1.CreateSlateRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.video.stitcher.v1.Slate] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.stitcher.v1.CreateSlateRequest]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L614}
  /// [google.cloud.video.stitcher.v1.Slate]: @googleapis_reference_link{google/cloud/video/stitcher/v1/slates.proto#L28}
  ///
  // clang-format on
  future<StatusOr<google::cloud::video::stitcher::v1::Slate>> CreateSlate(
      google::cloud::video::stitcher::v1::CreateSlateRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateSlate
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateSlate(
      NoAwaitTag,
      google::cloud::video::stitcher::v1::CreateSlateRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateSlate
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::video::stitcher::v1::Slate>> CreateSlate(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Lists all slates in the specified project and location.
  ///
  /// @param parent  Required. The project to list slates, in the form of
  ///  `projects/{project_number}/locations/{location}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.video.stitcher.v1.Slate], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.stitcher.v1.ListSlatesRequest]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L662}
  /// [google.cloud.video.stitcher.v1.Slate]: @googleapis_reference_link{google/cloud/video/stitcher/v1/slates.proto#L28}
  ///
  // clang-format on
  StreamRange<google::cloud::video::stitcher::v1::Slate> ListSlates(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists all slates in the specified project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.video.stitcher.v1.ListSlatesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.video.stitcher.v1.Slate], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.stitcher.v1.ListSlatesRequest]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L662}
  /// [google.cloud.video.stitcher.v1.Slate]: @googleapis_reference_link{google/cloud/video/stitcher/v1/slates.proto#L28}
  ///
  // clang-format on
  StreamRange<google::cloud::video::stitcher::v1::Slate> ListSlates(
      google::cloud::video::stitcher::v1::ListSlatesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Returns the specified slate.
  ///
  /// @param name  Required. The name of the slate to be retrieved, of the slate, in the form
  ///  of `projects/{project_number}/locations/{location}/slates/{id}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.video.stitcher.v1.Slate])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.stitcher.v1.GetSlateRequest]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L650}
  /// [google.cloud.video.stitcher.v1.Slate]: @googleapis_reference_link{google/cloud/video/stitcher/v1/slates.proto#L28}
  ///
  // clang-format on
  StatusOr<google::cloud::video::stitcher::v1::Slate> GetSlate(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Returns the specified slate.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.video.stitcher.v1.GetSlateRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.video.stitcher.v1.Slate])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.stitcher.v1.GetSlateRequest]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L650}
  /// [google.cloud.video.stitcher.v1.Slate]: @googleapis_reference_link{google/cloud/video/stitcher/v1/slates.proto#L28}
  ///
  // clang-format on
  StatusOr<google::cloud::video::stitcher::v1::Slate> GetSlate(
      google::cloud::video::stitcher::v1::GetSlateRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates the specified slate.
  ///
  /// @param slate  Required. The resource with updated fields.
  /// @param update_mask  Required. The update mask which specifies fields which should be updated.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.video.stitcher.v1.Slate] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.stitcher.v1.Slate]: @googleapis_reference_link{google/cloud/video/stitcher/v1/slates.proto#L28}
  /// [google.cloud.video.stitcher.v1.UpdateSlateRequest]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L699}
  ///
  // clang-format on
  future<StatusOr<google::cloud::video::stitcher::v1::Slate>> UpdateSlate(
      google::cloud::video::stitcher::v1::Slate const& slate,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateSlate
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateSlate(
      NoAwaitTag, google::cloud::video::stitcher::v1::Slate const& slate,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates the specified slate.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.video.stitcher.v1.UpdateSlateRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.video.stitcher.v1.Slate] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.stitcher.v1.Slate]: @googleapis_reference_link{google/cloud/video/stitcher/v1/slates.proto#L28}
  /// [google.cloud.video.stitcher.v1.UpdateSlateRequest]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L699}
  ///
  // clang-format on
  future<StatusOr<google::cloud::video::stitcher::v1::Slate>> UpdateSlate(
      google::cloud::video::stitcher::v1::UpdateSlateRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateSlate
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateSlate(
      NoAwaitTag,
      google::cloud::video::stitcher::v1::UpdateSlateRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateSlate
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::video::stitcher::v1::Slate>> UpdateSlate(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Deletes the specified slate.
  ///
  /// @param name  Required. The name of the slate to be deleted, in the form of
  ///  `projects/{project_number}/locations/{location}/slates/{id}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.video.stitcher.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.stitcher.v1.DeleteSlateRequest]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L709}
  /// [google.cloud.video.stitcher.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L968}
  ///
  // clang-format on
  future<StatusOr<google::cloud::video::stitcher::v1::OperationMetadata>>
  DeleteSlate(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteSlate
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteSlate(NoAwaitTag,
                                                       std::string const& name,
                                                       Options opts = {});

  // clang-format off
  ///
  /// Deletes the specified slate.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.video.stitcher.v1.DeleteSlateRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.video.stitcher.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.stitcher.v1.DeleteSlateRequest]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L709}
  /// [google.cloud.video.stitcher.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L968}
  ///
  // clang-format on
  future<StatusOr<google::cloud::video::stitcher::v1::OperationMetadata>>
  DeleteSlate(
      google::cloud::video::stitcher::v1::DeleteSlateRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteSlate
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteSlate(
      NoAwaitTag,
      google::cloud::video::stitcher::v1::DeleteSlateRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteSlate
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::video::stitcher::v1::OperationMetadata>>
  DeleteSlate(google::longrunning::Operation const& operation,
              Options opts = {});

  // clang-format off
  ///
  /// Creates a new live session.
  ///
  /// @param parent  Required. The project and location in which the live session should be
  ///  created, in the form of `projects/{project_number}/locations/{location}`.
  /// @param live_session  Required. Parameters for creating a live session.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.video.stitcher.v1.LiveSession])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.stitcher.v1.CreateLiveSessionRequest]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L721}
  /// [google.cloud.video.stitcher.v1.LiveSession]: @googleapis_reference_link{google/cloud/video/stitcher/v1/sessions.proto#L152}
  ///
  // clang-format on
  StatusOr<google::cloud::video::stitcher::v1::LiveSession> CreateLiveSession(
      std::string const& parent,
      google::cloud::video::stitcher::v1::LiveSession const& live_session,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new live session.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.video.stitcher.v1.CreateLiveSessionRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.video.stitcher.v1.LiveSession])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.stitcher.v1.CreateLiveSessionRequest]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L721}
  /// [google.cloud.video.stitcher.v1.LiveSession]: @googleapis_reference_link{google/cloud/video/stitcher/v1/sessions.proto#L152}
  ///
  // clang-format on
  StatusOr<google::cloud::video::stitcher::v1::LiveSession> CreateLiveSession(
      google::cloud::video::stitcher::v1::CreateLiveSessionRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Returns the details for the specified live session.
  ///
  /// @param name  Required. The name of the live session, in the form of
  ///  `projects/{project_number}/locations/{location}/liveSessions/{id}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.video.stitcher.v1.LiveSession])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.stitcher.v1.GetLiveSessionRequest]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L736}
  /// [google.cloud.video.stitcher.v1.LiveSession]: @googleapis_reference_link{google/cloud/video/stitcher/v1/sessions.proto#L152}
  ///
  // clang-format on
  StatusOr<google::cloud::video::stitcher::v1::LiveSession> GetLiveSession(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Returns the details for the specified live session.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.video.stitcher.v1.GetLiveSessionRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.video.stitcher.v1.LiveSession])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.stitcher.v1.GetLiveSessionRequest]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L736}
  /// [google.cloud.video.stitcher.v1.LiveSession]: @googleapis_reference_link{google/cloud/video/stitcher/v1/sessions.proto#L152}
  ///
  // clang-format on
  StatusOr<google::cloud::video::stitcher::v1::LiveSession> GetLiveSession(
      google::cloud::video::stitcher::v1::GetLiveSessionRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Registers the live config with the provided unique ID in
  /// the specified region.
  ///
  /// @param parent  Required. The project in which the live config should be created, in
  ///  the form of `projects/{project_number}/locations/{location}`.
  /// @param live_config  Required. The live config resource to create.
  /// @param live_config_id  Required. The unique identifier ID to use for the live config.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.video.stitcher.v1.LiveConfig] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.stitcher.v1.CreateLiveConfigRequest]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L748}
  /// [google.cloud.video.stitcher.v1.LiveConfig]: @googleapis_reference_link{google/cloud/video/stitcher/v1/live_configs.proto#L44}
  ///
  // clang-format on
  future<StatusOr<google::cloud::video::stitcher::v1::LiveConfig>>
  CreateLiveConfig(
      std::string const& parent,
      google::cloud::video::stitcher::v1::LiveConfig const& live_config,
      std::string const& live_config_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateLiveConfig
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateLiveConfig(
      NoAwaitTag, std::string const& parent,
      google::cloud::video::stitcher::v1::LiveConfig const& live_config,
      std::string const& live_config_id, Options opts = {});

  // clang-format off
  ///
  /// Registers the live config with the provided unique ID in
  /// the specified region.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.video.stitcher.v1.CreateLiveConfigRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.video.stitcher.v1.LiveConfig] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.stitcher.v1.CreateLiveConfigRequest]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L748}
  /// [google.cloud.video.stitcher.v1.LiveConfig]: @googleapis_reference_link{google/cloud/video/stitcher/v1/live_configs.proto#L44}
  ///
  // clang-format on
  future<StatusOr<google::cloud::video::stitcher::v1::LiveConfig>>
  CreateLiveConfig(
      google::cloud::video::stitcher::v1::CreateLiveConfigRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateLiveConfig
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateLiveConfig(
      NoAwaitTag,
      google::cloud::video::stitcher::v1::CreateLiveConfigRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateLiveConfig
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::video::stitcher::v1::LiveConfig>>
  CreateLiveConfig(google::longrunning::Operation const& operation,
                   Options opts = {});

  // clang-format off
  ///
  /// Lists all live configs managed by the Video Stitcher that
  /// belong to the specified project and region.
  ///
  /// @param parent  Required. The project that contains the list of live configs, in the
  ///  form of `projects/{project_number}/locations/{location}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.video.stitcher.v1.LiveConfig], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.stitcher.v1.ListLiveConfigsRequest]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L781}
  /// [google.cloud.video.stitcher.v1.LiveConfig]: @googleapis_reference_link{google/cloud/video/stitcher/v1/live_configs.proto#L44}
  ///
  // clang-format on
  StreamRange<google::cloud::video::stitcher::v1::LiveConfig> ListLiveConfigs(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists all live configs managed by the Video Stitcher that
  /// belong to the specified project and region.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.video.stitcher.v1.ListLiveConfigsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.video.stitcher.v1.LiveConfig], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.stitcher.v1.ListLiveConfigsRequest]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L781}
  /// [google.cloud.video.stitcher.v1.LiveConfig]: @googleapis_reference_link{google/cloud/video/stitcher/v1/live_configs.proto#L44}
  ///
  // clang-format on
  StreamRange<google::cloud::video::stitcher::v1::LiveConfig> ListLiveConfigs(
      google::cloud::video::stitcher::v1::ListLiveConfigsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Returns the specified live config managed by the Video
  /// Stitcher service.
  ///
  /// @param name  Required. The name of the live config to be retrieved, in the form
  ///  of
  ///  `projects/{project_number}/locations/{location}/liveConfigs/{id}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.video.stitcher.v1.LiveConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.stitcher.v1.GetLiveConfigRequest]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L820}
  /// [google.cloud.video.stitcher.v1.LiveConfig]: @googleapis_reference_link{google/cloud/video/stitcher/v1/live_configs.proto#L44}
  ///
  // clang-format on
  StatusOr<google::cloud::video::stitcher::v1::LiveConfig> GetLiveConfig(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Returns the specified live config managed by the Video
  /// Stitcher service.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.video.stitcher.v1.GetLiveConfigRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.video.stitcher.v1.LiveConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.stitcher.v1.GetLiveConfigRequest]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L820}
  /// [google.cloud.video.stitcher.v1.LiveConfig]: @googleapis_reference_link{google/cloud/video/stitcher/v1/live_configs.proto#L44}
  ///
  // clang-format on
  StatusOr<google::cloud::video::stitcher::v1::LiveConfig> GetLiveConfig(
      google::cloud::video::stitcher::v1::GetLiveConfigRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes the specified live config.
  ///
  /// @param name  Required. The name of the live config to be deleted, in the form of
  ///  `projects/{project_number}/locations/{location}/liveConfigs/{id}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.video.stitcher.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.stitcher.v1.DeleteLiveConfigRequest]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L833}
  /// [google.cloud.video.stitcher.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L968}
  ///
  // clang-format on
  future<StatusOr<google::cloud::video::stitcher::v1::OperationMetadata>>
  DeleteLiveConfig(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteLiveConfig
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteLiveConfig(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes the specified live config.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.video.stitcher.v1.DeleteLiveConfigRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.video.stitcher.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.stitcher.v1.DeleteLiveConfigRequest]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L833}
  /// [google.cloud.video.stitcher.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L968}
  ///
  // clang-format on
  future<StatusOr<google::cloud::video::stitcher::v1::OperationMetadata>>
  DeleteLiveConfig(
      google::cloud::video::stitcher::v1::DeleteLiveConfigRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteLiveConfig
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteLiveConfig(
      NoAwaitTag,
      google::cloud::video::stitcher::v1::DeleteLiveConfigRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteLiveConfig
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::video::stitcher::v1::OperationMetadata>>
  DeleteLiveConfig(google::longrunning::Operation const& operation,
                   Options opts = {});

  // clang-format off
  ///
  /// Updates the specified LiveConfig. Only update fields specified
  /// in the call method body.
  ///
  /// @param live_config  Required. The LiveConfig resource which replaces the resource on the
  ///  server.
  /// @param update_mask  Required. The update mask applies to the resource.
  ///  For the `FieldMask` definition, see
  ///  https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.video.stitcher.v1.LiveConfig] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.stitcher.v1.LiveConfig]: @googleapis_reference_link{google/cloud/video/stitcher/v1/live_configs.proto#L44}
  /// [google.cloud.video.stitcher.v1.UpdateLiveConfigRequest]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L845}
  ///
  // clang-format on
  future<StatusOr<google::cloud::video::stitcher::v1::LiveConfig>>
  UpdateLiveConfig(
      google::cloud::video::stitcher::v1::LiveConfig const& live_config,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateLiveConfig
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateLiveConfig(
      NoAwaitTag,
      google::cloud::video::stitcher::v1::LiveConfig const& live_config,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates the specified LiveConfig. Only update fields specified
  /// in the call method body.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.video.stitcher.v1.UpdateLiveConfigRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.video.stitcher.v1.LiveConfig] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.stitcher.v1.LiveConfig]: @googleapis_reference_link{google/cloud/video/stitcher/v1/live_configs.proto#L44}
  /// [google.cloud.video.stitcher.v1.UpdateLiveConfigRequest]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L845}
  ///
  // clang-format on
  future<StatusOr<google::cloud::video::stitcher::v1::LiveConfig>>
  UpdateLiveConfig(
      google::cloud::video::stitcher::v1::UpdateLiveConfigRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateLiveConfig
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateLiveConfig(
      NoAwaitTag,
      google::cloud::video::stitcher::v1::UpdateLiveConfigRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateLiveConfig
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::video::stitcher::v1::LiveConfig>>
  UpdateLiveConfig(google::longrunning::Operation const& operation,
                   Options opts = {});

  // clang-format off
  ///
  /// Registers the VOD config with the provided unique ID in
  /// the specified region.
  ///
  /// @param parent  Required. The project in which the VOD config should be created, in
  ///  the form of `projects/{project_number}/locations/{location}`.
  /// @param vod_config  Required. The VOD config resource to create.
  /// @param vod_config_id  Required. The unique identifier ID to use for the VOD config.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.video.stitcher.v1.VodConfig] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.stitcher.v1.CreateVodConfigRequest]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L858}
  /// [google.cloud.video.stitcher.v1.VodConfig]: @googleapis_reference_link{google/cloud/video/stitcher/v1/vod_configs.proto#L29}
  ///
  // clang-format on
  future<StatusOr<google::cloud::video::stitcher::v1::VodConfig>>
  CreateVodConfig(
      std::string const& parent,
      google::cloud::video::stitcher::v1::VodConfig const& vod_config,
      std::string const& vod_config_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateVodConfig
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateVodConfig(
      NoAwaitTag, std::string const& parent,
      google::cloud::video::stitcher::v1::VodConfig const& vod_config,
      std::string const& vod_config_id, Options opts = {});

  // clang-format off
  ///
  /// Registers the VOD config with the provided unique ID in
  /// the specified region.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.video.stitcher.v1.CreateVodConfigRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.video.stitcher.v1.VodConfig] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.stitcher.v1.CreateVodConfigRequest]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L858}
  /// [google.cloud.video.stitcher.v1.VodConfig]: @googleapis_reference_link{google/cloud/video/stitcher/v1/vod_configs.proto#L29}
  ///
  // clang-format on
  future<StatusOr<google::cloud::video::stitcher::v1::VodConfig>>
  CreateVodConfig(
      google::cloud::video::stitcher::v1::CreateVodConfigRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateVodConfig
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateVodConfig(
      NoAwaitTag,
      google::cloud::video::stitcher::v1::CreateVodConfigRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateVodConfig
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::video::stitcher::v1::VodConfig>>
  CreateVodConfig(google::longrunning::Operation const& operation,
                  Options opts = {});

  // clang-format off
  ///
  /// Lists all VOD configs managed by the Video Stitcher API that
  /// belong to the specified project and region.
  ///
  /// @param parent  Required. The project that contains the list of VOD configs, in the
  ///  form of `projects/{project_number}/locations/{location}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.video.stitcher.v1.VodConfig], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.stitcher.v1.ListVodConfigsRequest]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L891}
  /// [google.cloud.video.stitcher.v1.VodConfig]: @googleapis_reference_link{google/cloud/video/stitcher/v1/vod_configs.proto#L29}
  ///
  // clang-format on
  StreamRange<google::cloud::video::stitcher::v1::VodConfig> ListVodConfigs(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists all VOD configs managed by the Video Stitcher API that
  /// belong to the specified project and region.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.video.stitcher.v1.ListVodConfigsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.video.stitcher.v1.VodConfig], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.stitcher.v1.ListVodConfigsRequest]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L891}
  /// [google.cloud.video.stitcher.v1.VodConfig]: @googleapis_reference_link{google/cloud/video/stitcher/v1/vod_configs.proto#L29}
  ///
  // clang-format on
  StreamRange<google::cloud::video::stitcher::v1::VodConfig> ListVodConfigs(
      google::cloud::video::stitcher::v1::ListVodConfigsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Returns the specified VOD config managed by the Video
  /// Stitcher API service.
  ///
  /// @param name  Required. The name of the VOD config to be retrieved, in the form
  ///  of `projects/{project_number}/locations/{location}/vodConfigs/{id}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.video.stitcher.v1.VodConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.stitcher.v1.GetVodConfigRequest]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L931}
  /// [google.cloud.video.stitcher.v1.VodConfig]: @googleapis_reference_link{google/cloud/video/stitcher/v1/vod_configs.proto#L29}
  ///
  // clang-format on
  StatusOr<google::cloud::video::stitcher::v1::VodConfig> GetVodConfig(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Returns the specified VOD config managed by the Video
  /// Stitcher API service.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.video.stitcher.v1.GetVodConfigRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.video.stitcher.v1.VodConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.stitcher.v1.GetVodConfigRequest]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L931}
  /// [google.cloud.video.stitcher.v1.VodConfig]: @googleapis_reference_link{google/cloud/video/stitcher/v1/vod_configs.proto#L29}
  ///
  // clang-format on
  StatusOr<google::cloud::video::stitcher::v1::VodConfig> GetVodConfig(
      google::cloud::video::stitcher::v1::GetVodConfigRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes the specified VOD config.
  ///
  /// @param name  Required. The name of the VOD config to be deleted, in the form of
  ///  `projects/{project_number}/locations/{location}/vodConfigs/{id}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.video.stitcher.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.stitcher.v1.DeleteVodConfigRequest]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L943}
  /// [google.cloud.video.stitcher.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L968}
  ///
  // clang-format on
  future<StatusOr<google::cloud::video::stitcher::v1::OperationMetadata>>
  DeleteVodConfig(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteVodConfig
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteVodConfig(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes the specified VOD config.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.video.stitcher.v1.DeleteVodConfigRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.video.stitcher.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.stitcher.v1.DeleteVodConfigRequest]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L943}
  /// [google.cloud.video.stitcher.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L968}
  ///
  // clang-format on
  future<StatusOr<google::cloud::video::stitcher::v1::OperationMetadata>>
  DeleteVodConfig(
      google::cloud::video::stitcher::v1::DeleteVodConfigRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteVodConfig
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteVodConfig(
      NoAwaitTag,
      google::cloud::video::stitcher::v1::DeleteVodConfigRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteVodConfig
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::video::stitcher::v1::OperationMetadata>>
  DeleteVodConfig(google::longrunning::Operation const& operation,
                  Options opts = {});

  // clang-format off
  ///
  /// Updates the specified VOD config. Only update fields specified
  /// in the call method body.
  ///
  /// @param vod_config  Required. The VOD config resource which replaces the resource on the
  ///  server.
  /// @param update_mask  Required. The update mask applies to the resource.
  ///  For the `FieldMask` definition, see
  ///  https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.video.stitcher.v1.VodConfig] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.stitcher.v1.UpdateVodConfigRequest]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L955}
  /// [google.cloud.video.stitcher.v1.VodConfig]: @googleapis_reference_link{google/cloud/video/stitcher/v1/vod_configs.proto#L29}
  ///
  // clang-format on
  future<StatusOr<google::cloud::video::stitcher::v1::VodConfig>>
  UpdateVodConfig(
      google::cloud::video::stitcher::v1::VodConfig const& vod_config,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateVodConfig
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateVodConfig(
      NoAwaitTag,
      google::cloud::video::stitcher::v1::VodConfig const& vod_config,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates the specified VOD config. Only update fields specified
  /// in the call method body.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.video.stitcher.v1.UpdateVodConfigRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.video.stitcher.v1.VodConfig] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.video.stitcher.v1.UpdateVodConfigRequest]: @googleapis_reference_link{google/cloud/video/stitcher/v1/video_stitcher_service.proto#L955}
  /// [google.cloud.video.stitcher.v1.VodConfig]: @googleapis_reference_link{google/cloud/video/stitcher/v1/vod_configs.proto#L29}
  ///
  // clang-format on
  future<StatusOr<google::cloud::video::stitcher::v1::VodConfig>>
  UpdateVodConfig(
      google::cloud::video::stitcher::v1::UpdateVodConfigRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateVodConfig
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateVodConfig(
      NoAwaitTag,
      google::cloud::video::stitcher::v1::UpdateVodConfigRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateVodConfig
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::video::stitcher::v1::VodConfig>>
  UpdateVodConfig(google::longrunning::Operation const& operation,
                  Options opts = {});

  // clang-format off
  ///
  /// Lists operations that match the specified filter in the request. If the
  /// server doesn't support this method, it returns `UNIMPLEMENTED`.
  ///
  /// NOTE: the `name` binding allows API services to override the binding
  /// to use different resource name schemes, such as `users/*/operations`. To
  /// override the binding, API services can add a binding such as
  /// `"/v1/{name=users/*}/operations"` to their service configuration.
  /// For backwards compatibility, the default name includes the operations
  /// collection id, however overriding users must ensure the name binding
  /// is the parent resource, without the operations collection id.
  ///
  /// @param name  The name of the operation's parent resource.
  /// @param filter  The standard list filter.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.longrunning.Operation], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.longrunning.ListOperationsRequest]: @googleapis_reference_link{google/longrunning/operations.proto#L171}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  StreamRange<google::longrunning::Operation> ListOperations(
      std::string const& name, std::string const& filter, Options opts = {});

  // clang-format off
  ///
  /// Lists operations that match the specified filter in the request. If the
  /// server doesn't support this method, it returns `UNIMPLEMENTED`.
  ///
  /// NOTE: the `name` binding allows API services to override the binding
  /// to use different resource name schemes, such as `users/*/operations`. To
  /// override the binding, API services can add a binding such as
  /// `"/v1/{name=users/*}/operations"` to their service configuration.
  /// For backwards compatibility, the default name includes the operations
  /// collection id, however overriding users must ensure the name binding
  /// is the parent resource, without the operations collection id.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.longrunning.ListOperationsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.longrunning.Operation], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.longrunning.ListOperationsRequest]: @googleapis_reference_link{google/longrunning/operations.proto#L171}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  StreamRange<google::longrunning::Operation> ListOperations(
      google::longrunning::ListOperationsRequest request, Options opts = {});

  // clang-format off
  ///
  /// Gets the latest state of a long-running operation.  Clients can use this
  /// method to poll the operation result at intervals as recommended by the API
  /// service.
  ///
  /// @param name  The name of the operation resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.longrunning.Operation])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.longrunning.GetOperationRequest]: @googleapis_reference_link{google/longrunning/operations.proto#L165}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> GetOperation(std::string const& name,
                                                        Options opts = {});

  // clang-format off
  ///
  /// Gets the latest state of a long-running operation.  Clients can use this
  /// method to poll the operation result at intervals as recommended by the API
  /// service.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.longrunning.GetOperationRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.longrunning.Operation])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.longrunning.GetOperationRequest]: @googleapis_reference_link{google/longrunning/operations.proto#L165}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> GetOperation(
      google::longrunning::GetOperationRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes a long-running operation. This method indicates that the client is
  /// no longer interested in the operation result. It does not cancel the
  /// operation. If the server doesn't support this method, it returns
  /// `google.rpc.Code.UNIMPLEMENTED`.
  ///
  /// @param name  The name of the operation resource to be deleted.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.longrunning.DeleteOperationRequest]: @googleapis_reference_link{google/longrunning/operations.proto#L201}
  ///
  // clang-format on
  Status DeleteOperation(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a long-running operation. This method indicates that the client is
  /// no longer interested in the operation result. It does not cancel the
  /// operation. If the server doesn't support this method, it returns
  /// `google.rpc.Code.UNIMPLEMENTED`.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.longrunning.DeleteOperationRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.longrunning.DeleteOperationRequest]: @googleapis_reference_link{google/longrunning/operations.proto#L201}
  ///
  // clang-format on
  Status DeleteOperation(
      google::longrunning::DeleteOperationRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Starts asynchronous cancellation on a long-running operation.  The server
  /// makes a best effort to cancel the operation, but success is not
  /// guaranteed.  If the server doesn't support this method, it returns
  /// `google.rpc.Code.UNIMPLEMENTED`.  Clients can use
  /// [Operations.GetOperation][google.longrunning.Operations.GetOperation] or
  /// other methods to check whether the cancellation succeeded or whether the
  /// operation completed despite cancellation. On successful cancellation,
  /// the operation is not deleted; instead, it becomes an operation with
  /// an [Operation.error][google.longrunning.Operation.error] value with a [google.rpc.Status.code][google.rpc.Status.code] of 1,
  /// corresponding to `Code.CANCELLED`.
  ///
  /// @param name  The name of the operation resource to be cancelled.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.longrunning.CancelOperationRequest]: @googleapis_reference_link{google/longrunning/operations.proto#L195}
  /// [google.longrunning.Operation.error]: @googleapis_reference_link{google/longrunning/operations.proto#L150}
  /// [google.longrunning.Operations.GetOperation]: @googleapis_reference_link{google/longrunning/operations.proto#L77}
  /// [google.rpc.Status.code]: @googleapis_reference_link{google/rpc/status.proto#L38}
  ///
  // clang-format on
  Status CancelOperation(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Starts asynchronous cancellation on a long-running operation.  The server
  /// makes a best effort to cancel the operation, but success is not
  /// guaranteed.  If the server doesn't support this method, it returns
  /// `google.rpc.Code.UNIMPLEMENTED`.  Clients can use
  /// [Operations.GetOperation][google.longrunning.Operations.GetOperation] or
  /// other methods to check whether the cancellation succeeded or whether the
  /// operation completed despite cancellation. On successful cancellation,
  /// the operation is not deleted; instead, it becomes an operation with
  /// an [Operation.error][google.longrunning.Operation.error] value with a [google.rpc.Status.code][google.rpc.Status.code] of 1,
  /// corresponding to `Code.CANCELLED`.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.longrunning.CancelOperationRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.longrunning.CancelOperationRequest]: @googleapis_reference_link{google/longrunning/operations.proto#L195}
  /// [google.longrunning.Operation.error]: @googleapis_reference_link{google/longrunning/operations.proto#L150}
  /// [google.longrunning.Operations.GetOperation]: @googleapis_reference_link{google/longrunning/operations.proto#L77}
  /// [google.rpc.Status.code]: @googleapis_reference_link{google/rpc/status.proto#L38}
  ///
  // clang-format on
  Status CancelOperation(
      google::longrunning::CancelOperationRequest const& request,
      Options opts = {});

 private:
  std::shared_ptr<VideoStitcherServiceConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace video_stitcher_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_VIDEO_STITCHER_V1_VIDEO_STITCHER_CLIENT_H
