// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/video/livestream/v1/service.proto

#include "google/cloud/video/livestream/v1/livestream_connection.h"
#include "google/cloud/video/livestream/v1/internal/livestream_connection_impl.h"
#include "google/cloud/video/livestream/v1/internal/livestream_option_defaults.h"
#include "google/cloud/video/livestream/v1/internal/livestream_stub_factory.h"
#include "google/cloud/video/livestream/v1/internal/livestream_tracing_connection.h"
#include "google/cloud/video/livestream/v1/livestream_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace video_livestream_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

LivestreamServiceConnection::~LivestreamServiceConnection() = default;

future<StatusOr<google::cloud::video::livestream::v1::Channel>>
LivestreamServiceConnection::CreateChannel(
    google::cloud::video::livestream::v1::CreateChannelRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::video::livestream::v1::Channel>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
LivestreamServiceConnection::CreateChannel(
    NoAwaitTag,
    google::cloud::video::livestream::v1::CreateChannelRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::video::livestream::v1::Channel>>
LivestreamServiceConnection::CreateChannel(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::video::livestream::v1::Channel>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::video::livestream::v1::Channel>
LivestreamServiceConnection::ListChannels(
    google::cloud::video::livestream::v1::
        ListChannelsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::video::livestream::v1::Channel>>();
}

StatusOr<google::cloud::video::livestream::v1::Channel>
LivestreamServiceConnection::GetChannel(
    google::cloud::video::livestream::v1::GetChannelRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::video::livestream::v1::OperationMetadata>>
LivestreamServiceConnection::DeleteChannel(
    google::cloud::video::livestream::v1::DeleteChannelRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::video::livestream::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
LivestreamServiceConnection::DeleteChannel(
    NoAwaitTag,
    google::cloud::video::livestream::v1::DeleteChannelRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::video::livestream::v1::OperationMetadata>>
LivestreamServiceConnection::DeleteChannel(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::video::livestream::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::video::livestream::v1::Channel>>
LivestreamServiceConnection::UpdateChannel(
    google::cloud::video::livestream::v1::UpdateChannelRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::video::livestream::v1::Channel>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
LivestreamServiceConnection::UpdateChannel(
    NoAwaitTag,
    google::cloud::video::livestream::v1::UpdateChannelRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::video::livestream::v1::Channel>>
LivestreamServiceConnection::UpdateChannel(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::video::livestream::v1::Channel>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::video::livestream::v1::ChannelOperationResponse>>
LivestreamServiceConnection::StartChannel(
    google::cloud::video::livestream::v1::StartChannelRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::video::livestream::v1::ChannelOperationResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
LivestreamServiceConnection::StartChannel(
    NoAwaitTag,
    google::cloud::video::livestream::v1::StartChannelRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::video::livestream::v1::ChannelOperationResponse>>
LivestreamServiceConnection::StartChannel(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::video::livestream::v1::ChannelOperationResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::video::livestream::v1::ChannelOperationResponse>>
LivestreamServiceConnection::StopChannel(
    google::cloud::video::livestream::v1::StopChannelRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::video::livestream::v1::ChannelOperationResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
LivestreamServiceConnection::StopChannel(
    NoAwaitTag,
    google::cloud::video::livestream::v1::StopChannelRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::video::livestream::v1::ChannelOperationResponse>>
LivestreamServiceConnection::StopChannel(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::video::livestream::v1::ChannelOperationResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::video::livestream::v1::Input>>
LivestreamServiceConnection::CreateInput(
    google::cloud::video::livestream::v1::CreateInputRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::video::livestream::v1::Input>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
LivestreamServiceConnection::CreateInput(
    NoAwaitTag,
    google::cloud::video::livestream::v1::CreateInputRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::video::livestream::v1::Input>>
LivestreamServiceConnection::CreateInput(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::video::livestream::v1::Input>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::video::livestream::v1::Input>
LivestreamServiceConnection::ListInputs(
    google::cloud::video::livestream::v1::
        ListInputsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::video::livestream::v1::Input>>();
}

StatusOr<google::cloud::video::livestream::v1::Input>
LivestreamServiceConnection::GetInput(
    google::cloud::video::livestream::v1::GetInputRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::video::livestream::v1::OperationMetadata>>
LivestreamServiceConnection::DeleteInput(
    google::cloud::video::livestream::v1::DeleteInputRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::video::livestream::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
LivestreamServiceConnection::DeleteInput(
    NoAwaitTag,
    google::cloud::video::livestream::v1::DeleteInputRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::video::livestream::v1::OperationMetadata>>
LivestreamServiceConnection::DeleteInput(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::video::livestream::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::video::livestream::v1::Input>>
LivestreamServiceConnection::UpdateInput(
    google::cloud::video::livestream::v1::UpdateInputRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::video::livestream::v1::Input>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
LivestreamServiceConnection::UpdateInput(
    NoAwaitTag,
    google::cloud::video::livestream::v1::UpdateInputRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::video::livestream::v1::Input>>
LivestreamServiceConnection::UpdateInput(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::video::livestream::v1::Input>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::video::livestream::v1::Event>
LivestreamServiceConnection::CreateEvent(
    google::cloud::video::livestream::v1::CreateEventRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::video::livestream::v1::Event>
LivestreamServiceConnection::ListEvents(
    google::cloud::video::livestream::v1::
        ListEventsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::video::livestream::v1::Event>>();
}

StatusOr<google::cloud::video::livestream::v1::Event>
LivestreamServiceConnection::GetEvent(
    google::cloud::video::livestream::v1::GetEventRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status LivestreamServiceConnection::DeleteEvent(
    google::cloud::video::livestream::v1::DeleteEventRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::video::livestream::v1::Clip>
LivestreamServiceConnection::ListClips(
    google::cloud::video::livestream::v1::
        ListClipsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::video::livestream::v1::Clip>>();
}

StatusOr<google::cloud::video::livestream::v1::Clip>
LivestreamServiceConnection::GetClip(
    google::cloud::video::livestream::v1::GetClipRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::video::livestream::v1::Clip>>
LivestreamServiceConnection::CreateClip(
    google::cloud::video::livestream::v1::CreateClipRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::video::livestream::v1::Clip>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
LivestreamServiceConnection::CreateClip(
    NoAwaitTag,
    google::cloud::video::livestream::v1::CreateClipRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::video::livestream::v1::Clip>>
LivestreamServiceConnection::CreateClip(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::video::livestream::v1::Clip>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::video::livestream::v1::OperationMetadata>>
LivestreamServiceConnection::DeleteClip(
    google::cloud::video::livestream::v1::DeleteClipRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::video::livestream::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
LivestreamServiceConnection::DeleteClip(
    NoAwaitTag,
    google::cloud::video::livestream::v1::DeleteClipRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::video::livestream::v1::OperationMetadata>>
LivestreamServiceConnection::DeleteClip(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::video::livestream::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::video::livestream::v1::Asset>>
LivestreamServiceConnection::CreateAsset(
    google::cloud::video::livestream::v1::CreateAssetRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::video::livestream::v1::Asset>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
LivestreamServiceConnection::CreateAsset(
    NoAwaitTag,
    google::cloud::video::livestream::v1::CreateAssetRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::video::livestream::v1::Asset>>
LivestreamServiceConnection::CreateAsset(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::video::livestream::v1::Asset>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::video::livestream::v1::OperationMetadata>>
LivestreamServiceConnection::DeleteAsset(
    google::cloud::video::livestream::v1::DeleteAssetRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::video::livestream::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
LivestreamServiceConnection::DeleteAsset(
    NoAwaitTag,
    google::cloud::video::livestream::v1::DeleteAssetRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::video::livestream::v1::OperationMetadata>>
LivestreamServiceConnection::DeleteAsset(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::video::livestream::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::video::livestream::v1::Asset>
LivestreamServiceConnection::GetAsset(
    google::cloud::video::livestream::v1::GetAssetRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::video::livestream::v1::Asset>
LivestreamServiceConnection::ListAssets(
    google::cloud::video::livestream::v1::
        ListAssetsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::video::livestream::v1::Asset>>();
}

StatusOr<google::cloud::video::livestream::v1::Pool>
LivestreamServiceConnection::GetPool(
    google::cloud::video::livestream::v1::GetPoolRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::video::livestream::v1::Pool>>
LivestreamServiceConnection::UpdatePool(
    google::cloud::video::livestream::v1::UpdatePoolRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::video::livestream::v1::Pool>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
LivestreamServiceConnection::UpdatePool(
    NoAwaitTag,
    google::cloud::video::livestream::v1::UpdatePoolRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::video::livestream::v1::Pool>>
LivestreamServiceConnection::UpdatePool(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::video::livestream::v1::Pool>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::location::Location>
LivestreamServiceConnection::ListLocations(
    google::cloud::location::
        ListLocationsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::location::Location>>();
}

StatusOr<google::cloud::location::Location>
LivestreamServiceConnection::GetLocation(
    google::cloud::location::GetLocationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::longrunning::Operation>
LivestreamServiceConnection::ListOperations(
    google::longrunning::
        ListOperationsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::longrunning::Operation>>();
}

StatusOr<google::longrunning::Operation>
LivestreamServiceConnection::GetOperation(
    google::longrunning::GetOperationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status LivestreamServiceConnection::DeleteOperation(
    google::longrunning::DeleteOperationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status LivestreamServiceConnection::CancelOperation(
    google::longrunning::CancelOperationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<LivestreamServiceConnection> MakeLivestreamServiceConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 LivestreamServicePolicyOptionList>(options,
                                                                    __func__);
  options = video_livestream_v1_internal::LivestreamServiceDefaultOptions(
      std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub = video_livestream_v1_internal::CreateDefaultLivestreamServiceStub(
      std::move(auth), options);
  return video_livestream_v1_internal::MakeLivestreamServiceTracingConnection(
      std::make_shared<
          video_livestream_v1_internal::LivestreamServiceConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace video_livestream_v1
}  // namespace cloud
}  // namespace google
