// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/translate/v3/translation_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_TRANSLATE_V3_TRANSLATION_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_TRANSLATE_V3_TRANSLATION_CLIENT_H

#include "google/cloud/translate/v3/translation_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <map>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace translate_v3 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Provides natural language translation operations.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class TranslationServiceClient {
 public:
  explicit TranslationServiceClient(
      std::shared_ptr<TranslationServiceConnection> connection,
      Options opts = {});
  ~TranslationServiceClient();

  ///@{
  /// @name Copy and move support
  TranslationServiceClient(TranslationServiceClient const&) = default;
  TranslationServiceClient& operator=(TranslationServiceClient const&) =
      default;
  TranslationServiceClient(TranslationServiceClient&&) = default;
  TranslationServiceClient& operator=(TranslationServiceClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(TranslationServiceClient const& a,
                         TranslationServiceClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(TranslationServiceClient const& a,
                         TranslationServiceClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Translates input text and returns translated text.
  ///
  /// @param parent  Required. Project or location to make a call. Must refer to a caller's
  ///  project.
  ///  @n
  ///  Format: `projects/{project-number-or-id}` or
  ///  `projects/{project-number-or-id}/locations/{location-id}`.
  ///  @n
  ///  For global calls, use `projects/{project-number-or-id}/locations/global` or
  ///  `projects/{project-number-or-id}`.
  ///  @n
  ///  Non-global location is required for requests using AutoML models or
  ///  custom glossaries.
  ///  @n
  ///  Models and glossaries must be within the same region (have same
  ///  location-id), otherwise an INVALID_ARGUMENT (400) error is returned.
  /// @param target_language_code  Required. The ISO-639 language code to use for translation of the input
  ///  text, set to one of the language codes listed in Language Support.
  /// @param contents  Required. The content of the input in string format.
  ///  We recommend the total content be less than 30,000 codepoints. The max
  ///  length of this field is 1024. Use BatchTranslateText for larger text.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.translation.v3.TranslateTextResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.TranslateTextRequest]: @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L483}
  /// [google.cloud.translation.v3.TranslateTextResponse]: @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L567}
  ///
  // clang-format on
  StatusOr<google::cloud::translation::v3::TranslateTextResponse> TranslateText(
      std::string const& parent, std::string const& target_language_code,
      std::vector<std::string> const& contents, Options opts = {});

  // clang-format off
  ///
  /// Translates input text and returns translated text.
  ///
  /// @param parent  Required. Project or location to make a call. Must refer to a caller's
  ///  project.
  ///  @n
  ///  Format: `projects/{project-number-or-id}` or
  ///  `projects/{project-number-or-id}/locations/{location-id}`.
  ///  @n
  ///  For global calls, use `projects/{project-number-or-id}/locations/global` or
  ///  `projects/{project-number-or-id}`.
  ///  @n
  ///  Non-global location is required for requests using AutoML models or
  ///  custom glossaries.
  ///  @n
  ///  Models and glossaries must be within the same region (have same
  ///  location-id), otherwise an INVALID_ARGUMENT (400) error is returned.
  /// @param model  Optional. The `model` type requested for this translation.
  ///  @n
  ///  The format depends on model type:
  ///  @n
  ///  - AutoML Translation models:
  ///    `projects/{project-number-or-id}/locations/{location-id}/models/{model-id}`
  ///  @n
  ///  - General (built-in) models:
  ///    `projects/{project-number-or-id}/locations/{location-id}/models/general/nmt`,
  ///  @n
  ///  - Translation LLM models:
  ///    `projects/{project-number-or-id}/locations/{location-id}/models/general/translation-llm`,
  ///  @n
  ///  For global (non-regionalized) requests, use `location-id` `global`.
  ///  For example,
  ///  `projects/{project-number-or-id}/locations/global/models/general/nmt`.
  ///  @n
  ///  If not provided, the default Google model (NMT) will be used
  /// @param mime_type  Optional. The format of the source text, for example, "text/html",
  ///   "text/plain". If left blank, the MIME type defaults to "text/html".
  /// @param source_language_code  Optional. The ISO-639 language code of the input text if
  ///  known, for example, "en-US" or "sr-Latn". Supported language codes are
  ///  listed in Language Support. If the source language isn't specified, the API
  ///  attempts to identify the source language automatically and returns the
  ///  source language within the response.
  /// @param target_language_code  Required. The ISO-639 language code to use for translation of the input
  ///  text, set to one of the language codes listed in Language Support.
  /// @param contents  Required. The content of the input in string format.
  ///  We recommend the total content be less than 30,000 codepoints. The max
  ///  length of this field is 1024. Use BatchTranslateText for larger text.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.translation.v3.TranslateTextResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.TranslateTextRequest]: @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L483}
  /// [google.cloud.translation.v3.TranslateTextResponse]: @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L567}
  ///
  // clang-format on
  StatusOr<google::cloud::translation::v3::TranslateTextResponse> TranslateText(
      std::string const& parent, std::string const& model,
      std::string const& mime_type, std::string const& source_language_code,
      std::string const& target_language_code,
      std::vector<std::string> const& contents, Options opts = {});

  // clang-format off
  ///
  /// Translates input text and returns translated text.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.translation.v3.TranslateTextRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.translation.v3.TranslateTextResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.TranslateTextRequest]: @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L483}
  /// [google.cloud.translation.v3.TranslateTextResponse]: @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L567}
  ///
  // clang-format on
  StatusOr<google::cloud::translation::v3::TranslateTextResponse> TranslateText(
      google::cloud::translation::v3::TranslateTextRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Romanize input text written in non-Latin scripts to Latin text.
  ///
  /// @param parent  Required. Project or location to make a call. Must refer to a caller's
  ///  project.
  ///  @n
  ///  Format: `projects/{project-number-or-id}/locations/{location-id}` or
  ///  `projects/{project-number-or-id}`.
  ///  @n
  ///  For global calls, use `projects/{project-number-or-id}/locations/global` or
  ///  `projects/{project-number-or-id}`.
  /// @param contents  Required. The content of the input in string format.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.translation.v3.RomanizeTextResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.RomanizeTextRequest]: @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L609}
  /// [google.cloud.translation.v3.RomanizeTextResponse]: @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L650}
  ///
  // clang-format on
  StatusOr<google::cloud::translation::v3::RomanizeTextResponse> RomanizeText(
      std::string const& parent, std::vector<std::string> const& contents,
      Options opts = {});

  // clang-format off
  ///
  /// Romanize input text written in non-Latin scripts to Latin text.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.translation.v3.RomanizeTextRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.translation.v3.RomanizeTextResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.RomanizeTextRequest]: @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L609}
  /// [google.cloud.translation.v3.RomanizeTextResponse]: @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L650}
  ///
  // clang-format on
  StatusOr<google::cloud::translation::v3::RomanizeTextResponse> RomanizeText(
      google::cloud::translation::v3::RomanizeTextRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Detects the language of text within a request.
  ///
  /// @param parent  Required. Project or location to make a call. Must refer to a caller's
  ///  project.
  ///  @n
  ///  Format: `projects/{project-number-or-id}/locations/{location-id}` or
  ///  `projects/{project-number-or-id}`.
  ///  @n
  ///  For global calls, use `projects/{project-number-or-id}/locations/global` or
  ///  `projects/{project-number-or-id}`.
  ///  @n
  ///  Only models within the same region (has same location-id) can be used.
  ///  Otherwise an INVALID_ARGUMENT (400) error is returned.
  /// @param model  Optional. The language detection model to be used.
  ///  @n
  ///  Format:
  ///  `projects/{project-number-or-id}/locations/{location-id}/models/language-detection/{model-id}`
  ///  @n
  ///  Only one language detection model is currently supported:
  ///  `projects/{project-number-or-id}/locations/{location-id}/models/language-detection/default`.
  ///  @n
  ///  If not specified, the default model is used.
  /// @param mime_type  Optional. The format of the source text, for example, "text/html",
  ///  "text/plain". If left blank, the MIME type defaults to "text/html".
  /// @param content  The content of the input stored as a string.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.translation.v3.DetectLanguageResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.DetectLanguageRequest]: @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L658}
  /// [google.cloud.translation.v3.DetectLanguageResponse]: @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L721}
  ///
  // clang-format on
  StatusOr<google::cloud::translation::v3::DetectLanguageResponse>
  DetectLanguage(std::string const& parent, std::string const& model,
                 std::string const& mime_type, std::string const& content,
                 Options opts = {});

  // clang-format off
  ///
  /// Detects the language of text within a request.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.translation.v3.DetectLanguageRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.translation.v3.DetectLanguageResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.DetectLanguageRequest]: @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L658}
  /// [google.cloud.translation.v3.DetectLanguageResponse]: @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L721}
  ///
  // clang-format on
  StatusOr<google::cloud::translation::v3::DetectLanguageResponse>
  DetectLanguage(
      google::cloud::translation::v3::DetectLanguageRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Returns a list of supported languages for translation.
  ///
  /// @param parent  Required. Project or location to make a call. Must refer to a caller's
  ///  project.
  ///  @n
  ///  Format: `projects/{project-number-or-id}` or
  ///  `projects/{project-number-or-id}/locations/{location-id}`.
  ///  @n
  ///  For global calls, use `projects/{project-number-or-id}/locations/global` or
  ///  `projects/{project-number-or-id}`.
  ///  @n
  ///  Non-global location is required for AutoML models.
  ///  @n
  ///  Only models within the same region (have same location-id) can be used,
  ///  otherwise an INVALID_ARGUMENT (400) error is returned.
  /// @param model  Optional. Get supported languages of this model.
  ///  @n
  ///  The format depends on model type:
  ///  @n
  ///  - AutoML Translation models:
  ///    `projects/{project-number-or-id}/locations/{location-id}/models/{model-id}`
  ///  @n
  ///  - General (built-in) models:
  ///    `projects/{project-number-or-id}/locations/{location-id}/models/general/nmt`,
  ///  @n
  ///  Returns languages supported by the specified model.
  ///  If missing, we get supported languages of Google general NMT model.
  /// @param display_language_code  Optional. The language to use to return localized, human readable names
  ///  of supported languages. If missing, then display names are not returned
  ///  in a response.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.translation.v3.SupportedLanguages])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.GetSupportedLanguagesRequest]: @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L728}
  /// [google.cloud.translation.v3.SupportedLanguages]: @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L771}
  ///
  // clang-format on
  StatusOr<google::cloud::translation::v3::SupportedLanguages>
  GetSupportedLanguages(std::string const& parent, std::string const& model,
                        std::string const& display_language_code,
                        Options opts = {});

  // clang-format off
  ///
  /// Returns a list of supported languages for translation.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.translation.v3.GetSupportedLanguagesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.translation.v3.SupportedLanguages])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.GetSupportedLanguagesRequest]: @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L728}
  /// [google.cloud.translation.v3.SupportedLanguages]: @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L771}
  ///
  // clang-format on
  StatusOr<google::cloud::translation::v3::SupportedLanguages>
  GetSupportedLanguages(
      google::cloud::translation::v3::GetSupportedLanguagesRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Translates documents in synchronous mode.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.translation.v3.TranslateDocumentRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.translation.v3.TranslateDocumentResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.TranslateDocumentRequest]: @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L1023}
  /// [google.cloud.translation.v3.TranslateDocumentResponse]: @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L1136}
  ///
  // clang-format on
  StatusOr<google::cloud::translation::v3::TranslateDocumentResponse>
  TranslateDocument(
      google::cloud::translation::v3::TranslateDocumentRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Translates a large volume of text in asynchronous batch mode.
  /// This function provides real-time output as the inputs are being processed.
  /// If caller cancels a request, the partial results (for an input file, it's
  /// all or nothing) may still be available on the specified output location.
  ///
  /// This call returns immediately and you can
  /// use google.longrunning.Operation.name to poll the status of the call.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.translation.v3.BatchTranslateTextRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.translation.v3.BatchTranslateResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.BatchTranslateResponse]: @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L1280}
  /// [google.cloud.translation.v3.BatchTranslateTextRequest]: @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L1160}
  ///
  // clang-format on
  future<StatusOr<google::cloud::translation::v3::BatchTranslateResponse>>
  BatchTranslateText(
      google::cloud::translation::v3::BatchTranslateTextRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief BatchTranslateText
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> BatchTranslateText(
      NoAwaitTag,
      google::cloud::translation::v3::BatchTranslateTextRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief BatchTranslateText
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::translation::v3::BatchTranslateResponse>>
  BatchTranslateText(google::longrunning::Operation const& operation,
                     Options opts = {});

  // clang-format off
  ///
  /// Translates a large volume of document in asynchronous batch mode.
  /// This function provides real-time output as the inputs are being processed.
  /// If caller cancels a request, the partial results (for an input file, it's
  /// all or nothing) may still be available on the specified output location.
  ///
  /// This call returns immediately and you can use
  /// google.longrunning.Operation.name to poll the status of the call.
  ///
  /// @param parent  Required. Location to make a regional call.
  ///  @n
  ///  Format: `projects/{project-number-or-id}/locations/{location-id}`.
  ///  @n
  ///  The `global` location is not supported for batch translation.
  ///  @n
  ///  Only AutoML Translation models or glossaries within the same region (have
  ///  the same location-id) can be used, otherwise an INVALID_ARGUMENT (400)
  ///  error is returned.
  /// @param source_language_code  Required. The ISO-639 language code of the input document if known, for
  ///  example, "en-US" or "sr-Latn". Supported language codes are listed in
  ///  [Language Support](https://cloud.google.com/translate/docs/languages).
  /// @param target_language_codes  Required. The ISO-639 language code to use for translation of the input
  ///  document. Specify up to 10 language codes here.
  /// @param input_configs  Required. Input configurations.
  ///  The total number of files matched should be <= 100.
  ///  The total content size to translate should be <= 100M Unicode codepoints.
  ///  The files must use UTF-8 encoding.
  /// @param output_config  Required. Output configuration.
  ///  If 2 input configs match to the same file (that is, same input path),
  ///  we don't generate output for duplicate inputs.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.translation.v3.BatchTranslateDocumentResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.BatchTranslateDocumentRequest]: @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L1683}
  /// [google.cloud.translation.v3.BatchTranslateDocumentResponse]: @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L1859}
  ///
  // clang-format on
  future<
      StatusOr<google::cloud::translation::v3::BatchTranslateDocumentResponse>>
  BatchTranslateDocument(
      std::string const& parent, std::string const& source_language_code,
      std::vector<std::string> const& target_language_codes,
      std::vector<
          google::cloud::translation::v3::BatchDocumentInputConfig> const&
          input_configs,
      google::cloud::translation::v3::BatchDocumentOutputConfig const&
          output_config,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief BatchTranslateDocument
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> BatchTranslateDocument(
      NoAwaitTag, std::string const& parent,
      std::string const& source_language_code,
      std::vector<std::string> const& target_language_codes,
      std::vector<
          google::cloud::translation::v3::BatchDocumentInputConfig> const&
          input_configs,
      google::cloud::translation::v3::BatchDocumentOutputConfig const&
          output_config,
      Options opts = {});

  // clang-format off
  ///
  /// Translates a large volume of document in asynchronous batch mode.
  /// This function provides real-time output as the inputs are being processed.
  /// If caller cancels a request, the partial results (for an input file, it's
  /// all or nothing) may still be available on the specified output location.
  ///
  /// This call returns immediately and you can use
  /// google.longrunning.Operation.name to poll the status of the call.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.translation.v3.BatchTranslateDocumentRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.translation.v3.BatchTranslateDocumentResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.BatchTranslateDocumentRequest]: @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L1683}
  /// [google.cloud.translation.v3.BatchTranslateDocumentResponse]: @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L1859}
  ///
  // clang-format on
  future<
      StatusOr<google::cloud::translation::v3::BatchTranslateDocumentResponse>>
  BatchTranslateDocument(
      google::cloud::translation::v3::BatchTranslateDocumentRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief BatchTranslateDocument
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> BatchTranslateDocument(
      NoAwaitTag,
      google::cloud::translation::v3::BatchTranslateDocumentRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief BatchTranslateDocument
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<
      StatusOr<google::cloud::translation::v3::BatchTranslateDocumentResponse>>
  BatchTranslateDocument(google::longrunning::Operation const& operation,
                         Options opts = {});

  // clang-format off
  ///
  /// Creates a glossary and returns the long-running operation. Returns
  /// NOT_FOUND, if the project doesn't exist.
  ///
  /// @param parent  Required. The project name.
  /// @param glossary  Required. The glossary to create.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.translation.v3.Glossary] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.CreateGlossaryRequest]: @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L1387}
  /// [google.cloud.translation.v3.Glossary]: @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L1329}
  ///
  // clang-format on
  future<StatusOr<google::cloud::translation::v3::Glossary>> CreateGlossary(
      std::string const& parent,
      google::cloud::translation::v3::Glossary const& glossary,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateGlossary
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateGlossary(
      NoAwaitTag, std::string const& parent,
      google::cloud::translation::v3::Glossary const& glossary,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a glossary and returns the long-running operation. Returns
  /// NOT_FOUND, if the project doesn't exist.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.translation.v3.CreateGlossaryRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.translation.v3.Glossary] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.CreateGlossaryRequest]: @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L1387}
  /// [google.cloud.translation.v3.Glossary]: @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L1329}
  ///
  // clang-format on
  future<StatusOr<google::cloud::translation::v3::Glossary>> CreateGlossary(
      google::cloud::translation::v3::CreateGlossaryRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateGlossary
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateGlossary(
      NoAwaitTag,
      google::cloud::translation::v3::CreateGlossaryRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateGlossary
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::translation::v3::Glossary>> CreateGlossary(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Updates a glossary. A LRO is used since the update can be async if the
  /// glossary's entry file is updated.
  ///
  /// @param glossary  Required. The glossary entry to update.
  /// @param update_mask  The list of fields to be updated. Currently only `display_name` and
  ///  'input_config'
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.translation.v3.Glossary] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.Glossary]: @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L1329}
  /// [google.cloud.translation.v3.UpdateGlossaryRequest]: @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L1401}
  ///
  // clang-format on
  future<StatusOr<google::cloud::translation::v3::Glossary>> UpdateGlossary(
      google::cloud::translation::v3::Glossary const& glossary,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateGlossary
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateGlossary(
      NoAwaitTag, google::cloud::translation::v3::Glossary const& glossary,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates a glossary. A LRO is used since the update can be async if the
  /// glossary's entry file is updated.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.translation.v3.UpdateGlossaryRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.translation.v3.Glossary] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.Glossary]: @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L1329}
  /// [google.cloud.translation.v3.UpdateGlossaryRequest]: @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L1401}
  ///
  // clang-format on
  future<StatusOr<google::cloud::translation::v3::Glossary>> UpdateGlossary(
      google::cloud::translation::v3::UpdateGlossaryRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateGlossary
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateGlossary(
      NoAwaitTag,
      google::cloud::translation::v3::UpdateGlossaryRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateGlossary
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::translation::v3::Glossary>> UpdateGlossary(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Lists glossaries in a project. Returns NOT_FOUND, if the project doesn't
  /// exist.
  ///
  /// @param parent  Required. The name of the project from which to list all of the glossaries.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.translation.v3.Glossary], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.Glossary]: @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L1329}
  /// [google.cloud.translation.v3.ListGlossariesRequest]: @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L1433}
  ///
  // clang-format on
  StreamRange<google::cloud::translation::v3::Glossary> ListGlossaries(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists glossaries in a project. Returns NOT_FOUND, if the project doesn't
  /// exist.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.translation.v3.ListGlossariesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.translation.v3.Glossary], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.Glossary]: @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L1329}
  /// [google.cloud.translation.v3.ListGlossariesRequest]: @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L1433}
  ///
  // clang-format on
  StreamRange<google::cloud::translation::v3::Glossary> ListGlossaries(
      google::cloud::translation::v3::ListGlossariesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets a glossary. Returns NOT_FOUND, if the glossary doesn't
  /// exist.
  ///
  /// @param name  Required. The name of the glossary to retrieve.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.translation.v3.Glossary])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.GetGlossaryRequest]: @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L1411}
  /// [google.cloud.translation.v3.Glossary]: @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L1329}
  ///
  // clang-format on
  StatusOr<google::cloud::translation::v3::Glossary> GetGlossary(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets a glossary. Returns NOT_FOUND, if the glossary doesn't
  /// exist.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.translation.v3.GetGlossaryRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.translation.v3.Glossary])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.GetGlossaryRequest]: @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L1411}
  /// [google.cloud.translation.v3.Glossary]: @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L1329}
  ///
  // clang-format on
  StatusOr<google::cloud::translation::v3::Glossary> GetGlossary(
      google::cloud::translation::v3::GetGlossaryRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes a glossary, or cancels glossary construction
  /// if the glossary isn't created yet.
  /// Returns NOT_FOUND, if the glossary doesn't exist.
  ///
  /// @param name  Required. The name of the glossary to delete.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.translation.v3.DeleteGlossaryResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.DeleteGlossaryRequest]: @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L1422}
  /// [google.cloud.translation.v3.DeleteGlossaryResponse]: @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L1669}
  ///
  // clang-format on
  future<StatusOr<google::cloud::translation::v3::DeleteGlossaryResponse>>
  DeleteGlossary(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteGlossary
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteGlossary(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a glossary, or cancels glossary construction
  /// if the glossary isn't created yet.
  /// Returns NOT_FOUND, if the glossary doesn't exist.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.translation.v3.DeleteGlossaryRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.translation.v3.DeleteGlossaryResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.DeleteGlossaryRequest]: @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L1422}
  /// [google.cloud.translation.v3.DeleteGlossaryResponse]: @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L1669}
  ///
  // clang-format on
  future<StatusOr<google::cloud::translation::v3::DeleteGlossaryResponse>>
  DeleteGlossary(
      google::cloud::translation::v3::DeleteGlossaryRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteGlossary
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteGlossary(
      NoAwaitTag,
      google::cloud::translation::v3::DeleteGlossaryRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteGlossary
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::translation::v3::DeleteGlossaryResponse>>
  DeleteGlossary(google::longrunning::Operation const& operation,
                 Options opts = {});

  // clang-format off
  ///
  /// Gets a single glossary entry by the given id.
  ///
  /// @param name  Required. The resource name of the glossary entry to get
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.translation.v3.GlossaryEntry])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.GetGlossaryEntryRequest]: @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L1483}
  /// [google.cloud.translation.v3.GlossaryEntry]: @googleapis_reference_link{google/cloud/translate/v3/common.proto#L80}
  ///
  // clang-format on
  StatusOr<google::cloud::translation::v3::GlossaryEntry> GetGlossaryEntry(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets a single glossary entry by the given id.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.translation.v3.GetGlossaryEntryRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.translation.v3.GlossaryEntry])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.GetGlossaryEntryRequest]: @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L1483}
  /// [google.cloud.translation.v3.GlossaryEntry]: @googleapis_reference_link{google/cloud/translate/v3/common.proto#L80}
  ///
  // clang-format on
  StatusOr<google::cloud::translation::v3::GlossaryEntry> GetGlossaryEntry(
      google::cloud::translation::v3::GetGlossaryEntryRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// List the entries for the glossary.
  ///
  /// @param parent  Required. The parent glossary resource name for listing the glossary's
  ///  entries.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.translation.v3.GlossaryEntry], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.GlossaryEntry]: @googleapis_reference_link{google/cloud/translate/v3/common.proto#L80}
  /// [google.cloud.translation.v3.ListGlossaryEntriesRequest]: @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L1505}
  ///
  // clang-format on
  StreamRange<google::cloud::translation::v3::GlossaryEntry>
  ListGlossaryEntries(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// List the entries for the glossary.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.translation.v3.ListGlossaryEntriesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.translation.v3.GlossaryEntry], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.GlossaryEntry]: @googleapis_reference_link{google/cloud/translate/v3/common.proto#L80}
  /// [google.cloud.translation.v3.ListGlossaryEntriesRequest]: @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L1505}
  ///
  // clang-format on
  StreamRange<google::cloud::translation::v3::GlossaryEntry>
  ListGlossaryEntries(
      google::cloud::translation::v3::ListGlossaryEntriesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a glossary entry.
  ///
  /// @param parent  Required. The resource name of the glossary to create the entry under.
  /// @param glossary_entry  Required. The glossary entry to create
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.translation.v3.GlossaryEntry])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.CreateGlossaryEntryRequest]: @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L1538}
  /// [google.cloud.translation.v3.GlossaryEntry]: @googleapis_reference_link{google/cloud/translate/v3/common.proto#L80}
  ///
  // clang-format on
  StatusOr<google::cloud::translation::v3::GlossaryEntry> CreateGlossaryEntry(
      std::string const& parent,
      google::cloud::translation::v3::GlossaryEntry const& glossary_entry,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a glossary entry.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.translation.v3.CreateGlossaryEntryRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.translation.v3.GlossaryEntry])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.CreateGlossaryEntryRequest]: @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L1538}
  /// [google.cloud.translation.v3.GlossaryEntry]: @googleapis_reference_link{google/cloud/translate/v3/common.proto#L80}
  ///
  // clang-format on
  StatusOr<google::cloud::translation::v3::GlossaryEntry> CreateGlossaryEntry(
      google::cloud::translation::v3::CreateGlossaryEntryRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates a glossary entry.
  ///
  /// @param glossary_entry  Required. The glossary entry to update.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.translation.v3.GlossaryEntry])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.GlossaryEntry]: @googleapis_reference_link{google/cloud/translate/v3/common.proto#L80}
  /// [google.cloud.translation.v3.UpdateGlossaryEntryRequest]: @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L1552}
  ///
  // clang-format on
  StatusOr<google::cloud::translation::v3::GlossaryEntry> UpdateGlossaryEntry(
      google::cloud::translation::v3::GlossaryEntry const& glossary_entry,
      Options opts = {});

  // clang-format off
  ///
  /// Updates a glossary entry.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.translation.v3.UpdateGlossaryEntryRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.translation.v3.GlossaryEntry])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.GlossaryEntry]: @googleapis_reference_link{google/cloud/translate/v3/common.proto#L80}
  /// [google.cloud.translation.v3.UpdateGlossaryEntryRequest]: @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L1552}
  ///
  // clang-format on
  StatusOr<google::cloud::translation::v3::GlossaryEntry> UpdateGlossaryEntry(
      google::cloud::translation::v3::UpdateGlossaryEntryRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes a single entry from the glossary
  ///
  /// @param name  Required. The resource name of the glossary entry to delete
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.DeleteGlossaryEntryRequest]: @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L1494}
  ///
  // clang-format on
  Status DeleteGlossaryEntry(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a single entry from the glossary
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.translation.v3.DeleteGlossaryEntryRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.DeleteGlossaryEntryRequest]: @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L1494}
  ///
  // clang-format on
  Status DeleteGlossaryEntry(
      google::cloud::translation::v3::DeleteGlossaryEntryRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a Dataset.
  ///
  /// @param parent  Required. The project name.
  /// @param dataset  Required. The Dataset to create.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.translation.v3.Dataset] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.CreateDatasetRequest]: @googleapis_reference_link{google/cloud/translate/v3/automl_translation.proto#L185}
  /// [google.cloud.translation.v3.Dataset]: @googleapis_reference_link{google/cloud/translate/v3/automl_translation.proto#L292}
  ///
  // clang-format on
  future<StatusOr<google::cloud::translation::v3::Dataset>> CreateDataset(
      std::string const& parent,
      google::cloud::translation::v3::Dataset const& dataset,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateDataset
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateDataset(
      NoAwaitTag, std::string const& parent,
      google::cloud::translation::v3::Dataset const& dataset,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a Dataset.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.translation.v3.CreateDatasetRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.translation.v3.Dataset] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.CreateDatasetRequest]: @googleapis_reference_link{google/cloud/translate/v3/automl_translation.proto#L185}
  /// [google.cloud.translation.v3.Dataset]: @googleapis_reference_link{google/cloud/translate/v3/automl_translation.proto#L292}
  ///
  // clang-format on
  future<StatusOr<google::cloud::translation::v3::Dataset>> CreateDataset(
      google::cloud::translation::v3::CreateDatasetRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateDataset
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateDataset(
      NoAwaitTag,
      google::cloud::translation::v3::CreateDatasetRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateDataset
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::translation::v3::Dataset>> CreateDataset(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Gets a Dataset.
  ///
  /// @param name  Required. The resource name of the dataset to retrieve.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.translation.v3.Dataset])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.Dataset]: @googleapis_reference_link{google/cloud/translate/v3/automl_translation.proto#L292}
  /// [google.cloud.translation.v3.GetDatasetRequest]: @googleapis_reference_link{google/cloud/translate/v3/automl_translation.proto#L142}
  ///
  // clang-format on
  StatusOr<google::cloud::translation::v3::Dataset> GetDataset(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets a Dataset.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.translation.v3.GetDatasetRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.translation.v3.Dataset])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.Dataset]: @googleapis_reference_link{google/cloud/translate/v3/automl_translation.proto#L292}
  /// [google.cloud.translation.v3.GetDatasetRequest]: @googleapis_reference_link{google/cloud/translate/v3/automl_translation.proto#L142}
  ///
  // clang-format on
  StatusOr<google::cloud::translation::v3::Dataset> GetDataset(
      google::cloud::translation::v3::GetDatasetRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists datasets.
  ///
  /// @param parent  Required. Name of the parent project. In form of
  ///  `projects/{project-number-or-id}/locations/{location-id}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.translation.v3.Dataset], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.Dataset]: @googleapis_reference_link{google/cloud/translate/v3/automl_translation.proto#L292}
  /// [google.cloud.translation.v3.ListDatasetsRequest]: @googleapis_reference_link{google/cloud/translate/v3/automl_translation.proto#L153}
  ///
  // clang-format on
  StreamRange<google::cloud::translation::v3::Dataset> ListDatasets(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists datasets.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.translation.v3.ListDatasetsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.translation.v3.Dataset], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.Dataset]: @googleapis_reference_link{google/cloud/translate/v3/automl_translation.proto#L292}
  /// [google.cloud.translation.v3.ListDatasetsRequest]: @googleapis_reference_link{google/cloud/translate/v3/automl_translation.proto#L153}
  ///
  // clang-format on
  StreamRange<google::cloud::translation::v3::Dataset> ListDatasets(
      google::cloud::translation::v3::ListDatasetsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes a dataset and all of its contents.
  ///
  /// @param name  Required. The name of the dataset to delete.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.translation.v3.DeleteDatasetMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.DeleteDatasetMetadata]: @googleapis_reference_link{google/cloud/translate/v3/automl_translation.proto#L127}
  /// [google.cloud.translation.v3.DeleteDatasetRequest]: @googleapis_reference_link{google/cloud/translate/v3/automl_translation.proto#L116}
  ///
  // clang-format on
  future<StatusOr<google::cloud::translation::v3::DeleteDatasetMetadata>>
  DeleteDataset(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteDataset
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteDataset(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a dataset and all of its contents.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.translation.v3.DeleteDatasetRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.translation.v3.DeleteDatasetMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.DeleteDatasetMetadata]: @googleapis_reference_link{google/cloud/translate/v3/automl_translation.proto#L127}
  /// [google.cloud.translation.v3.DeleteDatasetRequest]: @googleapis_reference_link{google/cloud/translate/v3/automl_translation.proto#L116}
  ///
  // clang-format on
  future<StatusOr<google::cloud::translation::v3::DeleteDatasetMetadata>>
  DeleteDataset(
      google::cloud::translation::v3::DeleteDatasetRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteDataset
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteDataset(
      NoAwaitTag,
      google::cloud::translation::v3::DeleteDatasetRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteDataset
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::translation::v3::DeleteDatasetMetadata>>
  DeleteDataset(google::longrunning::Operation const& operation,
                Options opts = {});

  // clang-format off
  ///
  /// Creates an Adaptive MT dataset.
  ///
  /// @param parent  Required. Name of the parent project. In form of
  ///  `projects/{project-number-or-id}/locations/{location-id}`
  /// @param adaptive_mt_dataset  Required. The AdaptiveMtDataset to be created.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.translation.v3.AdaptiveMtDataset])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.AdaptiveMtDataset]: @googleapis_reference_link{google/cloud/translate/v3/adaptive_mt.proto#L34}
  /// [google.cloud.translation.v3.CreateAdaptiveMtDatasetRequest]: @googleapis_reference_link{google/cloud/translate/v3/adaptive_mt.proto#L73}
  ///
  // clang-format on
  StatusOr<google::cloud::translation::v3::AdaptiveMtDataset>
  CreateAdaptiveMtDataset(
      std::string const& parent,
      google::cloud::translation::v3::AdaptiveMtDataset const&
          adaptive_mt_dataset,
      Options opts = {});

  // clang-format off
  ///
  /// Creates an Adaptive MT dataset.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.translation.v3.CreateAdaptiveMtDatasetRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.translation.v3.AdaptiveMtDataset])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.AdaptiveMtDataset]: @googleapis_reference_link{google/cloud/translate/v3/adaptive_mt.proto#L34}
  /// [google.cloud.translation.v3.CreateAdaptiveMtDatasetRequest]: @googleapis_reference_link{google/cloud/translate/v3/adaptive_mt.proto#L73}
  ///
  // clang-format on
  StatusOr<google::cloud::translation::v3::AdaptiveMtDataset>
  CreateAdaptiveMtDataset(
      google::cloud::translation::v3::CreateAdaptiveMtDatasetRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes an Adaptive MT dataset, including all its entries and associated
  /// metadata.
  ///
  /// @param name  Required. Name of the dataset. In the form of
  ///  `projects/{project-number-or-id}/locations/{location-id}/adaptiveMtDatasets/{adaptive-mt-dataset-id}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.DeleteAdaptiveMtDatasetRequest]: @googleapis_reference_link{google/cloud/translate/v3/adaptive_mt.proto#L89}
  ///
  // clang-format on
  Status DeleteAdaptiveMtDataset(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes an Adaptive MT dataset, including all its entries and associated
  /// metadata.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.translation.v3.DeleteAdaptiveMtDatasetRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.DeleteAdaptiveMtDatasetRequest]: @googleapis_reference_link{google/cloud/translate/v3/adaptive_mt.proto#L89}
  ///
  // clang-format on
  Status DeleteAdaptiveMtDataset(
      google::cloud::translation::v3::DeleteAdaptiveMtDatasetRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets the Adaptive MT dataset.
  ///
  /// @param name  Required. Name of the dataset. In the form of
  ///  `projects/{project-number-or-id}/locations/{location-id}/adaptiveMtDatasets/{adaptive-mt-dataset-id}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.translation.v3.AdaptiveMtDataset])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.AdaptiveMtDataset]: @googleapis_reference_link{google/cloud/translate/v3/adaptive_mt.proto#L34}
  /// [google.cloud.translation.v3.GetAdaptiveMtDatasetRequest]: @googleapis_reference_link{google/cloud/translate/v3/adaptive_mt.proto#L101}
  ///
  // clang-format on
  StatusOr<google::cloud::translation::v3::AdaptiveMtDataset>
  GetAdaptiveMtDataset(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets the Adaptive MT dataset.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.translation.v3.GetAdaptiveMtDatasetRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.translation.v3.AdaptiveMtDataset])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.AdaptiveMtDataset]: @googleapis_reference_link{google/cloud/translate/v3/adaptive_mt.proto#L34}
  /// [google.cloud.translation.v3.GetAdaptiveMtDatasetRequest]: @googleapis_reference_link{google/cloud/translate/v3/adaptive_mt.proto#L101}
  ///
  // clang-format on
  StatusOr<google::cloud::translation::v3::AdaptiveMtDataset>
  GetAdaptiveMtDataset(
      google::cloud::translation::v3::GetAdaptiveMtDatasetRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists all Adaptive MT datasets for which the caller has read permission.
  ///
  /// @param parent  Required. The resource name of the project from which to list the Adaptive
  ///  MT datasets. `projects/{project-number-or-id}/locations/{location-id}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.translation.v3.AdaptiveMtDataset], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.AdaptiveMtDataset]: @googleapis_reference_link{google/cloud/translate/v3/adaptive_mt.proto#L34}
  /// [google.cloud.translation.v3.ListAdaptiveMtDatasetsRequest]: @googleapis_reference_link{google/cloud/translate/v3/adaptive_mt.proto#L114}
  ///
  // clang-format on
  StreamRange<google::cloud::translation::v3::AdaptiveMtDataset>
  ListAdaptiveMtDatasets(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists all Adaptive MT datasets for which the caller has read permission.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.translation.v3.ListAdaptiveMtDatasetsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.translation.v3.AdaptiveMtDataset], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.AdaptiveMtDataset]: @googleapis_reference_link{google/cloud/translate/v3/adaptive_mt.proto#L34}
  /// [google.cloud.translation.v3.ListAdaptiveMtDatasetsRequest]: @googleapis_reference_link{google/cloud/translate/v3/adaptive_mt.proto#L114}
  ///
  // clang-format on
  StreamRange<google::cloud::translation::v3::AdaptiveMtDataset>
  ListAdaptiveMtDatasets(
      google::cloud::translation::v3::ListAdaptiveMtDatasetsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Translate text using Adaptive MT.
  ///
  /// @param parent  Required. Location to make a regional call.
  ///  @n
  ///  Format: `projects/{project-number-or-id}/locations/{location-id}`.
  /// @param content  Required. The content of the input in string format.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.translation.v3.AdaptiveMtTranslateResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.AdaptiveMtTranslateRequest]: @googleapis_reference_link{google/cloud/translate/v3/adaptive_mt.proto#L153}
  /// [google.cloud.translation.v3.AdaptiveMtTranslateResponse]: @googleapis_reference_link{google/cloud/translate/v3/adaptive_mt.proto#L245}
  ///
  // clang-format on
  StatusOr<google::cloud::translation::v3::AdaptiveMtTranslateResponse>
  AdaptiveMtTranslate(std::string const& parent,
                      std::vector<std::string> const& content,
                      Options opts = {});

  // clang-format off
  ///
  /// Translate text using Adaptive MT.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.translation.v3.AdaptiveMtTranslateRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.translation.v3.AdaptiveMtTranslateResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.AdaptiveMtTranslateRequest]: @googleapis_reference_link{google/cloud/translate/v3/adaptive_mt.proto#L153}
  /// [google.cloud.translation.v3.AdaptiveMtTranslateResponse]: @googleapis_reference_link{google/cloud/translate/v3/adaptive_mt.proto#L245}
  ///
  // clang-format on
  StatusOr<google::cloud::translation::v3::AdaptiveMtTranslateResponse>
  AdaptiveMtTranslate(
      google::cloud::translation::v3::AdaptiveMtTranslateRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets and AdaptiveMtFile
  ///
  /// @param name  Required. The resource name of the file, in form of
  ///  `projects/{project-number-or-id}/locations/{location_id}/adaptiveMtDatasets/{dataset}/adaptiveMtFiles/{file}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.translation.v3.AdaptiveMtFile])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.AdaptiveMtFile]: @googleapis_reference_link{google/cloud/translate/v3/adaptive_mt.proto#L259}
  /// [google.cloud.translation.v3.GetAdaptiveMtFileRequest]: @googleapis_reference_link{google/cloud/translate/v3/adaptive_mt.proto#L292}
  ///
  // clang-format on
  StatusOr<google::cloud::translation::v3::AdaptiveMtFile> GetAdaptiveMtFile(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets and AdaptiveMtFile
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.translation.v3.GetAdaptiveMtFileRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.translation.v3.AdaptiveMtFile])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.AdaptiveMtFile]: @googleapis_reference_link{google/cloud/translate/v3/adaptive_mt.proto#L259}
  /// [google.cloud.translation.v3.GetAdaptiveMtFileRequest]: @googleapis_reference_link{google/cloud/translate/v3/adaptive_mt.proto#L292}
  ///
  // clang-format on
  StatusOr<google::cloud::translation::v3::AdaptiveMtFile> GetAdaptiveMtFile(
      google::cloud::translation::v3::GetAdaptiveMtFileRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes an AdaptiveMtFile along with its sentences.
  ///
  /// @param name  Required. The resource name of the file to delete, in form of
  ///  `projects/{project-number-or-id}/locations/{location_id}/adaptiveMtDatasets/{dataset}/adaptiveMtFiles/{file}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.DeleteAdaptiveMtFileRequest]: @googleapis_reference_link{google/cloud/translate/v3/adaptive_mt.proto#L304}
  ///
  // clang-format on
  Status DeleteAdaptiveMtFile(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes an AdaptiveMtFile along with its sentences.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.translation.v3.DeleteAdaptiveMtFileRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.DeleteAdaptiveMtFileRequest]: @googleapis_reference_link{google/cloud/translate/v3/adaptive_mt.proto#L304}
  ///
  // clang-format on
  Status DeleteAdaptiveMtFile(
      google::cloud::translation::v3::DeleteAdaptiveMtFileRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Imports an AdaptiveMtFile and adds all of its sentences into the
  /// AdaptiveMtDataset.
  ///
  /// @param parent  Required. The resource name of the file, in form of
  ///  `projects/{project-number-or-id}/locations/{location_id}/adaptiveMtDatasets/{dataset}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.translation.v3.ImportAdaptiveMtFileResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.ImportAdaptiveMtFileRequest]: @googleapis_reference_link{google/cloud/translate/v3/adaptive_mt.proto#L316}
  /// [google.cloud.translation.v3.ImportAdaptiveMtFileResponse]: @googleapis_reference_link{google/cloud/translate/v3/adaptive_mt.proto#L337}
  ///
  // clang-format on
  StatusOr<google::cloud::translation::v3::ImportAdaptiveMtFileResponse>
  ImportAdaptiveMtFile(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Imports an AdaptiveMtFile and adds all of its sentences into the
  /// AdaptiveMtDataset.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.translation.v3.ImportAdaptiveMtFileRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.translation.v3.ImportAdaptiveMtFileResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.ImportAdaptiveMtFileRequest]: @googleapis_reference_link{google/cloud/translate/v3/adaptive_mt.proto#L316}
  /// [google.cloud.translation.v3.ImportAdaptiveMtFileResponse]: @googleapis_reference_link{google/cloud/translate/v3/adaptive_mt.proto#L337}
  ///
  // clang-format on
  StatusOr<google::cloud::translation::v3::ImportAdaptiveMtFileResponse>
  ImportAdaptiveMtFile(
      google::cloud::translation::v3::ImportAdaptiveMtFileRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists all AdaptiveMtFiles associated to an AdaptiveMtDataset.
  ///
  /// @param parent  Required. The resource name of the project from which to list the Adaptive
  ///  MT files.
  ///  `projects/{project}/locations/{location}/adaptiveMtDatasets/{dataset}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.translation.v3.AdaptiveMtFile], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.AdaptiveMtFile]: @googleapis_reference_link{google/cloud/translate/v3/adaptive_mt.proto#L259}
  /// [google.cloud.translation.v3.ListAdaptiveMtFilesRequest]: @googleapis_reference_link{google/cloud/translate/v3/adaptive_mt.proto#L344}
  ///
  // clang-format on
  StreamRange<google::cloud::translation::v3::AdaptiveMtFile>
  ListAdaptiveMtFiles(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists all AdaptiveMtFiles associated to an AdaptiveMtDataset.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.translation.v3.ListAdaptiveMtFilesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.translation.v3.AdaptiveMtFile], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.AdaptiveMtFile]: @googleapis_reference_link{google/cloud/translate/v3/adaptive_mt.proto#L259}
  /// [google.cloud.translation.v3.ListAdaptiveMtFilesRequest]: @googleapis_reference_link{google/cloud/translate/v3/adaptive_mt.proto#L344}
  ///
  // clang-format on
  StreamRange<google::cloud::translation::v3::AdaptiveMtFile>
  ListAdaptiveMtFiles(
      google::cloud::translation::v3::ListAdaptiveMtFilesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists all AdaptiveMtSentences under a given file/dataset.
  ///
  /// @param parent  Required. The resource name of the project from which to list the Adaptive
  ///  MT files. The following format lists all sentences under a file.
  ///  `projects/{project}/locations/{location}/adaptiveMtDatasets/{dataset}/adaptiveMtFiles/{file}`
  ///  The following format lists all sentences within a dataset.
  ///  `projects/{project}/locations/{location}/adaptiveMtDatasets/{dataset}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.translation.v3.AdaptiveMtSentence], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.AdaptiveMtSentence]: @googleapis_reference_link{google/cloud/translate/v3/adaptive_mt.proto#L379}
  /// [google.cloud.translation.v3.ListAdaptiveMtSentencesRequest]: @googleapis_reference_link{google/cloud/translate/v3/adaptive_mt.proto#L412}
  ///
  // clang-format on
  StreamRange<google::cloud::translation::v3::AdaptiveMtSentence>
  ListAdaptiveMtSentences(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists all AdaptiveMtSentences under a given file/dataset.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.translation.v3.ListAdaptiveMtSentencesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.translation.v3.AdaptiveMtSentence], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.AdaptiveMtSentence]: @googleapis_reference_link{google/cloud/translate/v3/adaptive_mt.proto#L379}
  /// [google.cloud.translation.v3.ListAdaptiveMtSentencesRequest]: @googleapis_reference_link{google/cloud/translate/v3/adaptive_mt.proto#L412}
  ///
  // clang-format on
  StreamRange<google::cloud::translation::v3::AdaptiveMtSentence>
  ListAdaptiveMtSentences(
      google::cloud::translation::v3::ListAdaptiveMtSentencesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Import sentence pairs into translation Dataset.
  ///
  /// @param dataset  Required. Name of the dataset. In form of
  ///  `projects/{project-number-or-id}/locations/{location-id}/datasets/{dataset-id}`
  /// @param input_config  Required. The config for the input content.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.translation.v3.ImportDataMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.ImportDataMetadata]: @googleapis_reference_link{google/cloud/translate/v3/automl_translation.proto#L66}
  /// [google.cloud.translation.v3.ImportDataRequest]: @googleapis_reference_link{google/cloud/translate/v3/automl_translation.proto#L35}
  ///
  // clang-format on
  future<StatusOr<google::cloud::translation::v3::ImportDataMetadata>>
  ImportData(
      std::string const& dataset,
      google::cloud::translation::v3::DatasetInputConfig const& input_config,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief ImportData
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> ImportData(
      NoAwaitTag, std::string const& dataset,
      google::cloud::translation::v3::DatasetInputConfig const& input_config,
      Options opts = {});

  // clang-format off
  ///
  /// Import sentence pairs into translation Dataset.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.translation.v3.ImportDataRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.translation.v3.ImportDataMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.ImportDataMetadata]: @googleapis_reference_link{google/cloud/translate/v3/automl_translation.proto#L66}
  /// [google.cloud.translation.v3.ImportDataRequest]: @googleapis_reference_link{google/cloud/translate/v3/automl_translation.proto#L35}
  ///
  // clang-format on
  future<StatusOr<google::cloud::translation::v3::ImportDataMetadata>>
  ImportData(google::cloud::translation::v3::ImportDataRequest const& request,
             Options opts = {});

  // clang-format off
  ///
  /// @copybrief ImportData
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> ImportData(
      NoAwaitTag,
      google::cloud::translation::v3::ImportDataRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief ImportData
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::translation::v3::ImportDataMetadata>>
  ImportData(google::longrunning::Operation const& operation,
             Options opts = {});

  // clang-format off
  ///
  /// Exports dataset's data to the provided output location.
  ///
  /// @param dataset  Required. Name of the dataset. In form of
  ///  `projects/{project-number-or-id}/locations/{location-id}/datasets/{dataset-id}`
  /// @param output_config  Required. The config for the output content.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.translation.v3.ExportDataMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.ExportDataMetadata]: @googleapis_reference_link{google/cloud/translate/v3/automl_translation.proto#L101}
  /// [google.cloud.translation.v3.ExportDataRequest]: @googleapis_reference_link{google/cloud/translate/v3/automl_translation.proto#L81}
  ///
  // clang-format on
  future<StatusOr<google::cloud::translation::v3::ExportDataMetadata>>
  ExportData(
      std::string const& dataset,
      google::cloud::translation::v3::DatasetOutputConfig const& output_config,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief ExportData
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> ExportData(
      NoAwaitTag, std::string const& dataset,
      google::cloud::translation::v3::DatasetOutputConfig const& output_config,
      Options opts = {});

  // clang-format off
  ///
  /// Exports dataset's data to the provided output location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.translation.v3.ExportDataRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.translation.v3.ExportDataMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.ExportDataMetadata]: @googleapis_reference_link{google/cloud/translate/v3/automl_translation.proto#L101}
  /// [google.cloud.translation.v3.ExportDataRequest]: @googleapis_reference_link{google/cloud/translate/v3/automl_translation.proto#L81}
  ///
  // clang-format on
  future<StatusOr<google::cloud::translation::v3::ExportDataMetadata>>
  ExportData(google::cloud::translation::v3::ExportDataRequest const& request,
             Options opts = {});

  // clang-format off
  ///
  /// @copybrief ExportData
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> ExportData(
      NoAwaitTag,
      google::cloud::translation::v3::ExportDataRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief ExportData
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::translation::v3::ExportDataMetadata>>
  ExportData(google::longrunning::Operation const& operation,
             Options opts = {});

  // clang-format off
  ///
  /// Lists sentence pairs in the dataset.
  ///
  /// @param parent  Required. Name of the parent dataset. In form of
  ///  `projects/{project-number-or-id}/locations/{location-id}/datasets/{dataset-id}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.translation.v3.Example], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.Example]: @googleapis_reference_link{google/cloud/translate/v3/automl_translation.proto#L251}
  /// [google.cloud.translation.v3.ListExamplesRequest]: @googleapis_reference_link{google/cloud/translate/v3/automl_translation.proto#L214}
  ///
  // clang-format on
  StreamRange<google::cloud::translation::v3::Example> ListExamples(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists sentence pairs in the dataset.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.translation.v3.ListExamplesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.translation.v3.Example], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.Example]: @googleapis_reference_link{google/cloud/translate/v3/automl_translation.proto#L251}
  /// [google.cloud.translation.v3.ListExamplesRequest]: @googleapis_reference_link{google/cloud/translate/v3/automl_translation.proto#L214}
  ///
  // clang-format on
  StreamRange<google::cloud::translation::v3::Example> ListExamples(
      google::cloud::translation::v3::ListExamplesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a Model.
  ///
  /// @param parent  Required. The project name, in form of
  ///  `projects/{project}/locations/{location}`
  /// @param model  Required. The Model to create.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.translation.v3.Model] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.CreateModelRequest]: @googleapis_reference_link{google/cloud/translate/v3/automl_translation.proto#L335}
  /// [google.cloud.translation.v3.Model]: @googleapis_reference_link{google/cloud/translate/v3/automl_translation.proto#L435}
  ///
  // clang-format on
  future<StatusOr<google::cloud::translation::v3::Model>> CreateModel(
      std::string const& parent,
      google::cloud::translation::v3::Model const& model, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateModel
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateModel(
      NoAwaitTag, std::string const& parent,
      google::cloud::translation::v3::Model const& model, Options opts = {});

  // clang-format off
  ///
  /// Creates a Model.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.translation.v3.CreateModelRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.translation.v3.Model] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.CreateModelRequest]: @googleapis_reference_link{google/cloud/translate/v3/automl_translation.proto#L335}
  /// [google.cloud.translation.v3.Model]: @googleapis_reference_link{google/cloud/translate/v3/automl_translation.proto#L435}
  ///
  // clang-format on
  future<StatusOr<google::cloud::translation::v3::Model>> CreateModel(
      google::cloud::translation::v3::CreateModelRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateModel
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateModel(
      NoAwaitTag,
      google::cloud::translation::v3::CreateModelRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateModel
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::translation::v3::Model>> CreateModel(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Lists models.
  ///
  /// @param parent  Required. Name of the parent project. In form of
  ///  `projects/{project-number-or-id}/locations/{location-id}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.translation.v3.Model], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.ListModelsRequest]: @googleapis_reference_link{google/cloud/translate/v3/automl_translation.proto#L365}
  /// [google.cloud.translation.v3.Model]: @googleapis_reference_link{google/cloud/translate/v3/automl_translation.proto#L435}
  ///
  // clang-format on
  StreamRange<google::cloud::translation::v3::Model> ListModels(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists models.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.translation.v3.ListModelsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.translation.v3.Model], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.ListModelsRequest]: @googleapis_reference_link{google/cloud/translate/v3/automl_translation.proto#L365}
  /// [google.cloud.translation.v3.Model]: @googleapis_reference_link{google/cloud/translate/v3/automl_translation.proto#L435}
  ///
  // clang-format on
  StreamRange<google::cloud::translation::v3::Model> ListModels(
      google::cloud::translation::v3::ListModelsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets a model.
  ///
  /// @param name  Required. The resource name of the model to retrieve.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.translation.v3.Model])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.GetModelRequest]: @googleapis_reference_link{google/cloud/translate/v3/automl_translation.proto#L402}
  /// [google.cloud.translation.v3.Model]: @googleapis_reference_link{google/cloud/translate/v3/automl_translation.proto#L435}
  ///
  // clang-format on
  StatusOr<google::cloud::translation::v3::Model> GetModel(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets a model.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.translation.v3.GetModelRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.translation.v3.Model])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.GetModelRequest]: @googleapis_reference_link{google/cloud/translate/v3/automl_translation.proto#L402}
  /// [google.cloud.translation.v3.Model]: @googleapis_reference_link{google/cloud/translate/v3/automl_translation.proto#L435}
  ///
  // clang-format on
  StatusOr<google::cloud::translation::v3::Model> GetModel(
      google::cloud::translation::v3::GetModelRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes a model.
  ///
  /// @param name  Required. The name of the model to delete.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.translation.v3.DeleteModelMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.DeleteModelMetadata]: @googleapis_reference_link{google/cloud/translate/v3/automl_translation.proto#L420}
  /// [google.cloud.translation.v3.DeleteModelRequest]: @googleapis_reference_link{google/cloud/translate/v3/automl_translation.proto#L411}
  ///
  // clang-format on
  future<StatusOr<google::cloud::translation::v3::DeleteModelMetadata>>
  DeleteModel(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteModel
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteModel(NoAwaitTag,
                                                       std::string const& name,
                                                       Options opts = {});

  // clang-format off
  ///
  /// Deletes a model.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.translation.v3.DeleteModelRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.translation.v3.DeleteModelMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.translation.v3.DeleteModelMetadata]: @googleapis_reference_link{google/cloud/translate/v3/automl_translation.proto#L420}
  /// [google.cloud.translation.v3.DeleteModelRequest]: @googleapis_reference_link{google/cloud/translate/v3/automl_translation.proto#L411}
  ///
  // clang-format on
  future<StatusOr<google::cloud::translation::v3::DeleteModelMetadata>>
  DeleteModel(google::cloud::translation::v3::DeleteModelRequest const& request,
              Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteModel
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteModel(
      NoAwaitTag,
      google::cloud::translation::v3::DeleteModelRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteModel
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::translation::v3::DeleteModelMetadata>>
  DeleteModel(google::longrunning::Operation const& operation,
              Options opts = {});

  // clang-format off
  ///
  /// Lists information about the supported locations for this service.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.location.ListLocationsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.location.Location], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.location.ListLocationsRequest]: @googleapis_reference_link{google/cloud/location/locations.proto#L58}
  /// [google.cloud.location.Location]: @googleapis_reference_link{google/cloud/location/locations.proto#L88}
  ///
  // clang-format on
  StreamRange<google::cloud::location::Location> ListLocations(
      google::cloud::location::ListLocationsRequest request, Options opts = {});

  // clang-format off
  ///
  /// Gets information about a location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.location.GetLocationRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.location.Location])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.location.GetLocationRequest]: @googleapis_reference_link{google/cloud/location/locations.proto#L82}
  /// [google.cloud.location.Location]: @googleapis_reference_link{google/cloud/location/locations.proto#L88}
  ///
  // clang-format on
  StatusOr<google::cloud::location::Location> GetLocation(
      google::cloud::location::GetLocationRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists operations that match the specified filter in the request. If the
  /// server doesn't support this method, it returns `UNIMPLEMENTED`.
  ///
  /// NOTE: the `name` binding allows API services to override the binding
  /// to use different resource name schemes, such as `users/*/operations`. To
  /// override the binding, API services can add a binding such as
  /// `"/v1/{name=users/*}/operations"` to their service configuration.
  /// For backwards compatibility, the default name includes the operations
  /// collection id, however overriding users must ensure the name binding
  /// is the parent resource, without the operations collection id.
  ///
  /// @param name  The name of the operation's parent resource.
  /// @param filter  The standard list filter.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.longrunning.Operation], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.longrunning.ListOperationsRequest]: @googleapis_reference_link{google/longrunning/operations.proto#L171}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  StreamRange<google::longrunning::Operation> ListOperations(
      std::string const& name, std::string const& filter, Options opts = {});

  // clang-format off
  ///
  /// Lists operations that match the specified filter in the request. If the
  /// server doesn't support this method, it returns `UNIMPLEMENTED`.
  ///
  /// NOTE: the `name` binding allows API services to override the binding
  /// to use different resource name schemes, such as `users/*/operations`. To
  /// override the binding, API services can add a binding such as
  /// `"/v1/{name=users/*}/operations"` to their service configuration.
  /// For backwards compatibility, the default name includes the operations
  /// collection id, however overriding users must ensure the name binding
  /// is the parent resource, without the operations collection id.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.longrunning.ListOperationsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.longrunning.Operation], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.longrunning.ListOperationsRequest]: @googleapis_reference_link{google/longrunning/operations.proto#L171}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  StreamRange<google::longrunning::Operation> ListOperations(
      google::longrunning::ListOperationsRequest request, Options opts = {});

  // clang-format off
  ///
  /// Gets the latest state of a long-running operation.  Clients can use this
  /// method to poll the operation result at intervals as recommended by the API
  /// service.
  ///
  /// @param name  The name of the operation resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.longrunning.Operation])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.longrunning.GetOperationRequest]: @googleapis_reference_link{google/longrunning/operations.proto#L165}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> GetOperation(std::string const& name,
                                                        Options opts = {});

  // clang-format off
  ///
  /// Gets the latest state of a long-running operation.  Clients can use this
  /// method to poll the operation result at intervals as recommended by the API
  /// service.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.longrunning.GetOperationRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.longrunning.Operation])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.longrunning.GetOperationRequest]: @googleapis_reference_link{google/longrunning/operations.proto#L165}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> GetOperation(
      google::longrunning::GetOperationRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes a long-running operation. This method indicates that the client is
  /// no longer interested in the operation result. It does not cancel the
  /// operation. If the server doesn't support this method, it returns
  /// `google.rpc.Code.UNIMPLEMENTED`.
  ///
  /// @param name  The name of the operation resource to be deleted.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.longrunning.DeleteOperationRequest]: @googleapis_reference_link{google/longrunning/operations.proto#L201}
  ///
  // clang-format on
  Status DeleteOperation(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a long-running operation. This method indicates that the client is
  /// no longer interested in the operation result. It does not cancel the
  /// operation. If the server doesn't support this method, it returns
  /// `google.rpc.Code.UNIMPLEMENTED`.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.longrunning.DeleteOperationRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.longrunning.DeleteOperationRequest]: @googleapis_reference_link{google/longrunning/operations.proto#L201}
  ///
  // clang-format on
  Status DeleteOperation(
      google::longrunning::DeleteOperationRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Starts asynchronous cancellation on a long-running operation.  The server
  /// makes a best effort to cancel the operation, but success is not
  /// guaranteed.  If the server doesn't support this method, it returns
  /// `google.rpc.Code.UNIMPLEMENTED`.  Clients can use
  /// [Operations.GetOperation][google.longrunning.Operations.GetOperation] or
  /// other methods to check whether the cancellation succeeded or whether the
  /// operation completed despite cancellation. On successful cancellation,
  /// the operation is not deleted; instead, it becomes an operation with
  /// an [Operation.error][google.longrunning.Operation.error] value with a [google.rpc.Status.code][google.rpc.Status.code] of 1,
  /// corresponding to `Code.CANCELLED`.
  ///
  /// @param name  The name of the operation resource to be cancelled.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.longrunning.CancelOperationRequest]: @googleapis_reference_link{google/longrunning/operations.proto#L195}
  /// [google.longrunning.Operation.error]: @googleapis_reference_link{google/longrunning/operations.proto#L150}
  /// [google.longrunning.Operations.GetOperation]: @googleapis_reference_link{google/longrunning/operations.proto#L77}
  /// [google.rpc.Status.code]: @googleapis_reference_link{google/rpc/status.proto#L38}
  ///
  // clang-format on
  Status CancelOperation(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Starts asynchronous cancellation on a long-running operation.  The server
  /// makes a best effort to cancel the operation, but success is not
  /// guaranteed.  If the server doesn't support this method, it returns
  /// `google.rpc.Code.UNIMPLEMENTED`.  Clients can use
  /// [Operations.GetOperation][google.longrunning.Operations.GetOperation] or
  /// other methods to check whether the cancellation succeeded or whether the
  /// operation completed despite cancellation. On successful cancellation,
  /// the operation is not deleted; instead, it becomes an operation with
  /// an [Operation.error][google.longrunning.Operation.error] value with a [google.rpc.Status.code][google.rpc.Status.code] of 1,
  /// corresponding to `Code.CANCELLED`.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.longrunning.CancelOperationRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.longrunning.CancelOperationRequest]: @googleapis_reference_link{google/longrunning/operations.proto#L195}
  /// [google.longrunning.Operation.error]: @googleapis_reference_link{google/longrunning/operations.proto#L150}
  /// [google.longrunning.Operations.GetOperation]: @googleapis_reference_link{google/longrunning/operations.proto#L77}
  /// [google.rpc.Status.code]: @googleapis_reference_link{google/rpc/status.proto#L38}
  ///
  // clang-format on
  Status CancelOperation(
      google::longrunning::CancelOperationRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Waits until the specified long-running operation is done or reaches at most
  /// a specified timeout, returning the latest state.  If the operation is
  /// already done, the latest state is immediately returned.  If the timeout
  /// specified is greater than the default HTTP/RPC timeout, the HTTP/RPC
  /// timeout is used.  If the server does not support this method, it returns
  /// `google.rpc.Code.UNIMPLEMENTED`.
  /// Note that this method is on a best-effort basis.  It may return the latest
  /// state before the specified timeout (including immediately), meaning even an
  /// immediate response is no guarantee that the operation is done.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.longrunning.WaitOperationRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.longrunning.Operation])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  /// [google.longrunning.WaitOperationRequest]: @googleapis_reference_link{google/longrunning/operations.proto#L207}
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> WaitOperation(
      google::longrunning::WaitOperationRequest const& request,
      Options opts = {});

 private:
  std::shared_ptr<TranslationServiceConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace translate_v3
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_TRANSLATE_V3_TRANSLATION_CLIENT_H
