// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/translate/v3/translation_service.proto

#include "google/cloud/translate/v3/translation_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace translate_v3 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

TranslationServiceClient::TranslationServiceClient(
    std::shared_ptr<TranslationServiceConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
TranslationServiceClient::~TranslationServiceClient() = default;

StatusOr<google::cloud::translation::v3::TranslateTextResponse>
TranslationServiceClient::TranslateText(
    std::string const& parent, std::string const& target_language_code,
    std::vector<std::string> const& contents, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::translation::v3::TranslateTextRequest request;
  request.set_parent(parent);
  request.set_target_language_code(target_language_code);
  *request.mutable_contents() = {contents.begin(), contents.end()};
  return connection_->TranslateText(request);
}

StatusOr<google::cloud::translation::v3::TranslateTextResponse>
TranslationServiceClient::TranslateText(
    std::string const& parent, std::string const& model,
    std::string const& mime_type, std::string const& source_language_code,
    std::string const& target_language_code,
    std::vector<std::string> const& contents, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::translation::v3::TranslateTextRequest request;
  request.set_parent(parent);
  request.set_model(model);
  request.set_mime_type(mime_type);
  request.set_source_language_code(source_language_code);
  request.set_target_language_code(target_language_code);
  *request.mutable_contents() = {contents.begin(), contents.end()};
  return connection_->TranslateText(request);
}

StatusOr<google::cloud::translation::v3::TranslateTextResponse>
TranslationServiceClient::TranslateText(
    google::cloud::translation::v3::TranslateTextRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->TranslateText(request);
}

StatusOr<google::cloud::translation::v3::RomanizeTextResponse>
TranslationServiceClient::RomanizeText(std::string const& parent,
                                       std::vector<std::string> const& contents,
                                       Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::translation::v3::RomanizeTextRequest request;
  request.set_parent(parent);
  *request.mutable_contents() = {contents.begin(), contents.end()};
  return connection_->RomanizeText(request);
}

StatusOr<google::cloud::translation::v3::RomanizeTextResponse>
TranslationServiceClient::RomanizeText(
    google::cloud::translation::v3::RomanizeTextRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RomanizeText(request);
}

StatusOr<google::cloud::translation::v3::DetectLanguageResponse>
TranslationServiceClient::DetectLanguage(std::string const& parent,
                                         std::string const& model,
                                         std::string const& mime_type,
                                         std::string const& content,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::translation::v3::DetectLanguageRequest request;
  request.set_parent(parent);
  request.set_model(model);
  request.set_mime_type(mime_type);
  request.set_content(content);
  return connection_->DetectLanguage(request);
}

StatusOr<google::cloud::translation::v3::DetectLanguageResponse>
TranslationServiceClient::DetectLanguage(
    google::cloud::translation::v3::DetectLanguageRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DetectLanguage(request);
}

StatusOr<google::cloud::translation::v3::SupportedLanguages>
TranslationServiceClient::GetSupportedLanguages(
    std::string const& parent, std::string const& model,
    std::string const& display_language_code, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::translation::v3::GetSupportedLanguagesRequest request;
  request.set_parent(parent);
  request.set_model(model);
  request.set_display_language_code(display_language_code);
  return connection_->GetSupportedLanguages(request);
}

StatusOr<google::cloud::translation::v3::SupportedLanguages>
TranslationServiceClient::GetSupportedLanguages(
    google::cloud::translation::v3::GetSupportedLanguagesRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetSupportedLanguages(request);
}

StatusOr<google::cloud::translation::v3::TranslateDocumentResponse>
TranslationServiceClient::TranslateDocument(
    google::cloud::translation::v3::TranslateDocumentRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->TranslateDocument(request);
}

future<StatusOr<google::cloud::translation::v3::BatchTranslateResponse>>
TranslationServiceClient::BatchTranslateText(
    google::cloud::translation::v3::BatchTranslateTextRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->BatchTranslateText(request);
}

StatusOr<google::longrunning::Operation>
TranslationServiceClient::BatchTranslateText(
    NoAwaitTag,
    google::cloud::translation::v3::BatchTranslateTextRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->BatchTranslateText(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::translation::v3::BatchTranslateResponse>>
TranslationServiceClient::BatchTranslateText(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->BatchTranslateText(operation);
}

future<StatusOr<google::cloud::translation::v3::BatchTranslateDocumentResponse>>
TranslationServiceClient::BatchTranslateDocument(
    std::string const& parent, std::string const& source_language_code,
    std::vector<std::string> const& target_language_codes,
    std::vector<google::cloud::translation::v3::BatchDocumentInputConfig> const&
        input_configs,
    google::cloud::translation::v3::BatchDocumentOutputConfig const&
        output_config,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::translation::v3::BatchTranslateDocumentRequest request;
  request.set_parent(parent);
  request.set_source_language_code(source_language_code);
  *request.mutable_target_language_codes() = {target_language_codes.begin(),
                                              target_language_codes.end()};
  *request.mutable_input_configs() = {input_configs.begin(),
                                      input_configs.end()};
  *request.mutable_output_config() = output_config;
  return connection_->BatchTranslateDocument(request);
}

StatusOr<google::longrunning::Operation>
TranslationServiceClient::BatchTranslateDocument(
    NoAwaitTag, std::string const& parent,
    std::string const& source_language_code,
    std::vector<std::string> const& target_language_codes,
    std::vector<google::cloud::translation::v3::BatchDocumentInputConfig> const&
        input_configs,
    google::cloud::translation::v3::BatchDocumentOutputConfig const&
        output_config,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::translation::v3::BatchTranslateDocumentRequest request;
  request.set_parent(parent);
  request.set_source_language_code(source_language_code);
  *request.mutable_target_language_codes() = {target_language_codes.begin(),
                                              target_language_codes.end()};
  *request.mutable_input_configs() = {input_configs.begin(),
                                      input_configs.end()};
  *request.mutable_output_config() = output_config;
  return connection_->BatchTranslateDocument(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::translation::v3::BatchTranslateDocumentResponse>>
TranslationServiceClient::BatchTranslateDocument(
    google::cloud::translation::v3::BatchTranslateDocumentRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->BatchTranslateDocument(request);
}

StatusOr<google::longrunning::Operation>
TranslationServiceClient::BatchTranslateDocument(
    NoAwaitTag,
    google::cloud::translation::v3::BatchTranslateDocumentRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->BatchTranslateDocument(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::translation::v3::BatchTranslateDocumentResponse>>
TranslationServiceClient::BatchTranslateDocument(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->BatchTranslateDocument(operation);
}

future<StatusOr<google::cloud::translation::v3::Glossary>>
TranslationServiceClient::CreateGlossary(
    std::string const& parent,
    google::cloud::translation::v3::Glossary const& glossary, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::translation::v3::CreateGlossaryRequest request;
  request.set_parent(parent);
  *request.mutable_glossary() = glossary;
  return connection_->CreateGlossary(request);
}

StatusOr<google::longrunning::Operation>
TranslationServiceClient::CreateGlossary(
    NoAwaitTag, std::string const& parent,
    google::cloud::translation::v3::Glossary const& glossary, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::translation::v3::CreateGlossaryRequest request;
  request.set_parent(parent);
  *request.mutable_glossary() = glossary;
  return connection_->CreateGlossary(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::translation::v3::Glossary>>
TranslationServiceClient::CreateGlossary(
    google::cloud::translation::v3::CreateGlossaryRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateGlossary(request);
}

StatusOr<google::longrunning::Operation>
TranslationServiceClient::CreateGlossary(
    NoAwaitTag,
    google::cloud::translation::v3::CreateGlossaryRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateGlossary(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::translation::v3::Glossary>>
TranslationServiceClient::CreateGlossary(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateGlossary(operation);
}

future<StatusOr<google::cloud::translation::v3::Glossary>>
TranslationServiceClient::UpdateGlossary(
    google::cloud::translation::v3::Glossary const& glossary,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::translation::v3::UpdateGlossaryRequest request;
  *request.mutable_glossary() = glossary;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateGlossary(request);
}

StatusOr<google::longrunning::Operation>
TranslationServiceClient::UpdateGlossary(
    NoAwaitTag, google::cloud::translation::v3::Glossary const& glossary,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::translation::v3::UpdateGlossaryRequest request;
  *request.mutable_glossary() = glossary;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateGlossary(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::translation::v3::Glossary>>
TranslationServiceClient::UpdateGlossary(
    google::cloud::translation::v3::UpdateGlossaryRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateGlossary(request);
}

StatusOr<google::longrunning::Operation>
TranslationServiceClient::UpdateGlossary(
    NoAwaitTag,
    google::cloud::translation::v3::UpdateGlossaryRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateGlossary(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::translation::v3::Glossary>>
TranslationServiceClient::UpdateGlossary(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateGlossary(operation);
}

StreamRange<google::cloud::translation::v3::Glossary>
TranslationServiceClient::ListGlossaries(std::string const& parent,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::translation::v3::ListGlossariesRequest request;
  request.set_parent(parent);
  return connection_->ListGlossaries(request);
}

StreamRange<google::cloud::translation::v3::Glossary>
TranslationServiceClient::ListGlossaries(
    google::cloud::translation::v3::ListGlossariesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListGlossaries(std::move(request));
}

StatusOr<google::cloud::translation::v3::Glossary>
TranslationServiceClient::GetGlossary(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::translation::v3::GetGlossaryRequest request;
  request.set_name(name);
  return connection_->GetGlossary(request);
}

StatusOr<google::cloud::translation::v3::Glossary>
TranslationServiceClient::GetGlossary(
    google::cloud::translation::v3::GetGlossaryRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetGlossary(request);
}

future<StatusOr<google::cloud::translation::v3::DeleteGlossaryResponse>>
TranslationServiceClient::DeleteGlossary(std::string const& name,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::translation::v3::DeleteGlossaryRequest request;
  request.set_name(name);
  return connection_->DeleteGlossary(request);
}

StatusOr<google::longrunning::Operation>
TranslationServiceClient::DeleteGlossary(NoAwaitTag, std::string const& name,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::translation::v3::DeleteGlossaryRequest request;
  request.set_name(name);
  return connection_->DeleteGlossary(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::translation::v3::DeleteGlossaryResponse>>
TranslationServiceClient::DeleteGlossary(
    google::cloud::translation::v3::DeleteGlossaryRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteGlossary(request);
}

StatusOr<google::longrunning::Operation>
TranslationServiceClient::DeleteGlossary(
    NoAwaitTag,
    google::cloud::translation::v3::DeleteGlossaryRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteGlossary(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::translation::v3::DeleteGlossaryResponse>>
TranslationServiceClient::DeleteGlossary(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteGlossary(operation);
}

StatusOr<google::cloud::translation::v3::GlossaryEntry>
TranslationServiceClient::GetGlossaryEntry(std::string const& name,
                                           Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::translation::v3::GetGlossaryEntryRequest request;
  request.set_name(name);
  return connection_->GetGlossaryEntry(request);
}

StatusOr<google::cloud::translation::v3::GlossaryEntry>
TranslationServiceClient::GetGlossaryEntry(
    google::cloud::translation::v3::GetGlossaryEntryRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetGlossaryEntry(request);
}

StreamRange<google::cloud::translation::v3::GlossaryEntry>
TranslationServiceClient::ListGlossaryEntries(std::string const& parent,
                                              Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::translation::v3::ListGlossaryEntriesRequest request;
  request.set_parent(parent);
  return connection_->ListGlossaryEntries(request);
}

StreamRange<google::cloud::translation::v3::GlossaryEntry>
TranslationServiceClient::ListGlossaryEntries(
    google::cloud::translation::v3::ListGlossaryEntriesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListGlossaryEntries(std::move(request));
}

StatusOr<google::cloud::translation::v3::GlossaryEntry>
TranslationServiceClient::CreateGlossaryEntry(
    std::string const& parent,
    google::cloud::translation::v3::GlossaryEntry const& glossary_entry,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::translation::v3::CreateGlossaryEntryRequest request;
  request.set_parent(parent);
  *request.mutable_glossary_entry() = glossary_entry;
  return connection_->CreateGlossaryEntry(request);
}

StatusOr<google::cloud::translation::v3::GlossaryEntry>
TranslationServiceClient::CreateGlossaryEntry(
    google::cloud::translation::v3::CreateGlossaryEntryRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateGlossaryEntry(request);
}

StatusOr<google::cloud::translation::v3::GlossaryEntry>
TranslationServiceClient::UpdateGlossaryEntry(
    google::cloud::translation::v3::GlossaryEntry const& glossary_entry,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::translation::v3::UpdateGlossaryEntryRequest request;
  *request.mutable_glossary_entry() = glossary_entry;
  return connection_->UpdateGlossaryEntry(request);
}

StatusOr<google::cloud::translation::v3::GlossaryEntry>
TranslationServiceClient::UpdateGlossaryEntry(
    google::cloud::translation::v3::UpdateGlossaryEntryRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateGlossaryEntry(request);
}

Status TranslationServiceClient::DeleteGlossaryEntry(std::string const& name,
                                                     Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::translation::v3::DeleteGlossaryEntryRequest request;
  request.set_name(name);
  return connection_->DeleteGlossaryEntry(request);
}

Status TranslationServiceClient::DeleteGlossaryEntry(
    google::cloud::translation::v3::DeleteGlossaryEntryRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteGlossaryEntry(request);
}

future<StatusOr<google::cloud::translation::v3::Dataset>>
TranslationServiceClient::CreateDataset(
    std::string const& parent,
    google::cloud::translation::v3::Dataset const& dataset, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::translation::v3::CreateDatasetRequest request;
  request.set_parent(parent);
  *request.mutable_dataset() = dataset;
  return connection_->CreateDataset(request);
}

StatusOr<google::longrunning::Operation>
TranslationServiceClient::CreateDataset(
    NoAwaitTag, std::string const& parent,
    google::cloud::translation::v3::Dataset const& dataset, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::translation::v3::CreateDatasetRequest request;
  request.set_parent(parent);
  *request.mutable_dataset() = dataset;
  return connection_->CreateDataset(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::translation::v3::Dataset>>
TranslationServiceClient::CreateDataset(
    google::cloud::translation::v3::CreateDatasetRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateDataset(request);
}

StatusOr<google::longrunning::Operation>
TranslationServiceClient::CreateDataset(
    NoAwaitTag,
    google::cloud::translation::v3::CreateDatasetRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateDataset(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::translation::v3::Dataset>>
TranslationServiceClient::CreateDataset(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateDataset(operation);
}

StatusOr<google::cloud::translation::v3::Dataset>
TranslationServiceClient::GetDataset(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::translation::v3::GetDatasetRequest request;
  request.set_name(name);
  return connection_->GetDataset(request);
}

StatusOr<google::cloud::translation::v3::Dataset>
TranslationServiceClient::GetDataset(
    google::cloud::translation::v3::GetDatasetRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetDataset(request);
}

StreamRange<google::cloud::translation::v3::Dataset>
TranslationServiceClient::ListDatasets(std::string const& parent,
                                       Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::translation::v3::ListDatasetsRequest request;
  request.set_parent(parent);
  return connection_->ListDatasets(request);
}

StreamRange<google::cloud::translation::v3::Dataset>
TranslationServiceClient::ListDatasets(
    google::cloud::translation::v3::ListDatasetsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListDatasets(std::move(request));
}

future<StatusOr<google::cloud::translation::v3::DeleteDatasetMetadata>>
TranslationServiceClient::DeleteDataset(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::translation::v3::DeleteDatasetRequest request;
  request.set_name(name);
  return connection_->DeleteDataset(request);
}

StatusOr<google::longrunning::Operation>
TranslationServiceClient::DeleteDataset(NoAwaitTag, std::string const& name,
                                        Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::translation::v3::DeleteDatasetRequest request;
  request.set_name(name);
  return connection_->DeleteDataset(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::translation::v3::DeleteDatasetMetadata>>
TranslationServiceClient::DeleteDataset(
    google::cloud::translation::v3::DeleteDatasetRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteDataset(request);
}

StatusOr<google::longrunning::Operation>
TranslationServiceClient::DeleteDataset(
    NoAwaitTag,
    google::cloud::translation::v3::DeleteDatasetRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteDataset(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::translation::v3::DeleteDatasetMetadata>>
TranslationServiceClient::DeleteDataset(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteDataset(operation);
}

StatusOr<google::cloud::translation::v3::AdaptiveMtDataset>
TranslationServiceClient::CreateAdaptiveMtDataset(
    std::string const& parent,
    google::cloud::translation::v3::AdaptiveMtDataset const&
        adaptive_mt_dataset,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::translation::v3::CreateAdaptiveMtDatasetRequest request;
  request.set_parent(parent);
  *request.mutable_adaptive_mt_dataset() = adaptive_mt_dataset;
  return connection_->CreateAdaptiveMtDataset(request);
}

StatusOr<google::cloud::translation::v3::AdaptiveMtDataset>
TranslationServiceClient::CreateAdaptiveMtDataset(
    google::cloud::translation::v3::CreateAdaptiveMtDatasetRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateAdaptiveMtDataset(request);
}

Status TranslationServiceClient::DeleteAdaptiveMtDataset(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::translation::v3::DeleteAdaptiveMtDatasetRequest request;
  request.set_name(name);
  return connection_->DeleteAdaptiveMtDataset(request);
}

Status TranslationServiceClient::DeleteAdaptiveMtDataset(
    google::cloud::translation::v3::DeleteAdaptiveMtDatasetRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteAdaptiveMtDataset(request);
}

StatusOr<google::cloud::translation::v3::AdaptiveMtDataset>
TranslationServiceClient::GetAdaptiveMtDataset(std::string const& name,
                                               Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::translation::v3::GetAdaptiveMtDatasetRequest request;
  request.set_name(name);
  return connection_->GetAdaptiveMtDataset(request);
}

StatusOr<google::cloud::translation::v3::AdaptiveMtDataset>
TranslationServiceClient::GetAdaptiveMtDataset(
    google::cloud::translation::v3::GetAdaptiveMtDatasetRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetAdaptiveMtDataset(request);
}

StreamRange<google::cloud::translation::v3::AdaptiveMtDataset>
TranslationServiceClient::ListAdaptiveMtDatasets(std::string const& parent,
                                                 Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::translation::v3::ListAdaptiveMtDatasetsRequest request;
  request.set_parent(parent);
  return connection_->ListAdaptiveMtDatasets(request);
}

StreamRange<google::cloud::translation::v3::AdaptiveMtDataset>
TranslationServiceClient::ListAdaptiveMtDatasets(
    google::cloud::translation::v3::ListAdaptiveMtDatasetsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListAdaptiveMtDatasets(std::move(request));
}

StatusOr<google::cloud::translation::v3::AdaptiveMtTranslateResponse>
TranslationServiceClient::AdaptiveMtTranslate(
    std::string const& parent, std::vector<std::string> const& content,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::translation::v3::AdaptiveMtTranslateRequest request;
  request.set_parent(parent);
  *request.mutable_content() = {content.begin(), content.end()};
  return connection_->AdaptiveMtTranslate(request);
}

StatusOr<google::cloud::translation::v3::AdaptiveMtTranslateResponse>
TranslationServiceClient::AdaptiveMtTranslate(
    google::cloud::translation::v3::AdaptiveMtTranslateRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->AdaptiveMtTranslate(request);
}

StatusOr<google::cloud::translation::v3::AdaptiveMtFile>
TranslationServiceClient::GetAdaptiveMtFile(std::string const& name,
                                            Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::translation::v3::GetAdaptiveMtFileRequest request;
  request.set_name(name);
  return connection_->GetAdaptiveMtFile(request);
}

StatusOr<google::cloud::translation::v3::AdaptiveMtFile>
TranslationServiceClient::GetAdaptiveMtFile(
    google::cloud::translation::v3::GetAdaptiveMtFileRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetAdaptiveMtFile(request);
}

Status TranslationServiceClient::DeleteAdaptiveMtFile(std::string const& name,
                                                      Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::translation::v3::DeleteAdaptiveMtFileRequest request;
  request.set_name(name);
  return connection_->DeleteAdaptiveMtFile(request);
}

Status TranslationServiceClient::DeleteAdaptiveMtFile(
    google::cloud::translation::v3::DeleteAdaptiveMtFileRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteAdaptiveMtFile(request);
}

StatusOr<google::cloud::translation::v3::ImportAdaptiveMtFileResponse>
TranslationServiceClient::ImportAdaptiveMtFile(std::string const& parent,
                                               Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::translation::v3::ImportAdaptiveMtFileRequest request;
  request.set_parent(parent);
  return connection_->ImportAdaptiveMtFile(request);
}

StatusOr<google::cloud::translation::v3::ImportAdaptiveMtFileResponse>
TranslationServiceClient::ImportAdaptiveMtFile(
    google::cloud::translation::v3::ImportAdaptiveMtFileRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ImportAdaptiveMtFile(request);
}

StreamRange<google::cloud::translation::v3::AdaptiveMtFile>
TranslationServiceClient::ListAdaptiveMtFiles(std::string const& parent,
                                              Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::translation::v3::ListAdaptiveMtFilesRequest request;
  request.set_parent(parent);
  return connection_->ListAdaptiveMtFiles(request);
}

StreamRange<google::cloud::translation::v3::AdaptiveMtFile>
TranslationServiceClient::ListAdaptiveMtFiles(
    google::cloud::translation::v3::ListAdaptiveMtFilesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListAdaptiveMtFiles(std::move(request));
}

StreamRange<google::cloud::translation::v3::AdaptiveMtSentence>
TranslationServiceClient::ListAdaptiveMtSentences(std::string const& parent,
                                                  Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::translation::v3::ListAdaptiveMtSentencesRequest request;
  request.set_parent(parent);
  return connection_->ListAdaptiveMtSentences(request);
}

StreamRange<google::cloud::translation::v3::AdaptiveMtSentence>
TranslationServiceClient::ListAdaptiveMtSentences(
    google::cloud::translation::v3::ListAdaptiveMtSentencesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListAdaptiveMtSentences(std::move(request));
}

future<StatusOr<google::cloud::translation::v3::ImportDataMetadata>>
TranslationServiceClient::ImportData(
    std::string const& dataset,
    google::cloud::translation::v3::DatasetInputConfig const& input_config,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::translation::v3::ImportDataRequest request;
  request.set_dataset(dataset);
  *request.mutable_input_config() = input_config;
  return connection_->ImportData(request);
}

StatusOr<google::longrunning::Operation> TranslationServiceClient::ImportData(
    NoAwaitTag, std::string const& dataset,
    google::cloud::translation::v3::DatasetInputConfig const& input_config,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::translation::v3::ImportDataRequest request;
  request.set_dataset(dataset);
  *request.mutable_input_config() = input_config;
  return connection_->ImportData(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::translation::v3::ImportDataMetadata>>
TranslationServiceClient::ImportData(
    google::cloud::translation::v3::ImportDataRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ImportData(request);
}

StatusOr<google::longrunning::Operation> TranslationServiceClient::ImportData(
    NoAwaitTag,
    google::cloud::translation::v3::ImportDataRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ImportData(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::translation::v3::ImportDataMetadata>>
TranslationServiceClient::ImportData(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ImportData(operation);
}

future<StatusOr<google::cloud::translation::v3::ExportDataMetadata>>
TranslationServiceClient::ExportData(
    std::string const& dataset,
    google::cloud::translation::v3::DatasetOutputConfig const& output_config,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::translation::v3::ExportDataRequest request;
  request.set_dataset(dataset);
  *request.mutable_output_config() = output_config;
  return connection_->ExportData(request);
}

StatusOr<google::longrunning::Operation> TranslationServiceClient::ExportData(
    NoAwaitTag, std::string const& dataset,
    google::cloud::translation::v3::DatasetOutputConfig const& output_config,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::translation::v3::ExportDataRequest request;
  request.set_dataset(dataset);
  *request.mutable_output_config() = output_config;
  return connection_->ExportData(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::translation::v3::ExportDataMetadata>>
TranslationServiceClient::ExportData(
    google::cloud::translation::v3::ExportDataRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ExportData(request);
}

StatusOr<google::longrunning::Operation> TranslationServiceClient::ExportData(
    NoAwaitTag,
    google::cloud::translation::v3::ExportDataRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ExportData(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::translation::v3::ExportDataMetadata>>
TranslationServiceClient::ExportData(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ExportData(operation);
}

StreamRange<google::cloud::translation::v3::Example>
TranslationServiceClient::ListExamples(std::string const& parent,
                                       Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::translation::v3::ListExamplesRequest request;
  request.set_parent(parent);
  return connection_->ListExamples(request);
}

StreamRange<google::cloud::translation::v3::Example>
TranslationServiceClient::ListExamples(
    google::cloud::translation::v3::ListExamplesRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListExamples(std::move(request));
}

future<StatusOr<google::cloud::translation::v3::Model>>
TranslationServiceClient::CreateModel(
    std::string const& parent,
    google::cloud::translation::v3::Model const& model, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::translation::v3::CreateModelRequest request;
  request.set_parent(parent);
  *request.mutable_model() = model;
  return connection_->CreateModel(request);
}

StatusOr<google::longrunning::Operation> TranslationServiceClient::CreateModel(
    NoAwaitTag, std::string const& parent,
    google::cloud::translation::v3::Model const& model, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::translation::v3::CreateModelRequest request;
  request.set_parent(parent);
  *request.mutable_model() = model;
  return connection_->CreateModel(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::translation::v3::Model>>
TranslationServiceClient::CreateModel(
    google::cloud::translation::v3::CreateModelRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateModel(request);
}

StatusOr<google::longrunning::Operation> TranslationServiceClient::CreateModel(
    NoAwaitTag,
    google::cloud::translation::v3::CreateModelRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateModel(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::translation::v3::Model>>
TranslationServiceClient::CreateModel(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateModel(operation);
}

StreamRange<google::cloud::translation::v3::Model>
TranslationServiceClient::ListModels(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::translation::v3::ListModelsRequest request;
  request.set_parent(parent);
  return connection_->ListModels(request);
}

StreamRange<google::cloud::translation::v3::Model>
TranslationServiceClient::ListModels(
    google::cloud::translation::v3::ListModelsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListModels(std::move(request));
}

StatusOr<google::cloud::translation::v3::Model>
TranslationServiceClient::GetModel(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::translation::v3::GetModelRequest request;
  request.set_name(name);
  return connection_->GetModel(request);
}

StatusOr<google::cloud::translation::v3::Model>
TranslationServiceClient::GetModel(
    google::cloud::translation::v3::GetModelRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetModel(request);
}

future<StatusOr<google::cloud::translation::v3::DeleteModelMetadata>>
TranslationServiceClient::DeleteModel(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::translation::v3::DeleteModelRequest request;
  request.set_name(name);
  return connection_->DeleteModel(request);
}

StatusOr<google::longrunning::Operation> TranslationServiceClient::DeleteModel(
    NoAwaitTag, std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::translation::v3::DeleteModelRequest request;
  request.set_name(name);
  return connection_->DeleteModel(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::translation::v3::DeleteModelMetadata>>
TranslationServiceClient::DeleteModel(
    google::cloud::translation::v3::DeleteModelRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteModel(request);
}

StatusOr<google::longrunning::Operation> TranslationServiceClient::DeleteModel(
    NoAwaitTag,
    google::cloud::translation::v3::DeleteModelRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteModel(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::translation::v3::DeleteModelMetadata>>
TranslationServiceClient::DeleteModel(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteModel(operation);
}

StreamRange<google::cloud::location::Location>
TranslationServiceClient::ListLocations(
    google::cloud::location::ListLocationsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListLocations(std::move(request));
}

StatusOr<google::cloud::location::Location>
TranslationServiceClient::GetLocation(
    google::cloud::location::GetLocationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetLocation(request);
}

StreamRange<google::longrunning::Operation>
TranslationServiceClient::ListOperations(std::string const& name,
                                         std::string const& filter,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::ListOperationsRequest request;
  request.set_name(name);
  request.set_filter(filter);
  return connection_->ListOperations(request);
}

StreamRange<google::longrunning::Operation>
TranslationServiceClient::ListOperations(
    google::longrunning::ListOperationsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListOperations(std::move(request));
}

StatusOr<google::longrunning::Operation> TranslationServiceClient::GetOperation(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::GetOperationRequest request;
  request.set_name(name);
  return connection_->GetOperation(request);
}

StatusOr<google::longrunning::Operation> TranslationServiceClient::GetOperation(
    google::longrunning::GetOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetOperation(request);
}

Status TranslationServiceClient::DeleteOperation(std::string const& name,
                                                 Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::DeleteOperationRequest request;
  request.set_name(name);
  return connection_->DeleteOperation(request);
}

Status TranslationServiceClient::DeleteOperation(
    google::longrunning::DeleteOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteOperation(request);
}

Status TranslationServiceClient::CancelOperation(std::string const& name,
                                                 Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::CancelOperationRequest request;
  request.set_name(name);
  return connection_->CancelOperation(request);
}

Status TranslationServiceClient::CancelOperation(
    google::longrunning::CancelOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CancelOperation(request);
}

StatusOr<google::longrunning::Operation>
TranslationServiceClient::WaitOperation(
    google::longrunning::WaitOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->WaitOperation(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace translate_v3
}  // namespace cloud
}  // namespace google
