// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/translate/v3/translation_service.proto

#include "google/cloud/translate/v3/internal/translation_connection_impl.h"
#include "google/cloud/translate/v3/internal/translation_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace translate_v3_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<translate_v3::TranslationServiceRetryPolicy> retry_policy(
    Options const& options) {
  return options.get<translate_v3::TranslationServiceRetryPolicyOption>()
      ->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options.get<translate_v3::TranslationServiceBackoffPolicyOption>()
      ->clone();
}

std::unique_ptr<translate_v3::TranslationServiceConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options
      .get<translate_v3::TranslationServiceConnectionIdempotencyPolicyOption>()
      ->clone();
}

std::unique_ptr<PollingPolicy> polling_policy(Options const& options) {
  return options.get<translate_v3::TranslationServicePollingPolicyOption>()
      ->clone();
}

}  // namespace

TranslationServiceConnectionImpl::TranslationServiceConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<translate_v3_internal::TranslationServiceStub> stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(
          std::move(options), TranslationServiceConnection::options())) {}

StatusOr<google::cloud::translation::v3::TranslateTextResponse>
TranslationServiceConnectionImpl::TranslateText(
    google::cloud::translation::v3::TranslateTextRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->TranslateText(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::translation::v3::TranslateTextRequest const& request) {
        return stub_->TranslateText(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::translation::v3::RomanizeTextResponse>
TranslationServiceConnectionImpl::RomanizeText(
    google::cloud::translation::v3::RomanizeTextRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->RomanizeText(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::translation::v3::RomanizeTextRequest const& request) {
        return stub_->RomanizeText(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::translation::v3::DetectLanguageResponse>
TranslationServiceConnectionImpl::DetectLanguage(
    google::cloud::translation::v3::DetectLanguageRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DetectLanguage(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::translation::v3::DetectLanguageRequest const&
                 request) {
        return stub_->DetectLanguage(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::translation::v3::SupportedLanguages>
TranslationServiceConnectionImpl::GetSupportedLanguages(
    google::cloud::translation::v3::GetSupportedLanguagesRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetSupportedLanguages(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::translation::v3::GetSupportedLanguagesRequest const&
                 request) {
        return stub_->GetSupportedLanguages(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::translation::v3::TranslateDocumentResponse>
TranslationServiceConnectionImpl::TranslateDocument(
    google::cloud::translation::v3::TranslateDocumentRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->TranslateDocument(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::translation::v3::TranslateDocumentRequest const&
                 request) {
        return stub_->TranslateDocument(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::translation::v3::BatchTranslateResponse>>
TranslationServiceConnectionImpl::BatchTranslateText(
    google::cloud::translation::v3::BatchTranslateTextRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->BatchTranslateText(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::translation::v3::BatchTranslateResponse>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::translation::v3::BatchTranslateTextRequest const&
              request) {
        return stub->AsyncBatchTranslateText(cq, std::move(context),
                                             std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::translation::v3::BatchTranslateResponse>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
TranslationServiceConnectionImpl::BatchTranslateText(
    NoAwaitTag,
    google::cloud::translation::v3::BatchTranslateTextRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->BatchTranslateText(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::translation::v3::BatchTranslateTextRequest const&
                 request) {
        return stub_->BatchTranslateText(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::translation::v3::BatchTranslateResponse>>
TranslationServiceConnectionImpl::BatchTranslateText(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::translation::v3::
                   BatchTranslateMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::translation::v3::BatchTranslateResponse>>(
        internal::InvalidArgumentError(
            "operation does not correspond to BatchTranslateText",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::translation::v3::BatchTranslateResponse>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::translation::v3::BatchTranslateResponse>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::translation::v3::BatchTranslateDocumentResponse>>
TranslationServiceConnectionImpl::BatchTranslateDocument(
    google::cloud::translation::v3::BatchTranslateDocumentRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->BatchTranslateDocument(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::translation::v3::BatchTranslateDocumentResponse>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::translation::v3::BatchTranslateDocumentRequest const&
              request) {
        return stub->AsyncBatchTranslateDocument(cq, std::move(context),
                                                 std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::translation::v3::BatchTranslateDocumentResponse>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
TranslationServiceConnectionImpl::BatchTranslateDocument(
    NoAwaitTag,
    google::cloud::translation::v3::BatchTranslateDocumentRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->BatchTranslateDocument(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::translation::v3::BatchTranslateDocumentRequest const&
              request) {
        return stub_->BatchTranslateDocument(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::translation::v3::BatchTranslateDocumentResponse>>
TranslationServiceConnectionImpl::BatchTranslateDocument(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::translation::v3::
                   BatchTranslateDocumentMetadata>()) {
    return make_ready_future<StatusOr<
        google::cloud::translation::v3::BatchTranslateDocumentResponse>>(
        internal::InvalidArgumentError(
            "operation does not correspond to BatchTranslateDocument",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::translation::v3::BatchTranslateDocumentResponse>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::translation::v3::BatchTranslateDocumentResponse>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::translation::v3::Glossary>>
TranslationServiceConnectionImpl::CreateGlossary(
    google::cloud::translation::v3::CreateGlossaryRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->CreateGlossary(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::translation::v3::Glossary>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::translation::v3::CreateGlossaryRequest const&
              request) {
        return stub->AsyncCreateGlossary(cq, std::move(context),
                                         std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::translation::v3::Glossary>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
TranslationServiceConnectionImpl::CreateGlossary(
    NoAwaitTag,
    google::cloud::translation::v3::CreateGlossaryRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateGlossary(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::translation::v3::CreateGlossaryRequest const&
                 request) {
        return stub_->CreateGlossary(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::translation::v3::Glossary>>
TranslationServiceConnectionImpl::CreateGlossary(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::translation::v3::
                   CreateGlossaryMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::translation::v3::Glossary>>(
        internal::InvalidArgumentError(
            "operation does not correspond to CreateGlossary",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::translation::v3::Glossary>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::translation::v3::Glossary>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::translation::v3::Glossary>>
TranslationServiceConnectionImpl::UpdateGlossary(
    google::cloud::translation::v3::UpdateGlossaryRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->UpdateGlossary(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::translation::v3::Glossary>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::translation::v3::UpdateGlossaryRequest const&
              request) {
        return stub->AsyncUpdateGlossary(cq, std::move(context),
                                         std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::translation::v3::Glossary>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
TranslationServiceConnectionImpl::UpdateGlossary(
    NoAwaitTag,
    google::cloud::translation::v3::UpdateGlossaryRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateGlossary(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::translation::v3::UpdateGlossaryRequest const&
                 request) {
        return stub_->UpdateGlossary(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::translation::v3::Glossary>>
TranslationServiceConnectionImpl::UpdateGlossary(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::translation::v3::
                   UpdateGlossaryMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::translation::v3::Glossary>>(
        internal::InvalidArgumentError(
            "operation does not correspond to UpdateGlossary",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::translation::v3::Glossary>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::translation::v3::Glossary>,
      polling_policy(*current), __func__);
}

StreamRange<google::cloud::translation::v3::Glossary>
TranslationServiceConnectionImpl::ListGlossaries(
    google::cloud::translation::v3::ListGlossariesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListGlossaries(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::translation::v3::Glossary>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<translate_v3::TranslationServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::translation::v3::ListGlossariesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::translation::v3::ListGlossariesRequest const&
                       request) {
              return stub->ListGlossaries(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::translation::v3::ListGlossariesResponse r) {
        std::vector<google::cloud::translation::v3::Glossary> result(
            r.glossaries().size());
        auto& messages = *r.mutable_glossaries();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::translation::v3::Glossary>
TranslationServiceConnectionImpl::GetGlossary(
    google::cloud::translation::v3::GetGlossaryRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetGlossary(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::translation::v3::GetGlossaryRequest const& request) {
        return stub_->GetGlossary(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::translation::v3::DeleteGlossaryResponse>>
TranslationServiceConnectionImpl::DeleteGlossary(
    google::cloud::translation::v3::DeleteGlossaryRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->DeleteGlossary(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::translation::v3::DeleteGlossaryResponse>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::translation::v3::DeleteGlossaryRequest const&
              request) {
        return stub->AsyncDeleteGlossary(cq, std::move(context),
                                         std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::translation::v3::DeleteGlossaryResponse>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
TranslationServiceConnectionImpl::DeleteGlossary(
    NoAwaitTag,
    google::cloud::translation::v3::DeleteGlossaryRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteGlossary(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::translation::v3::DeleteGlossaryRequest const&
                 request) {
        return stub_->DeleteGlossary(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::translation::v3::DeleteGlossaryResponse>>
TranslationServiceConnectionImpl::DeleteGlossary(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::translation::v3::
                   DeleteGlossaryMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::translation::v3::DeleteGlossaryResponse>>(
        internal::InvalidArgumentError(
            "operation does not correspond to DeleteGlossary",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::translation::v3::DeleteGlossaryResponse>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::translation::v3::DeleteGlossaryResponse>,
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::translation::v3::GlossaryEntry>
TranslationServiceConnectionImpl::GetGlossaryEntry(
    google::cloud::translation::v3::GetGlossaryEntryRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetGlossaryEntry(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::translation::v3::GetGlossaryEntryRequest const&
                 request) {
        return stub_->GetGlossaryEntry(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::cloud::translation::v3::GlossaryEntry>
TranslationServiceConnectionImpl::ListGlossaryEntries(
    google::cloud::translation::v3::ListGlossaryEntriesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListGlossaryEntries(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::translation::v3::GlossaryEntry>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<translate_v3::TranslationServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::translation::v3::ListGlossaryEntriesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::translation::v3::
                       ListGlossaryEntriesRequest const& request) {
              return stub->ListGlossaryEntries(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::translation::v3::ListGlossaryEntriesResponse r) {
        std::vector<google::cloud::translation::v3::GlossaryEntry> result(
            r.glossary_entries().size());
        auto& messages = *r.mutable_glossary_entries();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::translation::v3::GlossaryEntry>
TranslationServiceConnectionImpl::CreateGlossaryEntry(
    google::cloud::translation::v3::CreateGlossaryEntryRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateGlossaryEntry(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::translation::v3::CreateGlossaryEntryRequest const&
                 request) {
        return stub_->CreateGlossaryEntry(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::translation::v3::GlossaryEntry>
TranslationServiceConnectionImpl::UpdateGlossaryEntry(
    google::cloud::translation::v3::UpdateGlossaryEntryRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateGlossaryEntry(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::translation::v3::UpdateGlossaryEntryRequest const&
                 request) {
        return stub_->UpdateGlossaryEntry(context, options, request);
      },
      *current, request, __func__);
}

Status TranslationServiceConnectionImpl::DeleteGlossaryEntry(
    google::cloud::translation::v3::DeleteGlossaryEntryRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteGlossaryEntry(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::translation::v3::DeleteGlossaryEntryRequest const&
                 request) {
        return stub_->DeleteGlossaryEntry(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::translation::v3::Dataset>>
TranslationServiceConnectionImpl::CreateDataset(
    google::cloud::translation::v3::CreateDatasetRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->CreateDataset(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::translation::v3::Dataset>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::translation::v3::CreateDatasetRequest const& request) {
        return stub->AsyncCreateDataset(cq, std::move(context),
                                        std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::translation::v3::Dataset>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
TranslationServiceConnectionImpl::CreateDataset(
    NoAwaitTag,
    google::cloud::translation::v3::CreateDatasetRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateDataset(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::translation::v3::CreateDatasetRequest const& request) {
        return stub_->CreateDataset(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::translation::v3::Dataset>>
TranslationServiceConnectionImpl::CreateDataset(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::translation::v3::
                   CreateDatasetMetadata>()) {
    return make_ready_future<StatusOr<google::cloud::translation::v3::Dataset>>(
        internal::InvalidArgumentError(
            "operation does not correspond to CreateDataset",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::translation::v3::Dataset>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::translation::v3::Dataset>,
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::translation::v3::Dataset>
TranslationServiceConnectionImpl::GetDataset(
    google::cloud::translation::v3::GetDatasetRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetDataset(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::translation::v3::GetDatasetRequest const& request) {
        return stub_->GetDataset(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::cloud::translation::v3::Dataset>
TranslationServiceConnectionImpl::ListDatasets(
    google::cloud::translation::v3::ListDatasetsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListDatasets(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::translation::v3::Dataset>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<translate_v3::TranslationServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::translation::v3::ListDatasetsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::translation::v3::ListDatasetsRequest const&
                       request) {
              return stub->ListDatasets(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::translation::v3::ListDatasetsResponse r) {
        std::vector<google::cloud::translation::v3::Dataset> result(
            r.datasets().size());
        auto& messages = *r.mutable_datasets();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

future<StatusOr<google::cloud::translation::v3::DeleteDatasetMetadata>>
TranslationServiceConnectionImpl::DeleteDataset(
    google::cloud::translation::v3::DeleteDatasetRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->DeleteDataset(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::translation::v3::DeleteDatasetMetadata>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::translation::v3::DeleteDatasetRequest const& request) {
        return stub->AsyncDeleteDataset(cq, std::move(context),
                                        std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::translation::v3::DeleteDatasetMetadata>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
TranslationServiceConnectionImpl::DeleteDataset(
    NoAwaitTag,
    google::cloud::translation::v3::DeleteDatasetRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteDataset(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::translation::v3::DeleteDatasetRequest const& request) {
        return stub_->DeleteDataset(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::translation::v3::DeleteDatasetMetadata>>
TranslationServiceConnectionImpl::DeleteDataset(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::translation::v3::
                   DeleteDatasetMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::translation::v3::DeleteDatasetMetadata>>(
        internal::InvalidArgumentError(
            "operation does not correspond to DeleteDataset",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::translation::v3::DeleteDatasetMetadata>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::translation::v3::DeleteDatasetMetadata>,
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::translation::v3::AdaptiveMtDataset>
TranslationServiceConnectionImpl::CreateAdaptiveMtDataset(
    google::cloud::translation::v3::CreateAdaptiveMtDatasetRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateAdaptiveMtDataset(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::translation::v3::CreateAdaptiveMtDatasetRequest const&
              request) {
        return stub_->CreateAdaptiveMtDataset(context, options, request);
      },
      *current, request, __func__);
}

Status TranslationServiceConnectionImpl::DeleteAdaptiveMtDataset(
    google::cloud::translation::v3::DeleteAdaptiveMtDatasetRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteAdaptiveMtDataset(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::translation::v3::DeleteAdaptiveMtDatasetRequest const&
              request) {
        return stub_->DeleteAdaptiveMtDataset(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::translation::v3::AdaptiveMtDataset>
TranslationServiceConnectionImpl::GetAdaptiveMtDataset(
    google::cloud::translation::v3::GetAdaptiveMtDatasetRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetAdaptiveMtDataset(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::translation::v3::GetAdaptiveMtDatasetRequest const&
                 request) {
        return stub_->GetAdaptiveMtDataset(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::cloud::translation::v3::AdaptiveMtDataset>
TranslationServiceConnectionImpl::ListAdaptiveMtDatasets(
    google::cloud::translation::v3::ListAdaptiveMtDatasetsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->ListAdaptiveMtDatasets(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::translation::v3::AdaptiveMtDataset>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<translate_v3::TranslationServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::translation::v3::ListAdaptiveMtDatasetsRequest const&
              r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::translation::v3::
                       ListAdaptiveMtDatasetsRequest const& request) {
              return stub->ListAdaptiveMtDatasets(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::translation::v3::ListAdaptiveMtDatasetsResponse r) {
        std::vector<google::cloud::translation::v3::AdaptiveMtDataset> result(
            r.adaptive_mt_datasets().size());
        auto& messages = *r.mutable_adaptive_mt_datasets();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::translation::v3::AdaptiveMtTranslateResponse>
TranslationServiceConnectionImpl::AdaptiveMtTranslate(
    google::cloud::translation::v3::AdaptiveMtTranslateRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->AdaptiveMtTranslate(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::translation::v3::AdaptiveMtTranslateRequest const&
                 request) {
        return stub_->AdaptiveMtTranslate(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::translation::v3::AdaptiveMtFile>
TranslationServiceConnectionImpl::GetAdaptiveMtFile(
    google::cloud::translation::v3::GetAdaptiveMtFileRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetAdaptiveMtFile(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::translation::v3::GetAdaptiveMtFileRequest const&
                 request) {
        return stub_->GetAdaptiveMtFile(context, options, request);
      },
      *current, request, __func__);
}

Status TranslationServiceConnectionImpl::DeleteAdaptiveMtFile(
    google::cloud::translation::v3::DeleteAdaptiveMtFileRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteAdaptiveMtFile(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::translation::v3::DeleteAdaptiveMtFileRequest const&
                 request) {
        return stub_->DeleteAdaptiveMtFile(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::translation::v3::ImportAdaptiveMtFileResponse>
TranslationServiceConnectionImpl::ImportAdaptiveMtFile(
    google::cloud::translation::v3::ImportAdaptiveMtFileRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->ImportAdaptiveMtFile(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::translation::v3::ImportAdaptiveMtFileRequest const&
                 request) {
        return stub_->ImportAdaptiveMtFile(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::cloud::translation::v3::AdaptiveMtFile>
TranslationServiceConnectionImpl::ListAdaptiveMtFiles(
    google::cloud::translation::v3::ListAdaptiveMtFilesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListAdaptiveMtFiles(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::translation::v3::AdaptiveMtFile>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<translate_v3::TranslationServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::translation::v3::ListAdaptiveMtFilesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::translation::v3::
                       ListAdaptiveMtFilesRequest const& request) {
              return stub->ListAdaptiveMtFiles(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::translation::v3::ListAdaptiveMtFilesResponse r) {
        std::vector<google::cloud::translation::v3::AdaptiveMtFile> result(
            r.adaptive_mt_files().size());
        auto& messages = *r.mutable_adaptive_mt_files();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StreamRange<google::cloud::translation::v3::AdaptiveMtSentence>
TranslationServiceConnectionImpl::ListAdaptiveMtSentences(
    google::cloud::translation::v3::ListAdaptiveMtSentencesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->ListAdaptiveMtSentences(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::translation::v3::AdaptiveMtSentence>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<translate_v3::TranslationServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::translation::v3::ListAdaptiveMtSentencesRequest const&
              r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::translation::v3::
                       ListAdaptiveMtSentencesRequest const& request) {
              return stub->ListAdaptiveMtSentences(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::translation::v3::ListAdaptiveMtSentencesResponse r) {
        std::vector<google::cloud::translation::v3::AdaptiveMtSentence> result(
            r.adaptive_mt_sentences().size());
        auto& messages = *r.mutable_adaptive_mt_sentences();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

future<StatusOr<google::cloud::translation::v3::ImportDataMetadata>>
TranslationServiceConnectionImpl::ImportData(
    google::cloud::translation::v3::ImportDataRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->ImportData(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::translation::v3::ImportDataMetadata>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::translation::v3::ImportDataRequest const& request) {
        return stub->AsyncImportData(cq, std::move(context), std::move(options),
                                     request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::translation::v3::ImportDataMetadata>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
TranslationServiceConnectionImpl::ImportData(
    NoAwaitTag,
    google::cloud::translation::v3::ImportDataRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->ImportData(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::translation::v3::ImportDataRequest const& request) {
        return stub_->ImportData(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::translation::v3::ImportDataMetadata>>
TranslationServiceConnectionImpl::ImportData(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::translation::v3::ImportDataMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::translation::v3::ImportDataMetadata>>(
        internal::InvalidArgumentError(
            "operation does not correspond to ImportData",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::translation::v3::ImportDataMetadata>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::translation::v3::ImportDataMetadata>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::translation::v3::ExportDataMetadata>>
TranslationServiceConnectionImpl::ExportData(
    google::cloud::translation::v3::ExportDataRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->ExportData(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::translation::v3::ExportDataMetadata>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::translation::v3::ExportDataRequest const& request) {
        return stub->AsyncExportData(cq, std::move(context), std::move(options),
                                     request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::translation::v3::ExportDataMetadata>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
TranslationServiceConnectionImpl::ExportData(
    NoAwaitTag,
    google::cloud::translation::v3::ExportDataRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->ExportData(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::translation::v3::ExportDataRequest const& request) {
        return stub_->ExportData(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::translation::v3::ExportDataMetadata>>
TranslationServiceConnectionImpl::ExportData(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::translation::v3::ExportDataMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::translation::v3::ExportDataMetadata>>(
        internal::InvalidArgumentError(
            "operation does not correspond to ExportData",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::translation::v3::ExportDataMetadata>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::translation::v3::ExportDataMetadata>,
      polling_policy(*current), __func__);
}

StreamRange<google::cloud::translation::v3::Example>
TranslationServiceConnectionImpl::ListExamples(
    google::cloud::translation::v3::ListExamplesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListExamples(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::translation::v3::Example>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<translate_v3::TranslationServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::translation::v3::ListExamplesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::translation::v3::ListExamplesRequest const&
                       request) {
              return stub->ListExamples(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::translation::v3::ListExamplesResponse r) {
        std::vector<google::cloud::translation::v3::Example> result(
            r.examples().size());
        auto& messages = *r.mutable_examples();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

future<StatusOr<google::cloud::translation::v3::Model>>
TranslationServiceConnectionImpl::CreateModel(
    google::cloud::translation::v3::CreateModelRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->CreateModel(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::translation::v3::Model>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::translation::v3::CreateModelRequest const& request) {
        return stub->AsyncCreateModel(cq, std::move(context),
                                      std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::translation::v3::Model>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
TranslationServiceConnectionImpl::CreateModel(
    NoAwaitTag,
    google::cloud::translation::v3::CreateModelRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateModel(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::translation::v3::CreateModelRequest const& request) {
        return stub_->CreateModel(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::translation::v3::Model>>
TranslationServiceConnectionImpl::CreateModel(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::translation::v3::
                   CreateModelMetadata>()) {
    return make_ready_future<StatusOr<google::cloud::translation::v3::Model>>(
        internal::InvalidArgumentError(
            "operation does not correspond to CreateModel",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::translation::v3::Model>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::translation::v3::Model>,
      polling_policy(*current), __func__);
}

StreamRange<google::cloud::translation::v3::Model>
TranslationServiceConnectionImpl::ListModels(
    google::cloud::translation::v3::ListModelsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListModels(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::translation::v3::Model>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<translate_v3::TranslationServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::translation::v3::ListModelsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::translation::v3::ListModelsRequest const&
                       request) {
              return stub->ListModels(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::translation::v3::ListModelsResponse r) {
        std::vector<google::cloud::translation::v3::Model> result(
            r.models().size());
        auto& messages = *r.mutable_models();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::translation::v3::Model>
TranslationServiceConnectionImpl::GetModel(
    google::cloud::translation::v3::GetModelRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetModel(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::translation::v3::GetModelRequest const& request) {
        return stub_->GetModel(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::translation::v3::DeleteModelMetadata>>
TranslationServiceConnectionImpl::DeleteModel(
    google::cloud::translation::v3::DeleteModelRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->DeleteModel(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::translation::v3::DeleteModelMetadata>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::translation::v3::DeleteModelRequest const& request) {
        return stub->AsyncDeleteModel(cq, std::move(context),
                                      std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::translation::v3::DeleteModelMetadata>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
TranslationServiceConnectionImpl::DeleteModel(
    NoAwaitTag,
    google::cloud::translation::v3::DeleteModelRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteModel(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::translation::v3::DeleteModelRequest const& request) {
        return stub_->DeleteModel(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::translation::v3::DeleteModelMetadata>>
TranslationServiceConnectionImpl::DeleteModel(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::translation::v3::
                   DeleteModelMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::translation::v3::DeleteModelMetadata>>(
        internal::InvalidArgumentError(
            "operation does not correspond to DeleteModel",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::translation::v3::DeleteModelMetadata>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::translation::v3::DeleteModelMetadata>,
      polling_policy(*current), __func__);
}

StreamRange<google::cloud::location::Location>
TranslationServiceConnectionImpl::ListLocations(
    google::cloud::location::ListLocationsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListLocations(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::location::Location>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<translate_v3::TranslationServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::location::ListLocationsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context, Options const& options,
                google::cloud::location::ListLocationsRequest const& request) {
              return stub->ListLocations(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::location::ListLocationsResponse r) {
        std::vector<google::cloud::location::Location> result(
            r.locations().size());
        auto& messages = *r.mutable_locations();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::location::Location>
TranslationServiceConnectionImpl::GetLocation(
    google::cloud::location::GetLocationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetLocation(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::location::GetLocationRequest const& request) {
        return stub_->GetLocation(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::longrunning::Operation>
TranslationServiceConnectionImpl::ListOperations(
    google::longrunning::ListOperationsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListOperations(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::longrunning::Operation>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<translate_v3::TranslationServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::longrunning::ListOperationsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::longrunning::ListOperationsRequest const& request) {
              return stub->ListOperations(context, options, request);
            },
            options, r, function_name);
      },
      [](google::longrunning::ListOperationsResponse r) {
        std::vector<google::longrunning::Operation> result(
            r.operations().size());
        auto& messages = *r.mutable_operations();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::longrunning::Operation>
TranslationServiceConnectionImpl::GetOperation(
    google::longrunning::GetOperationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetOperation(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::longrunning::GetOperationRequest const& request) {
        return stub_->GetOperation(context, options, request);
      },
      *current, request, __func__);
}

Status TranslationServiceConnectionImpl::DeleteOperation(
    google::longrunning::DeleteOperationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteOperation(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::longrunning::DeleteOperationRequest const& request) {
        return stub_->DeleteOperation(context, options, request);
      },
      *current, request, __func__);
}

Status TranslationServiceConnectionImpl::CancelOperation(
    google::longrunning::CancelOperationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CancelOperation(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::longrunning::CancelOperationRequest const& request) {
        return stub_->CancelOperation(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::longrunning::Operation>
TranslationServiceConnectionImpl::WaitOperation(
    google::longrunning::WaitOperationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->WaitOperation(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::longrunning::WaitOperationRequest const& request) {
        return stub_->WaitOperation(context, options, request);
      },
      *current, request, __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace translate_v3_internal
}  // namespace cloud
}  // namespace google
