// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/tpu/v1/cloud_tpu.proto

#include "google/cloud/tpu/v1/tpu_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace tpu_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

TpuConnectionIdempotencyPolicy::~TpuConnectionIdempotencyPolicy() = default;

std::unique_ptr<TpuConnectionIdempotencyPolicy>
TpuConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<TpuConnectionIdempotencyPolicy>(*this);
}

Idempotency TpuConnectionIdempotencyPolicy::ListNodes(
    google::cloud::tpu::v1::ListNodesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency TpuConnectionIdempotencyPolicy::GetNode(
    google::cloud::tpu::v1::GetNodeRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency TpuConnectionIdempotencyPolicy::CreateNode(
    google::cloud::tpu::v1::CreateNodeRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency TpuConnectionIdempotencyPolicy::DeleteNode(
    google::cloud::tpu::v1::DeleteNodeRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency TpuConnectionIdempotencyPolicy::ReimageNode(
    google::cloud::tpu::v1::ReimageNodeRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency TpuConnectionIdempotencyPolicy::StopNode(
    google::cloud::tpu::v1::StopNodeRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency TpuConnectionIdempotencyPolicy::StartNode(
    google::cloud::tpu::v1::StartNodeRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency TpuConnectionIdempotencyPolicy::ListTensorFlowVersions(
    google::cloud::tpu::v1::ListTensorFlowVersionsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency TpuConnectionIdempotencyPolicy::GetTensorFlowVersion(
    google::cloud::tpu::v1::GetTensorFlowVersionRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency TpuConnectionIdempotencyPolicy::ListAcceleratorTypes(
    google::cloud::tpu::v1::ListAcceleratorTypesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency TpuConnectionIdempotencyPolicy::GetAcceleratorType(
    google::cloud::tpu::v1::GetAcceleratorTypeRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency TpuConnectionIdempotencyPolicy::ListLocations(
    google::cloud::location::ListLocationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency TpuConnectionIdempotencyPolicy::GetLocation(
    google::cloud::location::GetLocationRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency TpuConnectionIdempotencyPolicy::ListOperations(
    google::longrunning::ListOperationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency TpuConnectionIdempotencyPolicy::GetOperation(
    google::longrunning::GetOperationRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency TpuConnectionIdempotencyPolicy::DeleteOperation(
    google::longrunning::DeleteOperationRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency TpuConnectionIdempotencyPolicy::CancelOperation(
    google::longrunning::CancelOperationRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<TpuConnectionIdempotencyPolicy>
MakeDefaultTpuConnectionIdempotencyPolicy() {
  return std::make_unique<TpuConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace tpu_v1
}  // namespace cloud
}  // namespace google
