// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/texttospeech/v1/cloud_tts.proto

#include "google/cloud/texttospeech/v1/internal/text_to_speech_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace texttospeech_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

TextToSpeechTracingConnection::TextToSpeechTracingConnection(
    std::shared_ptr<texttospeech_v1::TextToSpeechConnection> child)
    : child_(std::move(child)) {}

StatusOr<google::cloud::texttospeech::v1::ListVoicesResponse>
TextToSpeechTracingConnection::ListVoices(
    google::cloud::texttospeech::v1::ListVoicesRequest const& request) {
  auto span =
      internal::MakeSpan("texttospeech_v1::TextToSpeechConnection::ListVoices");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->ListVoices(request));
}

StatusOr<google::cloud::texttospeech::v1::SynthesizeSpeechResponse>
TextToSpeechTracingConnection::SynthesizeSpeech(
    google::cloud::texttospeech::v1::SynthesizeSpeechRequest const& request) {
  auto span = internal::MakeSpan(
      "texttospeech_v1::TextToSpeechConnection::SynthesizeSpeech");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->SynthesizeSpeech(request));
}

std::unique_ptr<::google::cloud::AsyncStreamingReadWriteRpc<
    google::cloud::texttospeech::v1::StreamingSynthesizeRequest,
    google::cloud::texttospeech::v1::StreamingSynthesizeResponse>>
TextToSpeechTracingConnection::AsyncStreamingSynthesize() {
  return child_->AsyncStreamingSynthesize();
}

StreamRange<google::longrunning::Operation>
TextToSpeechTracingConnection::ListOperations(
    google::longrunning::ListOperationsRequest request) {
  auto span = internal::MakeSpan(
      "texttospeech_v1::TextToSpeechConnection::ListOperations");
  internal::OTelScope scope(span);
  auto sr = child_->ListOperations(std::move(request));
  return internal::MakeTracedStreamRange<google::longrunning::Operation>(
      std::move(span), std::move(sr));
}

StatusOr<google::longrunning::Operation>
TextToSpeechTracingConnection::GetOperation(
    google::longrunning::GetOperationRequest const& request) {
  auto span = internal::MakeSpan(
      "texttospeech_v1::TextToSpeechConnection::GetOperation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetOperation(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<texttospeech_v1::TextToSpeechConnection>
MakeTextToSpeechTracingConnection(
    std::shared_ptr<texttospeech_v1::TextToSpeechConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<TextToSpeechTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace texttospeech_v1_internal
}  // namespace cloud
}  // namespace google
