// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/telcoautomation/v1/telcoautomation.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_TELCOAUTOMATION_V1_TELCO_AUTOMATION_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_TELCOAUTOMATION_V1_TELCO_AUTOMATION_CLIENT_H

#include "google/cloud/telcoautomation/v1/telco_automation_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <map>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace telcoautomation_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// TelcoAutomation Service manages the control plane cluster a.k.a.
/// Orchestration Cluster (GKE cluster with config controller) of TNA. It also
/// exposes blueprint APIs which manages the lifecycle of blueprints that
/// control the infrastructure setup (e.g GDCE clusters) and deployment of
/// network functions.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class TelcoAutomationClient {
 public:
  explicit TelcoAutomationClient(
      std::shared_ptr<TelcoAutomationConnection> connection, Options opts = {});
  ~TelcoAutomationClient();

  ///@{
  /// @name Copy and move support
  TelcoAutomationClient(TelcoAutomationClient const&) = default;
  TelcoAutomationClient& operator=(TelcoAutomationClient const&) = default;
  TelcoAutomationClient(TelcoAutomationClient&&) = default;
  TelcoAutomationClient& operator=(TelcoAutomationClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(TelcoAutomationClient const& a,
                         TelcoAutomationClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(TelcoAutomationClient const& a,
                         TelcoAutomationClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Lists OrchestrationClusters in a given project and location.
  ///
  /// @param parent  Required. Parent value for ListOrchestrationClustersRequest
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.telcoautomation.v1.OrchestrationCluster], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.ListOrchestrationClustersRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L904}
  /// [google.cloud.telcoautomation.v1.OrchestrationCluster]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L493}
  ///
  // clang-format on
  StreamRange<google::cloud::telcoautomation::v1::OrchestrationCluster>
  ListOrchestrationClusters(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists OrchestrationClusters in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.telcoautomation.v1.ListOrchestrationClustersRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.telcoautomation.v1.OrchestrationCluster], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.ListOrchestrationClustersRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L904}
  /// [google.cloud.telcoautomation.v1.OrchestrationCluster]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L493}
  ///
  // clang-format on
  StreamRange<google::cloud::telcoautomation::v1::OrchestrationCluster>
  ListOrchestrationClusters(
      google::cloud::telcoautomation::v1::ListOrchestrationClustersRequest
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single OrchestrationCluster.
  ///
  /// @param name  Required. Name of the resource
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.telcoautomation.v1.OrchestrationCluster])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.GetOrchestrationClusterRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L940}
  /// [google.cloud.telcoautomation.v1.OrchestrationCluster]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L493}
  ///
  // clang-format on
  StatusOr<google::cloud::telcoautomation::v1::OrchestrationCluster>
  GetOrchestrationCluster(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single OrchestrationCluster.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.telcoautomation.v1.GetOrchestrationClusterRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.telcoautomation.v1.OrchestrationCluster])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.GetOrchestrationClusterRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L940}
  /// [google.cloud.telcoautomation.v1.OrchestrationCluster]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L493}
  ///
  // clang-format on
  StatusOr<google::cloud::telcoautomation::v1::OrchestrationCluster>
  GetOrchestrationCluster(
      google::cloud::telcoautomation::v1::GetOrchestrationClusterRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new OrchestrationCluster in a given project and location.
  ///
  /// @param parent  Required. Value for parent.
  /// @param orchestration_cluster  Required. The resource being created
  /// @param orchestration_cluster_id  Required. Id of the requesting object
  ///  If auto-generating Id server-side, remove this field and
  ///  orchestration_cluster_id from the method_signature of Create RPC
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.telcoautomation.v1.OrchestrationCluster] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.CreateOrchestrationClusterRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L951}
  /// [google.cloud.telcoautomation.v1.OrchestrationCluster]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L493}
  ///
  // clang-format on
  future<StatusOr<google::cloud::telcoautomation::v1::OrchestrationCluster>>
  CreateOrchestrationCluster(
      std::string const& parent,
      google::cloud::telcoautomation::v1::OrchestrationCluster const&
          orchestration_cluster,
      std::string const& orchestration_cluster_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateOrchestrationCluster
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateOrchestrationCluster(
      NoAwaitTag, std::string const& parent,
      google::cloud::telcoautomation::v1::OrchestrationCluster const&
          orchestration_cluster,
      std::string const& orchestration_cluster_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new OrchestrationCluster in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.telcoautomation.v1.CreateOrchestrationClusterRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.telcoautomation.v1.OrchestrationCluster] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.CreateOrchestrationClusterRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L951}
  /// [google.cloud.telcoautomation.v1.OrchestrationCluster]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L493}
  ///
  // clang-format on
  future<StatusOr<google::cloud::telcoautomation::v1::OrchestrationCluster>>
  CreateOrchestrationCluster(
      google::cloud::telcoautomation::v1::
          CreateOrchestrationClusterRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateOrchestrationCluster
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateOrchestrationCluster(
      NoAwaitTag,
      google::cloud::telcoautomation::v1::
          CreateOrchestrationClusterRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateOrchestrationCluster
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::telcoautomation::v1::OrchestrationCluster>>
  CreateOrchestrationCluster(google::longrunning::Operation const& operation,
                             Options opts = {});

  // clang-format off
  ///
  /// Deletes a single OrchestrationCluster.
  ///
  /// @param name  Required. Name of the resource
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.telcoautomation.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.DeleteOrchestrationClusterRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L986}
  /// [google.cloud.telcoautomation.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1604}
  ///
  // clang-format on
  future<StatusOr<google::cloud::telcoautomation::v1::OperationMetadata>>
  DeleteOrchestrationCluster(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteOrchestrationCluster
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteOrchestrationCluster(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a single OrchestrationCluster.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.telcoautomation.v1.DeleteOrchestrationClusterRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.telcoautomation.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.DeleteOrchestrationClusterRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L986}
  /// [google.cloud.telcoautomation.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1604}
  ///
  // clang-format on
  future<StatusOr<google::cloud::telcoautomation::v1::OperationMetadata>>
  DeleteOrchestrationCluster(
      google::cloud::telcoautomation::v1::
          DeleteOrchestrationClusterRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteOrchestrationCluster
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteOrchestrationCluster(
      NoAwaitTag,
      google::cloud::telcoautomation::v1::
          DeleteOrchestrationClusterRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteOrchestrationCluster
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::telcoautomation::v1::OperationMetadata>>
  DeleteOrchestrationCluster(google::longrunning::Operation const& operation,
                             Options opts = {});

  // clang-format off
  ///
  /// Lists EdgeSlms in a given project and location.
  ///
  /// @param parent  Required. Parent value for ListEdgeSlmsRequest
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.telcoautomation.v1.EdgeSlm], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.EdgeSlm]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L546}
  /// [google.cloud.telcoautomation.v1.ListEdgeSlmsRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1012}
  ///
  // clang-format on
  StreamRange<google::cloud::telcoautomation::v1::EdgeSlm> ListEdgeSlms(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists EdgeSlms in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.telcoautomation.v1.ListEdgeSlmsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.telcoautomation.v1.EdgeSlm], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.EdgeSlm]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L546}
  /// [google.cloud.telcoautomation.v1.ListEdgeSlmsRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1012}
  ///
  // clang-format on
  StreamRange<google::cloud::telcoautomation::v1::EdgeSlm> ListEdgeSlms(
      google::cloud::telcoautomation::v1::ListEdgeSlmsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single EdgeSlm.
  ///
  /// @param name  Required. Name of the resource
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.telcoautomation.v1.EdgeSlm])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.EdgeSlm]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L546}
  /// [google.cloud.telcoautomation.v1.GetEdgeSlmRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1048}
  ///
  // clang-format on
  StatusOr<google::cloud::telcoautomation::v1::EdgeSlm> GetEdgeSlm(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single EdgeSlm.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.telcoautomation.v1.GetEdgeSlmRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.telcoautomation.v1.EdgeSlm])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.EdgeSlm]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L546}
  /// [google.cloud.telcoautomation.v1.GetEdgeSlmRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1048}
  ///
  // clang-format on
  StatusOr<google::cloud::telcoautomation::v1::EdgeSlm> GetEdgeSlm(
      google::cloud::telcoautomation::v1::GetEdgeSlmRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new EdgeSlm in a given project and location.
  ///
  /// @param parent  Required. Value for parent.
  /// @param edge_slm  Required. The resource being created
  /// @param edge_slm_id  Required. Id of the requesting object
  ///  If auto-generating Id server-side, remove this field and
  ///  edge_slm_id from the method_signature of Create RPC
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.telcoautomation.v1.EdgeSlm] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.CreateEdgeSlmRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1059}
  /// [google.cloud.telcoautomation.v1.EdgeSlm]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L546}
  ///
  // clang-format on
  future<StatusOr<google::cloud::telcoautomation::v1::EdgeSlm>> CreateEdgeSlm(
      std::string const& parent,
      google::cloud::telcoautomation::v1::EdgeSlm const& edge_slm,
      std::string const& edge_slm_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateEdgeSlm
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateEdgeSlm(
      NoAwaitTag, std::string const& parent,
      google::cloud::telcoautomation::v1::EdgeSlm const& edge_slm,
      std::string const& edge_slm_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new EdgeSlm in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.telcoautomation.v1.CreateEdgeSlmRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.telcoautomation.v1.EdgeSlm] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.CreateEdgeSlmRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1059}
  /// [google.cloud.telcoautomation.v1.EdgeSlm]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L546}
  ///
  // clang-format on
  future<StatusOr<google::cloud::telcoautomation::v1::EdgeSlm>> CreateEdgeSlm(
      google::cloud::telcoautomation::v1::CreateEdgeSlmRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateEdgeSlm
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateEdgeSlm(
      NoAwaitTag,
      google::cloud::telcoautomation::v1::CreateEdgeSlmRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateEdgeSlm
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::telcoautomation::v1::EdgeSlm>> CreateEdgeSlm(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Deletes a single EdgeSlm.
  ///
  /// @param name  Required. Name of the resource
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.telcoautomation.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.DeleteEdgeSlmRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1093}
  /// [google.cloud.telcoautomation.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1604}
  ///
  // clang-format on
  future<StatusOr<google::cloud::telcoautomation::v1::OperationMetadata>>
  DeleteEdgeSlm(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteEdgeSlm
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteEdgeSlm(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a single EdgeSlm.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.telcoautomation.v1.DeleteEdgeSlmRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.telcoautomation.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.DeleteEdgeSlmRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1093}
  /// [google.cloud.telcoautomation.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1604}
  ///
  // clang-format on
  future<StatusOr<google::cloud::telcoautomation::v1::OperationMetadata>>
  DeleteEdgeSlm(
      google::cloud::telcoautomation::v1::DeleteEdgeSlmRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteEdgeSlm
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteEdgeSlm(
      NoAwaitTag,
      google::cloud::telcoautomation::v1::DeleteEdgeSlmRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteEdgeSlm
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::telcoautomation::v1::OperationMetadata>>
  DeleteEdgeSlm(google::longrunning::Operation const& operation,
                Options opts = {});

  // clang-format off
  ///
  /// Creates a blueprint.
  ///
  /// @param parent  Required. The name of parent resource.
  ///  Format should be -
  ///  "projects/{project_id}/locations/{location_name}/orchestrationClusters/{orchestration_cluster}".
  /// @param blueprint  Required. The `Blueprint` to create.
  /// @param blueprint_id  Optional. The name of the blueprint.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.telcoautomation.v1.Blueprint])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.Blueprint]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L631}
  /// [google.cloud.telcoautomation.v1.CreateBlueprintRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1119}
  ///
  // clang-format on
  StatusOr<google::cloud::telcoautomation::v1::Blueprint> CreateBlueprint(
      std::string const& parent,
      google::cloud::telcoautomation::v1::Blueprint const& blueprint,
      std::string const& blueprint_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a blueprint.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.telcoautomation.v1.CreateBlueprintRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.telcoautomation.v1.Blueprint])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.Blueprint]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L631}
  /// [google.cloud.telcoautomation.v1.CreateBlueprintRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1119}
  ///
  // clang-format on
  StatusOr<google::cloud::telcoautomation::v1::Blueprint> CreateBlueprint(
      google::cloud::telcoautomation::v1::CreateBlueprintRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates a blueprint.
  ///
  /// @param blueprint  Required. The `blueprint` to update.
  /// @param update_mask  Required. Update mask is used to specify the fields to be overwritten in
  ///  the `blueprint` resource by the update.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.telcoautomation.v1.Blueprint])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.Blueprint]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L631}
  /// [google.cloud.telcoautomation.v1.UpdateBlueprintRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1138}
  ///
  // clang-format on
  StatusOr<google::cloud::telcoautomation::v1::Blueprint> UpdateBlueprint(
      google::cloud::telcoautomation::v1::Blueprint const& blueprint,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates a blueprint.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.telcoautomation.v1.UpdateBlueprintRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.telcoautomation.v1.Blueprint])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.Blueprint]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L631}
  /// [google.cloud.telcoautomation.v1.UpdateBlueprintRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1138}
  ///
  // clang-format on
  StatusOr<google::cloud::telcoautomation::v1::Blueprint> UpdateBlueprint(
      google::cloud::telcoautomation::v1::UpdateBlueprintRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Returns the requested blueprint.
  ///
  /// @param name  Required. The name of the blueprint.
  ///  Case 1: If the name provided in the request is
  ///  {blueprint_id}@{revision_id}, then the revision with revision_id will be
  ///  returned. Case 2: If the name provided in the request is {blueprint}, then
  ///  the current state of the blueprint is returned.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.telcoautomation.v1.Blueprint])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.Blueprint]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L631}
  /// [google.cloud.telcoautomation.v1.GetBlueprintRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1149}
  ///
  // clang-format on
  StatusOr<google::cloud::telcoautomation::v1::Blueprint> GetBlueprint(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Returns the requested blueprint.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.telcoautomation.v1.GetBlueprintRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.telcoautomation.v1.Blueprint])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.Blueprint]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L631}
  /// [google.cloud.telcoautomation.v1.GetBlueprintRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1149}
  ///
  // clang-format on
  StatusOr<google::cloud::telcoautomation::v1::Blueprint> GetBlueprint(
      google::cloud::telcoautomation::v1::GetBlueprintRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes a blueprint and all its revisions.
  ///
  /// @param name  Required. The name of blueprint to delete.
  ///  Blueprint name should be in the format {blueprint_id}, if
  ///  {blueprint_id}@{revision_id} is passed then the API throws invalid
  ///  argument.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.DeleteBlueprintRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1168}
  ///
  // clang-format on
  Status DeleteBlueprint(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a blueprint and all its revisions.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.telcoautomation.v1.DeleteBlueprintRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.DeleteBlueprintRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1168}
  ///
  // clang-format on
  Status DeleteBlueprint(
      google::cloud::telcoautomation::v1::DeleteBlueprintRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// List all blueprints.
  ///
  /// @param parent  Required. The name of parent orchestration cluster resource.
  ///  Format should be -
  ///  "projects/{project_id}/locations/{location_name}/orchestrationClusters/{orchestration_cluster}".
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.telcoautomation.v1.Blueprint], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.Blueprint]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L631}
  /// [google.cloud.telcoautomation.v1.ListBlueprintsRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1182}
  ///
  // clang-format on
  StreamRange<google::cloud::telcoautomation::v1::Blueprint> ListBlueprints(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// List all blueprints.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.telcoautomation.v1.ListBlueprintsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.telcoautomation.v1.Blueprint], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.Blueprint]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L631}
  /// [google.cloud.telcoautomation.v1.ListBlueprintsRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1182}
  ///
  // clang-format on
  StreamRange<google::cloud::telcoautomation::v1::Blueprint> ListBlueprints(
      google::cloud::telcoautomation::v1::ListBlueprintsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Approves a blueprint and commits a new revision.
  ///
  /// @param name  Required. The name of the blueprint to approve. The blueprint must be in
  ///  Proposed state. A new revision is committed on approval.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.telcoautomation.v1.Blueprint])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.ApproveBlueprintRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1217}
  /// [google.cloud.telcoautomation.v1.Blueprint]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L631}
  ///
  // clang-format on
  StatusOr<google::cloud::telcoautomation::v1::Blueprint> ApproveBlueprint(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Approves a blueprint and commits a new revision.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.telcoautomation.v1.ApproveBlueprintRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.telcoautomation.v1.Blueprint])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.ApproveBlueprintRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1217}
  /// [google.cloud.telcoautomation.v1.Blueprint]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L631}
  ///
  // clang-format on
  StatusOr<google::cloud::telcoautomation::v1::Blueprint> ApproveBlueprint(
      google::cloud::telcoautomation::v1::ApproveBlueprintRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Proposes a blueprint for approval of changes.
  ///
  /// @param name  Required. The name of the blueprint being proposed.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.telcoautomation.v1.Blueprint])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.Blueprint]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L631}
  /// [google.cloud.telcoautomation.v1.ProposeBlueprintRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1229}
  ///
  // clang-format on
  StatusOr<google::cloud::telcoautomation::v1::Blueprint> ProposeBlueprint(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Proposes a blueprint for approval of changes.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.telcoautomation.v1.ProposeBlueprintRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.telcoautomation.v1.Blueprint])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.Blueprint]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L631}
  /// [google.cloud.telcoautomation.v1.ProposeBlueprintRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1229}
  ///
  // clang-format on
  StatusOr<google::cloud::telcoautomation::v1::Blueprint> ProposeBlueprint(
      google::cloud::telcoautomation::v1::ProposeBlueprintRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Rejects a blueprint revision proposal and flips it back to Draft state.
  ///
  /// @param name  Required. The name of the blueprint being rejected.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.telcoautomation.v1.Blueprint])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.Blueprint]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L631}
  /// [google.cloud.telcoautomation.v1.RejectBlueprintRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1240}
  ///
  // clang-format on
  StatusOr<google::cloud::telcoautomation::v1::Blueprint> RejectBlueprint(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Rejects a blueprint revision proposal and flips it back to Draft state.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.telcoautomation.v1.RejectBlueprintRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.telcoautomation.v1.Blueprint])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.Blueprint]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L631}
  /// [google.cloud.telcoautomation.v1.RejectBlueprintRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1240}
  ///
  // clang-format on
  StatusOr<google::cloud::telcoautomation::v1::Blueprint> RejectBlueprint(
      google::cloud::telcoautomation::v1::RejectBlueprintRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// List blueprint revisions of a given blueprint.
  ///
  /// @param name  Required. The name of the blueprint to list revisions for.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.telcoautomation.v1.Blueprint], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.Blueprint]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L631}
  /// [google.cloud.telcoautomation.v1.ListBlueprintRevisionsRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1251}
  ///
  // clang-format on
  StreamRange<google::cloud::telcoautomation::v1::Blueprint>
  ListBlueprintRevisions(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// List blueprint revisions of a given blueprint.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.telcoautomation.v1.ListBlueprintRevisionsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.telcoautomation.v1.Blueprint], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.Blueprint]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L631}
  /// [google.cloud.telcoautomation.v1.ListBlueprintRevisionsRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1251}
  ///
  // clang-format on
  StreamRange<google::cloud::telcoautomation::v1::Blueprint>
  ListBlueprintRevisions(
      google::cloud::telcoautomation::v1::ListBlueprintRevisionsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Searches across blueprint revisions.
  ///
  /// @param parent  Required. The name of parent orchestration cluster resource.
  ///  Format should be -
  ///  "projects/{project_id}/locations/{location_name}/orchestrationClusters/{orchestration_cluster}".
  /// @param query  Required. Supported queries:
  ///  1. ""                       : Lists all revisions across all blueprints.
  ///  2. "latest=true"            : Lists latest revisions across all blueprints.
  ///  3. "name={name}"            : Lists all revisions of blueprint with name
  ///  {name}.
  ///  4. "name={name} latest=true": Lists latest revision of blueprint with name
  ///  {name}
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.telcoautomation.v1.Blueprint], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.Blueprint]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L631}
  /// [google.cloud.telcoautomation.v1.SearchBlueprintRevisionsRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1279}
  ///
  // clang-format on
  StreamRange<google::cloud::telcoautomation::v1::Blueprint>
  SearchBlueprintRevisions(std::string const& parent, std::string const& query,
                           Options opts = {});

  // clang-format off
  ///
  /// Searches across blueprint revisions.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.telcoautomation.v1.SearchBlueprintRevisionsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.telcoautomation.v1.Blueprint], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.Blueprint]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L631}
  /// [google.cloud.telcoautomation.v1.SearchBlueprintRevisionsRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1279}
  ///
  // clang-format on
  StreamRange<google::cloud::telcoautomation::v1::Blueprint>
  SearchBlueprintRevisions(
      google::cloud::telcoautomation::v1::SearchBlueprintRevisionsRequest
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Searches across deployment revisions.
  ///
  /// @param parent  Required. The name of parent orchestration cluster resource.
  ///  Format should be -
  ///  "projects/{project_id}/locations/{location_name}/orchestrationClusters/{orchestration_cluster}".
  /// @param query  Required. Supported queries:
  ///  1. ""                       : Lists all revisions across all deployments.
  ///  2. "latest=true"            : Lists latest revisions across all
  ///  deployments.
  ///  3. "name={name}"            : Lists all revisions of deployment with name
  ///  {name}.
  ///  4. "name={name} latest=true": Lists latest revision of deployment with name
  ///  {name}
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.telcoautomation.v1.Deployment], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.Deployment]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L762}
  /// [google.cloud.telcoautomation.v1.SearchDeploymentRevisionsRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1498}
  ///
  // clang-format on
  StreamRange<google::cloud::telcoautomation::v1::Deployment>
  SearchDeploymentRevisions(std::string const& parent, std::string const& query,
                            Options opts = {});

  // clang-format off
  ///
  /// Searches across deployment revisions.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.telcoautomation.v1.SearchDeploymentRevisionsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.telcoautomation.v1.Deployment], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.Deployment]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L762}
  /// [google.cloud.telcoautomation.v1.SearchDeploymentRevisionsRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1498}
  ///
  // clang-format on
  StreamRange<google::cloud::telcoautomation::v1::Deployment>
  SearchDeploymentRevisions(
      google::cloud::telcoautomation::v1::SearchDeploymentRevisionsRequest
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Discards the changes in a blueprint and reverts the blueprint to the last
  /// approved blueprint revision. No changes take place if a blueprint does not
  /// have revisions.
  ///
  /// @param name  Required. The name of the blueprint of which changes are being discarded.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.telcoautomation.v1.DiscardBlueprintChangesResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.DiscardBlueprintChangesRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1319}
  /// [google.cloud.telcoautomation.v1.DiscardBlueprintChangesResponse]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1330}
  ///
  // clang-format on
  StatusOr<google::cloud::telcoautomation::v1::DiscardBlueprintChangesResponse>
  DiscardBlueprintChanges(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Discards the changes in a blueprint and reverts the blueprint to the last
  /// approved blueprint revision. No changes take place if a blueprint does not
  /// have revisions.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.telcoautomation.v1.DiscardBlueprintChangesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.telcoautomation.v1.DiscardBlueprintChangesResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.DiscardBlueprintChangesRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1319}
  /// [google.cloud.telcoautomation.v1.DiscardBlueprintChangesResponse]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1330}
  ///
  // clang-format on
  StatusOr<google::cloud::telcoautomation::v1::DiscardBlueprintChangesResponse>
  DiscardBlueprintChanges(
      google::cloud::telcoautomation::v1::DiscardBlueprintChangesRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists the blueprints in TNA's public catalog. Default page size = 20,
  /// Max Page Size = 100.
  ///
  /// @param parent  Required. Parent value of public blueprint.
  ///  Format should be -
  ///  "projects/{project_id}/locations/{location_name}".
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.telcoautomation.v1.PublicBlueprint], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.ListPublicBlueprintsRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1333}
  /// [google.cloud.telcoautomation.v1.PublicBlueprint]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L730}
  ///
  // clang-format on
  StreamRange<google::cloud::telcoautomation::v1::PublicBlueprint>
  ListPublicBlueprints(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists the blueprints in TNA's public catalog. Default page size = 20,
  /// Max Page Size = 100.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.telcoautomation.v1.ListPublicBlueprintsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.telcoautomation.v1.PublicBlueprint], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.ListPublicBlueprintsRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1333}
  /// [google.cloud.telcoautomation.v1.PublicBlueprint]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L730}
  ///
  // clang-format on
  StreamRange<google::cloud::telcoautomation::v1::PublicBlueprint>
  ListPublicBlueprints(
      google::cloud::telcoautomation::v1::ListPublicBlueprintsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Returns the requested public blueprint.
  ///
  /// @param name  Required. The name of the public blueprint.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.telcoautomation.v1.PublicBlueprint])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.GetPublicBlueprintRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1363}
  /// [google.cloud.telcoautomation.v1.PublicBlueprint]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L730}
  ///
  // clang-format on
  StatusOr<google::cloud::telcoautomation::v1::PublicBlueprint>
  GetPublicBlueprint(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Returns the requested public blueprint.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.telcoautomation.v1.GetPublicBlueprintRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.telcoautomation.v1.PublicBlueprint])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.GetPublicBlueprintRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1363}
  /// [google.cloud.telcoautomation.v1.PublicBlueprint]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L730}
  ///
  // clang-format on
  StatusOr<google::cloud::telcoautomation::v1::PublicBlueprint>
  GetPublicBlueprint(
      google::cloud::telcoautomation::v1::GetPublicBlueprintRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a deployment.
  ///
  /// @param parent  Required. The name of parent resource.
  ///  Format should be -
  ///  "projects/{project_id}/locations/{location_name}/orchestrationClusters/{orchestration_cluster}".
  /// @param deployment  Required. The `Deployment` to create.
  /// @param deployment_id  Optional. The name of the deployment.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.telcoautomation.v1.Deployment])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.CreateDeploymentRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1374}
  /// [google.cloud.telcoautomation.v1.Deployment]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L762}
  ///
  // clang-format on
  StatusOr<google::cloud::telcoautomation::v1::Deployment> CreateDeployment(
      std::string const& parent,
      google::cloud::telcoautomation::v1::Deployment const& deployment,
      std::string const& deployment_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a deployment.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.telcoautomation.v1.CreateDeploymentRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.telcoautomation.v1.Deployment])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.CreateDeploymentRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1374}
  /// [google.cloud.telcoautomation.v1.Deployment]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L762}
  ///
  // clang-format on
  StatusOr<google::cloud::telcoautomation::v1::Deployment> CreateDeployment(
      google::cloud::telcoautomation::v1::CreateDeploymentRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates a deployment.
  ///
  /// @param deployment  Required. The `deployment` to update.
  /// @param update_mask  Required. Update mask is used to specify the fields to be overwritten in
  ///  the `deployment` resource by the update.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.telcoautomation.v1.Deployment])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.Deployment]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L762}
  /// [google.cloud.telcoautomation.v1.UpdateDeploymentRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1393}
  ///
  // clang-format on
  StatusOr<google::cloud::telcoautomation::v1::Deployment> UpdateDeployment(
      google::cloud::telcoautomation::v1::Deployment const& deployment,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates a deployment.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.telcoautomation.v1.UpdateDeploymentRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.telcoautomation.v1.Deployment])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.Deployment]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L762}
  /// [google.cloud.telcoautomation.v1.UpdateDeploymentRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1393}
  ///
  // clang-format on
  StatusOr<google::cloud::telcoautomation::v1::Deployment> UpdateDeployment(
      google::cloud::telcoautomation::v1::UpdateDeploymentRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Returns the requested deployment.
  ///
  /// @param name  Required. The name of the deployment.
  ///  Case 1: If the name provided in the request is
  ///  {deployment_id}@{revision_id}, then the revision with revision_id will be
  ///  returned.
  ///  Case 2: If the name provided in the request is {deployment}, then
  ///  the current state of the deployment is returned.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.telcoautomation.v1.Deployment])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.Deployment]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L762}
  /// [google.cloud.telcoautomation.v1.GetDeploymentRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1404}
  ///
  // clang-format on
  StatusOr<google::cloud::telcoautomation::v1::Deployment> GetDeployment(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Returns the requested deployment.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.telcoautomation.v1.GetDeploymentRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.telcoautomation.v1.Deployment])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.Deployment]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L762}
  /// [google.cloud.telcoautomation.v1.GetDeploymentRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1404}
  ///
  // clang-format on
  StatusOr<google::cloud::telcoautomation::v1::Deployment> GetDeployment(
      google::cloud::telcoautomation::v1::GetDeploymentRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Removes the deployment by marking it as DELETING. Post which deployment and
  /// it's revisions gets deleted.
  ///
  /// @param name  Required. The name of deployment to initiate delete.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.RemoveDeploymentRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1424}
  ///
  // clang-format on
  Status RemoveDeployment(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Removes the deployment by marking it as DELETING. Post which deployment and
  /// it's revisions gets deleted.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.telcoautomation.v1.RemoveDeploymentRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.RemoveDeploymentRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1424}
  ///
  // clang-format on
  Status RemoveDeployment(
      google::cloud::telcoautomation::v1::RemoveDeploymentRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// List all deployments.
  ///
  /// @param parent  Required. The name of parent orchestration cluster resource.
  ///  Format should be -
  ///  "projects/{project_id}/locations/{location_name}/orchestrationClusters/{orchestration_cluster}".
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.telcoautomation.v1.Deployment], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.Deployment]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L762}
  /// [google.cloud.telcoautomation.v1.ListDeploymentsRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1435}
  ///
  // clang-format on
  StreamRange<google::cloud::telcoautomation::v1::Deployment> ListDeployments(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// List all deployments.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.telcoautomation.v1.ListDeploymentsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.telcoautomation.v1.Deployment], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.Deployment]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L762}
  /// [google.cloud.telcoautomation.v1.ListDeploymentsRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1435}
  ///
  // clang-format on
  StreamRange<google::cloud::telcoautomation::v1::Deployment> ListDeployments(
      google::cloud::telcoautomation::v1::ListDeploymentsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// List deployment revisions of a given deployment.
  ///
  /// @param name  Required. The name of the deployment to list revisions for.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.telcoautomation.v1.Deployment], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.Deployment]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L762}
  /// [google.cloud.telcoautomation.v1.ListDeploymentRevisionsRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1470}
  ///
  // clang-format on
  StreamRange<google::cloud::telcoautomation::v1::Deployment>
  ListDeploymentRevisions(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// List deployment revisions of a given deployment.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.telcoautomation.v1.ListDeploymentRevisionsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.telcoautomation.v1.Deployment], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.Deployment]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L762}
  /// [google.cloud.telcoautomation.v1.ListDeploymentRevisionsRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1470}
  ///
  // clang-format on
  StreamRange<google::cloud::telcoautomation::v1::Deployment>
  ListDeploymentRevisions(
      google::cloud::telcoautomation::v1::ListDeploymentRevisionsRequest
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Discards the changes in a deployment and reverts the deployment to the last
  /// approved deployment revision. No changes take place if a deployment does
  /// not have revisions.
  ///
  /// @param name  Required. The name of the deployment of which changes are being discarded.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.telcoautomation.v1.DiscardDeploymentChangesResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.DiscardDeploymentChangesRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1539}
  /// [google.cloud.telcoautomation.v1.DiscardDeploymentChangesResponse]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1550}
  ///
  // clang-format on
  StatusOr<google::cloud::telcoautomation::v1::DiscardDeploymentChangesResponse>
  DiscardDeploymentChanges(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Discards the changes in a deployment and reverts the deployment to the last
  /// approved deployment revision. No changes take place if a deployment does
  /// not have revisions.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.telcoautomation.v1.DiscardDeploymentChangesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.telcoautomation.v1.DiscardDeploymentChangesResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.DiscardDeploymentChangesRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1539}
  /// [google.cloud.telcoautomation.v1.DiscardDeploymentChangesResponse]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1550}
  ///
  // clang-format on
  StatusOr<google::cloud::telcoautomation::v1::DiscardDeploymentChangesResponse>
  DiscardDeploymentChanges(
      google::cloud::telcoautomation::v1::DiscardDeploymentChangesRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Applies the deployment's YAML files to the parent orchestration cluster.
  ///
  /// @param name  Required. The name of the deployment to apply to orchestration cluster.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.telcoautomation.v1.Deployment])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.ApplyDeploymentRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1555}
  /// [google.cloud.telcoautomation.v1.Deployment]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L762}
  ///
  // clang-format on
  StatusOr<google::cloud::telcoautomation::v1::Deployment> ApplyDeployment(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Applies the deployment's YAML files to the parent orchestration cluster.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.telcoautomation.v1.ApplyDeploymentRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.telcoautomation.v1.Deployment])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.ApplyDeploymentRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1555}
  /// [google.cloud.telcoautomation.v1.Deployment]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L762}
  ///
  // clang-format on
  StatusOr<google::cloud::telcoautomation::v1::Deployment> ApplyDeployment(
      google::cloud::telcoautomation::v1::ApplyDeploymentRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Returns the requested deployment status.
  ///
  /// @param name  Required. The name of the deployment without revisionID.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.telcoautomation.v1.ComputeDeploymentStatusResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.ComputeDeploymentStatusRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1566}
  /// [google.cloud.telcoautomation.v1.ComputeDeploymentStatusResponse]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1577}
  ///
  // clang-format on
  StatusOr<google::cloud::telcoautomation::v1::ComputeDeploymentStatusResponse>
  ComputeDeploymentStatus(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Returns the requested deployment status.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.telcoautomation.v1.ComputeDeploymentStatusRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.telcoautomation.v1.ComputeDeploymentStatusResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.ComputeDeploymentStatusRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1566}
  /// [google.cloud.telcoautomation.v1.ComputeDeploymentStatusResponse]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1577}
  ///
  // clang-format on
  StatusOr<google::cloud::telcoautomation::v1::ComputeDeploymentStatusResponse>
  ComputeDeploymentStatus(
      google::cloud::telcoautomation::v1::ComputeDeploymentStatusRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Rollback the active deployment to the given past approved deployment
  /// revision.
  ///
  /// @param name  Required. Name of the deployment.
  /// @param revision_id  Required. The revision id of deployment to roll back to.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.telcoautomation.v1.Deployment])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.Deployment]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L762}
  /// [google.cloud.telcoautomation.v1.RollbackDeploymentRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1590}
  ///
  // clang-format on
  StatusOr<google::cloud::telcoautomation::v1::Deployment> RollbackDeployment(
      std::string const& name, std::string const& revision_id,
      Options opts = {});

  // clang-format off
  ///
  /// Rollback the active deployment to the given past approved deployment
  /// revision.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.telcoautomation.v1.RollbackDeploymentRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.telcoautomation.v1.Deployment])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.Deployment]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L762}
  /// [google.cloud.telcoautomation.v1.RollbackDeploymentRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1590}
  ///
  // clang-format on
  StatusOr<google::cloud::telcoautomation::v1::Deployment> RollbackDeployment(
      google::cloud::telcoautomation::v1::RollbackDeploymentRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Returns the requested hydrated deployment.
  ///
  /// @param name  Required. Name of the hydrated deployment.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.telcoautomation.v1.HydratedDeployment])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.GetHydratedDeploymentRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1634}
  /// [google.cloud.telcoautomation.v1.HydratedDeployment]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L864}
  ///
  // clang-format on
  StatusOr<google::cloud::telcoautomation::v1::HydratedDeployment>
  GetHydratedDeployment(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Returns the requested hydrated deployment.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.telcoautomation.v1.GetHydratedDeploymentRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.telcoautomation.v1.HydratedDeployment])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.GetHydratedDeploymentRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1634}
  /// [google.cloud.telcoautomation.v1.HydratedDeployment]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L864}
  ///
  // clang-format on
  StatusOr<google::cloud::telcoautomation::v1::HydratedDeployment>
  GetHydratedDeployment(
      google::cloud::telcoautomation::v1::GetHydratedDeploymentRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// List all hydrated deployments present under a deployment.
  ///
  /// @param parent  Required. The deployment managing the hydrated deployments.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.telcoautomation.v1.HydratedDeployment], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.HydratedDeployment]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L864}
  /// [google.cloud.telcoautomation.v1.ListHydratedDeploymentsRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1645}
  ///
  // clang-format on
  StreamRange<google::cloud::telcoautomation::v1::HydratedDeployment>
  ListHydratedDeployments(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// List all hydrated deployments present under a deployment.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.telcoautomation.v1.ListHydratedDeploymentsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.telcoautomation.v1.HydratedDeployment], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.HydratedDeployment]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L864}
  /// [google.cloud.telcoautomation.v1.ListHydratedDeploymentsRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1645}
  ///
  // clang-format on
  StreamRange<google::cloud::telcoautomation::v1::HydratedDeployment>
  ListHydratedDeployments(
      google::cloud::telcoautomation::v1::ListHydratedDeploymentsRequest
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates a hydrated deployment.
  ///
  /// @param hydrated_deployment  Required. The hydrated deployment to update.
  /// @param update_mask  Required. The list of fields to update. Update mask supports a special
  ///  value `*` which fully replaces (equivalent to PUT) the resource provided.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.telcoautomation.v1.HydratedDeployment])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.HydratedDeployment]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L864}
  /// [google.cloud.telcoautomation.v1.UpdateHydratedDeploymentRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1676}
  ///
  // clang-format on
  StatusOr<google::cloud::telcoautomation::v1::HydratedDeployment>
  UpdateHydratedDeployment(
      google::cloud::telcoautomation::v1::HydratedDeployment const&
          hydrated_deployment,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates a hydrated deployment.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.telcoautomation.v1.UpdateHydratedDeploymentRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.telcoautomation.v1.HydratedDeployment])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.HydratedDeployment]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L864}
  /// [google.cloud.telcoautomation.v1.UpdateHydratedDeploymentRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1676}
  ///
  // clang-format on
  StatusOr<google::cloud::telcoautomation::v1::HydratedDeployment>
  UpdateHydratedDeployment(
      google::cloud::telcoautomation::v1::UpdateHydratedDeploymentRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Applies a hydrated deployment to a workload cluster.
  ///
  /// @param name  Required. The name of the hydrated deployment to apply.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.telcoautomation.v1.HydratedDeployment])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.ApplyHydratedDeploymentRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1688}
  /// [google.cloud.telcoautomation.v1.HydratedDeployment]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L864}
  ///
  // clang-format on
  StatusOr<google::cloud::telcoautomation::v1::HydratedDeployment>
  ApplyHydratedDeployment(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Applies a hydrated deployment to a workload cluster.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.telcoautomation.v1.ApplyHydratedDeploymentRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.telcoautomation.v1.HydratedDeployment])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.telcoautomation.v1.ApplyHydratedDeploymentRequest]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L1688}
  /// [google.cloud.telcoautomation.v1.HydratedDeployment]: @googleapis_reference_link{google/cloud/telcoautomation/v1/telcoautomation.proto#L864}
  ///
  // clang-format on
  StatusOr<google::cloud::telcoautomation::v1::HydratedDeployment>
  ApplyHydratedDeployment(
      google::cloud::telcoautomation::v1::ApplyHydratedDeploymentRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists information about the supported locations for this service.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.location.ListLocationsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.location.Location], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.location.ListLocationsRequest]: @googleapis_reference_link{google/cloud/location/locations.proto#L58}
  /// [google.cloud.location.Location]: @googleapis_reference_link{google/cloud/location/locations.proto#L88}
  ///
  // clang-format on
  StreamRange<google::cloud::location::Location> ListLocations(
      google::cloud::location::ListLocationsRequest request, Options opts = {});

  // clang-format off
  ///
  /// Gets information about a location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.location.GetLocationRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.location.Location])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.location.GetLocationRequest]: @googleapis_reference_link{google/cloud/location/locations.proto#L82}
  /// [google.cloud.location.Location]: @googleapis_reference_link{google/cloud/location/locations.proto#L88}
  ///
  // clang-format on
  StatusOr<google::cloud::location::Location> GetLocation(
      google::cloud::location::GetLocationRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists operations that match the specified filter in the request. If the
  /// server doesn't support this method, it returns `UNIMPLEMENTED`.
  ///
  /// NOTE: the `name` binding allows API services to override the binding
  /// to use different resource name schemes, such as `users/*/operations`. To
  /// override the binding, API services can add a binding such as
  /// `"/v1/{name=users/*}/operations"` to their service configuration.
  /// For backwards compatibility, the default name includes the operations
  /// collection id, however overriding users must ensure the name binding
  /// is the parent resource, without the operations collection id.
  ///
  /// @param name  The name of the operation's parent resource.
  /// @param filter  The standard list filter.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.longrunning.Operation], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.longrunning.ListOperationsRequest]: @googleapis_reference_link{google/longrunning/operations.proto#L171}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  StreamRange<google::longrunning::Operation> ListOperations(
      std::string const& name, std::string const& filter, Options opts = {});

  // clang-format off
  ///
  /// Lists operations that match the specified filter in the request. If the
  /// server doesn't support this method, it returns `UNIMPLEMENTED`.
  ///
  /// NOTE: the `name` binding allows API services to override the binding
  /// to use different resource name schemes, such as `users/*/operations`. To
  /// override the binding, API services can add a binding such as
  /// `"/v1/{name=users/*}/operations"` to their service configuration.
  /// For backwards compatibility, the default name includes the operations
  /// collection id, however overriding users must ensure the name binding
  /// is the parent resource, without the operations collection id.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.longrunning.ListOperationsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.longrunning.Operation], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.longrunning.ListOperationsRequest]: @googleapis_reference_link{google/longrunning/operations.proto#L171}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  StreamRange<google::longrunning::Operation> ListOperations(
      google::longrunning::ListOperationsRequest request, Options opts = {});

  // clang-format off
  ///
  /// Gets the latest state of a long-running operation.  Clients can use this
  /// method to poll the operation result at intervals as recommended by the API
  /// service.
  ///
  /// @param name  The name of the operation resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.longrunning.Operation])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.longrunning.GetOperationRequest]: @googleapis_reference_link{google/longrunning/operations.proto#L165}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> GetOperation(std::string const& name,
                                                        Options opts = {});

  // clang-format off
  ///
  /// Gets the latest state of a long-running operation.  Clients can use this
  /// method to poll the operation result at intervals as recommended by the API
  /// service.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.longrunning.GetOperationRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.longrunning.Operation])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.longrunning.GetOperationRequest]: @googleapis_reference_link{google/longrunning/operations.proto#L165}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> GetOperation(
      google::longrunning::GetOperationRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes a long-running operation. This method indicates that the client is
  /// no longer interested in the operation result. It does not cancel the
  /// operation. If the server doesn't support this method, it returns
  /// `google.rpc.Code.UNIMPLEMENTED`.
  ///
  /// @param name  The name of the operation resource to be deleted.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.longrunning.DeleteOperationRequest]: @googleapis_reference_link{google/longrunning/operations.proto#L201}
  ///
  // clang-format on
  Status DeleteOperation(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a long-running operation. This method indicates that the client is
  /// no longer interested in the operation result. It does not cancel the
  /// operation. If the server doesn't support this method, it returns
  /// `google.rpc.Code.UNIMPLEMENTED`.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.longrunning.DeleteOperationRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.longrunning.DeleteOperationRequest]: @googleapis_reference_link{google/longrunning/operations.proto#L201}
  ///
  // clang-format on
  Status DeleteOperation(
      google::longrunning::DeleteOperationRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Starts asynchronous cancellation on a long-running operation.  The server
  /// makes a best effort to cancel the operation, but success is not
  /// guaranteed.  If the server doesn't support this method, it returns
  /// `google.rpc.Code.UNIMPLEMENTED`.  Clients can use
  /// [Operations.GetOperation][google.longrunning.Operations.GetOperation] or
  /// other methods to check whether the cancellation succeeded or whether the
  /// operation completed despite cancellation. On successful cancellation,
  /// the operation is not deleted; instead, it becomes an operation with
  /// an [Operation.error][google.longrunning.Operation.error] value with a [google.rpc.Status.code][google.rpc.Status.code] of 1,
  /// corresponding to `Code.CANCELLED`.
  ///
  /// @param name  The name of the operation resource to be cancelled.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.longrunning.CancelOperationRequest]: @googleapis_reference_link{google/longrunning/operations.proto#L195}
  /// [google.longrunning.Operation.error]: @googleapis_reference_link{google/longrunning/operations.proto#L150}
  /// [google.longrunning.Operations.GetOperation]: @googleapis_reference_link{google/longrunning/operations.proto#L77}
  /// [google.rpc.Status.code]: @googleapis_reference_link{google/rpc/status.proto#L38}
  ///
  // clang-format on
  Status CancelOperation(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Starts asynchronous cancellation on a long-running operation.  The server
  /// makes a best effort to cancel the operation, but success is not
  /// guaranteed.  If the server doesn't support this method, it returns
  /// `google.rpc.Code.UNIMPLEMENTED`.  Clients can use
  /// [Operations.GetOperation][google.longrunning.Operations.GetOperation] or
  /// other methods to check whether the cancellation succeeded or whether the
  /// operation completed despite cancellation. On successful cancellation,
  /// the operation is not deleted; instead, it becomes an operation with
  /// an [Operation.error][google.longrunning.Operation.error] value with a [google.rpc.Status.code][google.rpc.Status.code] of 1,
  /// corresponding to `Code.CANCELLED`.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.longrunning.CancelOperationRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.longrunning.CancelOperationRequest]: @googleapis_reference_link{google/longrunning/operations.proto#L195}
  /// [google.longrunning.Operation.error]: @googleapis_reference_link{google/longrunning/operations.proto#L150}
  /// [google.longrunning.Operations.GetOperation]: @googleapis_reference_link{google/longrunning/operations.proto#L77}
  /// [google.rpc.Status.code]: @googleapis_reference_link{google/rpc/status.proto#L38}
  ///
  // clang-format on
  Status CancelOperation(
      google::longrunning::CancelOperationRequest const& request,
      Options opts = {});

 private:
  std::shared_ptr<TelcoAutomationConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace telcoautomation_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_TELCOAUTOMATION_V1_TELCO_AUTOMATION_CLIENT_H
