// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/tasks/v2/cloudtasks.proto

#include "google/cloud/tasks/v2/internal/cloud_tasks_logging_decorator.h"
#include "google/cloud/internal/log_wrapper.h"
#include "google/cloud/status_or.h"
#include <google/cloud/tasks/v2/cloudtasks.grpc.pb.h>
#include <memory>
#include <set>
#include <string>
#include <utility>

namespace google {
namespace cloud {
namespace tasks_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

CloudTasksLogging::CloudTasksLogging(std::shared_ptr<CloudTasksStub> child,
                                     TracingOptions tracing_options,
                                     std::set<std::string> const&)
    : child_(std::move(child)), tracing_options_(std::move(tracing_options)) {}

StatusOr<google::cloud::tasks::v2::ListQueuesResponse>
CloudTasksLogging::ListQueues(
    grpc::ClientContext& context, Options const& options,
    google::cloud::tasks::v2::ListQueuesRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::tasks::v2::ListQueuesRequest const& request) {
        return child_->ListQueues(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::tasks::v2::Queue> CloudTasksLogging::GetQueue(
    grpc::ClientContext& context, Options const& options,
    google::cloud::tasks::v2::GetQueueRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::tasks::v2::GetQueueRequest const& request) {
        return child_->GetQueue(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::tasks::v2::Queue> CloudTasksLogging::CreateQueue(
    grpc::ClientContext& context, Options const& options,
    google::cloud::tasks::v2::CreateQueueRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::tasks::v2::CreateQueueRequest const& request) {
        return child_->CreateQueue(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::tasks::v2::Queue> CloudTasksLogging::UpdateQueue(
    grpc::ClientContext& context, Options const& options,
    google::cloud::tasks::v2::UpdateQueueRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::tasks::v2::UpdateQueueRequest const& request) {
        return child_->UpdateQueue(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

Status CloudTasksLogging::DeleteQueue(
    grpc::ClientContext& context, Options const& options,
    google::cloud::tasks::v2::DeleteQueueRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::tasks::v2::DeleteQueueRequest const& request) {
        return child_->DeleteQueue(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::tasks::v2::Queue> CloudTasksLogging::PurgeQueue(
    grpc::ClientContext& context, Options const& options,
    google::cloud::tasks::v2::PurgeQueueRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::tasks::v2::PurgeQueueRequest const& request) {
        return child_->PurgeQueue(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::tasks::v2::Queue> CloudTasksLogging::PauseQueue(
    grpc::ClientContext& context, Options const& options,
    google::cloud::tasks::v2::PauseQueueRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::tasks::v2::PauseQueueRequest const& request) {
        return child_->PauseQueue(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::tasks::v2::Queue> CloudTasksLogging::ResumeQueue(
    grpc::ClientContext& context, Options const& options,
    google::cloud::tasks::v2::ResumeQueueRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::tasks::v2::ResumeQueueRequest const& request) {
        return child_->ResumeQueue(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::iam::v1::Policy> CloudTasksLogging::GetIamPolicy(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::GetIamPolicyRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::iam::v1::GetIamPolicyRequest const& request) {
        return child_->GetIamPolicy(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::iam::v1::Policy> CloudTasksLogging::SetIamPolicy(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::SetIamPolicyRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::iam::v1::SetIamPolicyRequest const& request) {
        return child_->SetIamPolicy(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
CloudTasksLogging::TestIamPermissions(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::TestIamPermissionsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::iam::v1::TestIamPermissionsRequest const& request) {
        return child_->TestIamPermissions(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::tasks::v2::ListTasksResponse>
CloudTasksLogging::ListTasks(
    grpc::ClientContext& context, Options const& options,
    google::cloud::tasks::v2::ListTasksRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::tasks::v2::ListTasksRequest const& request) {
        return child_->ListTasks(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::tasks::v2::Task> CloudTasksLogging::GetTask(
    grpc::ClientContext& context, Options const& options,
    google::cloud::tasks::v2::GetTaskRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::tasks::v2::GetTaskRequest const& request) {
        return child_->GetTask(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::tasks::v2::Task> CloudTasksLogging::CreateTask(
    grpc::ClientContext& context, Options const& options,
    google::cloud::tasks::v2::CreateTaskRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::tasks::v2::CreateTaskRequest const& request) {
        return child_->CreateTask(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

Status CloudTasksLogging::DeleteTask(
    grpc::ClientContext& context, Options const& options,
    google::cloud::tasks::v2::DeleteTaskRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::tasks::v2::DeleteTaskRequest const& request) {
        return child_->DeleteTask(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::tasks::v2::Task> CloudTasksLogging::RunTask(
    grpc::ClientContext& context, Options const& options,
    google::cloud::tasks::v2::RunTaskRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::tasks::v2::RunTaskRequest const& request) {
        return child_->RunTask(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::location::ListLocationsResponse>
CloudTasksLogging::ListLocations(
    grpc::ClientContext& context, Options const& options,
    google::cloud::location::ListLocationsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::location::ListLocationsRequest const& request) {
        return child_->ListLocations(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::location::Location> CloudTasksLogging::GetLocation(
    grpc::ClientContext& context, Options const& options,
    google::cloud::location::GetLocationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::location::GetLocationRequest const& request) {
        return child_->GetLocation(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace tasks_v2_internal
}  // namespace cloud
}  // namespace google
