// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/tasks/v2/cloudtasks.proto

#include "google/cloud/tasks/v2/internal/cloud_tasks_auth_decorator.h"
#include <google/cloud/tasks/v2/cloudtasks.grpc.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace tasks_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

CloudTasksAuth::CloudTasksAuth(
    std::shared_ptr<google::cloud::internal::GrpcAuthenticationStrategy> auth,
    std::shared_ptr<CloudTasksStub> child)
    : auth_(std::move(auth)), child_(std::move(child)) {}

StatusOr<google::cloud::tasks::v2::ListQueuesResponse>
CloudTasksAuth::ListQueues(
    grpc::ClientContext& context, Options const& options,
    google::cloud::tasks::v2::ListQueuesRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListQueues(context, options, request);
}

StatusOr<google::cloud::tasks::v2::Queue> CloudTasksAuth::GetQueue(
    grpc::ClientContext& context, Options const& options,
    google::cloud::tasks::v2::GetQueueRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetQueue(context, options, request);
}

StatusOr<google::cloud::tasks::v2::Queue> CloudTasksAuth::CreateQueue(
    grpc::ClientContext& context, Options const& options,
    google::cloud::tasks::v2::CreateQueueRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CreateQueue(context, options, request);
}

StatusOr<google::cloud::tasks::v2::Queue> CloudTasksAuth::UpdateQueue(
    grpc::ClientContext& context, Options const& options,
    google::cloud::tasks::v2::UpdateQueueRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->UpdateQueue(context, options, request);
}

Status CloudTasksAuth::DeleteQueue(
    grpc::ClientContext& context, Options const& options,
    google::cloud::tasks::v2::DeleteQueueRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DeleteQueue(context, options, request);
}

StatusOr<google::cloud::tasks::v2::Queue> CloudTasksAuth::PurgeQueue(
    grpc::ClientContext& context, Options const& options,
    google::cloud::tasks::v2::PurgeQueueRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->PurgeQueue(context, options, request);
}

StatusOr<google::cloud::tasks::v2::Queue> CloudTasksAuth::PauseQueue(
    grpc::ClientContext& context, Options const& options,
    google::cloud::tasks::v2::PauseQueueRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->PauseQueue(context, options, request);
}

StatusOr<google::cloud::tasks::v2::Queue> CloudTasksAuth::ResumeQueue(
    grpc::ClientContext& context, Options const& options,
    google::cloud::tasks::v2::ResumeQueueRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ResumeQueue(context, options, request);
}

StatusOr<google::iam::v1::Policy> CloudTasksAuth::GetIamPolicy(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::GetIamPolicyRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetIamPolicy(context, options, request);
}

StatusOr<google::iam::v1::Policy> CloudTasksAuth::SetIamPolicy(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::SetIamPolicyRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->SetIamPolicy(context, options, request);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
CloudTasksAuth::TestIamPermissions(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::TestIamPermissionsRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->TestIamPermissions(context, options, request);
}

StatusOr<google::cloud::tasks::v2::ListTasksResponse> CloudTasksAuth::ListTasks(
    grpc::ClientContext& context, Options const& options,
    google::cloud::tasks::v2::ListTasksRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListTasks(context, options, request);
}

StatusOr<google::cloud::tasks::v2::Task> CloudTasksAuth::GetTask(
    grpc::ClientContext& context, Options const& options,
    google::cloud::tasks::v2::GetTaskRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetTask(context, options, request);
}

StatusOr<google::cloud::tasks::v2::Task> CloudTasksAuth::CreateTask(
    grpc::ClientContext& context, Options const& options,
    google::cloud::tasks::v2::CreateTaskRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CreateTask(context, options, request);
}

Status CloudTasksAuth::DeleteTask(
    grpc::ClientContext& context, Options const& options,
    google::cloud::tasks::v2::DeleteTaskRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DeleteTask(context, options, request);
}

StatusOr<google::cloud::tasks::v2::Task> CloudTasksAuth::RunTask(
    grpc::ClientContext& context, Options const& options,
    google::cloud::tasks::v2::RunTaskRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->RunTask(context, options, request);
}

StatusOr<google::cloud::location::ListLocationsResponse>
CloudTasksAuth::ListLocations(
    grpc::ClientContext& context, Options const& options,
    google::cloud::location::ListLocationsRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListLocations(context, options, request);
}

StatusOr<google::cloud::location::Location> CloudTasksAuth::GetLocation(
    grpc::ClientContext& context, Options const& options,
    google::cloud::location::GetLocationRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetLocation(context, options, request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace tasks_v2_internal
}  // namespace cloud
}  // namespace google
