// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/talent/v4/job_service.proto

#include "google/cloud/talent/v4/job_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace talent_v4 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

JobServiceConnectionIdempotencyPolicy::
    ~JobServiceConnectionIdempotencyPolicy() = default;

std::unique_ptr<JobServiceConnectionIdempotencyPolicy>
JobServiceConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<JobServiceConnectionIdempotencyPolicy>(*this);
}

Idempotency JobServiceConnectionIdempotencyPolicy::CreateJob(
    google::cloud::talent::v4::CreateJobRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency JobServiceConnectionIdempotencyPolicy::BatchCreateJobs(
    google::cloud::talent::v4::BatchCreateJobsRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency JobServiceConnectionIdempotencyPolicy::GetJob(
    google::cloud::talent::v4::GetJobRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency JobServiceConnectionIdempotencyPolicy::UpdateJob(
    google::cloud::talent::v4::UpdateJobRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency JobServiceConnectionIdempotencyPolicy::BatchUpdateJobs(
    google::cloud::talent::v4::BatchUpdateJobsRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency JobServiceConnectionIdempotencyPolicy::DeleteJob(
    google::cloud::talent::v4::DeleteJobRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency JobServiceConnectionIdempotencyPolicy::BatchDeleteJobs(
    google::cloud::talent::v4::BatchDeleteJobsRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency JobServiceConnectionIdempotencyPolicy::ListJobs(
    google::cloud::talent::v4::ListJobsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency JobServiceConnectionIdempotencyPolicy::SearchJobs(
    google::cloud::talent::v4::SearchJobsRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency JobServiceConnectionIdempotencyPolicy::SearchJobsForAlert(
    google::cloud::talent::v4::SearchJobsRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency JobServiceConnectionIdempotencyPolicy::GetOperation(
    google::longrunning::GetOperationRequest const&) {
  return Idempotency::kIdempotent;
}

std::unique_ptr<JobServiceConnectionIdempotencyPolicy>
MakeDefaultJobServiceConnectionIdempotencyPolicy() {
  return std::make_unique<JobServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace talent_v4
}  // namespace cloud
}  // namespace google
