// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/talent/v4/tenant_service.proto

#include "google/cloud/talent/v4/internal/tenant_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace talent_v4_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

TenantServiceTracingConnection::TenantServiceTracingConnection(
    std::shared_ptr<talent_v4::TenantServiceConnection> child)
    : child_(std::move(child)) {}

StatusOr<google::cloud::talent::v4::Tenant>
TenantServiceTracingConnection::CreateTenant(
    google::cloud::talent::v4::CreateTenantRequest const& request) {
  auto span =
      internal::MakeSpan("talent_v4::TenantServiceConnection::CreateTenant");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateTenant(request));
}

StatusOr<google::cloud::talent::v4::Tenant>
TenantServiceTracingConnection::GetTenant(
    google::cloud::talent::v4::GetTenantRequest const& request) {
  auto span =
      internal::MakeSpan("talent_v4::TenantServiceConnection::GetTenant");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetTenant(request));
}

StatusOr<google::cloud::talent::v4::Tenant>
TenantServiceTracingConnection::UpdateTenant(
    google::cloud::talent::v4::UpdateTenantRequest const& request) {
  auto span =
      internal::MakeSpan("talent_v4::TenantServiceConnection::UpdateTenant");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateTenant(request));
}

Status TenantServiceTracingConnection::DeleteTenant(
    google::cloud::talent::v4::DeleteTenantRequest const& request) {
  auto span =
      internal::MakeSpan("talent_v4::TenantServiceConnection::DeleteTenant");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteTenant(request));
}

StreamRange<google::cloud::talent::v4::Tenant>
TenantServiceTracingConnection::ListTenants(
    google::cloud::talent::v4::ListTenantsRequest request) {
  auto span =
      internal::MakeSpan("talent_v4::TenantServiceConnection::ListTenants");
  internal::OTelScope scope(span);
  auto sr = child_->ListTenants(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::talent::v4::Tenant>(
      std::move(span), std::move(sr));
}

StatusOr<google::longrunning::Operation>
TenantServiceTracingConnection::GetOperation(
    google::longrunning::GetOperationRequest const& request) {
  auto span =
      internal::MakeSpan("talent_v4::TenantServiceConnection::GetOperation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetOperation(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<talent_v4::TenantServiceConnection>
MakeTenantServiceTracingConnection(
    std::shared_ptr<talent_v4::TenantServiceConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<TenantServiceTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace talent_v4_internal
}  // namespace cloud
}  // namespace google
