// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/talent/v4/tenant_service.proto

#include "google/cloud/talent/v4/internal/tenant_connection_impl.h"
#include "google/cloud/talent/v4/internal/tenant_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace talent_v4_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<talent_v4::TenantServiceRetryPolicy> retry_policy(
    Options const& options) {
  return options.get<talent_v4::TenantServiceRetryPolicyOption>()->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options.get<talent_v4::TenantServiceBackoffPolicyOption>()->clone();
}

std::unique_ptr<talent_v4::TenantServiceConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options
      .get<talent_v4::TenantServiceConnectionIdempotencyPolicyOption>()
      ->clone();
}

}  // namespace

TenantServiceConnectionImpl::TenantServiceConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<talent_v4_internal::TenantServiceStub> stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(std::move(options),
                                      TenantServiceConnection::options())) {}

StatusOr<google::cloud::talent::v4::Tenant>
TenantServiceConnectionImpl::CreateTenant(
    google::cloud::talent::v4::CreateTenantRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateTenant(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::talent::v4::CreateTenantRequest const& request) {
        return stub_->CreateTenant(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::talent::v4::Tenant>
TenantServiceConnectionImpl::GetTenant(
    google::cloud::talent::v4::GetTenantRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetTenant(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::talent::v4::GetTenantRequest const& request) {
        return stub_->GetTenant(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::talent::v4::Tenant>
TenantServiceConnectionImpl::UpdateTenant(
    google::cloud::talent::v4::UpdateTenantRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateTenant(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::talent::v4::UpdateTenantRequest const& request) {
        return stub_->UpdateTenant(context, options, request);
      },
      *current, request, __func__);
}

Status TenantServiceConnectionImpl::DeleteTenant(
    google::cloud::talent::v4::DeleteTenantRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteTenant(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::talent::v4::DeleteTenantRequest const& request) {
        return stub_->DeleteTenant(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::cloud::talent::v4::Tenant>
TenantServiceConnectionImpl::ListTenants(
    google::cloud::talent::v4::ListTenantsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListTenants(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::talent::v4::Tenant>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<talent_v4::TenantServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::talent::v4::ListTenantsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context, Options const& options,
                google::cloud::talent::v4::ListTenantsRequest const& request) {
              return stub->ListTenants(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::talent::v4::ListTenantsResponse r) {
        std::vector<google::cloud::talent::v4::Tenant> result(
            r.tenants().size());
        auto& messages = *r.mutable_tenants();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::longrunning::Operation>
TenantServiceConnectionImpl::GetOperation(
    google::longrunning::GetOperationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetOperation(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::longrunning::GetOperationRequest const& request) {
        return stub_->GetOperation(context, options, request);
      },
      *current, request, __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace talent_v4_internal
}  // namespace cloud
}  // namespace google
