// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/talent/v4/completion_service.proto

#include "google/cloud/talent/v4/completion_connection.h"
#include "google/cloud/talent/v4/completion_options.h"
#include "google/cloud/talent/v4/internal/completion_connection_impl.h"
#include "google/cloud/talent/v4/internal/completion_option_defaults.h"
#include "google/cloud/talent/v4/internal/completion_stub_factory.h"
#include "google/cloud/talent/v4/internal/completion_tracing_connection.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace talent_v4 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

CompletionConnection::~CompletionConnection() = default;

StatusOr<google::cloud::talent::v4::CompleteQueryResponse>
CompletionConnection::CompleteQuery(
    google::cloud::talent::v4::CompleteQueryRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::longrunning::Operation> CompletionConnection::GetOperation(
    google::longrunning::GetOperationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<CompletionConnection> MakeCompletionConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 CompletionPolicyOptionList>(options, __func__);
  options = talent_v4_internal::CompletionDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub =
      talent_v4_internal::CreateDefaultCompletionStub(std::move(auth), options);
  return talent_v4_internal::MakeCompletionTracingConnection(
      std::make_shared<talent_v4_internal::CompletionConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace talent_v4
}  // namespace cloud
}  // namespace google
