// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/storageinsights/v1/storageinsights.proto

#include "google/cloud/storageinsights/v1/storage_insights_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace storageinsights_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

StorageInsightsConnectionIdempotencyPolicy::
    ~StorageInsightsConnectionIdempotencyPolicy() = default;

std::unique_ptr<StorageInsightsConnectionIdempotencyPolicy>
StorageInsightsConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<StorageInsightsConnectionIdempotencyPolicy>(*this);
}

Idempotency StorageInsightsConnectionIdempotencyPolicy::ListReportConfigs(
    google::cloud::storageinsights::v1::ListReportConfigsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency StorageInsightsConnectionIdempotencyPolicy::GetReportConfig(
    google::cloud::storageinsights::v1::GetReportConfigRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency StorageInsightsConnectionIdempotencyPolicy::CreateReportConfig(
    google::cloud::storageinsights::v1::CreateReportConfigRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency StorageInsightsConnectionIdempotencyPolicy::UpdateReportConfig(
    google::cloud::storageinsights::v1::UpdateReportConfigRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency StorageInsightsConnectionIdempotencyPolicy::DeleteReportConfig(
    google::cloud::storageinsights::v1::DeleteReportConfigRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency StorageInsightsConnectionIdempotencyPolicy::ListReportDetails(
    google::cloud::storageinsights::v1::ListReportDetailsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency StorageInsightsConnectionIdempotencyPolicy::GetReportDetail(
    google::cloud::storageinsights::v1::GetReportDetailRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency StorageInsightsConnectionIdempotencyPolicy::ListLocations(
    google::cloud::location::ListLocationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency StorageInsightsConnectionIdempotencyPolicy::GetLocation(
    google::cloud::location::GetLocationRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency StorageInsightsConnectionIdempotencyPolicy::ListOperations(
    google::longrunning::ListOperationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency StorageInsightsConnectionIdempotencyPolicy::GetOperation(
    google::longrunning::GetOperationRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency StorageInsightsConnectionIdempotencyPolicy::DeleteOperation(
    google::longrunning::DeleteOperationRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency StorageInsightsConnectionIdempotencyPolicy::CancelOperation(
    google::longrunning::CancelOperationRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<StorageInsightsConnectionIdempotencyPolicy>
MakeDefaultStorageInsightsConnectionIdempotencyPolicy() {
  return std::make_unique<StorageInsightsConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace storageinsights_v1
}  // namespace cloud
}  // namespace google
