// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/storageinsights/v1/storageinsights.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_STORAGEINSIGHTS_V1_INTERNAL_STORAGE_INSIGHTS_CONNECTION_IMPL_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_STORAGEINSIGHTS_V1_INTERNAL_STORAGE_INSIGHTS_CONNECTION_IMPL_H

#include "google/cloud/storageinsights/v1/internal/storage_insights_retry_traits.h"
#include "google/cloud/storageinsights/v1/internal/storage_insights_stub.h"
#include "google/cloud/storageinsights/v1/storage_insights_connection.h"
#include "google/cloud/storageinsights/v1/storage_insights_connection_idempotency_policy.h"
#include "google/cloud/storageinsights/v1/storage_insights_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace storageinsights_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class StorageInsightsConnectionImpl
    : public storageinsights_v1::StorageInsightsConnection {
 public:
  ~StorageInsightsConnectionImpl() override = default;

  StorageInsightsConnectionImpl(
      std::unique_ptr<google::cloud::BackgroundThreads> background,
      std::shared_ptr<storageinsights_v1_internal::StorageInsightsStub> stub,
      Options options);

  Options options() override { return options_; }

  StreamRange<google::cloud::storageinsights::v1::ReportConfig>
  ListReportConfigs(google::cloud::storageinsights::v1::ListReportConfigsRequest
                        request) override;

  StatusOr<google::cloud::storageinsights::v1::ReportConfig> GetReportConfig(
      google::cloud::storageinsights::v1::GetReportConfigRequest const& request)
      override;

  StatusOr<google::cloud::storageinsights::v1::ReportConfig> CreateReportConfig(
      google::cloud::storageinsights::v1::CreateReportConfigRequest const&
          request) override;

  StatusOr<google::cloud::storageinsights::v1::ReportConfig> UpdateReportConfig(
      google::cloud::storageinsights::v1::UpdateReportConfigRequest const&
          request) override;

  Status DeleteReportConfig(
      google::cloud::storageinsights::v1::DeleteReportConfigRequest const&
          request) override;

  StreamRange<google::cloud::storageinsights::v1::ReportDetail>
  ListReportDetails(google::cloud::storageinsights::v1::ListReportDetailsRequest
                        request) override;

  StatusOr<google::cloud::storageinsights::v1::ReportDetail> GetReportDetail(
      google::cloud::storageinsights::v1::GetReportDetailRequest const& request)
      override;

  StreamRange<google::cloud::location::Location> ListLocations(
      google::cloud::location::ListLocationsRequest request) override;

  StatusOr<google::cloud::location::Location> GetLocation(
      google::cloud::location::GetLocationRequest const& request) override;

  StreamRange<google::longrunning::Operation> ListOperations(
      google::longrunning::ListOperationsRequest request) override;

  StatusOr<google::longrunning::Operation> GetOperation(
      google::longrunning::GetOperationRequest const& request) override;

  Status DeleteOperation(
      google::longrunning::DeleteOperationRequest const& request) override;

  Status CancelOperation(
      google::longrunning::CancelOperationRequest const& request) override;

 private:
  std::unique_ptr<google::cloud::BackgroundThreads> background_;
  std::shared_ptr<storageinsights_v1_internal::StorageInsightsStub> stub_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace storageinsights_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_STORAGEINSIGHTS_V1_INTERNAL_STORAGE_INSIGHTS_CONNECTION_IMPL_H
