// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/storageinsights/v1/storageinsights.proto

#include "google/cloud/storageinsights/v1/internal/storage_insights_connection_impl.h"
#include "google/cloud/storageinsights/v1/internal/storage_insights_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace storageinsights_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<storageinsights_v1::StorageInsightsRetryPolicy> retry_policy(
    Options const& options) {
  return options.get<storageinsights_v1::StorageInsightsRetryPolicyOption>()
      ->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options.get<storageinsights_v1::StorageInsightsBackoffPolicyOption>()
      ->clone();
}

std::unique_ptr<storageinsights_v1::StorageInsightsConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options
      .get<storageinsights_v1::
               StorageInsightsConnectionIdempotencyPolicyOption>()
      ->clone();
}

}  // namespace

StorageInsightsConnectionImpl::StorageInsightsConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<storageinsights_v1_internal::StorageInsightsStub> stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(std::move(options),
                                      StorageInsightsConnection::options())) {}

StreamRange<google::cloud::storageinsights::v1::ReportConfig>
StorageInsightsConnectionImpl::ListReportConfigs(
    google::cloud::storageinsights::v1::ListReportConfigsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListReportConfigs(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::storageinsights::v1::ReportConfig>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<storageinsights_v1::StorageInsightsRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::storageinsights::v1::ListReportConfigsRequest const&
              r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::storageinsights::v1::
                       ListReportConfigsRequest const& request) {
              return stub->ListReportConfigs(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::storageinsights::v1::ListReportConfigsResponse r) {
        std::vector<google::cloud::storageinsights::v1::ReportConfig> result(
            r.report_configs().size());
        auto& messages = *r.mutable_report_configs();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::storageinsights::v1::ReportConfig>
StorageInsightsConnectionImpl::GetReportConfig(
    google::cloud::storageinsights::v1::GetReportConfigRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetReportConfig(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::storageinsights::v1::GetReportConfigRequest const&
                 request) {
        return stub_->GetReportConfig(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::storageinsights::v1::ReportConfig>
StorageInsightsConnectionImpl::CreateReportConfig(
    google::cloud::storageinsights::v1::CreateReportConfigRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateReportConfig(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::storageinsights::v1::CreateReportConfigRequest const&
              request) {
        return stub_->CreateReportConfig(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::storageinsights::v1::ReportConfig>
StorageInsightsConnectionImpl::UpdateReportConfig(
    google::cloud::storageinsights::v1::UpdateReportConfigRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateReportConfig(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::storageinsights::v1::UpdateReportConfigRequest const&
              request) {
        return stub_->UpdateReportConfig(context, options, request);
      },
      *current, request, __func__);
}

Status StorageInsightsConnectionImpl::DeleteReportConfig(
    google::cloud::storageinsights::v1::DeleteReportConfigRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteReportConfig(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::storageinsights::v1::DeleteReportConfigRequest const&
              request) {
        return stub_->DeleteReportConfig(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::cloud::storageinsights::v1::ReportDetail>
StorageInsightsConnectionImpl::ListReportDetails(
    google::cloud::storageinsights::v1::ListReportDetailsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListReportDetails(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::storageinsights::v1::ReportDetail>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<storageinsights_v1::StorageInsightsRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::storageinsights::v1::ListReportDetailsRequest const&
              r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::storageinsights::v1::
                       ListReportDetailsRequest const& request) {
              return stub->ListReportDetails(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::storageinsights::v1::ListReportDetailsResponse r) {
        std::vector<google::cloud::storageinsights::v1::ReportDetail> result(
            r.report_details().size());
        auto& messages = *r.mutable_report_details();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::storageinsights::v1::ReportDetail>
StorageInsightsConnectionImpl::GetReportDetail(
    google::cloud::storageinsights::v1::GetReportDetailRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetReportDetail(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::storageinsights::v1::GetReportDetailRequest const&
                 request) {
        return stub_->GetReportDetail(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::cloud::location::Location>
StorageInsightsConnectionImpl::ListLocations(
    google::cloud::location::ListLocationsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListLocations(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::location::Location>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<storageinsights_v1::StorageInsightsRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::location::ListLocationsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context, Options const& options,
                google::cloud::location::ListLocationsRequest const& request) {
              return stub->ListLocations(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::location::ListLocationsResponse r) {
        std::vector<google::cloud::location::Location> result(
            r.locations().size());
        auto& messages = *r.mutable_locations();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::location::Location>
StorageInsightsConnectionImpl::GetLocation(
    google::cloud::location::GetLocationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetLocation(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::location::GetLocationRequest const& request) {
        return stub_->GetLocation(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::longrunning::Operation>
StorageInsightsConnectionImpl::ListOperations(
    google::longrunning::ListOperationsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListOperations(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::longrunning::Operation>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<storageinsights_v1::StorageInsightsRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::longrunning::ListOperationsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::longrunning::ListOperationsRequest const& request) {
              return stub->ListOperations(context, options, request);
            },
            options, r, function_name);
      },
      [](google::longrunning::ListOperationsResponse r) {
        std::vector<google::longrunning::Operation> result(
            r.operations().size());
        auto& messages = *r.mutable_operations();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::longrunning::Operation>
StorageInsightsConnectionImpl::GetOperation(
    google::longrunning::GetOperationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetOperation(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::longrunning::GetOperationRequest const& request) {
        return stub_->GetOperation(context, options, request);
      },
      *current, request, __func__);
}

Status StorageInsightsConnectionImpl::DeleteOperation(
    google::longrunning::DeleteOperationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteOperation(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::longrunning::DeleteOperationRequest const& request) {
        return stub_->DeleteOperation(context, options, request);
      },
      *current, request, __func__);
}

Status StorageInsightsConnectionImpl::CancelOperation(
    google::longrunning::CancelOperationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CancelOperation(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::longrunning::CancelOperationRequest const& request) {
        return stub_->CancelOperation(context, options, request);
      },
      *current, request, __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace storageinsights_v1_internal
}  // namespace cloud
}  // namespace google
