// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/sql/v1/cloud_sql_databases.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SQL_V1_SQL_DATABASES_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SQL_V1_SQL_DATABASES_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/version.h"
#include <google/cloud/sql/v1/cloud_sql_databases.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace sql_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class SqlDatabasesServiceConnectionIdempotencyPolicy {
 public:
  virtual ~SqlDatabasesServiceConnectionIdempotencyPolicy();

  /// Create a new copy of this object.
  virtual std::unique_ptr<SqlDatabasesServiceConnectionIdempotencyPolicy>
  clone() const;

  virtual google::cloud::Idempotency Delete(
      google::cloud::sql::v1::SqlDatabasesDeleteRequest const& request);

  virtual google::cloud::Idempotency Get(
      google::cloud::sql::v1::SqlDatabasesGetRequest const& request);

  virtual google::cloud::Idempotency Insert(
      google::cloud::sql::v1::SqlDatabasesInsertRequest const& request);

  virtual google::cloud::Idempotency List(
      google::cloud::sql::v1::SqlDatabasesListRequest const& request);

  virtual google::cloud::Idempotency Patch(
      google::cloud::sql::v1::SqlDatabasesUpdateRequest const& request);

  virtual google::cloud::Idempotency Update(
      google::cloud::sql::v1::SqlDatabasesUpdateRequest const& request);
};

std::unique_ptr<SqlDatabasesServiceConnectionIdempotencyPolicy>
MakeDefaultSqlDatabasesServiceConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace sql_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SQL_V1_SQL_DATABASES_CONNECTION_IDEMPOTENCY_POLICY_H
