// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/speech/v1/cloud_speech_adaptation.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SPEECH_V1_INTERNAL_ADAPTATION_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SPEECH_V1_INTERNAL_ADAPTATION_TRACING_CONNECTION_H

#include "google/cloud/speech/v1/adaptation_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace speech_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class AdaptationTracingConnection : public speech_v1::AdaptationConnection {
 public:
  ~AdaptationTracingConnection() override = default;

  explicit AdaptationTracingConnection(
      std::shared_ptr<speech_v1::AdaptationConnection> child);

  Options options() override { return child_->options(); }

  StatusOr<google::cloud::speech::v1::PhraseSet> CreatePhraseSet(
      google::cloud::speech::v1::CreatePhraseSetRequest const& request)
      override;

  StatusOr<google::cloud::speech::v1::PhraseSet> GetPhraseSet(
      google::cloud::speech::v1::GetPhraseSetRequest const& request) override;

  StreamRange<google::cloud::speech::v1::PhraseSet> ListPhraseSet(
      google::cloud::speech::v1::ListPhraseSetRequest request) override;

  StatusOr<google::cloud::speech::v1::PhraseSet> UpdatePhraseSet(
      google::cloud::speech::v1::UpdatePhraseSetRequest const& request)
      override;

  Status DeletePhraseSet(
      google::cloud::speech::v1::DeletePhraseSetRequest const& request)
      override;

  StatusOr<google::cloud::speech::v1::CustomClass> CreateCustomClass(
      google::cloud::speech::v1::CreateCustomClassRequest const& request)
      override;

  StatusOr<google::cloud::speech::v1::CustomClass> GetCustomClass(
      google::cloud::speech::v1::GetCustomClassRequest const& request) override;

  StreamRange<google::cloud::speech::v1::CustomClass> ListCustomClasses(
      google::cloud::speech::v1::ListCustomClassesRequest request) override;

  StatusOr<google::cloud::speech::v1::CustomClass> UpdateCustomClass(
      google::cloud::speech::v1::UpdateCustomClassRequest const& request)
      override;

  Status DeleteCustomClass(
      google::cloud::speech::v1::DeleteCustomClassRequest const& request)
      override;

  StreamRange<google::longrunning::Operation> ListOperations(
      google::longrunning::ListOperationsRequest request) override;

  StatusOr<google::longrunning::Operation> GetOperation(
      google::longrunning::GetOperationRequest const& request) override;

 private:
  std::shared_ptr<speech_v1::AdaptationConnection> child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<speech_v1::AdaptationConnection>
MakeAdaptationTracingConnection(
    std::shared_ptr<speech_v1::AdaptationConnection> conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace speech_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SPEECH_V1_INTERNAL_ADAPTATION_TRACING_CONNECTION_H
