// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/speech/v1/cloud_speech_adaptation.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SPEECH_V1_INTERNAL_ADAPTATION_AUTH_DECORATOR_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SPEECH_V1_INTERNAL_ADAPTATION_AUTH_DECORATOR_H

#include "google/cloud/speech/v1/internal/adaptation_stub.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include "google/cloud/version.h"
#include <memory>
#include <set>
#include <string>

namespace google {
namespace cloud {
namespace speech_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class AdaptationAuth : public AdaptationStub {
 public:
  ~AdaptationAuth() override = default;
  AdaptationAuth(
      std::shared_ptr<google::cloud::internal::GrpcAuthenticationStrategy> auth,
      std::shared_ptr<AdaptationStub> child);

  StatusOr<google::cloud::speech::v1::PhraseSet> CreatePhraseSet(
      grpc::ClientContext& context, Options const& options,
      google::cloud::speech::v1::CreatePhraseSetRequest const& request)
      override;

  StatusOr<google::cloud::speech::v1::PhraseSet> GetPhraseSet(
      grpc::ClientContext& context, Options const& options,
      google::cloud::speech::v1::GetPhraseSetRequest const& request) override;

  StatusOr<google::cloud::speech::v1::ListPhraseSetResponse> ListPhraseSet(
      grpc::ClientContext& context, Options const& options,
      google::cloud::speech::v1::ListPhraseSetRequest const& request) override;

  StatusOr<google::cloud::speech::v1::PhraseSet> UpdatePhraseSet(
      grpc::ClientContext& context, Options const& options,
      google::cloud::speech::v1::UpdatePhraseSetRequest const& request)
      override;

  Status DeletePhraseSet(
      grpc::ClientContext& context, Options const& options,
      google::cloud::speech::v1::DeletePhraseSetRequest const& request)
      override;

  StatusOr<google::cloud::speech::v1::CustomClass> CreateCustomClass(
      grpc::ClientContext& context, Options const& options,
      google::cloud::speech::v1::CreateCustomClassRequest const& request)
      override;

  StatusOr<google::cloud::speech::v1::CustomClass> GetCustomClass(
      grpc::ClientContext& context, Options const& options,
      google::cloud::speech::v1::GetCustomClassRequest const& request) override;

  StatusOr<google::cloud::speech::v1::ListCustomClassesResponse>
  ListCustomClasses(grpc::ClientContext& context, Options const& options,
                    google::cloud::speech::v1::ListCustomClassesRequest const&
                        request) override;

  StatusOr<google::cloud::speech::v1::CustomClass> UpdateCustomClass(
      grpc::ClientContext& context, Options const& options,
      google::cloud::speech::v1::UpdateCustomClassRequest const& request)
      override;

  Status DeleteCustomClass(
      grpc::ClientContext& context, Options const& options,
      google::cloud::speech::v1::DeleteCustomClassRequest const& request)
      override;

  StatusOr<google::longrunning::ListOperationsResponse> ListOperations(
      grpc::ClientContext& context, Options const& options,
      google::longrunning::ListOperationsRequest const& request) override;

  StatusOr<google::longrunning::Operation> GetOperation(
      grpc::ClientContext& context, Options const& options,
      google::longrunning::GetOperationRequest const& request) override;

 private:
  std::shared_ptr<google::cloud::internal::GrpcAuthenticationStrategy> auth_;
  std::shared_ptr<AdaptationStub> child_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace speech_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SPEECH_V1_INTERNAL_ADAPTATION_AUTH_DECORATOR_H
