// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/speech/v1/cloud_speech_adaptation.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SPEECH_V1_ADAPTATION_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SPEECH_V1_ADAPTATION_CLIENT_H

#include "google/cloud/speech/v1/adaptation_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace speech_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Service that implements Google Cloud Speech Adaptation API.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class AdaptationClient {
 public:
  explicit AdaptationClient(std::shared_ptr<AdaptationConnection> connection,
                            Options opts = {});
  ~AdaptationClient();

  ///@{
  /// @name Copy and move support
  AdaptationClient(AdaptationClient const&) = default;
  AdaptationClient& operator=(AdaptationClient const&) = default;
  AdaptationClient(AdaptationClient&&) = default;
  AdaptationClient& operator=(AdaptationClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(AdaptationClient const& a, AdaptationClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(AdaptationClient const& a, AdaptationClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Create a set of phrase hints. Each item in the set can be a single word or
  /// a multi-word phrase. The items in the PhraseSet are favored by the
  /// recognition model when you send a call that includes the PhraseSet.
  ///
  /// @param parent  Required. The parent resource where this phrase set will be created.
  ///  Format:
  ///  @n
  ///  `projects/{project}/locations/{location}`
  ///  @n
  ///  Speech-to-Text supports three locations: `global`, `us` (US North America),
  ///  and `eu` (Europe). If you are calling the `speech.googleapis.com`
  ///  endpoint, use the `global` location. To specify a region, use a
  ///  [regional endpoint](https://cloud.google.com/speech-to-text/docs/endpoints)
  ///  with matching `us` or `eu` location value.
  /// @param phrase_set  Required. The phrase set to create.
  /// @param phrase_set_id  Required. The ID to use for the phrase set, which will become the final
  ///  component of the phrase set's resource name.
  ///  @n
  ///  This value should restrict to letters, numbers, and hyphens, with the first
  ///  character a letter, the last a letter or a number, and be 4-63 characters.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.speech.v1.PhraseSet])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.speech.v1.CreatePhraseSetRequest]: @googleapis_reference_link{google/cloud/speech/v1/cloud_speech_adaptation.proto#L131}
  /// [google.cloud.speech.v1.PhraseSet]: @googleapis_reference_link{google/cloud/speech/v1/resource.proto#L56}
  ///
  // clang-format on
  StatusOr<google::cloud::speech::v1::PhraseSet> CreatePhraseSet(
      std::string const& parent,
      google::cloud::speech::v1::PhraseSet const& phrase_set,
      std::string const& phrase_set_id, Options opts = {});

  // clang-format off
  ///
  /// Create a set of phrase hints. Each item in the set can be a single word or
  /// a multi-word phrase. The items in the PhraseSet are favored by the
  /// recognition model when you send a call that includes the PhraseSet.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.speech.v1.CreatePhraseSetRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.speech.v1.PhraseSet])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.speech.v1.CreatePhraseSetRequest]: @googleapis_reference_link{google/cloud/speech/v1/cloud_speech_adaptation.proto#L131}
  /// [google.cloud.speech.v1.PhraseSet]: @googleapis_reference_link{google/cloud/speech/v1/resource.proto#L56}
  ///
  // clang-format on
  StatusOr<google::cloud::speech::v1::PhraseSet> CreatePhraseSet(
      google::cloud::speech::v1::CreatePhraseSetRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Get a phrase set.
  ///
  /// @param name  Required. The name of the phrase set to retrieve. Format:
  ///  @n
  ///  `projects/{project}/locations/{location}/phraseSets/{phrase_set}`
  ///  @n
  ///  Speech-to-Text supports three locations: `global`, `us` (US North America),
  ///  and `eu` (Europe). If you are calling the `speech.googleapis.com`
  ///  endpoint, use the `global` location. To specify a region, use a
  ///  [regional endpoint](https://cloud.google.com/speech-to-text/docs/endpoints)
  ///  with matching `us` or `eu` location value.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.speech.v1.PhraseSet])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.speech.v1.GetPhraseSetRequest]: @googleapis_reference_link{google/cloud/speech/v1/cloud_speech_adaptation.proto#L181}
  /// [google.cloud.speech.v1.PhraseSet]: @googleapis_reference_link{google/cloud/speech/v1/resource.proto#L56}
  ///
  // clang-format on
  StatusOr<google::cloud::speech::v1::PhraseSet> GetPhraseSet(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Get a phrase set.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.speech.v1.GetPhraseSetRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.speech.v1.PhraseSet])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.speech.v1.GetPhraseSetRequest]: @googleapis_reference_link{google/cloud/speech/v1/cloud_speech_adaptation.proto#L181}
  /// [google.cloud.speech.v1.PhraseSet]: @googleapis_reference_link{google/cloud/speech/v1/resource.proto#L56}
  ///
  // clang-format on
  StatusOr<google::cloud::speech::v1::PhraseSet> GetPhraseSet(
      google::cloud::speech::v1::GetPhraseSetRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// List phrase sets.
  ///
  /// @param parent  Required. The parent, which owns this collection of phrase set. Format:
  ///  @n
  ///  `projects/{project}/locations/{location}`
  ///  @n
  ///  Speech-to-Text supports three locations: `global`, `us` (US North America),
  ///  and `eu` (Europe). If you are calling the `speech.googleapis.com`
  ///  endpoint, use the `global` location. To specify a region, use a
  ///  [regional endpoint](https://cloud.google.com/speech-to-text/docs/endpoints)
  ///  with matching `us` or `eu` location value.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.speech.v1.PhraseSet], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.speech.v1.ListPhraseSetRequest]: @googleapis_reference_link{google/cloud/speech/v1/cloud_speech_adaptation.proto#L200}
  /// [google.cloud.speech.v1.PhraseSet]: @googleapis_reference_link{google/cloud/speech/v1/resource.proto#L56}
  ///
  // clang-format on
  StreamRange<google::cloud::speech::v1::PhraseSet> ListPhraseSet(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// List phrase sets.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.speech.v1.ListPhraseSetRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.speech.v1.PhraseSet], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.speech.v1.ListPhraseSetRequest]: @googleapis_reference_link{google/cloud/speech/v1/cloud_speech_adaptation.proto#L200}
  /// [google.cloud.speech.v1.PhraseSet]: @googleapis_reference_link{google/cloud/speech/v1/resource.proto#L56}
  ///
  // clang-format on
  StreamRange<google::cloud::speech::v1::PhraseSet> ListPhraseSet(
      google::cloud::speech::v1::ListPhraseSetRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Update a phrase set.
  ///
  /// @param phrase_set  Required. The phrase set to update.
  ///  @n
  ///  The phrase set's `name` field is used to identify the set to be
  ///  updated. Format:
  ///  @n
  ///  `projects/{project}/locations/{location}/phraseSets/{phrase_set}`
  ///  @n
  ///  Speech-to-Text supports three locations: `global`, `us` (US North America),
  ///  and `eu` (Europe). If you are calling the `speech.googleapis.com`
  ///  endpoint, use the `global` location. To specify a region, use a
  ///  [regional endpoint](https://cloud.google.com/speech-to-text/docs/endpoints)
  ///  with matching `us` or `eu` location value.
  /// @param update_mask  The list of fields to be updated.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.speech.v1.PhraseSet])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.speech.v1.PhraseSet]: @googleapis_reference_link{google/cloud/speech/v1/resource.proto#L56}
  /// [google.cloud.speech.v1.UpdatePhraseSetRequest]: @googleapis_reference_link{google/cloud/speech/v1/cloud_speech_adaptation.proto#L161}
  ///
  // clang-format on
  StatusOr<google::cloud::speech::v1::PhraseSet> UpdatePhraseSet(
      google::cloud::speech::v1::PhraseSet const& phrase_set,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Update a phrase set.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.speech.v1.UpdatePhraseSetRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.speech.v1.PhraseSet])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.speech.v1.PhraseSet]: @googleapis_reference_link{google/cloud/speech/v1/resource.proto#L56}
  /// [google.cloud.speech.v1.UpdatePhraseSetRequest]: @googleapis_reference_link{google/cloud/speech/v1/cloud_speech_adaptation.proto#L161}
  ///
  // clang-format on
  StatusOr<google::cloud::speech::v1::PhraseSet> UpdatePhraseSet(
      google::cloud::speech::v1::UpdatePhraseSetRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Delete a phrase set.
  ///
  /// @param name  Required. The name of the phrase set to delete. Format:
  ///  @n
  ///  `projects/{project}/locations/{location}/phraseSets/{phrase_set}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.speech.v1.DeletePhraseSetRequest]: @googleapis_reference_link{google/cloud/speech/v1/cloud_speech_adaptation.proto#L242}
  ///
  // clang-format on
  Status DeletePhraseSet(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Delete a phrase set.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.speech.v1.DeletePhraseSetRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.speech.v1.DeletePhraseSetRequest]: @googleapis_reference_link{google/cloud/speech/v1/cloud_speech_adaptation.proto#L242}
  ///
  // clang-format on
  Status DeletePhraseSet(
      google::cloud::speech::v1::DeletePhraseSetRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Create a custom class.
  ///
  /// @param parent  Required. The parent resource where this custom class will be created.
  ///  Format:
  ///  @n
  ///  `projects/{project}/locations/{location}/customClasses`
  ///  @n
  ///  Speech-to-Text supports three locations: `global`, `us` (US North America),
  ///  and `eu` (Europe). If you are calling the `speech.googleapis.com`
  ///  endpoint, use the `global` location. To specify a region, use a
  ///  [regional endpoint](https://cloud.google.com/speech-to-text/docs/endpoints)
  ///  with matching `us` or `eu` location value.
  /// @param custom_class  Required. The custom class to create.
  /// @param custom_class_id  Required. The ID to use for the custom class, which will become the final
  ///  component of the custom class' resource name.
  ///  @n
  ///  This value should restrict to letters, numbers, and hyphens, with the first
  ///  character a letter, the last a letter or a number, and be 4-63 characters.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.speech.v1.CustomClass])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.speech.v1.CreateCustomClassRequest]: @googleapis_reference_link{google/cloud/speech/v1/cloud_speech_adaptation.proto#L255}
  /// [google.cloud.speech.v1.CustomClass]: @googleapis_reference_link{google/cloud/speech/v1/resource.proto#L31}
  ///
  // clang-format on
  StatusOr<google::cloud::speech::v1::CustomClass> CreateCustomClass(
      std::string const& parent,
      google::cloud::speech::v1::CustomClass const& custom_class,
      std::string const& custom_class_id, Options opts = {});

  // clang-format off
  ///
  /// Create a custom class.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.speech.v1.CreateCustomClassRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.speech.v1.CustomClass])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.speech.v1.CreateCustomClassRequest]: @googleapis_reference_link{google/cloud/speech/v1/cloud_speech_adaptation.proto#L255}
  /// [google.cloud.speech.v1.CustomClass]: @googleapis_reference_link{google/cloud/speech/v1/resource.proto#L31}
  ///
  // clang-format on
  StatusOr<google::cloud::speech::v1::CustomClass> CreateCustomClass(
      google::cloud::speech::v1::CreateCustomClassRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Get a custom class.
  ///
  /// @param name  Required. The name of the custom class to retrieve. Format:
  ///  @n
  ///  `projects/{project}/locations/{location}/customClasses/{custom_class}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.speech.v1.CustomClass])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.speech.v1.CustomClass]: @googleapis_reference_link{google/cloud/speech/v1/resource.proto#L31}
  /// [google.cloud.speech.v1.GetCustomClassRequest]: @googleapis_reference_link{google/cloud/speech/v1/cloud_speech_adaptation.proto#L305}
  ///
  // clang-format on
  StatusOr<google::cloud::speech::v1::CustomClass> GetCustomClass(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Get a custom class.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.speech.v1.GetCustomClassRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.speech.v1.CustomClass])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.speech.v1.CustomClass]: @googleapis_reference_link{google/cloud/speech/v1/resource.proto#L31}
  /// [google.cloud.speech.v1.GetCustomClassRequest]: @googleapis_reference_link{google/cloud/speech/v1/cloud_speech_adaptation.proto#L305}
  ///
  // clang-format on
  StatusOr<google::cloud::speech::v1::CustomClass> GetCustomClass(
      google::cloud::speech::v1::GetCustomClassRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// List custom classes.
  ///
  /// @param parent  Required. The parent, which owns this collection of custom classes. Format:
  ///  @n
  ///  `projects/{project}/locations/{location}/customClasses`
  ///  @n
  ///  Speech-to-Text supports three locations: `global`, `us` (US North America),
  ///  and `eu` (Europe). If you are calling the `speech.googleapis.com`
  ///  endpoint, use the `global` location. To specify a region, use a
  ///  [regional endpoint](https://cloud.google.com/speech-to-text/docs/endpoints)
  ///  with matching `us` or `eu` location value.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.speech.v1.CustomClass], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.speech.v1.CustomClass]: @googleapis_reference_link{google/cloud/speech/v1/resource.proto#L31}
  /// [google.cloud.speech.v1.ListCustomClassesRequest]: @googleapis_reference_link{google/cloud/speech/v1/cloud_speech_adaptation.proto#L318}
  ///
  // clang-format on
  StreamRange<google::cloud::speech::v1::CustomClass> ListCustomClasses(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// List custom classes.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.speech.v1.ListCustomClassesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.speech.v1.CustomClass], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.speech.v1.CustomClass]: @googleapis_reference_link{google/cloud/speech/v1/resource.proto#L31}
  /// [google.cloud.speech.v1.ListCustomClassesRequest]: @googleapis_reference_link{google/cloud/speech/v1/cloud_speech_adaptation.proto#L318}
  ///
  // clang-format on
  StreamRange<google::cloud::speech::v1::CustomClass> ListCustomClasses(
      google::cloud::speech::v1::ListCustomClassesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Update a custom class.
  ///
  /// @param custom_class  Required. The custom class to update.
  ///  @n
  ///  The custom class's `name` field is used to identify the custom class to be
  ///  updated. Format:
  ///  @n
  ///  `projects/{project}/locations/{location}/customClasses/{custom_class}`
  ///  @n
  ///  Speech-to-Text supports three locations: `global`, `us` (US North America),
  ///  and `eu` (Europe). If you are calling the `speech.googleapis.com`
  ///  endpoint, use the `global` location. To specify a region, use a
  ///  [regional endpoint](https://cloud.google.com/speech-to-text/docs/endpoints)
  ///  with matching `us` or `eu` location value.
  /// @param update_mask  The list of fields to be updated.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.speech.v1.CustomClass])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.speech.v1.CustomClass]: @googleapis_reference_link{google/cloud/speech/v1/resource.proto#L31}
  /// [google.cloud.speech.v1.UpdateCustomClassRequest]: @googleapis_reference_link{google/cloud/speech/v1/cloud_speech_adaptation.proto#L285}
  ///
  // clang-format on
  StatusOr<google::cloud::speech::v1::CustomClass> UpdateCustomClass(
      google::cloud::speech::v1::CustomClass const& custom_class,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Update a custom class.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.speech.v1.UpdateCustomClassRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.speech.v1.CustomClass])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.speech.v1.CustomClass]: @googleapis_reference_link{google/cloud/speech/v1/resource.proto#L31}
  /// [google.cloud.speech.v1.UpdateCustomClassRequest]: @googleapis_reference_link{google/cloud/speech/v1/cloud_speech_adaptation.proto#L285}
  ///
  // clang-format on
  StatusOr<google::cloud::speech::v1::CustomClass> UpdateCustomClass(
      google::cloud::speech::v1::UpdateCustomClassRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Delete a custom class.
  ///
  /// @param name  Required. The name of the custom class to delete. Format:
  ///  @n
  ///  `projects/{project}/locations/{location}/customClasses/{custom_class}`
  ///  @n
  ///  Speech-to-Text supports three locations: `global`, `us` (US North America),
  ///  and `eu` (Europe). If you are calling the `speech.googleapis.com`
  ///  endpoint, use the `global` location. To specify a region, use a
  ///  [regional endpoint](https://cloud.google.com/speech-to-text/docs/endpoints)
  ///  with matching `us` or `eu` location value.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.speech.v1.DeleteCustomClassRequest]: @googleapis_reference_link{google/cloud/speech/v1/cloud_speech_adaptation.proto#L360}
  ///
  // clang-format on
  Status DeleteCustomClass(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Delete a custom class.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.speech.v1.DeleteCustomClassRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.speech.v1.DeleteCustomClassRequest]: @googleapis_reference_link{google/cloud/speech/v1/cloud_speech_adaptation.proto#L360}
  ///
  // clang-format on
  Status DeleteCustomClass(
      google::cloud::speech::v1::DeleteCustomClassRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists operations that match the specified filter in the request. If the
  /// server doesn't support this method, it returns `UNIMPLEMENTED`.
  ///
  /// NOTE: the `name` binding allows API services to override the binding
  /// to use different resource name schemes, such as `users/*/operations`. To
  /// override the binding, API services can add a binding such as
  /// `"/v1/{name=users/*}/operations"` to their service configuration.
  /// For backwards compatibility, the default name includes the operations
  /// collection id, however overriding users must ensure the name binding
  /// is the parent resource, without the operations collection id.
  ///
  /// @param name  The name of the operation's parent resource.
  /// @param filter  The standard list filter.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.longrunning.Operation], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.longrunning.ListOperationsRequest]: @googleapis_reference_link{google/longrunning/operations.proto#L171}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  StreamRange<google::longrunning::Operation> ListOperations(
      std::string const& name, std::string const& filter, Options opts = {});

  // clang-format off
  ///
  /// Lists operations that match the specified filter in the request. If the
  /// server doesn't support this method, it returns `UNIMPLEMENTED`.
  ///
  /// NOTE: the `name` binding allows API services to override the binding
  /// to use different resource name schemes, such as `users/*/operations`. To
  /// override the binding, API services can add a binding such as
  /// `"/v1/{name=users/*}/operations"` to their service configuration.
  /// For backwards compatibility, the default name includes the operations
  /// collection id, however overriding users must ensure the name binding
  /// is the parent resource, without the operations collection id.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.longrunning.ListOperationsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.longrunning.Operation], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.longrunning.ListOperationsRequest]: @googleapis_reference_link{google/longrunning/operations.proto#L171}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  StreamRange<google::longrunning::Operation> ListOperations(
      google::longrunning::ListOperationsRequest request, Options opts = {});

  // clang-format off
  ///
  /// Gets the latest state of a long-running operation.  Clients can use this
  /// method to poll the operation result at intervals as recommended by the API
  /// service.
  ///
  /// @param name  The name of the operation resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.longrunning.Operation])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.longrunning.GetOperationRequest]: @googleapis_reference_link{google/longrunning/operations.proto#L165}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> GetOperation(std::string const& name,
                                                        Options opts = {});

  // clang-format off
  ///
  /// Gets the latest state of a long-running operation.  Clients can use this
  /// method to poll the operation result at intervals as recommended by the API
  /// service.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.longrunning.GetOperationRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.longrunning.Operation])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.longrunning.GetOperationRequest]: @googleapis_reference_link{google/longrunning/operations.proto#L165}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> GetOperation(
      google::longrunning::GetOperationRequest const& request,
      Options opts = {});

 private:
  std::shared_ptr<AdaptationConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace speech_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SPEECH_V1_ADAPTATION_CLIENT_H
