// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/api/serviceusage/v1/serviceusage.proto

#include "google/cloud/serviceusage/v1/service_usage_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace serviceusage_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

ServiceUsageConnectionIdempotencyPolicy::
    ~ServiceUsageConnectionIdempotencyPolicy() = default;

std::unique_ptr<ServiceUsageConnectionIdempotencyPolicy>
ServiceUsageConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<ServiceUsageConnectionIdempotencyPolicy>(*this);
}

Idempotency ServiceUsageConnectionIdempotencyPolicy::EnableService(
    google::api::serviceusage::v1::EnableServiceRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ServiceUsageConnectionIdempotencyPolicy::DisableService(
    google::api::serviceusage::v1::DisableServiceRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ServiceUsageConnectionIdempotencyPolicy::GetService(
    google::api::serviceusage::v1::GetServiceRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency ServiceUsageConnectionIdempotencyPolicy::ListServices(
    google::api::serviceusage::v1::ListServicesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency ServiceUsageConnectionIdempotencyPolicy::BatchEnableServices(
    google::api::serviceusage::v1::BatchEnableServicesRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ServiceUsageConnectionIdempotencyPolicy::BatchGetServices(
    google::api::serviceusage::v1::BatchGetServicesRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency ServiceUsageConnectionIdempotencyPolicy::ListOperations(
    google::longrunning::ListOperationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency ServiceUsageConnectionIdempotencyPolicy::GetOperation(
    google::longrunning::GetOperationRequest const&) {
  return Idempotency::kIdempotent;
}

std::unique_ptr<ServiceUsageConnectionIdempotencyPolicy>
MakeDefaultServiceUsageConnectionIdempotencyPolicy() {
  return std::make_unique<ServiceUsageConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace serviceusage_v1
}  // namespace cloud
}  // namespace google
