// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/api/serviceusage/v1/serviceusage.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SERVICEUSAGE_V1_INTERNAL_SERVICE_USAGE_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SERVICEUSAGE_V1_INTERNAL_SERVICE_USAGE_TRACING_CONNECTION_H

#include "google/cloud/serviceusage/v1/service_usage_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace serviceusage_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class ServiceUsageTracingConnection
    : public serviceusage_v1::ServiceUsageConnection {
 public:
  ~ServiceUsageTracingConnection() override = default;

  explicit ServiceUsageTracingConnection(
      std::shared_ptr<serviceusage_v1::ServiceUsageConnection> child);

  Options options() override { return child_->options(); }

  future<StatusOr<google::api::serviceusage::v1::EnableServiceResponse>>
  EnableService(google::api::serviceusage::v1::EnableServiceRequest const&
                    request) override;

  StatusOr<google::longrunning::Operation> EnableService(
      NoAwaitTag,
      google::api::serviceusage::v1::EnableServiceRequest const& request)
      override;

  future<StatusOr<google::api::serviceusage::v1::EnableServiceResponse>>
  EnableService(google::longrunning::Operation const& operation) override;

  future<StatusOr<google::api::serviceusage::v1::DisableServiceResponse>>
  DisableService(google::api::serviceusage::v1::DisableServiceRequest const&
                     request) override;

  StatusOr<google::longrunning::Operation> DisableService(
      NoAwaitTag,
      google::api::serviceusage::v1::DisableServiceRequest const& request)
      override;

  future<StatusOr<google::api::serviceusage::v1::DisableServiceResponse>>
  DisableService(google::longrunning::Operation const& operation) override;

  StatusOr<google::api::serviceusage::v1::Service> GetService(
      google::api::serviceusage::v1::GetServiceRequest const& request) override;

  StreamRange<google::api::serviceusage::v1::Service> ListServices(
      google::api::serviceusage::v1::ListServicesRequest request) override;

  future<StatusOr<google::api::serviceusage::v1::BatchEnableServicesResponse>>
  BatchEnableServices(
      google::api::serviceusage::v1::BatchEnableServicesRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> BatchEnableServices(
      NoAwaitTag,
      google::api::serviceusage::v1::BatchEnableServicesRequest const& request)
      override;

  future<StatusOr<google::api::serviceusage::v1::BatchEnableServicesResponse>>
  BatchEnableServices(google::longrunning::Operation const& operation) override;

  StatusOr<google::api::serviceusage::v1::BatchGetServicesResponse>
  BatchGetServices(google::api::serviceusage::v1::BatchGetServicesRequest const&
                       request) override;

  StreamRange<google::longrunning::Operation> ListOperations(
      google::longrunning::ListOperationsRequest request) override;

  StatusOr<google::longrunning::Operation> GetOperation(
      google::longrunning::GetOperationRequest const& request) override;

 private:
  std::shared_ptr<serviceusage_v1::ServiceUsageConnection> child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<serviceusage_v1::ServiceUsageConnection>
MakeServiceUsageTracingConnection(
    std::shared_ptr<serviceusage_v1::ServiceUsageConnection> conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace serviceusage_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SERVICEUSAGE_V1_INTERNAL_SERVICE_USAGE_TRACING_CONNECTION_H
