// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/api/servicemanagement/v1/servicemanager.proto

#include "google/cloud/servicemanagement/v1/service_manager_connection.h"
#include "google/cloud/servicemanagement/v1/internal/service_manager_connection_impl.h"
#include "google/cloud/servicemanagement/v1/internal/service_manager_option_defaults.h"
#include "google/cloud/servicemanagement/v1/internal/service_manager_stub_factory.h"
#include "google/cloud/servicemanagement/v1/internal/service_manager_tracing_connection.h"
#include "google/cloud/servicemanagement/v1/service_manager_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace servicemanagement_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ServiceManagerConnection::~ServiceManagerConnection() = default;

StreamRange<google::api::servicemanagement::v1::ManagedService>
ServiceManagerConnection::ListServices(
    google::api::servicemanagement::v1::
        ListServicesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::api::servicemanagement::v1::ManagedService>>();
}

StatusOr<google::api::servicemanagement::v1::ManagedService>
ServiceManagerConnection::GetService(
    google::api::servicemanagement::v1::GetServiceRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::api::servicemanagement::v1::ManagedService>>
ServiceManagerConnection::CreateService(
    google::api::servicemanagement::v1::CreateServiceRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::api::servicemanagement::v1::ManagedService>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
ServiceManagerConnection::CreateService(
    NoAwaitTag,
    google::api::servicemanagement::v1::CreateServiceRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::api::servicemanagement::v1::ManagedService>>
ServiceManagerConnection::CreateService(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::api::servicemanagement::v1::ManagedService>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::api::servicemanagement::v1::OperationMetadata>>
ServiceManagerConnection::DeleteService(
    google::api::servicemanagement::v1::DeleteServiceRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::api::servicemanagement::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
ServiceManagerConnection::DeleteService(
    NoAwaitTag,
    google::api::servicemanagement::v1::DeleteServiceRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::api::servicemanagement::v1::OperationMetadata>>
ServiceManagerConnection::DeleteService(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::api::servicemanagement::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::api::servicemanagement::v1::UndeleteServiceResponse>>
ServiceManagerConnection::UndeleteService(
    google::api::servicemanagement::v1::UndeleteServiceRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::api::servicemanagement::v1::UndeleteServiceResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
ServiceManagerConnection::UndeleteService(
    NoAwaitTag,
    google::api::servicemanagement::v1::UndeleteServiceRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::api::servicemanagement::v1::UndeleteServiceResponse>>
ServiceManagerConnection::UndeleteService(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::api::servicemanagement::v1::UndeleteServiceResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::api::Service> ServiceManagerConnection::ListServiceConfigs(
    google::api::servicemanagement::v1::
        ListServiceConfigsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::api::Service>>();
}

StatusOr<google::api::Service> ServiceManagerConnection::GetServiceConfig(
    google::api::servicemanagement::v1::GetServiceConfigRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::api::Service> ServiceManagerConnection::CreateServiceConfig(
    google::api::servicemanagement::v1::CreateServiceConfigRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::api::servicemanagement::v1::SubmitConfigSourceResponse>>
ServiceManagerConnection::SubmitConfigSource(
    google::api::servicemanagement::v1::SubmitConfigSourceRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::api::servicemanagement::v1::SubmitConfigSourceResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
ServiceManagerConnection::SubmitConfigSource(
    NoAwaitTag,
    google::api::servicemanagement::v1::SubmitConfigSourceRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::api::servicemanagement::v1::SubmitConfigSourceResponse>>
ServiceManagerConnection::SubmitConfigSource(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::api::servicemanagement::v1::SubmitConfigSourceResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::api::servicemanagement::v1::Rollout>
ServiceManagerConnection::ListServiceRollouts(
    google::api::servicemanagement::v1::
        ListServiceRolloutsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::api::servicemanagement::v1::Rollout>>();
}

StatusOr<google::api::servicemanagement::v1::Rollout>
ServiceManagerConnection::GetServiceRollout(
    google::api::servicemanagement::v1::GetServiceRolloutRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::api::servicemanagement::v1::Rollout>>
ServiceManagerConnection::CreateServiceRollout(
    google::api::servicemanagement::v1::CreateServiceRolloutRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::api::servicemanagement::v1::Rollout>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
ServiceManagerConnection::CreateServiceRollout(
    NoAwaitTag,
    google::api::servicemanagement::v1::CreateServiceRolloutRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::api::servicemanagement::v1::Rollout>>
ServiceManagerConnection::CreateServiceRollout(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::api::servicemanagement::v1::Rollout>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::api::servicemanagement::v1::GenerateConfigReportResponse>
ServiceManagerConnection::GenerateConfigReport(
    google::api::servicemanagement::v1::GenerateConfigReportRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::Policy> ServiceManagerConnection::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::Policy> ServiceManagerConnection::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
ServiceManagerConnection::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::longrunning::Operation>
ServiceManagerConnection::ListOperations(
    google::longrunning::
        ListOperationsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::longrunning::Operation>>();
}

std::shared_ptr<ServiceManagerConnection> MakeServiceManagerConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 ServiceManagerPolicyOptionList>(options,
                                                                 __func__);
  options = servicemanagement_v1_internal::ServiceManagerDefaultOptions(
      std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub = servicemanagement_v1_internal::CreateDefaultServiceManagerStub(
      std::move(auth), options);
  return servicemanagement_v1_internal::MakeServiceManagerTracingConnection(
      std::make_shared<
          servicemanagement_v1_internal::ServiceManagerConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace servicemanagement_v1
}  // namespace cloud
}  // namespace google
