// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/api/servicemanagement/v1/servicemanager.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SERVICEMANAGEMENT_V1_SERVICE_MANAGER_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SERVICEMANAGEMENT_V1_SERVICE_MANAGER_CLIENT_H

#include "google/cloud/servicemanagement/v1/service_manager_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace servicemanagement_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// [Google Service Management
/// API](https://cloud.google.com/service-infrastructure/docs/overview)
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class ServiceManagerClient {
 public:
  explicit ServiceManagerClient(
      std::shared_ptr<ServiceManagerConnection> connection, Options opts = {});
  ~ServiceManagerClient();

  ///@{
  /// @name Copy and move support
  ServiceManagerClient(ServiceManagerClient const&) = default;
  ServiceManagerClient& operator=(ServiceManagerClient const&) = default;
  ServiceManagerClient(ServiceManagerClient&&) = default;
  ServiceManagerClient& operator=(ServiceManagerClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(ServiceManagerClient const& a,
                         ServiceManagerClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(ServiceManagerClient const& a,
                         ServiceManagerClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Lists managed services.
  ///
  /// Returns all public services. For authenticated users, also returns all
  /// services the calling user has "servicemanagement.services.get" permission
  /// for.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.api.servicemanagement.v1.ListServicesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.api.servicemanagement.v1.ManagedService], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.api.servicemanagement.v1.ListServicesRequest]: @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L262}
  /// [google.api.servicemanagement.v1.ManagedService]: @googleapis_reference_link{google/api/servicemanagement/v1/resources.proto#L34}
  ///
  // clang-format on
  StreamRange<google::api::servicemanagement::v1::ManagedService> ListServices(
      google::api::servicemanagement::v1::ListServicesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets a managed service. Authentication is required unless the service is
  /// public.
  ///
  /// @param service_name  Required. The name of the service.  See the `ServiceManager` overview for
  ///  naming requirements.  For example: `example.googleapis.com`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.api.servicemanagement.v1.ManagedService])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.api.servicemanagement.v1.GetServiceRequest]: @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L292}
  /// [google.api.servicemanagement.v1.ManagedService]: @googleapis_reference_link{google/api/servicemanagement/v1/resources.proto#L34}
  ///
  // clang-format on
  StatusOr<google::api::servicemanagement::v1::ManagedService> GetService(
      std::string const& service_name, Options opts = {});

  // clang-format off
  ///
  /// Gets a managed service. Authentication is required unless the service is
  /// public.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.api.servicemanagement.v1.GetServiceRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.api.servicemanagement.v1.ManagedService])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.api.servicemanagement.v1.GetServiceRequest]: @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L292}
  /// [google.api.servicemanagement.v1.ManagedService]: @googleapis_reference_link{google/api/servicemanagement/v1/resources.proto#L34}
  ///
  // clang-format on
  StatusOr<google::api::servicemanagement::v1::ManagedService> GetService(
      google::api::servicemanagement::v1::GetServiceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new managed service.
  ///
  /// A managed service is immutable, and is subject to mandatory 30-day
  /// data retention. You cannot move a service or recreate it within 30 days
  /// after deletion.
  ///
  /// One producer project can own no more than 500 services. For security and
  /// reliability purposes, a production service should be hosted in a
  /// dedicated producer project.
  ///
  /// Operation<response: ManagedService>
  ///
  /// @param service  Required. Initial values for the service resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.api.servicemanagement.v1.ManagedService] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.api.servicemanagement.v1.CreateServiceRequest]: @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L299}
  /// [google.api.servicemanagement.v1.ManagedService]: @googleapis_reference_link{google/api/servicemanagement/v1/resources.proto#L34}
  ///
  // clang-format on
  future<StatusOr<google::api::servicemanagement::v1::ManagedService>>
  CreateService(
      google::api::servicemanagement::v1::ManagedService const& service,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateService
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateService(
      NoAwaitTag,
      google::api::servicemanagement::v1::ManagedService const& service,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new managed service.
  ///
  /// A managed service is immutable, and is subject to mandatory 30-day
  /// data retention. You cannot move a service or recreate it within 30 days
  /// after deletion.
  ///
  /// One producer project can own no more than 500 services. For security and
  /// reliability purposes, a production service should be hosted in a
  /// dedicated producer project.
  ///
  /// Operation<response: ManagedService>
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.api.servicemanagement.v1.CreateServiceRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.api.servicemanagement.v1.ManagedService] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.api.servicemanagement.v1.CreateServiceRequest]: @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L299}
  /// [google.api.servicemanagement.v1.ManagedService]: @googleapis_reference_link{google/api/servicemanagement/v1/resources.proto#L34}
  ///
  // clang-format on
  future<StatusOr<google::api::servicemanagement::v1::ManagedService>>
  CreateService(
      google::api::servicemanagement::v1::CreateServiceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateService
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateService(
      NoAwaitTag,
      google::api::servicemanagement::v1::CreateServiceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateService
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::api::servicemanagement::v1::ManagedService>>
  CreateService(google::longrunning::Operation const& operation,
                Options opts = {});

  // clang-format off
  ///
  /// Deletes a managed service. This method will change the service to the
  /// `Soft-Delete` state for 30 days. Within this period, service producers may
  /// call
  /// [UndeleteService][google.api.servicemanagement.v1.ServiceManager.UndeleteService]
  /// to restore the service. After 30 days, the service will be permanently
  /// deleted.
  ///
  /// Operation<response: google.protobuf.Empty>
  ///
  /// @param service_name  Required. The name of the service.  See the
  ///  [overview](https://cloud.google.com/service-management/overview) for naming
  ///  requirements.  For example: `example.googleapis.com`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.api.servicemanagement.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.api.servicemanagement.v1.DeleteServiceRequest]: @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L305}
  /// [google.api.servicemanagement.v1.OperationMetadata]: @googleapis_reference_link{google/api/servicemanagement/v1/resources.proto#L45}
  /// [google.api.servicemanagement.v1.ServiceManager.UndeleteService]: @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L118}
  ///
  // clang-format on
  future<StatusOr<google::api::servicemanagement::v1::OperationMetadata>>
  DeleteService(std::string const& service_name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteService
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteService(
      NoAwaitTag, std::string const& service_name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a managed service. This method will change the service to the
  /// `Soft-Delete` state for 30 days. Within this period, service producers may
  /// call
  /// [UndeleteService][google.api.servicemanagement.v1.ServiceManager.UndeleteService]
  /// to restore the service. After 30 days, the service will be permanently
  /// deleted.
  ///
  /// Operation<response: google.protobuf.Empty>
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.api.servicemanagement.v1.DeleteServiceRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.api.servicemanagement.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.api.servicemanagement.v1.DeleteServiceRequest]: @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L305}
  /// [google.api.servicemanagement.v1.OperationMetadata]: @googleapis_reference_link{google/api/servicemanagement/v1/resources.proto#L45}
  /// [google.api.servicemanagement.v1.ServiceManager.UndeleteService]: @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L118}
  ///
  // clang-format on
  future<StatusOr<google::api::servicemanagement::v1::OperationMetadata>>
  DeleteService(
      google::api::servicemanagement::v1::DeleteServiceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteService
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteService(
      NoAwaitTag,
      google::api::servicemanagement::v1::DeleteServiceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteService
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::api::servicemanagement::v1::OperationMetadata>>
  DeleteService(google::longrunning::Operation const& operation,
                Options opts = {});

  // clang-format off
  ///
  /// Revives a previously deleted managed service. The method restores the
  /// service using the configuration at the time the service was deleted.
  /// The target service must exist and must have been deleted within the
  /// last 30 days.
  ///
  /// Operation<response: UndeleteServiceResponse>
  ///
  /// @param service_name  Required. The name of the service. See the
  ///  [overview](https://cloud.google.com/service-management/overview) for naming
  ///  requirements. For example: `example.googleapis.com`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.api.servicemanagement.v1.UndeleteServiceResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.api.servicemanagement.v1.UndeleteServiceRequest]: @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L313}
  /// [google.api.servicemanagement.v1.UndeleteServiceResponse]: @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L321}
  ///
  // clang-format on
  future<StatusOr<google::api::servicemanagement::v1::UndeleteServiceResponse>>
  UndeleteService(std::string const& service_name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UndeleteService
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UndeleteService(
      NoAwaitTag, std::string const& service_name, Options opts = {});

  // clang-format off
  ///
  /// Revives a previously deleted managed service. The method restores the
  /// service using the configuration at the time the service was deleted.
  /// The target service must exist and must have been deleted within the
  /// last 30 days.
  ///
  /// Operation<response: UndeleteServiceResponse>
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.api.servicemanagement.v1.UndeleteServiceRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.api.servicemanagement.v1.UndeleteServiceResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.api.servicemanagement.v1.UndeleteServiceRequest]: @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L313}
  /// [google.api.servicemanagement.v1.UndeleteServiceResponse]: @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L321}
  ///
  // clang-format on
  future<StatusOr<google::api::servicemanagement::v1::UndeleteServiceResponse>>
  UndeleteService(
      google::api::servicemanagement::v1::UndeleteServiceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UndeleteService
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UndeleteService(
      NoAwaitTag,
      google::api::servicemanagement::v1::UndeleteServiceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UndeleteService
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::api::servicemanagement::v1::UndeleteServiceResponse>>
  UndeleteService(google::longrunning::Operation const& operation,
                  Options opts = {});

  // clang-format off
  ///
  /// Lists the history of the service configuration for a managed service,
  /// from the newest to the oldest.
  ///
  /// @param service_name  Required. The name of the service.  See the
  ///  [overview](https://cloud.google.com/service-management/overview) for naming
  ///  requirements.  For example: `example.googleapis.com`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.api.Service], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.api.Service]: @googleapis_reference_link{google/api/service.proto#L80}
  /// [google.api.servicemanagement.v1.ListServiceConfigsRequest]: @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L356}
  ///
  // clang-format on
  StreamRange<google::api::Service> ListServiceConfigs(
      std::string const& service_name, Options opts = {});

  // clang-format off
  ///
  /// Lists the history of the service configuration for a managed service,
  /// from the newest to the oldest.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.api.servicemanagement.v1.ListServiceConfigsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.api.Service], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.api.Service]: @googleapis_reference_link{google/api/service.proto#L80}
  /// [google.api.servicemanagement.v1.ListServiceConfigsRequest]: @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L356}
  ///
  // clang-format on
  StreamRange<google::api::Service> ListServiceConfigs(
      google::api::servicemanagement::v1::ListServiceConfigsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets a service configuration (version) for a managed service.
  ///
  /// @param service_name  Required. The name of the service.  See the
  ///  [overview](https://cloud.google.com/service-management/overview) for naming
  ///  requirements.  For example: `example.googleapis.com`.
  /// @param config_id  Required. The id of the service configuration resource.
  ///  @n
  ///  This field must be specified for the server to return all fields, including
  ///  `SourceInfo`.
  /// @param view  Specifies which parts of the Service Config should be returned in the
  ///  response.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.api.Service])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.api.Service]: @googleapis_reference_link{google/api/service.proto#L80}
  /// [google.api.servicemanagement.v1.GetServiceConfigRequest]: @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L327}
  ///
  // clang-format on
  StatusOr<google::api::Service> GetServiceConfig(
      std::string const& service_name, std::string const& config_id,
      google::api::servicemanagement::v1::GetServiceConfigRequest::ConfigView
          view,
      Options opts = {});

  // clang-format off
  ///
  /// Gets a service configuration (version) for a managed service.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.api.servicemanagement.v1.GetServiceConfigRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.api.Service])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.api.Service]: @googleapis_reference_link{google/api/service.proto#L80}
  /// [google.api.servicemanagement.v1.GetServiceConfigRequest]: @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L327}
  ///
  // clang-format on
  StatusOr<google::api::Service> GetServiceConfig(
      google::api::servicemanagement::v1::GetServiceConfigRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new service configuration (version) for a managed service.
  /// This method only stores the service configuration. To roll out the service
  /// configuration to backend systems please call
  /// [CreateServiceRollout][google.api.servicemanagement.v1.ServiceManager.CreateServiceRollout].
  ///
  /// Only the 100 most recent service configurations and ones referenced by
  /// existing rollouts are kept for each service. The rest will be deleted
  /// eventually.
  ///
  /// @param service_name  Required. The name of the service.  See the
  ///  [overview](https://cloud.google.com/service-management/overview) for naming
  ///  requirements.  For example: `example.googleapis.com`.
  /// @param service_config  Required. The service configuration resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.api.Service])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.api.Service]: @googleapis_reference_link{google/api/service.proto#L80}
  /// [google.api.servicemanagement.v1.CreateServiceConfigRequest]: @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L380}
  /// [google.api.servicemanagement.v1.ServiceManager.CreateServiceRollout]: @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L227}
  ///
  // clang-format on
  StatusOr<google::api::Service> CreateServiceConfig(
      std::string const& service_name,
      google::api::Service const& service_config, Options opts = {});

  // clang-format off
  ///
  /// Creates a new service configuration (version) for a managed service.
  /// This method only stores the service configuration. To roll out the service
  /// configuration to backend systems please call
  /// [CreateServiceRollout][google.api.servicemanagement.v1.ServiceManager.CreateServiceRollout].
  ///
  /// Only the 100 most recent service configurations and ones referenced by
  /// existing rollouts are kept for each service. The rest will be deleted
  /// eventually.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.api.servicemanagement.v1.CreateServiceConfigRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.api.Service])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.api.Service]: @googleapis_reference_link{google/api/service.proto#L80}
  /// [google.api.servicemanagement.v1.CreateServiceConfigRequest]: @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L380}
  /// [google.api.servicemanagement.v1.ServiceManager.CreateServiceRollout]: @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L227}
  ///
  // clang-format on
  StatusOr<google::api::Service> CreateServiceConfig(
      google::api::servicemanagement::v1::CreateServiceConfigRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new service configuration (version) for a managed service based
  /// on
  /// user-supplied configuration source files (for example: OpenAPI
  /// Specification). This method stores the source configurations as well as the
  /// generated service configuration. To rollout the service configuration to
  /// other services,
  /// please call
  /// [CreateServiceRollout][google.api.servicemanagement.v1.ServiceManager.CreateServiceRollout].
  ///
  /// Only the 100 most recent configuration sources and ones referenced by
  /// existing service configurtions are kept for each service. The rest will be
  /// deleted eventually.
  ///
  /// Operation<response: SubmitConfigSourceResponse>
  ///
  /// @param service_name  Required. The name of the service.  See the
  ///  [overview](https://cloud.google.com/service-management/overview) for naming
  ///  requirements.  For example: `example.googleapis.com`.
  /// @param config_source  Required. The source configuration for the service.
  /// @param validate_only  Optional. If set, this will result in the generation of a
  ///  `google.api.Service` configuration based on the `ConfigSource` provided,
  ///  but the generated config and the sources will NOT be persisted.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.api.servicemanagement.v1.SubmitConfigSourceResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.api.servicemanagement.v1.ServiceManager.CreateServiceRollout]: @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L227}
  /// [google.api.servicemanagement.v1.SubmitConfigSourceRequest]: @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L392}
  /// [google.api.servicemanagement.v1.SubmitConfigSourceResponse]: @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L408}
  ///
  // clang-format on
  future<
      StatusOr<google::api::servicemanagement::v1::SubmitConfigSourceResponse>>
  SubmitConfigSource(
      std::string const& service_name,
      google::api::servicemanagement::v1::ConfigSource const& config_source,
      bool validate_only, Options opts = {});

  // clang-format off
  ///
  /// @copybrief SubmitConfigSource
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> SubmitConfigSource(
      NoAwaitTag, std::string const& service_name,
      google::api::servicemanagement::v1::ConfigSource const& config_source,
      bool validate_only, Options opts = {});

  // clang-format off
  ///
  /// Creates a new service configuration (version) for a managed service based
  /// on
  /// user-supplied configuration source files (for example: OpenAPI
  /// Specification). This method stores the source configurations as well as the
  /// generated service configuration. To rollout the service configuration to
  /// other services,
  /// please call
  /// [CreateServiceRollout][google.api.servicemanagement.v1.ServiceManager.CreateServiceRollout].
  ///
  /// Only the 100 most recent configuration sources and ones referenced by
  /// existing service configurtions are kept for each service. The rest will be
  /// deleted eventually.
  ///
  /// Operation<response: SubmitConfigSourceResponse>
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.api.servicemanagement.v1.SubmitConfigSourceRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.api.servicemanagement.v1.SubmitConfigSourceResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.api.servicemanagement.v1.ServiceManager.CreateServiceRollout]: @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L227}
  /// [google.api.servicemanagement.v1.SubmitConfigSourceRequest]: @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L392}
  /// [google.api.servicemanagement.v1.SubmitConfigSourceResponse]: @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L408}
  ///
  // clang-format on
  future<
      StatusOr<google::api::servicemanagement::v1::SubmitConfigSourceResponse>>
  SubmitConfigSource(
      google::api::servicemanagement::v1::SubmitConfigSourceRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief SubmitConfigSource
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> SubmitConfigSource(
      NoAwaitTag,
      google::api::servicemanagement::v1::SubmitConfigSourceRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief SubmitConfigSource
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<
      StatusOr<google::api::servicemanagement::v1::SubmitConfigSourceResponse>>
  SubmitConfigSource(google::longrunning::Operation const& operation,
                     Options opts = {});

  // clang-format off
  ///
  /// Lists the history of the service configuration rollouts for a managed
  /// service, from the newest to the oldest.
  ///
  /// @param service_name  Required. The name of the service.  See the
  ///  [overview](https://cloud.google.com/service-management/overview) for naming
  ///  requirements.  For example: `example.googleapis.com`.
  /// @param filter  Required. Use `filter` to return subset of rollouts.
  ///  The following filters are supported:
  ///  @n
  ///   -- By [status]
  ///   [google.api.servicemanagement.v1.Rollout.RolloutStatus]. For example,
  ///   `filter="status=SUCCESS"`
  ///  @n
  ///   -- By [strategy]
  ///   [google.api.servicemanagement.v1.Rollout.strategy]. For example,
  ///   `filter="strategy=TrafficPercentStrategy"`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.api.servicemanagement.v1.Rollout], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.api.servicemanagement.v1.ListServiceRolloutsRequest]: @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L426}
  /// [google.api.servicemanagement.v1.Rollout]: @googleapis_reference_link{google/api/servicemanagement/v1/resources.proto#L190}
  ///
  // clang-format on
  StreamRange<google::api::servicemanagement::v1::Rollout> ListServiceRollouts(
      std::string const& service_name, std::string const& filter,
      Options opts = {});

  // clang-format off
  ///
  /// Lists the history of the service configuration rollouts for a managed
  /// service, from the newest to the oldest.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.api.servicemanagement.v1.ListServiceRolloutsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.api.servicemanagement.v1.Rollout], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.api.servicemanagement.v1.ListServiceRolloutsRequest]: @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L426}
  /// [google.api.servicemanagement.v1.Rollout]: @googleapis_reference_link{google/api/servicemanagement/v1/resources.proto#L190}
  ///
  // clang-format on
  StreamRange<google::api::servicemanagement::v1::Rollout> ListServiceRollouts(
      google::api::servicemanagement::v1::ListServiceRolloutsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets a service configuration
  /// [rollout][google.api.servicemanagement.v1.Rollout].
  ///
  /// @param service_name  Required. The name of the service.  See the
  ///  [overview](https://cloud.google.com/service-management/overview) for naming
  ///  requirements.  For example: `example.googleapis.com`.
  /// @param rollout_id  Required. The id of the rollout resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.api.servicemanagement.v1.Rollout])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.api.servicemanagement.v1.GetServiceRolloutRequest]: @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L462}
  /// [google.api.servicemanagement.v1.Rollout]: @googleapis_reference_link{google/api/servicemanagement/v1/resources.proto#L190}
  ///
  // clang-format on
  StatusOr<google::api::servicemanagement::v1::Rollout> GetServiceRollout(
      std::string const& service_name, std::string const& rollout_id,
      Options opts = {});

  // clang-format off
  ///
  /// Gets a service configuration
  /// [rollout][google.api.servicemanagement.v1.Rollout].
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.api.servicemanagement.v1.GetServiceRolloutRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.api.servicemanagement.v1.Rollout])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.api.servicemanagement.v1.GetServiceRolloutRequest]: @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L462}
  /// [google.api.servicemanagement.v1.Rollout]: @googleapis_reference_link{google/api/servicemanagement/v1/resources.proto#L190}
  ///
  // clang-format on
  StatusOr<google::api::servicemanagement::v1::Rollout> GetServiceRollout(
      google::api::servicemanagement::v1::GetServiceRolloutRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new service configuration rollout. Based on rollout, the
  /// Google Service Management will roll out the service configurations to
  /// different backend services. For example, the logging configuration will be
  /// pushed to Google Cloud Logging.
  ///
  /// Please note that any previous pending and running Rollouts and associated
  /// Operations will be automatically cancelled so that the latest Rollout will
  /// not be blocked by previous Rollouts.
  ///
  /// Only the 100 most recent (in any state) and the last 10 successful (if not
  /// already part of the set of 100 most recent) rollouts are kept for each
  /// service. The rest will be deleted eventually.
  ///
  /// Operation<response: Rollout>
  ///
  /// @param service_name  Required. The name of the service.  See the
  ///  [overview](https://cloud.google.com/service-management/overview) for naming
  ///  requirements.  For example: `example.googleapis.com`.
  /// @param rollout  Required. The rollout resource. The `service_name` field is output only.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.api.servicemanagement.v1.Rollout] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.api.servicemanagement.v1.CreateServiceRolloutRequest]: @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L415}
  /// [google.api.servicemanagement.v1.Rollout]: @googleapis_reference_link{google/api/servicemanagement/v1/resources.proto#L190}
  ///
  // clang-format on
  future<StatusOr<google::api::servicemanagement::v1::Rollout>>
  CreateServiceRollout(
      std::string const& service_name,
      google::api::servicemanagement::v1::Rollout const& rollout,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateServiceRollout
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateServiceRollout(
      NoAwaitTag, std::string const& service_name,
      google::api::servicemanagement::v1::Rollout const& rollout,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new service configuration rollout. Based on rollout, the
  /// Google Service Management will roll out the service configurations to
  /// different backend services. For example, the logging configuration will be
  /// pushed to Google Cloud Logging.
  ///
  /// Please note that any previous pending and running Rollouts and associated
  /// Operations will be automatically cancelled so that the latest Rollout will
  /// not be blocked by previous Rollouts.
  ///
  /// Only the 100 most recent (in any state) and the last 10 successful (if not
  /// already part of the set of 100 most recent) rollouts are kept for each
  /// service. The rest will be deleted eventually.
  ///
  /// Operation<response: Rollout>
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.api.servicemanagement.v1.CreateServiceRolloutRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.api.servicemanagement.v1.Rollout] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.api.servicemanagement.v1.CreateServiceRolloutRequest]: @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L415}
  /// [google.api.servicemanagement.v1.Rollout]: @googleapis_reference_link{google/api/servicemanagement/v1/resources.proto#L190}
  ///
  // clang-format on
  future<StatusOr<google::api::servicemanagement::v1::Rollout>>
  CreateServiceRollout(
      google::api::servicemanagement::v1::CreateServiceRolloutRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateServiceRollout
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateServiceRollout(
      NoAwaitTag,
      google::api::servicemanagement::v1::CreateServiceRolloutRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateServiceRollout
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::api::servicemanagement::v1::Rollout>>
  CreateServiceRollout(google::longrunning::Operation const& operation,
                       Options opts = {});

  // clang-format off
  ///
  /// Generates and returns a report (errors, warnings and changes from
  /// existing configurations) associated with
  /// GenerateConfigReportRequest.new_value
  ///
  /// If GenerateConfigReportRequest.old_value is specified,
  /// GenerateConfigReportRequest will contain a single ChangeReport based on the
  /// comparison between GenerateConfigReportRequest.new_value and
  /// GenerateConfigReportRequest.old_value.
  /// If GenerateConfigReportRequest.old_value is not specified, this method
  /// will compare GenerateConfigReportRequest.new_value with the last pushed
  /// service configuration.
  ///
  /// @param new_config  Required. Service configuration for which we want to generate the report.
  ///  For this version of API, the supported types are
  ///  [google.api.servicemanagement.v1.ConfigRef][google.api.servicemanagement.v1.ConfigRef],
  ///  [google.api.servicemanagement.v1.ConfigSource][google.api.servicemanagement.v1.ConfigSource],
  ///  and [google.api.Service][google.api.Service]
  /// @param old_config  Optional. Service configuration against which the comparison will be done.
  ///  For this version of API, the supported types are
  ///  [google.api.servicemanagement.v1.ConfigRef][google.api.servicemanagement.v1.ConfigRef],
  ///  [google.api.servicemanagement.v1.ConfigSource][google.api.servicemanagement.v1.ConfigSource],
  ///  and [google.api.Service][google.api.Service]
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.api.servicemanagement.v1.GenerateConfigReportResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.api.Service]: @googleapis_reference_link{google/api/service.proto#L80}
  /// [google.api.servicemanagement.v1.ConfigRef]: @googleapis_reference_link{google/api/servicemanagement/v1/resources.proto#L168}
  /// [google.api.servicemanagement.v1.ConfigSource]: @googleapis_reference_link{google/api/servicemanagement/v1/resources.proto#L114}
  /// [google.api.servicemanagement.v1.GenerateConfigReportRequest]: @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L476}
  /// [google.api.servicemanagement.v1.GenerateConfigReportResponse]: @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L493}
  ///
  // clang-format on
  StatusOr<google::api::servicemanagement::v1::GenerateConfigReportResponse>
  GenerateConfigReport(google::protobuf::Any const& new_config,
                       google::protobuf::Any const& old_config,
                       Options opts = {});

  // clang-format off
  ///
  /// Generates and returns a report (errors, warnings and changes from
  /// existing configurations) associated with
  /// GenerateConfigReportRequest.new_value
  ///
  /// If GenerateConfigReportRequest.old_value is specified,
  /// GenerateConfigReportRequest will contain a single ChangeReport based on the
  /// comparison between GenerateConfigReportRequest.new_value and
  /// GenerateConfigReportRequest.old_value.
  /// If GenerateConfigReportRequest.old_value is not specified, this method
  /// will compare GenerateConfigReportRequest.new_value with the last pushed
  /// service configuration.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.api.servicemanagement.v1.GenerateConfigReportRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.api.servicemanagement.v1.GenerateConfigReportResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.api.servicemanagement.v1.GenerateConfigReportRequest]: @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L476}
  /// [google.api.servicemanagement.v1.GenerateConfigReportResponse]: @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L493}
  ///
  // clang-format on
  StatusOr<google::api::servicemanagement::v1::GenerateConfigReportResponse>
  GenerateConfigReport(
      google::api::servicemanagement::v1::GenerateConfigReportRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Sets the access control policy on the specified resource. Replaces any
  /// existing policy.
  ///
  /// Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.iam.v1.SetIamPolicyRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.iam.v1.Policy])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.iam.v1.Policy]: @googleapis_reference_link{google/iam/v1/policy.proto#L102}
  /// [google.iam.v1.SetIamPolicyRequest]: @googleapis_reference_link{google/iam/v1/iam_policy.proto#L100}
  ///
  // clang-format on
  StatusOr<google::iam::v1::Policy> SetIamPolicy(
      google::iam::v1::SetIamPolicyRequest const& request, Options opts = {});

  // clang-format off
  ///
  /// Gets the access control policy for a resource.
  /// Returns an empty policy if the resource exists and does not have a policy
  /// set.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.iam.v1.GetIamPolicyRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.iam.v1.Policy])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.iam.v1.GetIamPolicyRequest]: @googleapis_reference_link{google/iam/v1/iam_policy.proto#L123}
  /// [google.iam.v1.Policy]: @googleapis_reference_link{google/iam/v1/policy.proto#L102}
  ///
  // clang-format on
  StatusOr<google::iam::v1::Policy> GetIamPolicy(
      google::iam::v1::GetIamPolicyRequest const& request, Options opts = {});

  // clang-format off
  ///
  /// Returns permissions that a caller has on the specified resource.
  /// If the resource does not exist, this will return an empty set of
  /// permissions, not a `NOT_FOUND` error.
  ///
  /// Note: This operation is designed to be used for building permission-aware
  /// UIs and command-line tools, not for authorization checking. This operation
  /// may "fail open" without warning.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.iam.v1.TestIamPermissionsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.iam.v1.TestIamPermissionsResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.iam.v1.TestIamPermissionsRequest]: @googleapis_reference_link{google/iam/v1/iam_policy.proto#L137}
  /// [google.iam.v1.TestIamPermissionsResponse]: @googleapis_reference_link{google/iam/v1/iam_policy.proto#L153}
  ///
  // clang-format on
  StatusOr<google::iam::v1::TestIamPermissionsResponse> TestIamPermissions(
      google::iam::v1::TestIamPermissionsRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists operations that match the specified filter in the request. If the
  /// server doesn't support this method, it returns `UNIMPLEMENTED`.
  ///
  /// NOTE: the `name` binding allows API services to override the binding
  /// to use different resource name schemes, such as `users/*/operations`. To
  /// override the binding, API services can add a binding such as
  /// `"/v1/{name=users/*}/operations"` to their service configuration.
  /// For backwards compatibility, the default name includes the operations
  /// collection id, however overriding users must ensure the name binding
  /// is the parent resource, without the operations collection id.
  ///
  /// @param name  The name of the operation's parent resource.
  /// @param filter  The standard list filter.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.longrunning.Operation], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.longrunning.ListOperationsRequest]: @googleapis_reference_link{google/longrunning/operations.proto#L171}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  StreamRange<google::longrunning::Operation> ListOperations(
      std::string const& name, std::string const& filter, Options opts = {});

  // clang-format off
  ///
  /// Lists operations that match the specified filter in the request. If the
  /// server doesn't support this method, it returns `UNIMPLEMENTED`.
  ///
  /// NOTE: the `name` binding allows API services to override the binding
  /// to use different resource name schemes, such as `users/*/operations`. To
  /// override the binding, API services can add a binding such as
  /// `"/v1/{name=users/*}/operations"` to their service configuration.
  /// For backwards compatibility, the default name includes the operations
  /// collection id, however overriding users must ensure the name binding
  /// is the parent resource, without the operations collection id.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.longrunning.ListOperationsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.longrunning.Operation], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.longrunning.ListOperationsRequest]: @googleapis_reference_link{google/longrunning/operations.proto#L171}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  StreamRange<google::longrunning::Operation> ListOperations(
      google::longrunning::ListOperationsRequest request, Options opts = {});

 private:
  std::shared_ptr<ServiceManagerConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace servicemanagement_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SERVICEMANAGEMENT_V1_SERVICE_MANAGER_CLIENT_H
