// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/api/servicemanagement/v1/servicemanager.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SERVICEMANAGEMENT_V1_INTERNAL_SERVICE_MANAGER_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SERVICEMANAGEMENT_V1_INTERNAL_SERVICE_MANAGER_TRACING_CONNECTION_H

#include "google/cloud/servicemanagement/v1/service_manager_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace servicemanagement_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class ServiceManagerTracingConnection
    : public servicemanagement_v1::ServiceManagerConnection {
 public:
  ~ServiceManagerTracingConnection() override = default;

  explicit ServiceManagerTracingConnection(
      std::shared_ptr<servicemanagement_v1::ServiceManagerConnection> child);

  Options options() override { return child_->options(); }

  StreamRange<google::api::servicemanagement::v1::ManagedService> ListServices(
      google::api::servicemanagement::v1::ListServicesRequest request) override;

  StatusOr<google::api::servicemanagement::v1::ManagedService> GetService(
      google::api::servicemanagement::v1::GetServiceRequest const& request)
      override;

  future<StatusOr<google::api::servicemanagement::v1::ManagedService>>
  CreateService(google::api::servicemanagement::v1::CreateServiceRequest const&
                    request) override;

  StatusOr<google::longrunning::Operation> CreateService(
      NoAwaitTag,
      google::api::servicemanagement::v1::CreateServiceRequest const& request)
      override;

  future<StatusOr<google::api::servicemanagement::v1::ManagedService>>
  CreateService(google::longrunning::Operation const& operation) override;

  future<StatusOr<google::api::servicemanagement::v1::OperationMetadata>>
  DeleteService(google::api::servicemanagement::v1::DeleteServiceRequest const&
                    request) override;

  StatusOr<google::longrunning::Operation> DeleteService(
      NoAwaitTag,
      google::api::servicemanagement::v1::DeleteServiceRequest const& request)
      override;

  future<StatusOr<google::api::servicemanagement::v1::OperationMetadata>>
  DeleteService(google::longrunning::Operation const& operation) override;

  future<StatusOr<google::api::servicemanagement::v1::UndeleteServiceResponse>>
  UndeleteService(
      google::api::servicemanagement::v1::UndeleteServiceRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> UndeleteService(
      NoAwaitTag,
      google::api::servicemanagement::v1::UndeleteServiceRequest const& request)
      override;

  future<StatusOr<google::api::servicemanagement::v1::UndeleteServiceResponse>>
  UndeleteService(google::longrunning::Operation const& operation) override;

  StreamRange<google::api::Service> ListServiceConfigs(
      google::api::servicemanagement::v1::ListServiceConfigsRequest request)
      override;

  StatusOr<google::api::Service> GetServiceConfig(
      google::api::servicemanagement::v1::GetServiceConfigRequest const&
          request) override;

  StatusOr<google::api::Service> CreateServiceConfig(
      google::api::servicemanagement::v1::CreateServiceConfigRequest const&
          request) override;

  future<
      StatusOr<google::api::servicemanagement::v1::SubmitConfigSourceResponse>>
  SubmitConfigSource(
      google::api::servicemanagement::v1::SubmitConfigSourceRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> SubmitConfigSource(
      NoAwaitTag,
      google::api::servicemanagement::v1::SubmitConfigSourceRequest const&
          request) override;

  future<
      StatusOr<google::api::servicemanagement::v1::SubmitConfigSourceResponse>>
  SubmitConfigSource(google::longrunning::Operation const& operation) override;

  StreamRange<google::api::servicemanagement::v1::Rollout> ListServiceRollouts(
      google::api::servicemanagement::v1::ListServiceRolloutsRequest request)
      override;

  StatusOr<google::api::servicemanagement::v1::Rollout> GetServiceRollout(
      google::api::servicemanagement::v1::GetServiceRolloutRequest const&
          request) override;

  future<StatusOr<google::api::servicemanagement::v1::Rollout>>
  CreateServiceRollout(
      google::api::servicemanagement::v1::CreateServiceRolloutRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> CreateServiceRollout(
      NoAwaitTag,
      google::api::servicemanagement::v1::CreateServiceRolloutRequest const&
          request) override;

  future<StatusOr<google::api::servicemanagement::v1::Rollout>>
  CreateServiceRollout(
      google::longrunning::Operation const& operation) override;

  StatusOr<google::api::servicemanagement::v1::GenerateConfigReportResponse>
  GenerateConfigReport(
      google::api::servicemanagement::v1::GenerateConfigReportRequest const&
          request) override;

  StatusOr<google::iam::v1::Policy> SetIamPolicy(
      google::iam::v1::SetIamPolicyRequest const& request) override;

  StatusOr<google::iam::v1::Policy> GetIamPolicy(
      google::iam::v1::GetIamPolicyRequest const& request) override;

  StatusOr<google::iam::v1::TestIamPermissionsResponse> TestIamPermissions(
      google::iam::v1::TestIamPermissionsRequest const& request) override;

  StreamRange<google::longrunning::Operation> ListOperations(
      google::longrunning::ListOperationsRequest request) override;

 private:
  std::shared_ptr<servicemanagement_v1::ServiceManagerConnection> child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<servicemanagement_v1::ServiceManagerConnection>
MakeServiceManagerTracingConnection(
    std::shared_ptr<servicemanagement_v1::ServiceManagerConnection> conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace servicemanagement_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SERVICEMANAGEMENT_V1_INTERNAL_SERVICE_MANAGER_TRACING_CONNECTION_H
