// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/servicehealth/v1/event_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SERVICEHEALTH_V1_MOCKS_MOCK_SERVICE_HEALTH_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SERVICEHEALTH_V1_MOCKS_MOCK_SERVICE_HEALTH_CONNECTION_H

#include "google/cloud/servicehealth/v1/service_health_connection.h"
#include <gmock/gmock.h>

namespace google {
namespace cloud {
namespace servicehealth_v1_mocks {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/**
 * A class to mock `ServiceHealthConnection`.
 *
 * Application developers may want to test their code with simulated responses,
 * including errors, from an object of type `ServiceHealthClient`. To do so,
 * construct an object of type `ServiceHealthClient` with an instance of this
 * class. Then use the Google Test framework functions to program the behavior
 * of this mock.
 *
 * @see [This example][bq-mock] for how to test your application with GoogleTest.
 * While the example showcases types from the BigQuery library, the underlying
 * principles apply for any pair of `*Client` and `*Connection`.
 *
 * [bq-mock]: @cloud_cpp_docs_link{bigquery,bigquery-read-mock}
 */
class MockServiceHealthConnection
    : public servicehealth_v1::ServiceHealthConnection {
 public:
  MOCK_METHOD(Options, options, (), (override));

  MOCK_METHOD((StreamRange<google::cloud::servicehealth::v1::Event>),
              ListEvents,
              (google::cloud::servicehealth::v1::ListEventsRequest request),
              (override));

  MOCK_METHOD(
      StatusOr<google::cloud::servicehealth::v1::Event>, GetEvent,
      (google::cloud::servicehealth::v1::GetEventRequest const& request),
      (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::servicehealth::v1::OrganizationEvent>),
      ListOrganizationEvents,
      (google::cloud::servicehealth::v1::ListOrganizationEventsRequest request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::servicehealth::v1::OrganizationEvent>,
      GetOrganizationEvent,
      (google::cloud::servicehealth::v1::GetOrganizationEventRequest const&
           request),
      (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::servicehealth::v1::OrganizationImpact>),
      ListOrganizationImpacts,
      (google::cloud::servicehealth::v1::ListOrganizationImpactsRequest
           request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::servicehealth::v1::OrganizationImpact>,
      GetOrganizationImpact,
      (google::cloud::servicehealth::v1::GetOrganizationImpactRequest const&
           request),
      (override));

  MOCK_METHOD((StreamRange<google::cloud::location::Location>), ListLocations,
              (google::cloud::location::ListLocationsRequest request),
              (override));

  MOCK_METHOD(StatusOr<google::cloud::location::Location>, GetLocation,
              (google::cloud::location::GetLocationRequest const& request),
              (override));
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace servicehealth_v1_mocks
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SERVICEHEALTH_V1_MOCKS_MOCK_SERVICE_HEALTH_CONNECTION_H
