// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/servicehealth/v1/event_service.proto

#include "google/cloud/servicehealth/v1/internal/service_health_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace servicehealth_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

ServiceHealthTracingConnection::ServiceHealthTracingConnection(
    std::shared_ptr<servicehealth_v1::ServiceHealthConnection> child)
    : child_(std::move(child)) {}

StreamRange<google::cloud::servicehealth::v1::Event>
ServiceHealthTracingConnection::ListEvents(
    google::cloud::servicehealth::v1::ListEventsRequest request) {
  auto span = internal::MakeSpan(
      "servicehealth_v1::ServiceHealthConnection::ListEvents");
  internal::OTelScope scope(span);
  auto sr = child_->ListEvents(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::servicehealth::v1::Event>(std::move(span), std::move(sr));
}

StatusOr<google::cloud::servicehealth::v1::Event>
ServiceHealthTracingConnection::GetEvent(
    google::cloud::servicehealth::v1::GetEventRequest const& request) {
  auto span =
      internal::MakeSpan("servicehealth_v1::ServiceHealthConnection::GetEvent");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetEvent(request));
}

StreamRange<google::cloud::servicehealth::v1::OrganizationEvent>
ServiceHealthTracingConnection::ListOrganizationEvents(
    google::cloud::servicehealth::v1::ListOrganizationEventsRequest request) {
  auto span = internal::MakeSpan(
      "servicehealth_v1::ServiceHealthConnection::ListOrganizationEvents");
  internal::OTelScope scope(span);
  auto sr = child_->ListOrganizationEvents(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::servicehealth::v1::OrganizationEvent>(std::move(span),
                                                           std::move(sr));
}

StatusOr<google::cloud::servicehealth::v1::OrganizationEvent>
ServiceHealthTracingConnection::GetOrganizationEvent(
    google::cloud::servicehealth::v1::GetOrganizationEventRequest const&
        request) {
  auto span = internal::MakeSpan(
      "servicehealth_v1::ServiceHealthConnection::GetOrganizationEvent");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetOrganizationEvent(request));
}

StreamRange<google::cloud::servicehealth::v1::OrganizationImpact>
ServiceHealthTracingConnection::ListOrganizationImpacts(
    google::cloud::servicehealth::v1::ListOrganizationImpactsRequest request) {
  auto span = internal::MakeSpan(
      "servicehealth_v1::ServiceHealthConnection::ListOrganizationImpacts");
  internal::OTelScope scope(span);
  auto sr = child_->ListOrganizationImpacts(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::servicehealth::v1::OrganizationImpact>(std::move(span),
                                                            std::move(sr));
}

StatusOr<google::cloud::servicehealth::v1::OrganizationImpact>
ServiceHealthTracingConnection::GetOrganizationImpact(
    google::cloud::servicehealth::v1::GetOrganizationImpactRequest const&
        request) {
  auto span = internal::MakeSpan(
      "servicehealth_v1::ServiceHealthConnection::GetOrganizationImpact");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetOrganizationImpact(request));
}

StreamRange<google::cloud::location::Location>
ServiceHealthTracingConnection::ListLocations(
    google::cloud::location::ListLocationsRequest request) {
  auto span = internal::MakeSpan(
      "servicehealth_v1::ServiceHealthConnection::ListLocations");
  internal::OTelScope scope(span);
  auto sr = child_->ListLocations(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::location::Location>(
      std::move(span), std::move(sr));
}

StatusOr<google::cloud::location::Location>
ServiceHealthTracingConnection::GetLocation(
    google::cloud::location::GetLocationRequest const& request) {
  auto span = internal::MakeSpan(
      "servicehealth_v1::ServiceHealthConnection::GetLocation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetLocation(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<servicehealth_v1::ServiceHealthConnection>
MakeServiceHealthTracingConnection(
    std::shared_ptr<servicehealth_v1::ServiceHealthConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<ServiceHealthTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace servicehealth_v1_internal
}  // namespace cloud
}  // namespace google
