// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/servicedirectory/v1/registration_service.proto

#include "google/cloud/servicedirectory/v1/registration_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace servicedirectory_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

RegistrationServiceConnectionIdempotencyPolicy::
    ~RegistrationServiceConnectionIdempotencyPolicy() = default;

std::unique_ptr<RegistrationServiceConnectionIdempotencyPolicy>
RegistrationServiceConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<RegistrationServiceConnectionIdempotencyPolicy>(
      *this);
}

Idempotency RegistrationServiceConnectionIdempotencyPolicy::CreateNamespace(
    google::cloud::servicedirectory::v1::CreateNamespaceRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency RegistrationServiceConnectionIdempotencyPolicy::ListNamespaces(
    google::cloud::servicedirectory::v1::ListNamespacesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency RegistrationServiceConnectionIdempotencyPolicy::GetNamespace(
    google::cloud::servicedirectory::v1::GetNamespaceRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency RegistrationServiceConnectionIdempotencyPolicy::UpdateNamespace(
    google::cloud::servicedirectory::v1::UpdateNamespaceRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency RegistrationServiceConnectionIdempotencyPolicy::DeleteNamespace(
    google::cloud::servicedirectory::v1::DeleteNamespaceRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency RegistrationServiceConnectionIdempotencyPolicy::CreateService(
    google::cloud::servicedirectory::v1::CreateServiceRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency RegistrationServiceConnectionIdempotencyPolicy::ListServices(
    google::cloud::servicedirectory::v1::ListServicesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency RegistrationServiceConnectionIdempotencyPolicy::GetService(
    google::cloud::servicedirectory::v1::GetServiceRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency RegistrationServiceConnectionIdempotencyPolicy::UpdateService(
    google::cloud::servicedirectory::v1::UpdateServiceRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency RegistrationServiceConnectionIdempotencyPolicy::DeleteService(
    google::cloud::servicedirectory::v1::DeleteServiceRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency RegistrationServiceConnectionIdempotencyPolicy::CreateEndpoint(
    google::cloud::servicedirectory::v1::CreateEndpointRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency RegistrationServiceConnectionIdempotencyPolicy::ListEndpoints(
    google::cloud::servicedirectory::v1::ListEndpointsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency RegistrationServiceConnectionIdempotencyPolicy::GetEndpoint(
    google::cloud::servicedirectory::v1::GetEndpointRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency RegistrationServiceConnectionIdempotencyPolicy::UpdateEndpoint(
    google::cloud::servicedirectory::v1::UpdateEndpointRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency RegistrationServiceConnectionIdempotencyPolicy::DeleteEndpoint(
    google::cloud::servicedirectory::v1::DeleteEndpointRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency RegistrationServiceConnectionIdempotencyPolicy::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency RegistrationServiceConnectionIdempotencyPolicy::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request) {
  return request.policy().etag().empty() ? Idempotency::kNonIdempotent
                                         : Idempotency::kIdempotent;
}

Idempotency RegistrationServiceConnectionIdempotencyPolicy::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency RegistrationServiceConnectionIdempotencyPolicy::ListLocations(
    google::cloud::location::ListLocationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency RegistrationServiceConnectionIdempotencyPolicy::GetLocation(
    google::cloud::location::GetLocationRequest const&) {
  return Idempotency::kIdempotent;
}

std::unique_ptr<RegistrationServiceConnectionIdempotencyPolicy>
MakeDefaultRegistrationServiceConnectionIdempotencyPolicy() {
  return std::make_unique<RegistrationServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace servicedirectory_v1
}  // namespace cloud
}  // namespace google
