// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source:
// google/cloud/securitycentermanagement/v1/security_center_management.proto

#include "google/cloud/securitycentermanagement/v1/security_center_management_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace securitycentermanagement_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

SecurityCenterManagementConnectionIdempotencyPolicy::
    ~SecurityCenterManagementConnectionIdempotencyPolicy() = default;

std::unique_ptr<SecurityCenterManagementConnectionIdempotencyPolicy>
SecurityCenterManagementConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<SecurityCenterManagementConnectionIdempotencyPolicy>(
      *this);
}

Idempotency SecurityCenterManagementConnectionIdempotencyPolicy::
    ListEffectiveSecurityHealthAnalyticsCustomModules(
        google::cloud::securitycentermanagement::v1::
            ListEffectiveSecurityHealthAnalyticsCustomModulesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency SecurityCenterManagementConnectionIdempotencyPolicy::
    GetEffectiveSecurityHealthAnalyticsCustomModule(
        google::cloud::securitycentermanagement::v1::
            GetEffectiveSecurityHealthAnalyticsCustomModuleRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency SecurityCenterManagementConnectionIdempotencyPolicy::
    ListSecurityHealthAnalyticsCustomModules(
        google::cloud::securitycentermanagement::v1::
            ListSecurityHealthAnalyticsCustomModulesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency SecurityCenterManagementConnectionIdempotencyPolicy::
    ListDescendantSecurityHealthAnalyticsCustomModules(
        google::cloud::securitycentermanagement::v1::
            ListDescendantSecurityHealthAnalyticsCustomModulesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency SecurityCenterManagementConnectionIdempotencyPolicy::
    GetSecurityHealthAnalyticsCustomModule(
        google::cloud::securitycentermanagement::v1::
            GetSecurityHealthAnalyticsCustomModuleRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency SecurityCenterManagementConnectionIdempotencyPolicy::
    CreateSecurityHealthAnalyticsCustomModule(
        google::cloud::securitycentermanagement::v1::
            CreateSecurityHealthAnalyticsCustomModuleRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SecurityCenterManagementConnectionIdempotencyPolicy::
    UpdateSecurityHealthAnalyticsCustomModule(
        google::cloud::securitycentermanagement::v1::
            UpdateSecurityHealthAnalyticsCustomModuleRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SecurityCenterManagementConnectionIdempotencyPolicy::
    DeleteSecurityHealthAnalyticsCustomModule(
        google::cloud::securitycentermanagement::v1::
            DeleteSecurityHealthAnalyticsCustomModuleRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SecurityCenterManagementConnectionIdempotencyPolicy::
    SimulateSecurityHealthAnalyticsCustomModule(
        google::cloud::securitycentermanagement::v1::
            SimulateSecurityHealthAnalyticsCustomModuleRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SecurityCenterManagementConnectionIdempotencyPolicy::
    ListEffectiveEventThreatDetectionCustomModules(
        google::cloud::securitycentermanagement::v1::
            ListEffectiveEventThreatDetectionCustomModulesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency SecurityCenterManagementConnectionIdempotencyPolicy::
    GetEffectiveEventThreatDetectionCustomModule(
        google::cloud::securitycentermanagement::v1::
            GetEffectiveEventThreatDetectionCustomModuleRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency SecurityCenterManagementConnectionIdempotencyPolicy::
    ListEventThreatDetectionCustomModules(
        google::cloud::securitycentermanagement::v1::
            ListEventThreatDetectionCustomModulesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency SecurityCenterManagementConnectionIdempotencyPolicy::
    ListDescendantEventThreatDetectionCustomModules(
        google::cloud::securitycentermanagement::v1::
            ListDescendantEventThreatDetectionCustomModulesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency SecurityCenterManagementConnectionIdempotencyPolicy::
    GetEventThreatDetectionCustomModule(
        google::cloud::securitycentermanagement::v1::
            GetEventThreatDetectionCustomModuleRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency SecurityCenterManagementConnectionIdempotencyPolicy::
    CreateEventThreatDetectionCustomModule(
        google::cloud::securitycentermanagement::v1::
            CreateEventThreatDetectionCustomModuleRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SecurityCenterManagementConnectionIdempotencyPolicy::
    UpdateEventThreatDetectionCustomModule(
        google::cloud::securitycentermanagement::v1::
            UpdateEventThreatDetectionCustomModuleRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SecurityCenterManagementConnectionIdempotencyPolicy::
    DeleteEventThreatDetectionCustomModule(
        google::cloud::securitycentermanagement::v1::
            DeleteEventThreatDetectionCustomModuleRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SecurityCenterManagementConnectionIdempotencyPolicy::
    ValidateEventThreatDetectionCustomModule(
        google::cloud::securitycentermanagement::v1::
            ValidateEventThreatDetectionCustomModuleRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
SecurityCenterManagementConnectionIdempotencyPolicy::GetSecurityCenterService(
    google::cloud::securitycentermanagement::v1::
        GetSecurityCenterServiceRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency
SecurityCenterManagementConnectionIdempotencyPolicy::ListSecurityCenterServices(
    google::cloud::securitycentermanagement::v1::
        ListSecurityCenterServicesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency SecurityCenterManagementConnectionIdempotencyPolicy::
    UpdateSecurityCenterService(google::cloud::securitycentermanagement::v1::
                                    UpdateSecurityCenterServiceRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SecurityCenterManagementConnectionIdempotencyPolicy::ListLocations(
    google::cloud::location::ListLocationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency SecurityCenterManagementConnectionIdempotencyPolicy::GetLocation(
    google::cloud::location::GetLocationRequest const&) {
  return Idempotency::kIdempotent;
}

std::unique_ptr<SecurityCenterManagementConnectionIdempotencyPolicy>
MakeDefaultSecurityCenterManagementConnectionIdempotencyPolicy() {
  return std::make_unique<
      SecurityCenterManagementConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace securitycentermanagement_v1
}  // namespace cloud
}  // namespace google
