// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source:
// google/cloud/securitycentermanagement/v1/security_center_management.proto

#include "google/cloud/securitycentermanagement/v1/security_center_management_connection.h"
#include "google/cloud/securitycentermanagement/v1/internal/security_center_management_connection_impl.h"
#include "google/cloud/securitycentermanagement/v1/internal/security_center_management_option_defaults.h"
#include "google/cloud/securitycentermanagement/v1/internal/security_center_management_stub_factory.h"
#include "google/cloud/securitycentermanagement/v1/internal/security_center_management_tracing_connection.h"
#include "google/cloud/securitycentermanagement/v1/security_center_management_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace securitycentermanagement_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

SecurityCenterManagementConnection::~SecurityCenterManagementConnection() =
    default;

StreamRange<google::cloud::securitycentermanagement::v1::
                EffectiveSecurityHealthAnalyticsCustomModule>
SecurityCenterManagementConnection::
    ListEffectiveSecurityHealthAnalyticsCustomModules(
        google::cloud::securitycentermanagement::v1::
            ListEffectiveSecurityHealthAnalyticsCustomModulesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::securitycentermanagement::v1::
                      EffectiveSecurityHealthAnalyticsCustomModule>>();
}

StatusOr<google::cloud::securitycentermanagement::v1::
             EffectiveSecurityHealthAnalyticsCustomModule>
SecurityCenterManagementConnection::
    GetEffectiveSecurityHealthAnalyticsCustomModule(
        google::cloud::securitycentermanagement::v1::
            GetEffectiveSecurityHealthAnalyticsCustomModuleRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::securitycentermanagement::v1::
                SecurityHealthAnalyticsCustomModule>
SecurityCenterManagementConnection::ListSecurityHealthAnalyticsCustomModules(
    google::cloud::securitycentermanagement::v1::
        ListSecurityHealthAnalyticsCustomModulesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::securitycentermanagement::v1::
                      SecurityHealthAnalyticsCustomModule>>();
}

StreamRange<google::cloud::securitycentermanagement::v1::
                SecurityHealthAnalyticsCustomModule>
SecurityCenterManagementConnection::
    ListDescendantSecurityHealthAnalyticsCustomModules(
        google::cloud::securitycentermanagement::v1::
            ListDescendantSecurityHealthAnalyticsCustomModulesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::securitycentermanagement::v1::
                      SecurityHealthAnalyticsCustomModule>>();
}

StatusOr<google::cloud::securitycentermanagement::v1::
             SecurityHealthAnalyticsCustomModule>
SecurityCenterManagementConnection::GetSecurityHealthAnalyticsCustomModule(
    google::cloud::securitycentermanagement::v1::
        GetSecurityHealthAnalyticsCustomModuleRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::securitycentermanagement::v1::
             SecurityHealthAnalyticsCustomModule>
SecurityCenterManagementConnection::CreateSecurityHealthAnalyticsCustomModule(
    google::cloud::securitycentermanagement::v1::
        CreateSecurityHealthAnalyticsCustomModuleRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::securitycentermanagement::v1::
             SecurityHealthAnalyticsCustomModule>
SecurityCenterManagementConnection::UpdateSecurityHealthAnalyticsCustomModule(
    google::cloud::securitycentermanagement::v1::
        UpdateSecurityHealthAnalyticsCustomModuleRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status
SecurityCenterManagementConnection::DeleteSecurityHealthAnalyticsCustomModule(
    google::cloud::securitycentermanagement::v1::
        DeleteSecurityHealthAnalyticsCustomModuleRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::securitycentermanagement::v1::
             SimulateSecurityHealthAnalyticsCustomModuleResponse>
SecurityCenterManagementConnection::SimulateSecurityHealthAnalyticsCustomModule(
    google::cloud::securitycentermanagement::v1::
        SimulateSecurityHealthAnalyticsCustomModuleRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::securitycentermanagement::v1::
                EffectiveEventThreatDetectionCustomModule>
SecurityCenterManagementConnection::
    ListEffectiveEventThreatDetectionCustomModules(
        google::cloud::securitycentermanagement::v1::
            ListEffectiveEventThreatDetectionCustomModulesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::securitycentermanagement::v1::
                      EffectiveEventThreatDetectionCustomModule>>();
}

StatusOr<google::cloud::securitycentermanagement::v1::
             EffectiveEventThreatDetectionCustomModule>
SecurityCenterManagementConnection::
    GetEffectiveEventThreatDetectionCustomModule(
        google::cloud::securitycentermanagement::v1::
            GetEffectiveEventThreatDetectionCustomModuleRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::securitycentermanagement::v1::
                EventThreatDetectionCustomModule>
SecurityCenterManagementConnection::ListEventThreatDetectionCustomModules(
    google::cloud::securitycentermanagement::v1::
        ListEventThreatDetectionCustomModulesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::securitycentermanagement::v1::
                      EventThreatDetectionCustomModule>>();
}

StreamRange<google::cloud::securitycentermanagement::v1::
                EventThreatDetectionCustomModule>
SecurityCenterManagementConnection::
    ListDescendantEventThreatDetectionCustomModules(
        google::cloud::securitycentermanagement::v1::
            ListDescendantEventThreatDetectionCustomModulesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::securitycentermanagement::v1::
                      EventThreatDetectionCustomModule>>();
}

StatusOr<google::cloud::securitycentermanagement::v1::
             EventThreatDetectionCustomModule>
SecurityCenterManagementConnection::GetEventThreatDetectionCustomModule(
    google::cloud::securitycentermanagement::v1::
        GetEventThreatDetectionCustomModuleRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::securitycentermanagement::v1::
             EventThreatDetectionCustomModule>
SecurityCenterManagementConnection::CreateEventThreatDetectionCustomModule(
    google::cloud::securitycentermanagement::v1::
        CreateEventThreatDetectionCustomModuleRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::securitycentermanagement::v1::
             EventThreatDetectionCustomModule>
SecurityCenterManagementConnection::UpdateEventThreatDetectionCustomModule(
    google::cloud::securitycentermanagement::v1::
        UpdateEventThreatDetectionCustomModuleRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status
SecurityCenterManagementConnection::DeleteEventThreatDetectionCustomModule(
    google::cloud::securitycentermanagement::v1::
        DeleteEventThreatDetectionCustomModuleRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::securitycentermanagement::v1::
             ValidateEventThreatDetectionCustomModuleResponse>
SecurityCenterManagementConnection::ValidateEventThreatDetectionCustomModule(
    google::cloud::securitycentermanagement::v1::
        ValidateEventThreatDetectionCustomModuleRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::securitycentermanagement::v1::SecurityCenterService>
SecurityCenterManagementConnection::GetSecurityCenterService(
    google::cloud::securitycentermanagement::v1::
        GetSecurityCenterServiceRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::securitycentermanagement::v1::SecurityCenterService>
SecurityCenterManagementConnection::ListSecurityCenterServices(
    google::cloud::securitycentermanagement::v1::
        ListSecurityCenterServicesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<StreamRange<
      google::cloud::securitycentermanagement::v1::SecurityCenterService>>();
}

StatusOr<google::cloud::securitycentermanagement::v1::SecurityCenterService>
SecurityCenterManagementConnection::UpdateSecurityCenterService(
    google::cloud::securitycentermanagement::v1::
        UpdateSecurityCenterServiceRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::location::Location>
SecurityCenterManagementConnection::ListLocations(
    google::cloud::location::
        ListLocationsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::location::Location>>();
}

StatusOr<google::cloud::location::Location>
SecurityCenterManagementConnection::GetLocation(
    google::cloud::location::GetLocationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<SecurityCenterManagementConnection>
MakeSecurityCenterManagementConnection(Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 SecurityCenterManagementPolicyOptionList>(
      options, __func__);
  options = securitycentermanagement_v1_internal::
      SecurityCenterManagementDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub = securitycentermanagement_v1_internal::
      CreateDefaultSecurityCenterManagementStub(std::move(auth), options);
  return securitycentermanagement_v1_internal::
      MakeSecurityCenterManagementTracingConnection(
          std::make_shared<securitycentermanagement_v1_internal::
                               SecurityCenterManagementConnectionImpl>(
              std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace securitycentermanagement_v1
}  // namespace cloud
}  // namespace google
