// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source:
// google/cloud/securitycentermanagement/v1/security_center_management.proto

#include "google/cloud/securitycentermanagement/v1/security_center_management_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace securitycentermanagement_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

SecurityCenterManagementClient::SecurityCenterManagementClient(
    std::shared_ptr<SecurityCenterManagementConnection> connection,
    Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
SecurityCenterManagementClient::~SecurityCenterManagementClient() = default;

StreamRange<google::cloud::securitycentermanagement::v1::
                EffectiveSecurityHealthAnalyticsCustomModule>
SecurityCenterManagementClient::
    ListEffectiveSecurityHealthAnalyticsCustomModules(std::string const& parent,
                                                      Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::securitycentermanagement::v1::
      ListEffectiveSecurityHealthAnalyticsCustomModulesRequest request;
  request.set_parent(parent);
  return connection_->ListEffectiveSecurityHealthAnalyticsCustomModules(
      request);
}

StreamRange<google::cloud::securitycentermanagement::v1::
                EffectiveSecurityHealthAnalyticsCustomModule>
SecurityCenterManagementClient::
    ListEffectiveSecurityHealthAnalyticsCustomModules(
        google::cloud::securitycentermanagement::v1::
            ListEffectiveSecurityHealthAnalyticsCustomModulesRequest request,
        Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListEffectiveSecurityHealthAnalyticsCustomModules(
      std::move(request));
}

StatusOr<google::cloud::securitycentermanagement::v1::
             EffectiveSecurityHealthAnalyticsCustomModule>
SecurityCenterManagementClient::GetEffectiveSecurityHealthAnalyticsCustomModule(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::securitycentermanagement::v1::
      GetEffectiveSecurityHealthAnalyticsCustomModuleRequest request;
  request.set_name(name);
  return connection_->GetEffectiveSecurityHealthAnalyticsCustomModule(request);
}

StatusOr<google::cloud::securitycentermanagement::v1::
             EffectiveSecurityHealthAnalyticsCustomModule>
SecurityCenterManagementClient::GetEffectiveSecurityHealthAnalyticsCustomModule(
    google::cloud::securitycentermanagement::v1::
        GetEffectiveSecurityHealthAnalyticsCustomModuleRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetEffectiveSecurityHealthAnalyticsCustomModule(request);
}

StreamRange<google::cloud::securitycentermanagement::v1::
                SecurityHealthAnalyticsCustomModule>
SecurityCenterManagementClient::ListSecurityHealthAnalyticsCustomModules(
    std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::securitycentermanagement::v1::
      ListSecurityHealthAnalyticsCustomModulesRequest request;
  request.set_parent(parent);
  return connection_->ListSecurityHealthAnalyticsCustomModules(request);
}

StreamRange<google::cloud::securitycentermanagement::v1::
                SecurityHealthAnalyticsCustomModule>
SecurityCenterManagementClient::ListSecurityHealthAnalyticsCustomModules(
    google::cloud::securitycentermanagement::v1::
        ListSecurityHealthAnalyticsCustomModulesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListSecurityHealthAnalyticsCustomModules(
      std::move(request));
}

StreamRange<google::cloud::securitycentermanagement::v1::
                SecurityHealthAnalyticsCustomModule>
SecurityCenterManagementClient::
    ListDescendantSecurityHealthAnalyticsCustomModules(
        std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::securitycentermanagement::v1::
      ListDescendantSecurityHealthAnalyticsCustomModulesRequest request;
  request.set_parent(parent);
  return connection_->ListDescendantSecurityHealthAnalyticsCustomModules(
      request);
}

StreamRange<google::cloud::securitycentermanagement::v1::
                SecurityHealthAnalyticsCustomModule>
SecurityCenterManagementClient::
    ListDescendantSecurityHealthAnalyticsCustomModules(
        google::cloud::securitycentermanagement::v1::
            ListDescendantSecurityHealthAnalyticsCustomModulesRequest request,
        Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListDescendantSecurityHealthAnalyticsCustomModules(
      std::move(request));
}

StatusOr<google::cloud::securitycentermanagement::v1::
             SecurityHealthAnalyticsCustomModule>
SecurityCenterManagementClient::GetSecurityHealthAnalyticsCustomModule(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::securitycentermanagement::v1::
      GetSecurityHealthAnalyticsCustomModuleRequest request;
  request.set_name(name);
  return connection_->GetSecurityHealthAnalyticsCustomModule(request);
}

StatusOr<google::cloud::securitycentermanagement::v1::
             SecurityHealthAnalyticsCustomModule>
SecurityCenterManagementClient::GetSecurityHealthAnalyticsCustomModule(
    google::cloud::securitycentermanagement::v1::
        GetSecurityHealthAnalyticsCustomModuleRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetSecurityHealthAnalyticsCustomModule(request);
}

StatusOr<google::cloud::securitycentermanagement::v1::
             SecurityHealthAnalyticsCustomModule>
SecurityCenterManagementClient::CreateSecurityHealthAnalyticsCustomModule(
    std::string const& parent,
    google::cloud::securitycentermanagement::v1::
        SecurityHealthAnalyticsCustomModule const&
            security_health_analytics_custom_module,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::securitycentermanagement::v1::
      CreateSecurityHealthAnalyticsCustomModuleRequest request;
  request.set_parent(parent);
  *request.mutable_security_health_analytics_custom_module() =
      security_health_analytics_custom_module;
  return connection_->CreateSecurityHealthAnalyticsCustomModule(request);
}

StatusOr<google::cloud::securitycentermanagement::v1::
             SecurityHealthAnalyticsCustomModule>
SecurityCenterManagementClient::CreateSecurityHealthAnalyticsCustomModule(
    google::cloud::securitycentermanagement::v1::
        CreateSecurityHealthAnalyticsCustomModuleRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateSecurityHealthAnalyticsCustomModule(request);
}

StatusOr<google::cloud::securitycentermanagement::v1::
             SecurityHealthAnalyticsCustomModule>
SecurityCenterManagementClient::UpdateSecurityHealthAnalyticsCustomModule(
    google::cloud::securitycentermanagement::v1::
        SecurityHealthAnalyticsCustomModule const&
            security_health_analytics_custom_module,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::securitycentermanagement::v1::
      UpdateSecurityHealthAnalyticsCustomModuleRequest request;
  *request.mutable_security_health_analytics_custom_module() =
      security_health_analytics_custom_module;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateSecurityHealthAnalyticsCustomModule(request);
}

StatusOr<google::cloud::securitycentermanagement::v1::
             SecurityHealthAnalyticsCustomModule>
SecurityCenterManagementClient::UpdateSecurityHealthAnalyticsCustomModule(
    google::cloud::securitycentermanagement::v1::
        UpdateSecurityHealthAnalyticsCustomModuleRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateSecurityHealthAnalyticsCustomModule(request);
}

Status
SecurityCenterManagementClient::DeleteSecurityHealthAnalyticsCustomModule(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::securitycentermanagement::v1::
      DeleteSecurityHealthAnalyticsCustomModuleRequest request;
  request.set_name(name);
  return connection_->DeleteSecurityHealthAnalyticsCustomModule(request);
}

Status
SecurityCenterManagementClient::DeleteSecurityHealthAnalyticsCustomModule(
    google::cloud::securitycentermanagement::v1::
        DeleteSecurityHealthAnalyticsCustomModuleRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteSecurityHealthAnalyticsCustomModule(request);
}

StatusOr<google::cloud::securitycentermanagement::v1::
             SimulateSecurityHealthAnalyticsCustomModuleResponse>
SecurityCenterManagementClient::SimulateSecurityHealthAnalyticsCustomModule(
    std::string const& parent,
    google::cloud::securitycentermanagement::v1::CustomConfig const&
        custom_config,
    google::cloud::securitycentermanagement::v1::
        SimulateSecurityHealthAnalyticsCustomModuleRequest::
            SimulatedResource const& resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::securitycentermanagement::v1::
      SimulateSecurityHealthAnalyticsCustomModuleRequest request;
  request.set_parent(parent);
  *request.mutable_custom_config() = custom_config;
  *request.mutable_resource() = resource;
  return connection_->SimulateSecurityHealthAnalyticsCustomModule(request);
}

StatusOr<google::cloud::securitycentermanagement::v1::
             SimulateSecurityHealthAnalyticsCustomModuleResponse>
SecurityCenterManagementClient::SimulateSecurityHealthAnalyticsCustomModule(
    google::cloud::securitycentermanagement::v1::
        SimulateSecurityHealthAnalyticsCustomModuleRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SimulateSecurityHealthAnalyticsCustomModule(request);
}

StreamRange<google::cloud::securitycentermanagement::v1::
                EffectiveEventThreatDetectionCustomModule>
SecurityCenterManagementClient::ListEffectiveEventThreatDetectionCustomModules(
    std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::securitycentermanagement::v1::
      ListEffectiveEventThreatDetectionCustomModulesRequest request;
  request.set_parent(parent);
  return connection_->ListEffectiveEventThreatDetectionCustomModules(request);
}

StreamRange<google::cloud::securitycentermanagement::v1::
                EffectiveEventThreatDetectionCustomModule>
SecurityCenterManagementClient::ListEffectiveEventThreatDetectionCustomModules(
    google::cloud::securitycentermanagement::v1::
        ListEffectiveEventThreatDetectionCustomModulesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListEffectiveEventThreatDetectionCustomModules(
      std::move(request));
}

StatusOr<google::cloud::securitycentermanagement::v1::
             EffectiveEventThreatDetectionCustomModule>
SecurityCenterManagementClient::GetEffectiveEventThreatDetectionCustomModule(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::securitycentermanagement::v1::
      GetEffectiveEventThreatDetectionCustomModuleRequest request;
  request.set_name(name);
  return connection_->GetEffectiveEventThreatDetectionCustomModule(request);
}

StatusOr<google::cloud::securitycentermanagement::v1::
             EffectiveEventThreatDetectionCustomModule>
SecurityCenterManagementClient::GetEffectiveEventThreatDetectionCustomModule(
    google::cloud::securitycentermanagement::v1::
        GetEffectiveEventThreatDetectionCustomModuleRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetEffectiveEventThreatDetectionCustomModule(request);
}

StreamRange<google::cloud::securitycentermanagement::v1::
                EventThreatDetectionCustomModule>
SecurityCenterManagementClient::ListEventThreatDetectionCustomModules(
    std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::securitycentermanagement::v1::
      ListEventThreatDetectionCustomModulesRequest request;
  request.set_parent(parent);
  return connection_->ListEventThreatDetectionCustomModules(request);
}

StreamRange<google::cloud::securitycentermanagement::v1::
                EventThreatDetectionCustomModule>
SecurityCenterManagementClient::ListEventThreatDetectionCustomModules(
    google::cloud::securitycentermanagement::v1::
        ListEventThreatDetectionCustomModulesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListEventThreatDetectionCustomModules(std::move(request));
}

StreamRange<google::cloud::securitycentermanagement::v1::
                EventThreatDetectionCustomModule>
SecurityCenterManagementClient::ListDescendantEventThreatDetectionCustomModules(
    std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::securitycentermanagement::v1::
      ListDescendantEventThreatDetectionCustomModulesRequest request;
  request.set_parent(parent);
  return connection_->ListDescendantEventThreatDetectionCustomModules(request);
}

StreamRange<google::cloud::securitycentermanagement::v1::
                EventThreatDetectionCustomModule>
SecurityCenterManagementClient::ListDescendantEventThreatDetectionCustomModules(
    google::cloud::securitycentermanagement::v1::
        ListDescendantEventThreatDetectionCustomModulesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListDescendantEventThreatDetectionCustomModules(
      std::move(request));
}

StatusOr<google::cloud::securitycentermanagement::v1::
             EventThreatDetectionCustomModule>
SecurityCenterManagementClient::GetEventThreatDetectionCustomModule(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::securitycentermanagement::v1::
      GetEventThreatDetectionCustomModuleRequest request;
  request.set_name(name);
  return connection_->GetEventThreatDetectionCustomModule(request);
}

StatusOr<google::cloud::securitycentermanagement::v1::
             EventThreatDetectionCustomModule>
SecurityCenterManagementClient::GetEventThreatDetectionCustomModule(
    google::cloud::securitycentermanagement::v1::
        GetEventThreatDetectionCustomModuleRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetEventThreatDetectionCustomModule(request);
}

StatusOr<google::cloud::securitycentermanagement::v1::
             EventThreatDetectionCustomModule>
SecurityCenterManagementClient::CreateEventThreatDetectionCustomModule(
    std::string const& parent,
    google::cloud::securitycentermanagement::v1::
        EventThreatDetectionCustomModule const&
            event_threat_detection_custom_module,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::securitycentermanagement::v1::
      CreateEventThreatDetectionCustomModuleRequest request;
  request.set_parent(parent);
  *request.mutable_event_threat_detection_custom_module() =
      event_threat_detection_custom_module;
  return connection_->CreateEventThreatDetectionCustomModule(request);
}

StatusOr<google::cloud::securitycentermanagement::v1::
             EventThreatDetectionCustomModule>
SecurityCenterManagementClient::CreateEventThreatDetectionCustomModule(
    google::cloud::securitycentermanagement::v1::
        CreateEventThreatDetectionCustomModuleRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateEventThreatDetectionCustomModule(request);
}

StatusOr<google::cloud::securitycentermanagement::v1::
             EventThreatDetectionCustomModule>
SecurityCenterManagementClient::UpdateEventThreatDetectionCustomModule(
    google::cloud::securitycentermanagement::v1::
        EventThreatDetectionCustomModule const&
            event_threat_detection_custom_module,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::securitycentermanagement::v1::
      UpdateEventThreatDetectionCustomModuleRequest request;
  *request.mutable_event_threat_detection_custom_module() =
      event_threat_detection_custom_module;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateEventThreatDetectionCustomModule(request);
}

StatusOr<google::cloud::securitycentermanagement::v1::
             EventThreatDetectionCustomModule>
SecurityCenterManagementClient::UpdateEventThreatDetectionCustomModule(
    google::cloud::securitycentermanagement::v1::
        UpdateEventThreatDetectionCustomModuleRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateEventThreatDetectionCustomModule(request);
}

Status SecurityCenterManagementClient::DeleteEventThreatDetectionCustomModule(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::securitycentermanagement::v1::
      DeleteEventThreatDetectionCustomModuleRequest request;
  request.set_name(name);
  return connection_->DeleteEventThreatDetectionCustomModule(request);
}

Status SecurityCenterManagementClient::DeleteEventThreatDetectionCustomModule(
    google::cloud::securitycentermanagement::v1::
        DeleteEventThreatDetectionCustomModuleRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteEventThreatDetectionCustomModule(request);
}

StatusOr<google::cloud::securitycentermanagement::v1::
             ValidateEventThreatDetectionCustomModuleResponse>
SecurityCenterManagementClient::ValidateEventThreatDetectionCustomModule(
    google::cloud::securitycentermanagement::v1::
        ValidateEventThreatDetectionCustomModuleRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ValidateEventThreatDetectionCustomModule(request);
}

StatusOr<google::cloud::securitycentermanagement::v1::SecurityCenterService>
SecurityCenterManagementClient::GetSecurityCenterService(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::securitycentermanagement::v1::GetSecurityCenterServiceRequest
      request;
  request.set_name(name);
  return connection_->GetSecurityCenterService(request);
}

StatusOr<google::cloud::securitycentermanagement::v1::SecurityCenterService>
SecurityCenterManagementClient::GetSecurityCenterService(
    google::cloud::securitycentermanagement::v1::
        GetSecurityCenterServiceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetSecurityCenterService(request);
}

StreamRange<google::cloud::securitycentermanagement::v1::SecurityCenterService>
SecurityCenterManagementClient::ListSecurityCenterServices(
    std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::securitycentermanagement::v1::ListSecurityCenterServicesRequest
      request;
  request.set_parent(parent);
  return connection_->ListSecurityCenterServices(request);
}

StreamRange<google::cloud::securitycentermanagement::v1::SecurityCenterService>
SecurityCenterManagementClient::ListSecurityCenterServices(
    google::cloud::securitycentermanagement::v1::
        ListSecurityCenterServicesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListSecurityCenterServices(std::move(request));
}

StatusOr<google::cloud::securitycentermanagement::v1::SecurityCenterService>
SecurityCenterManagementClient::UpdateSecurityCenterService(
    google::cloud::securitycentermanagement::v1::SecurityCenterService const&
        security_center_service,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::securitycentermanagement::v1::
      UpdateSecurityCenterServiceRequest request;
  *request.mutable_security_center_service() = security_center_service;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateSecurityCenterService(request);
}

StatusOr<google::cloud::securitycentermanagement::v1::SecurityCenterService>
SecurityCenterManagementClient::UpdateSecurityCenterService(
    google::cloud::securitycentermanagement::v1::
        UpdateSecurityCenterServiceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateSecurityCenterService(request);
}

StreamRange<google::cloud::location::Location>
SecurityCenterManagementClient::ListLocations(
    google::cloud::location::ListLocationsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListLocations(std::move(request));
}

StatusOr<google::cloud::location::Location>
SecurityCenterManagementClient::GetLocation(
    google::cloud::location::GetLocationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetLocation(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace securitycentermanagement_v1
}  // namespace cloud
}  // namespace google
