// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source:
// google/cloud/securitycentermanagement/v1/security_center_management.proto

#include "google/cloud/securitycentermanagement/v1/internal/security_center_management_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace securitycentermanagement_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

SecurityCenterManagementTracingStub::SecurityCenterManagementTracingStub(
    std::shared_ptr<SecurityCenterManagementStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::cloud::securitycentermanagement::v1::
             ListEffectiveSecurityHealthAnalyticsCustomModulesResponse>
SecurityCenterManagementTracingStub::
    ListEffectiveSecurityHealthAnalyticsCustomModules(
        grpc::ClientContext& context, Options const& options,
        google::cloud::securitycentermanagement::v1::
            ListEffectiveSecurityHealthAnalyticsCustomModulesRequest const&
                request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.securitycentermanagement.v1.SecurityCenterManagement",
      "ListEffectiveSecurityHealthAnalyticsCustomModules");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->ListEffectiveSecurityHealthAnalyticsCustomModules(
          context, options, request));
}

StatusOr<google::cloud::securitycentermanagement::v1::
             EffectiveSecurityHealthAnalyticsCustomModule>
SecurityCenterManagementTracingStub::
    GetEffectiveSecurityHealthAnalyticsCustomModule(
        grpc::ClientContext& context, Options const& options,
        google::cloud::securitycentermanagement::v1::
            GetEffectiveSecurityHealthAnalyticsCustomModuleRequest const&
                request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.securitycentermanagement.v1.SecurityCenterManagement",
      "GetEffectiveSecurityHealthAnalyticsCustomModule");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->GetEffectiveSecurityHealthAnalyticsCustomModule(context, options,
                                                              request));
}

StatusOr<google::cloud::securitycentermanagement::v1::
             ListSecurityHealthAnalyticsCustomModulesResponse>
SecurityCenterManagementTracingStub::ListSecurityHealthAnalyticsCustomModules(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycentermanagement::v1::
        ListSecurityHealthAnalyticsCustomModulesRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.securitycentermanagement.v1.SecurityCenterManagement",
      "ListSecurityHealthAnalyticsCustomModules");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListSecurityHealthAnalyticsCustomModules(
                               context, options, request));
}

StatusOr<google::cloud::securitycentermanagement::v1::
             ListDescendantSecurityHealthAnalyticsCustomModulesResponse>
SecurityCenterManagementTracingStub::
    ListDescendantSecurityHealthAnalyticsCustomModules(
        grpc::ClientContext& context, Options const& options,
        google::cloud::securitycentermanagement::v1::
            ListDescendantSecurityHealthAnalyticsCustomModulesRequest const&
                request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.securitycentermanagement.v1.SecurityCenterManagement",
      "ListDescendantSecurityHealthAnalyticsCustomModules");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->ListDescendantSecurityHealthAnalyticsCustomModules(
          context, options, request));
}

StatusOr<google::cloud::securitycentermanagement::v1::
             SecurityHealthAnalyticsCustomModule>
SecurityCenterManagementTracingStub::GetSecurityHealthAnalyticsCustomModule(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycentermanagement::v1::
        GetSecurityHealthAnalyticsCustomModuleRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.securitycentermanagement.v1.SecurityCenterManagement",
      "GetSecurityHealthAnalyticsCustomModule");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetSecurityHealthAnalyticsCustomModule(
                               context, options, request));
}

StatusOr<google::cloud::securitycentermanagement::v1::
             SecurityHealthAnalyticsCustomModule>
SecurityCenterManagementTracingStub::CreateSecurityHealthAnalyticsCustomModule(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycentermanagement::v1::
        CreateSecurityHealthAnalyticsCustomModuleRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.securitycentermanagement.v1.SecurityCenterManagement",
      "CreateSecurityHealthAnalyticsCustomModule");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateSecurityHealthAnalyticsCustomModule(
                               context, options, request));
}

StatusOr<google::cloud::securitycentermanagement::v1::
             SecurityHealthAnalyticsCustomModule>
SecurityCenterManagementTracingStub::UpdateSecurityHealthAnalyticsCustomModule(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycentermanagement::v1::
        UpdateSecurityHealthAnalyticsCustomModuleRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.securitycentermanagement.v1.SecurityCenterManagement",
      "UpdateSecurityHealthAnalyticsCustomModule");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateSecurityHealthAnalyticsCustomModule(
                               context, options, request));
}

Status
SecurityCenterManagementTracingStub::DeleteSecurityHealthAnalyticsCustomModule(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycentermanagement::v1::
        DeleteSecurityHealthAnalyticsCustomModuleRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.securitycentermanagement.v1.SecurityCenterManagement",
      "DeleteSecurityHealthAnalyticsCustomModule");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteSecurityHealthAnalyticsCustomModule(
                               context, options, request));
}

StatusOr<google::cloud::securitycentermanagement::v1::
             SimulateSecurityHealthAnalyticsCustomModuleResponse>
SecurityCenterManagementTracingStub::
    SimulateSecurityHealthAnalyticsCustomModule(
        grpc::ClientContext& context, Options const& options,
        google::cloud::securitycentermanagement::v1::
            SimulateSecurityHealthAnalyticsCustomModuleRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.securitycentermanagement.v1.SecurityCenterManagement",
      "SimulateSecurityHealthAnalyticsCustomModule");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->SimulateSecurityHealthAnalyticsCustomModule(
                               context, options, request));
}

StatusOr<google::cloud::securitycentermanagement::v1::
             ListEffectiveEventThreatDetectionCustomModulesResponse>
SecurityCenterManagementTracingStub::
    ListEffectiveEventThreatDetectionCustomModules(
        grpc::ClientContext& context, Options const& options,
        google::cloud::securitycentermanagement::v1::
            ListEffectiveEventThreatDetectionCustomModulesRequest const&
                request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.securitycentermanagement.v1.SecurityCenterManagement",
      "ListEffectiveEventThreatDetectionCustomModules");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->ListEffectiveEventThreatDetectionCustomModules(context, options,
                                                             request));
}

StatusOr<google::cloud::securitycentermanagement::v1::
             EffectiveEventThreatDetectionCustomModule>
SecurityCenterManagementTracingStub::
    GetEffectiveEventThreatDetectionCustomModule(
        grpc::ClientContext& context, Options const& options,
        google::cloud::securitycentermanagement::v1::
            GetEffectiveEventThreatDetectionCustomModuleRequest const&
                request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.securitycentermanagement.v1.SecurityCenterManagement",
      "GetEffectiveEventThreatDetectionCustomModule");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetEffectiveEventThreatDetectionCustomModule(
                               context, options, request));
}

StatusOr<google::cloud::securitycentermanagement::v1::
             ListEventThreatDetectionCustomModulesResponse>
SecurityCenterManagementTracingStub::ListEventThreatDetectionCustomModules(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycentermanagement::v1::
        ListEventThreatDetectionCustomModulesRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.securitycentermanagement.v1.SecurityCenterManagement",
      "ListEventThreatDetectionCustomModules");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->ListEventThreatDetectionCustomModules(context, options, request));
}

StatusOr<google::cloud::securitycentermanagement::v1::
             ListDescendantEventThreatDetectionCustomModulesResponse>
SecurityCenterManagementTracingStub::
    ListDescendantEventThreatDetectionCustomModules(
        grpc::ClientContext& context, Options const& options,
        google::cloud::securitycentermanagement::v1::
            ListDescendantEventThreatDetectionCustomModulesRequest const&
                request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.securitycentermanagement.v1.SecurityCenterManagement",
      "ListDescendantEventThreatDetectionCustomModules");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->ListDescendantEventThreatDetectionCustomModules(context, options,
                                                              request));
}

StatusOr<google::cloud::securitycentermanagement::v1::
             EventThreatDetectionCustomModule>
SecurityCenterManagementTracingStub::GetEventThreatDetectionCustomModule(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycentermanagement::v1::
        GetEventThreatDetectionCustomModuleRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.securitycentermanagement.v1.SecurityCenterManagement",
      "GetEventThreatDetectionCustomModule");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->GetEventThreatDetectionCustomModule(context, options, request));
}

StatusOr<google::cloud::securitycentermanagement::v1::
             EventThreatDetectionCustomModule>
SecurityCenterManagementTracingStub::CreateEventThreatDetectionCustomModule(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycentermanagement::v1::
        CreateEventThreatDetectionCustomModuleRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.securitycentermanagement.v1.SecurityCenterManagement",
      "CreateEventThreatDetectionCustomModule");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateEventThreatDetectionCustomModule(
                               context, options, request));
}

StatusOr<google::cloud::securitycentermanagement::v1::
             EventThreatDetectionCustomModule>
SecurityCenterManagementTracingStub::UpdateEventThreatDetectionCustomModule(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycentermanagement::v1::
        UpdateEventThreatDetectionCustomModuleRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.securitycentermanagement.v1.SecurityCenterManagement",
      "UpdateEventThreatDetectionCustomModule");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateEventThreatDetectionCustomModule(
                               context, options, request));
}

Status
SecurityCenterManagementTracingStub::DeleteEventThreatDetectionCustomModule(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycentermanagement::v1::
        DeleteEventThreatDetectionCustomModuleRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.securitycentermanagement.v1.SecurityCenterManagement",
      "DeleteEventThreatDetectionCustomModule");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteEventThreatDetectionCustomModule(
                               context, options, request));
}

StatusOr<google::cloud::securitycentermanagement::v1::
             ValidateEventThreatDetectionCustomModuleResponse>
SecurityCenterManagementTracingStub::ValidateEventThreatDetectionCustomModule(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycentermanagement::v1::
        ValidateEventThreatDetectionCustomModuleRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.securitycentermanagement.v1.SecurityCenterManagement",
      "ValidateEventThreatDetectionCustomModule");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ValidateEventThreatDetectionCustomModule(
                               context, options, request));
}

StatusOr<google::cloud::securitycentermanagement::v1::SecurityCenterService>
SecurityCenterManagementTracingStub::GetSecurityCenterService(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycentermanagement::v1::
        GetSecurityCenterServiceRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.securitycentermanagement.v1.SecurityCenterManagement",
      "GetSecurityCenterService");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->GetSecurityCenterService(context, options, request));
}

StatusOr<google::cloud::securitycentermanagement::v1::
             ListSecurityCenterServicesResponse>
SecurityCenterManagementTracingStub::ListSecurityCenterServices(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycentermanagement::v1::
        ListSecurityCenterServicesRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.securitycentermanagement.v1.SecurityCenterManagement",
      "ListSecurityCenterServices");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->ListSecurityCenterServices(context, options, request));
}

StatusOr<google::cloud::securitycentermanagement::v1::SecurityCenterService>
SecurityCenterManagementTracingStub::UpdateSecurityCenterService(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycentermanagement::v1::
        UpdateSecurityCenterServiceRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.securitycentermanagement.v1.SecurityCenterManagement",
      "UpdateSecurityCenterService");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->UpdateSecurityCenterService(context, options, request));
}

StatusOr<google::cloud::location::ListLocationsResponse>
SecurityCenterManagementTracingStub::ListLocations(
    grpc::ClientContext& context, Options const& options,
    google::cloud::location::ListLocationsRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.securitycentermanagement.v1.SecurityCenterManagement",
      "ListLocations");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListLocations(context, options, request));
}

StatusOr<google::cloud::location::Location>
SecurityCenterManagementTracingStub::GetLocation(
    grpc::ClientContext& context, Options const& options,
    google::cloud::location::GetLocationRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.securitycentermanagement.v1.SecurityCenterManagement",
      "GetLocation");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetLocation(context, options, request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<SecurityCenterManagementStub>
MakeSecurityCenterManagementTracingStub(
    std::shared_ptr<SecurityCenterManagementStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<SecurityCenterManagementTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace securitycentermanagement_v1_internal
}  // namespace cloud
}  // namespace google
