// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source:
// google/cloud/securitycentermanagement/v1/security_center_management.proto

#include "google/cloud/securitycentermanagement/v1/internal/security_center_management_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace securitycentermanagement_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

SecurityCenterManagementTracingConnection::
    SecurityCenterManagementTracingConnection(
        std::shared_ptr<
            securitycentermanagement_v1::SecurityCenterManagementConnection>
            child)
    : child_(std::move(child)) {}

StreamRange<google::cloud::securitycentermanagement::v1::
                EffectiveSecurityHealthAnalyticsCustomModule>
SecurityCenterManagementTracingConnection::
    ListEffectiveSecurityHealthAnalyticsCustomModules(
        google::cloud::securitycentermanagement::v1::
            ListEffectiveSecurityHealthAnalyticsCustomModulesRequest request) {
  auto span = internal::MakeSpan(
      "securitycentermanagement_v1::SecurityCenterManagementConnection::"
      "ListEffectiveSecurityHealthAnalyticsCustomModules");
  internal::OTelScope scope(span);
  auto sr = child_->ListEffectiveSecurityHealthAnalyticsCustomModules(
      std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::securitycentermanagement::v1::
          EffectiveSecurityHealthAnalyticsCustomModule>(std::move(span),
                                                        std::move(sr));
}

StatusOr<google::cloud::securitycentermanagement::v1::
             EffectiveSecurityHealthAnalyticsCustomModule>
SecurityCenterManagementTracingConnection::
    GetEffectiveSecurityHealthAnalyticsCustomModule(
        google::cloud::securitycentermanagement::v1::
            GetEffectiveSecurityHealthAnalyticsCustomModuleRequest const&
                request) {
  auto span = internal::MakeSpan(
      "securitycentermanagement_v1::SecurityCenterManagementConnection::"
      "GetEffectiveSecurityHealthAnalyticsCustomModule");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(
      *span, child_->GetEffectiveSecurityHealthAnalyticsCustomModule(request));
}

StreamRange<google::cloud::securitycentermanagement::v1::
                SecurityHealthAnalyticsCustomModule>
SecurityCenterManagementTracingConnection::
    ListSecurityHealthAnalyticsCustomModules(
        google::cloud::securitycentermanagement::v1::
            ListSecurityHealthAnalyticsCustomModulesRequest request) {
  auto span = internal::MakeSpan(
      "securitycentermanagement_v1::SecurityCenterManagementConnection::"
      "ListSecurityHealthAnalyticsCustomModules");
  internal::OTelScope scope(span);
  auto sr =
      child_->ListSecurityHealthAnalyticsCustomModules(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::securitycentermanagement::v1::
          SecurityHealthAnalyticsCustomModule>(std::move(span), std::move(sr));
}

StreamRange<google::cloud::securitycentermanagement::v1::
                SecurityHealthAnalyticsCustomModule>
SecurityCenterManagementTracingConnection::
    ListDescendantSecurityHealthAnalyticsCustomModules(
        google::cloud::securitycentermanagement::v1::
            ListDescendantSecurityHealthAnalyticsCustomModulesRequest request) {
  auto span = internal::MakeSpan(
      "securitycentermanagement_v1::SecurityCenterManagementConnection::"
      "ListDescendantSecurityHealthAnalyticsCustomModules");
  internal::OTelScope scope(span);
  auto sr = child_->ListDescendantSecurityHealthAnalyticsCustomModules(
      std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::securitycentermanagement::v1::
          SecurityHealthAnalyticsCustomModule>(std::move(span), std::move(sr));
}

StatusOr<google::cloud::securitycentermanagement::v1::
             SecurityHealthAnalyticsCustomModule>
SecurityCenterManagementTracingConnection::
    GetSecurityHealthAnalyticsCustomModule(
        google::cloud::securitycentermanagement::v1::
            GetSecurityHealthAnalyticsCustomModuleRequest const& request) {
  auto span = internal::MakeSpan(
      "securitycentermanagement_v1::SecurityCenterManagementConnection::"
      "GetSecurityHealthAnalyticsCustomModule");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(
      *span, child_->GetSecurityHealthAnalyticsCustomModule(request));
}

StatusOr<google::cloud::securitycentermanagement::v1::
             SecurityHealthAnalyticsCustomModule>
SecurityCenterManagementTracingConnection::
    CreateSecurityHealthAnalyticsCustomModule(
        google::cloud::securitycentermanagement::v1::
            CreateSecurityHealthAnalyticsCustomModuleRequest const& request) {
  auto span = internal::MakeSpan(
      "securitycentermanagement_v1::SecurityCenterManagementConnection::"
      "CreateSecurityHealthAnalyticsCustomModule");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(
      *span, child_->CreateSecurityHealthAnalyticsCustomModule(request));
}

StatusOr<google::cloud::securitycentermanagement::v1::
             SecurityHealthAnalyticsCustomModule>
SecurityCenterManagementTracingConnection::
    UpdateSecurityHealthAnalyticsCustomModule(
        google::cloud::securitycentermanagement::v1::
            UpdateSecurityHealthAnalyticsCustomModuleRequest const& request) {
  auto span = internal::MakeSpan(
      "securitycentermanagement_v1::SecurityCenterManagementConnection::"
      "UpdateSecurityHealthAnalyticsCustomModule");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(
      *span, child_->UpdateSecurityHealthAnalyticsCustomModule(request));
}

Status SecurityCenterManagementTracingConnection::
    DeleteSecurityHealthAnalyticsCustomModule(
        google::cloud::securitycentermanagement::v1::
            DeleteSecurityHealthAnalyticsCustomModuleRequest const& request) {
  auto span = internal::MakeSpan(
      "securitycentermanagement_v1::SecurityCenterManagementConnection::"
      "DeleteSecurityHealthAnalyticsCustomModule");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(
      *span, child_->DeleteSecurityHealthAnalyticsCustomModule(request));
}

StatusOr<google::cloud::securitycentermanagement::v1::
             SimulateSecurityHealthAnalyticsCustomModuleResponse>
SecurityCenterManagementTracingConnection::
    SimulateSecurityHealthAnalyticsCustomModule(
        google::cloud::securitycentermanagement::v1::
            SimulateSecurityHealthAnalyticsCustomModuleRequest const& request) {
  auto span = internal::MakeSpan(
      "securitycentermanagement_v1::SecurityCenterManagementConnection::"
      "SimulateSecurityHealthAnalyticsCustomModule");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(
      *span, child_->SimulateSecurityHealthAnalyticsCustomModule(request));
}

StreamRange<google::cloud::securitycentermanagement::v1::
                EffectiveEventThreatDetectionCustomModule>
SecurityCenterManagementTracingConnection::
    ListEffectiveEventThreatDetectionCustomModules(
        google::cloud::securitycentermanagement::v1::
            ListEffectiveEventThreatDetectionCustomModulesRequest request) {
  auto span = internal::MakeSpan(
      "securitycentermanagement_v1::SecurityCenterManagementConnection::"
      "ListEffectiveEventThreatDetectionCustomModules");
  internal::OTelScope scope(span);
  auto sr = child_->ListEffectiveEventThreatDetectionCustomModules(
      std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::securitycentermanagement::v1::
          EffectiveEventThreatDetectionCustomModule>(std::move(span),
                                                     std::move(sr));
}

StatusOr<google::cloud::securitycentermanagement::v1::
             EffectiveEventThreatDetectionCustomModule>
SecurityCenterManagementTracingConnection::
    GetEffectiveEventThreatDetectionCustomModule(
        google::cloud::securitycentermanagement::v1::
            GetEffectiveEventThreatDetectionCustomModuleRequest const&
                request) {
  auto span = internal::MakeSpan(
      "securitycentermanagement_v1::SecurityCenterManagementConnection::"
      "GetEffectiveEventThreatDetectionCustomModule");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(
      *span, child_->GetEffectiveEventThreatDetectionCustomModule(request));
}

StreamRange<google::cloud::securitycentermanagement::v1::
                EventThreatDetectionCustomModule>
SecurityCenterManagementTracingConnection::
    ListEventThreatDetectionCustomModules(
        google::cloud::securitycentermanagement::v1::
            ListEventThreatDetectionCustomModulesRequest request) {
  auto span = internal::MakeSpan(
      "securitycentermanagement_v1::SecurityCenterManagementConnection::"
      "ListEventThreatDetectionCustomModules");
  internal::OTelScope scope(span);
  auto sr = child_->ListEventThreatDetectionCustomModules(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::securitycentermanagement::v1::
          EventThreatDetectionCustomModule>(std::move(span), std::move(sr));
}

StreamRange<google::cloud::securitycentermanagement::v1::
                EventThreatDetectionCustomModule>
SecurityCenterManagementTracingConnection::
    ListDescendantEventThreatDetectionCustomModules(
        google::cloud::securitycentermanagement::v1::
            ListDescendantEventThreatDetectionCustomModulesRequest request) {
  auto span = internal::MakeSpan(
      "securitycentermanagement_v1::SecurityCenterManagementConnection::"
      "ListDescendantEventThreatDetectionCustomModules");
  internal::OTelScope scope(span);
  auto sr = child_->ListDescendantEventThreatDetectionCustomModules(
      std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::securitycentermanagement::v1::
          EventThreatDetectionCustomModule>(std::move(span), std::move(sr));
}

StatusOr<google::cloud::securitycentermanagement::v1::
             EventThreatDetectionCustomModule>
SecurityCenterManagementTracingConnection::GetEventThreatDetectionCustomModule(
    google::cloud::securitycentermanagement::v1::
        GetEventThreatDetectionCustomModuleRequest const& request) {
  auto span = internal::MakeSpan(
      "securitycentermanagement_v1::SecurityCenterManagementConnection::"
      "GetEventThreatDetectionCustomModule");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(
      *span, child_->GetEventThreatDetectionCustomModule(request));
}

StatusOr<google::cloud::securitycentermanagement::v1::
             EventThreatDetectionCustomModule>
SecurityCenterManagementTracingConnection::
    CreateEventThreatDetectionCustomModule(
        google::cloud::securitycentermanagement::v1::
            CreateEventThreatDetectionCustomModuleRequest const& request) {
  auto span = internal::MakeSpan(
      "securitycentermanagement_v1::SecurityCenterManagementConnection::"
      "CreateEventThreatDetectionCustomModule");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(
      *span, child_->CreateEventThreatDetectionCustomModule(request));
}

StatusOr<google::cloud::securitycentermanagement::v1::
             EventThreatDetectionCustomModule>
SecurityCenterManagementTracingConnection::
    UpdateEventThreatDetectionCustomModule(
        google::cloud::securitycentermanagement::v1::
            UpdateEventThreatDetectionCustomModuleRequest const& request) {
  auto span = internal::MakeSpan(
      "securitycentermanagement_v1::SecurityCenterManagementConnection::"
      "UpdateEventThreatDetectionCustomModule");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(
      *span, child_->UpdateEventThreatDetectionCustomModule(request));
}

Status SecurityCenterManagementTracingConnection::
    DeleteEventThreatDetectionCustomModule(
        google::cloud::securitycentermanagement::v1::
            DeleteEventThreatDetectionCustomModuleRequest const& request) {
  auto span = internal::MakeSpan(
      "securitycentermanagement_v1::SecurityCenterManagementConnection::"
      "DeleteEventThreatDetectionCustomModule");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(
      *span, child_->DeleteEventThreatDetectionCustomModule(request));
}

StatusOr<google::cloud::securitycentermanagement::v1::
             ValidateEventThreatDetectionCustomModuleResponse>
SecurityCenterManagementTracingConnection::
    ValidateEventThreatDetectionCustomModule(
        google::cloud::securitycentermanagement::v1::
            ValidateEventThreatDetectionCustomModuleRequest const& request) {
  auto span = internal::MakeSpan(
      "securitycentermanagement_v1::SecurityCenterManagementConnection::"
      "ValidateEventThreatDetectionCustomModule");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(
      *span, child_->ValidateEventThreatDetectionCustomModule(request));
}

StatusOr<google::cloud::securitycentermanagement::v1::SecurityCenterService>
SecurityCenterManagementTracingConnection::GetSecurityCenterService(
    google::cloud::securitycentermanagement::v1::
        GetSecurityCenterServiceRequest const& request) {
  auto span = internal::MakeSpan(
      "securitycentermanagement_v1::SecurityCenterManagementConnection::"
      "GetSecurityCenterService");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetSecurityCenterService(request));
}

StreamRange<google::cloud::securitycentermanagement::v1::SecurityCenterService>
SecurityCenterManagementTracingConnection::ListSecurityCenterServices(
    google::cloud::securitycentermanagement::v1::
        ListSecurityCenterServicesRequest request) {
  auto span = internal::MakeSpan(
      "securitycentermanagement_v1::SecurityCenterManagementConnection::"
      "ListSecurityCenterServices");
  internal::OTelScope scope(span);
  auto sr = child_->ListSecurityCenterServices(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::securitycentermanagement::v1::SecurityCenterService>(
      std::move(span), std::move(sr));
}

StatusOr<google::cloud::securitycentermanagement::v1::SecurityCenterService>
SecurityCenterManagementTracingConnection::UpdateSecurityCenterService(
    google::cloud::securitycentermanagement::v1::
        UpdateSecurityCenterServiceRequest const& request) {
  auto span = internal::MakeSpan(
      "securitycentermanagement_v1::SecurityCenterManagementConnection::"
      "UpdateSecurityCenterService");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateSecurityCenterService(request));
}

StreamRange<google::cloud::location::Location>
SecurityCenterManagementTracingConnection::ListLocations(
    google::cloud::location::ListLocationsRequest request) {
  auto span = internal::MakeSpan(
      "securitycentermanagement_v1::SecurityCenterManagementConnection::"
      "ListLocations");
  internal::OTelScope scope(span);
  auto sr = child_->ListLocations(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::location::Location>(
      std::move(span), std::move(sr));
}

StatusOr<google::cloud::location::Location>
SecurityCenterManagementTracingConnection::GetLocation(
    google::cloud::location::GetLocationRequest const& request) {
  auto span = internal::MakeSpan(
      "securitycentermanagement_v1::SecurityCenterManagementConnection::"
      "GetLocation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetLocation(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<securitycentermanagement_v1::SecurityCenterManagementConnection>
MakeSecurityCenterManagementTracingConnection(
    std::shared_ptr<
        securitycentermanagement_v1::SecurityCenterManagementConnection>
        conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<SecurityCenterManagementTracingConnection>(
        std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace securitycentermanagement_v1_internal
}  // namespace cloud
}  // namespace google
