// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/securitycenter/v2/securitycenter_service.proto

#include "google/cloud/securitycenter/v2/security_center_connection.h"
#include "google/cloud/securitycenter/v2/internal/security_center_connection_impl.h"
#include "google/cloud/securitycenter/v2/internal/security_center_option_defaults.h"
#include "google/cloud/securitycenter/v2/internal/security_center_stub_factory.h"
#include "google/cloud/securitycenter/v2/internal/security_center_tracing_connection.h"
#include "google/cloud/securitycenter/v2/security_center_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace securitycenter_v2 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

SecurityCenterConnection::~SecurityCenterConnection() = default;

StatusOr<
    google::cloud::securitycenter::v2::BatchCreateResourceValueConfigsResponse>
SecurityCenterConnection::BatchCreateResourceValueConfigs(
    google::cloud::securitycenter::v2::
        BatchCreateResourceValueConfigsRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::securitycenter::v2::BulkMuteFindingsResponse>>
SecurityCenterConnection::BulkMuteFindings(
    google::cloud::securitycenter::v2::BulkMuteFindingsRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::securitycenter::v2::BulkMuteFindingsResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
SecurityCenterConnection::BulkMuteFindings(
    NoAwaitTag,
    google::cloud::securitycenter::v2::BulkMuteFindingsRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::securitycenter::v2::BulkMuteFindingsResponse>>
SecurityCenterConnection::BulkMuteFindings(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::securitycenter::v2::BulkMuteFindingsResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::securitycenter::v2::BigQueryExport>
SecurityCenterConnection::CreateBigQueryExport(
    google::cloud::securitycenter::v2::CreateBigQueryExportRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::securitycenter::v2::Finding>
SecurityCenterConnection::CreateFinding(
    google::cloud::securitycenter::v2::CreateFindingRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::securitycenter::v2::MuteConfig>
SecurityCenterConnection::CreateMuteConfig(
    google::cloud::securitycenter::v2::CreateMuteConfigRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::securitycenter::v2::NotificationConfig>
SecurityCenterConnection::CreateNotificationConfig(
    google::cloud::securitycenter::v2::CreateNotificationConfigRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::securitycenter::v2::Source>
SecurityCenterConnection::CreateSource(
    google::cloud::securitycenter::v2::CreateSourceRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status SecurityCenterConnection::DeleteBigQueryExport(
    google::cloud::securitycenter::v2::DeleteBigQueryExportRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status SecurityCenterConnection::DeleteMuteConfig(
    google::cloud::securitycenter::v2::DeleteMuteConfigRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status SecurityCenterConnection::DeleteNotificationConfig(
    google::cloud::securitycenter::v2::DeleteNotificationConfigRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status SecurityCenterConnection::DeleteResourceValueConfig(
    google::cloud::securitycenter::v2::
        DeleteResourceValueConfigRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::securitycenter::v2::BigQueryExport>
SecurityCenterConnection::GetBigQueryExport(
    google::cloud::securitycenter::v2::GetBigQueryExportRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::securitycenter::v2::Simulation>
SecurityCenterConnection::GetSimulation(
    google::cloud::securitycenter::v2::GetSimulationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::securitycenter::v2::ValuedResource>
SecurityCenterConnection::GetValuedResource(
    google::cloud::securitycenter::v2::GetValuedResourceRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::Policy> SecurityCenterConnection::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::securitycenter::v2::MuteConfig>
SecurityCenterConnection::GetMuteConfig(
    google::cloud::securitycenter::v2::GetMuteConfigRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::securitycenter::v2::NotificationConfig>
SecurityCenterConnection::GetNotificationConfig(
    google::cloud::securitycenter::v2::GetNotificationConfigRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::securitycenter::v2::ResourceValueConfig>
SecurityCenterConnection::GetResourceValueConfig(
    google::cloud::securitycenter::v2::GetResourceValueConfigRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::securitycenter::v2::Source>
SecurityCenterConnection::GetSource(
    google::cloud::securitycenter::v2::GetSourceRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::securitycenter::v2::GroupResult>
SecurityCenterConnection::GroupFindings(
    google::cloud::securitycenter::v2::
        GroupFindingsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::securitycenter::v2::GroupResult>>();
}

StreamRange<google::cloud::securitycenter::v2::AttackPath>
SecurityCenterConnection::ListAttackPaths(
    google::cloud::securitycenter::v2::
        ListAttackPathsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::securitycenter::v2::AttackPath>>();
}

StreamRange<google::cloud::securitycenter::v2::BigQueryExport>
SecurityCenterConnection::ListBigQueryExports(
    google::cloud::securitycenter::v2::
        ListBigQueryExportsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::securitycenter::v2::BigQueryExport>>();
}

StreamRange<
    google::cloud::securitycenter::v2::ListFindingsResponse::ListFindingsResult>
SecurityCenterConnection::ListFindings(
    google::cloud::securitycenter::v2::
        ListFindingsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::securitycenter::v2::ListFindingsResponse::
                      ListFindingsResult>>();
}

StreamRange<google::cloud::securitycenter::v2::MuteConfig>
SecurityCenterConnection::ListMuteConfigs(
    google::cloud::securitycenter::v2::
        ListMuteConfigsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::securitycenter::v2::MuteConfig>>();
}

StreamRange<google::cloud::securitycenter::v2::NotificationConfig>
SecurityCenterConnection::ListNotificationConfigs(
    google::cloud::securitycenter::v2::
        ListNotificationConfigsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::securitycenter::v2::NotificationConfig>>();
}

StreamRange<google::cloud::securitycenter::v2::ResourceValueConfig>
SecurityCenterConnection::ListResourceValueConfigs(
    google::cloud::securitycenter::v2::
        ListResourceValueConfigsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::securitycenter::v2::ResourceValueConfig>>();
}

StreamRange<google::cloud::securitycenter::v2::Source>
SecurityCenterConnection::ListSources(
    google::cloud::securitycenter::v2::
        ListSourcesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::securitycenter::v2::Source>>();
}

StreamRange<google::cloud::securitycenter::v2::ValuedResource>
SecurityCenterConnection::ListValuedResources(
    google::cloud::securitycenter::v2::
        ListValuedResourcesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::securitycenter::v2::ValuedResource>>();
}

StatusOr<google::cloud::securitycenter::v2::Finding>
SecurityCenterConnection::SetFindingState(
    google::cloud::securitycenter::v2::SetFindingStateRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::Policy> SecurityCenterConnection::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::securitycenter::v2::Finding>
SecurityCenterConnection::SetMute(
    google::cloud::securitycenter::v2::SetMuteRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
SecurityCenterConnection::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::securitycenter::v2::BigQueryExport>
SecurityCenterConnection::UpdateBigQueryExport(
    google::cloud::securitycenter::v2::UpdateBigQueryExportRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::securitycenter::v2::ExternalSystem>
SecurityCenterConnection::UpdateExternalSystem(
    google::cloud::securitycenter::v2::UpdateExternalSystemRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::securitycenter::v2::Finding>
SecurityCenterConnection::UpdateFinding(
    google::cloud::securitycenter::v2::UpdateFindingRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::securitycenter::v2::MuteConfig>
SecurityCenterConnection::UpdateMuteConfig(
    google::cloud::securitycenter::v2::UpdateMuteConfigRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::securitycenter::v2::NotificationConfig>
SecurityCenterConnection::UpdateNotificationConfig(
    google::cloud::securitycenter::v2::UpdateNotificationConfigRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::securitycenter::v2::ResourceValueConfig>
SecurityCenterConnection::UpdateResourceValueConfig(
    google::cloud::securitycenter::v2::
        UpdateResourceValueConfigRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::securitycenter::v2::SecurityMarks>
SecurityCenterConnection::UpdateSecurityMarks(
    google::cloud::securitycenter::v2::UpdateSecurityMarksRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::securitycenter::v2::Source>
SecurityCenterConnection::UpdateSource(
    google::cloud::securitycenter::v2::UpdateSourceRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::longrunning::Operation>
SecurityCenterConnection::ListOperations(
    google::longrunning::
        ListOperationsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::longrunning::Operation>>();
}

StatusOr<google::longrunning::Operation> SecurityCenterConnection::GetOperation(
    google::longrunning::GetOperationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status SecurityCenterConnection::DeleteOperation(
    google::longrunning::DeleteOperationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status SecurityCenterConnection::CancelOperation(
    google::longrunning::CancelOperationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<SecurityCenterConnection> MakeSecurityCenterConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 SecurityCenterPolicyOptionList>(options,
                                                                 __func__);
  options = securitycenter_v2_internal::SecurityCenterDefaultOptions(
      std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub = securitycenter_v2_internal::CreateDefaultSecurityCenterStub(
      std::move(auth), options);
  return securitycenter_v2_internal::MakeSecurityCenterTracingConnection(
      std::make_shared<
          securitycenter_v2_internal::SecurityCenterConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace securitycenter_v2
}  // namespace cloud
}  // namespace google
