// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/securitycenter/v2/securitycenter_service.proto

#include "google/cloud/securitycenter/v2/internal/security_center_metadata_decorator.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/absl_str_cat_quiet.h"
#include "google/cloud/internal/absl_str_join_quiet.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/internal/routing_matcher.h"
#include "google/cloud/internal/url_encode.h"
#include "google/cloud/status_or.h"
#include <google/cloud/securitycenter/v2/securitycenter_service.grpc.pb.h>
#include <memory>
#include <string>
#include <utility>
#include <vector>

namespace google {
namespace cloud {
namespace securitycenter_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

SecurityCenterMetadata::SecurityCenterMetadata(
    std::shared_ptr<SecurityCenterStub> child,
    std::multimap<std::string, std::string> fixed_metadata,
    std::string api_client_header)
    : child_(std::move(child)),
      fixed_metadata_(std::move(fixed_metadata)),
      api_client_header_(
          api_client_header.empty()
              ? google::cloud::internal::GeneratedLibClientHeader()
              : std::move(api_client_header)) {}

StatusOr<
    google::cloud::securitycenter::v2::BatchCreateResourceValueConfigsResponse>
SecurityCenterMetadata::BatchCreateResourceValueConfigs(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::
        BatchCreateResourceValueConfigsRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->BatchCreateResourceValueConfigs(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
SecurityCenterMetadata::AsyncBulkMuteFindings(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::securitycenter::v2::BulkMuteFindingsRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->AsyncBulkMuteFindings(cq, std::move(context),
                                       std::move(options), request);
}

StatusOr<google::longrunning::Operation>
SecurityCenterMetadata::BulkMuteFindings(
    grpc::ClientContext& context, Options options,
    google::cloud::securitycenter::v2::BulkMuteFindingsRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->BulkMuteFindings(context, options, request);
}

StatusOr<google::cloud::securitycenter::v2::BigQueryExport>
SecurityCenterMetadata::CreateBigQueryExport(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::CreateBigQueryExportRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->CreateBigQueryExport(context, options, request);
}

StatusOr<google::cloud::securitycenter::v2::Finding>
SecurityCenterMetadata::CreateFinding(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::CreateFindingRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->CreateFinding(context, options, request);
}

StatusOr<google::cloud::securitycenter::v2::MuteConfig>
SecurityCenterMetadata::CreateMuteConfig(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::CreateMuteConfigRequest const& request) {
  std::vector<std::string> params;
  params.reserve(1);

  static auto* location_matcher = [] {
    return new google::cloud::internal::RoutingMatcher<
        google::cloud::securitycenter::v2::CreateMuteConfigRequest>{
        "location=",
        {
            {[](google::cloud::securitycenter::v2::
                    CreateMuteConfigRequest const& request)
                 -> std::string const& { return request.parent(); },
             std::regex{"folders/[^/]+/locations/([^/]+)",
                        std::regex::optimize}},
            {[](google::cloud::securitycenter::v2::
                    CreateMuteConfigRequest const& request)
                 -> std::string const& { return request.parent(); },
             std::regex{"organizations/[^/]+/locations/([^/]+)",
                        std::regex::optimize}},
            {[](google::cloud::securitycenter::v2::
                    CreateMuteConfigRequest const& request)
                 -> std::string const& { return request.parent(); },
             std::regex{"projects/[^/]+/locations/([^/]+)",
                        std::regex::optimize}},
        }};
  }();
  location_matcher->AppendParam(request, params);

  if (params.empty()) {
    SetMetadata(context, options);
  } else {
    SetMetadata(context, options, absl::StrJoin(params, "&"));
  }
  return child_->CreateMuteConfig(context, options, request);
}

StatusOr<google::cloud::securitycenter::v2::NotificationConfig>
SecurityCenterMetadata::CreateNotificationConfig(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::CreateNotificationConfigRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->CreateNotificationConfig(context, options, request);
}

StatusOr<google::cloud::securitycenter::v2::Source>
SecurityCenterMetadata::CreateSource(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::CreateSourceRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->CreateSource(context, options, request);
}

Status SecurityCenterMetadata::DeleteBigQueryExport(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::DeleteBigQueryExportRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteBigQueryExport(context, options, request);
}

Status SecurityCenterMetadata::DeleteMuteConfig(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::DeleteMuteConfigRequest const& request) {
  std::vector<std::string> params;
  params.reserve(1);

  static auto* location_matcher = [] {
    return new google::cloud::internal::RoutingMatcher<
        google::cloud::securitycenter::v2::DeleteMuteConfigRequest>{
        "location=",
        {
            {[](google::cloud::securitycenter::v2::
                    DeleteMuteConfigRequest const& request)
                 -> std::string const& { return request.name(); },
             std::regex{"folders/[^/]+/locations/([^/]+)/muteConfigs/[^/]+",
                        std::regex::optimize}},
            {[](google::cloud::securitycenter::v2::
                    DeleteMuteConfigRequest const& request)
                 -> std::string const& { return request.name(); },
             std::regex{
                 "organizations/[^/]+/locations/([^/]+)/muteConfigs/[^/]+",
                 std::regex::optimize}},
            {[](google::cloud::securitycenter::v2::
                    DeleteMuteConfigRequest const& request)
                 -> std::string const& { return request.name(); },
             std::regex{"projects/[^/]+/locations/([^/]+)/muteConfigs/[^/]+",
                        std::regex::optimize}},
        }};
  }();
  location_matcher->AppendParam(request, params);

  if (params.empty()) {
    SetMetadata(context, options);
  } else {
    SetMetadata(context, options, absl::StrJoin(params, "&"));
  }
  return child_->DeleteMuteConfig(context, options, request);
}

Status SecurityCenterMetadata::DeleteNotificationConfig(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::DeleteNotificationConfigRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteNotificationConfig(context, options, request);
}

Status SecurityCenterMetadata::DeleteResourceValueConfig(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::DeleteResourceValueConfigRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteResourceValueConfig(context, options, request);
}

StatusOr<google::cloud::securitycenter::v2::BigQueryExport>
SecurityCenterMetadata::GetBigQueryExport(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::GetBigQueryExportRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetBigQueryExport(context, options, request);
}

StatusOr<google::cloud::securitycenter::v2::Simulation>
SecurityCenterMetadata::GetSimulation(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::GetSimulationRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetSimulation(context, options, request);
}

StatusOr<google::cloud::securitycenter::v2::ValuedResource>
SecurityCenterMetadata::GetValuedResource(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::GetValuedResourceRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetValuedResource(context, options, request);
}

StatusOr<google::iam::v1::Policy> SecurityCenterMetadata::GetIamPolicy(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::GetIamPolicyRequest const& request) {
  SetMetadata(
      context, options,
      absl::StrCat("resource=", internal::UrlEncode(request.resource())));
  return child_->GetIamPolicy(context, options, request);
}

StatusOr<google::cloud::securitycenter::v2::MuteConfig>
SecurityCenterMetadata::GetMuteConfig(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::GetMuteConfigRequest const& request) {
  std::vector<std::string> params;
  params.reserve(1);

  static auto* location_matcher = [] {
    return new google::cloud::internal::RoutingMatcher<
        google::cloud::securitycenter::v2::GetMuteConfigRequest>{
        "location=",
        {
            {[](google::cloud::securitycenter::v2::GetMuteConfigRequest const&
                    request) -> std::string const& { return request.name(); },
             std::regex{"folders/[^/]+/locations/([^/]+)/muteConfigs/[^/]+",
                        std::regex::optimize}},
            {[](google::cloud::securitycenter::v2::GetMuteConfigRequest const&
                    request) -> std::string const& { return request.name(); },
             std::regex{
                 "organizations/[^/]+/locations/([^/]+)/muteConfigs/[^/]+",
                 std::regex::optimize}},
            {[](google::cloud::securitycenter::v2::GetMuteConfigRequest const&
                    request) -> std::string const& { return request.name(); },
             std::regex{"projects/[^/]+/locations/([^/]+)/muteConfigs/[^/]+",
                        std::regex::optimize}},
        }};
  }();
  location_matcher->AppendParam(request, params);

  if (params.empty()) {
    SetMetadata(context, options);
  } else {
    SetMetadata(context, options, absl::StrJoin(params, "&"));
  }
  return child_->GetMuteConfig(context, options, request);
}

StatusOr<google::cloud::securitycenter::v2::NotificationConfig>
SecurityCenterMetadata::GetNotificationConfig(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::GetNotificationConfigRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetNotificationConfig(context, options, request);
}

StatusOr<google::cloud::securitycenter::v2::ResourceValueConfig>
SecurityCenterMetadata::GetResourceValueConfig(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::GetResourceValueConfigRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetResourceValueConfig(context, options, request);
}

StatusOr<google::cloud::securitycenter::v2::Source>
SecurityCenterMetadata::GetSource(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::GetSourceRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetSource(context, options, request);
}

StatusOr<google::cloud::securitycenter::v2::GroupFindingsResponse>
SecurityCenterMetadata::GroupFindings(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::GroupFindingsRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->GroupFindings(context, options, request);
}

StatusOr<google::cloud::securitycenter::v2::ListAttackPathsResponse>
SecurityCenterMetadata::ListAttackPaths(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::ListAttackPathsRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListAttackPaths(context, options, request);
}

StatusOr<google::cloud::securitycenter::v2::ListBigQueryExportsResponse>
SecurityCenterMetadata::ListBigQueryExports(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::ListBigQueryExportsRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListBigQueryExports(context, options, request);
}

StatusOr<google::cloud::securitycenter::v2::ListFindingsResponse>
SecurityCenterMetadata::ListFindings(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::ListFindingsRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListFindings(context, options, request);
}

StatusOr<google::cloud::securitycenter::v2::ListMuteConfigsResponse>
SecurityCenterMetadata::ListMuteConfigs(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::ListMuteConfigsRequest const& request) {
  std::vector<std::string> params;
  params.reserve(1);

  static auto* location_matcher = [] {
    return new google::cloud::internal::RoutingMatcher<
        google::cloud::securitycenter::v2::ListMuteConfigsRequest>{
        "location=",
        {
            {[](google::cloud::securitycenter::v2::ListMuteConfigsRequest const&
                    request) -> std::string const& { return request.parent(); },
             std::regex{"folders/[^/]+/locations/([^/]+)/muteConfigs",
                        std::regex::optimize}},
            {[](google::cloud::securitycenter::v2::ListMuteConfigsRequest const&
                    request) -> std::string const& { return request.parent(); },
             std::regex{"organizations/[^/]+/locations/([^/]+)/muteConfigs",
                        std::regex::optimize}},
            {[](google::cloud::securitycenter::v2::ListMuteConfigsRequest const&
                    request) -> std::string const& { return request.parent(); },
             std::regex{"projects/[^/]+/locations/([^/]+)/muteConfigs",
                        std::regex::optimize}},
        }};
  }();
  location_matcher->AppendParam(request, params);

  if (params.empty()) {
    SetMetadata(context, options);
  } else {
    SetMetadata(context, options, absl::StrJoin(params, "&"));
  }
  return child_->ListMuteConfigs(context, options, request);
}

StatusOr<google::cloud::securitycenter::v2::ListNotificationConfigsResponse>
SecurityCenterMetadata::ListNotificationConfigs(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::ListNotificationConfigsRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListNotificationConfigs(context, options, request);
}

StatusOr<google::cloud::securitycenter::v2::ListResourceValueConfigsResponse>
SecurityCenterMetadata::ListResourceValueConfigs(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::ListResourceValueConfigsRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListResourceValueConfigs(context, options, request);
}

StatusOr<google::cloud::securitycenter::v2::ListSourcesResponse>
SecurityCenterMetadata::ListSources(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::ListSourcesRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListSources(context, options, request);
}

StatusOr<google::cloud::securitycenter::v2::ListValuedResourcesResponse>
SecurityCenterMetadata::ListValuedResources(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::ListValuedResourcesRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListValuedResources(context, options, request);
}

StatusOr<google::cloud::securitycenter::v2::Finding>
SecurityCenterMetadata::SetFindingState(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::SetFindingStateRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->SetFindingState(context, options, request);
}

StatusOr<google::iam::v1::Policy> SecurityCenterMetadata::SetIamPolicy(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::SetIamPolicyRequest const& request) {
  SetMetadata(
      context, options,
      absl::StrCat("resource=", internal::UrlEncode(request.resource())));
  return child_->SetIamPolicy(context, options, request);
}

StatusOr<google::cloud::securitycenter::v2::Finding>
SecurityCenterMetadata::SetMute(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::SetMuteRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->SetMute(context, options, request);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
SecurityCenterMetadata::TestIamPermissions(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::TestIamPermissionsRequest const& request) {
  SetMetadata(
      context, options,
      absl::StrCat("resource=", internal::UrlEncode(request.resource())));
  return child_->TestIamPermissions(context, options, request);
}

StatusOr<google::cloud::securitycenter::v2::BigQueryExport>
SecurityCenterMetadata::UpdateBigQueryExport(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::UpdateBigQueryExportRequest const&
        request) {
  SetMetadata(
      context, options,
      absl::StrCat("big_query_export.name=",
                   internal::UrlEncode(request.big_query_export().name())));
  return child_->UpdateBigQueryExport(context, options, request);
}

StatusOr<google::cloud::securitycenter::v2::ExternalSystem>
SecurityCenterMetadata::UpdateExternalSystem(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::UpdateExternalSystemRequest const&
        request) {
  SetMetadata(
      context, options,
      absl::StrCat("external_system.name=",
                   internal::UrlEncode(request.external_system().name())));
  return child_->UpdateExternalSystem(context, options, request);
}

StatusOr<google::cloud::securitycenter::v2::Finding>
SecurityCenterMetadata::UpdateFinding(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::UpdateFindingRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("finding.name=",
                           internal::UrlEncode(request.finding().name())));
  return child_->UpdateFinding(context, options, request);
}

StatusOr<google::cloud::securitycenter::v2::MuteConfig>
SecurityCenterMetadata::UpdateMuteConfig(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::UpdateMuteConfigRequest const& request) {
  std::vector<std::string> params;
  params.reserve(1);

  static auto* location_matcher = [] {
    return new google::cloud::internal::RoutingMatcher<
        google::cloud::securitycenter::v2::UpdateMuteConfigRequest>{
        "location=",
        {
            {[](google::cloud::securitycenter::v2::
                    UpdateMuteConfigRequest const& request)
                 -> std::string const& { return request.mute_config().name(); },
             std::regex{"folders/[^/]+/locations/([^/]+)/muteConfigs/[^/]+",
                        std::regex::optimize}},
            {[](google::cloud::securitycenter::v2::
                    UpdateMuteConfigRequest const& request)
                 -> std::string const& { return request.mute_config().name(); },
             std::regex{
                 "organizations/[^/]+/locations/([^/]+)/muteConfigs/[^/]+",
                 std::regex::optimize}},
            {[](google::cloud::securitycenter::v2::
                    UpdateMuteConfigRequest const& request)
                 -> std::string const& { return request.mute_config().name(); },
             std::regex{"projects/[^/]+/locations/([^/]+)/muteConfigs/[^/]+",
                        std::regex::optimize}},
        }};
  }();
  location_matcher->AppendParam(request, params);

  if (params.empty()) {
    SetMetadata(context, options);
  } else {
    SetMetadata(context, options, absl::StrJoin(params, "&"));
  }
  return child_->UpdateMuteConfig(context, options, request);
}

StatusOr<google::cloud::securitycenter::v2::NotificationConfig>
SecurityCenterMetadata::UpdateNotificationConfig(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::UpdateNotificationConfigRequest const&
        request) {
  SetMetadata(
      context, options,
      absl::StrCat("notification_config.name=",
                   internal::UrlEncode(request.notification_config().name())));
  return child_->UpdateNotificationConfig(context, options, request);
}

StatusOr<google::cloud::securitycenter::v2::ResourceValueConfig>
SecurityCenterMetadata::UpdateResourceValueConfig(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::UpdateResourceValueConfigRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat(
                  "resource_value_config.name=",
                  internal::UrlEncode(request.resource_value_config().name())));
  return child_->UpdateResourceValueConfig(context, options, request);
}

StatusOr<google::cloud::securitycenter::v2::SecurityMarks>
SecurityCenterMetadata::UpdateSecurityMarks(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::UpdateSecurityMarksRequest const&
        request) {
  SetMetadata(
      context, options,
      absl::StrCat("security_marks.name=",
                   internal::UrlEncode(request.security_marks().name())));
  return child_->UpdateSecurityMarks(context, options, request);
}

StatusOr<google::cloud::securitycenter::v2::Source>
SecurityCenterMetadata::UpdateSource(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::UpdateSourceRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("source.name=",
                           internal::UrlEncode(request.source().name())));
  return child_->UpdateSource(context, options, request);
}

StatusOr<google::longrunning::ListOperationsResponse>
SecurityCenterMetadata::ListOperations(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::ListOperationsRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->ListOperations(context, options, request);
}

StatusOr<google::longrunning::Operation> SecurityCenterMetadata::GetOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::GetOperationRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetOperation(context, options, request);
}

Status SecurityCenterMetadata::DeleteOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::DeleteOperationRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteOperation(context, options, request);
}

Status SecurityCenterMetadata::CancelOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::CancelOperationRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->CancelOperation(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
SecurityCenterMetadata::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncGetOperation(cq, std::move(context), std::move(options),
                                   request);
}

future<Status> SecurityCenterMetadata::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncCancelOperation(cq, std::move(context),
                                      std::move(options), request);
}

void SecurityCenterMetadata::SetMetadata(grpc::ClientContext& context,
                                         Options const& options,
                                         std::string const& request_params) {
  context.AddMetadata("x-goog-request-params", request_params);
  SetMetadata(context, options);
}

void SecurityCenterMetadata::SetMetadata(grpc::ClientContext& context,
                                         Options const& options) {
  google::cloud::internal::SetMetadata(context, options, fixed_metadata_,
                                       api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace securitycenter_v2_internal
}  // namespace cloud
}  // namespace google
