// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/securitycenter/v2/securitycenter_service.proto

#include "google/cloud/securitycenter/v2/internal/security_center_logging_decorator.h"
#include "google/cloud/internal/log_wrapper.h"
#include "google/cloud/status_or.h"
#include <google/cloud/securitycenter/v2/securitycenter_service.grpc.pb.h>
#include <memory>
#include <set>
#include <string>
#include <utility>

namespace google {
namespace cloud {
namespace securitycenter_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

SecurityCenterLogging::SecurityCenterLogging(
    std::shared_ptr<SecurityCenterStub> child, TracingOptions tracing_options,
    std::set<std::string> const&)
    : child_(std::move(child)), tracing_options_(std::move(tracing_options)) {}

StatusOr<
    google::cloud::securitycenter::v2::BatchCreateResourceValueConfigsResponse>
SecurityCenterLogging::BatchCreateResourceValueConfigs(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::
        BatchCreateResourceValueConfigsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::securitycenter::v2::
                 BatchCreateResourceValueConfigsRequest const& request) {
        return child_->BatchCreateResourceValueConfigs(context, options,
                                                       request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
SecurityCenterLogging::AsyncBulkMuteFindings(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::securitycenter::v2::BulkMuteFindingsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::securitycenter::v2::BulkMuteFindingsRequest const&
                 request) {
        return child_->AsyncBulkMuteFindings(cq, std::move(context),
                                             std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
SecurityCenterLogging::BulkMuteFindings(
    grpc::ClientContext& context, Options options,
    google::cloud::securitycenter::v2::BulkMuteFindingsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::securitycenter::v2::BulkMuteFindingsRequest const&
                 request) {
        return child_->BulkMuteFindings(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::securitycenter::v2::BigQueryExport>
SecurityCenterLogging::CreateBigQueryExport(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::CreateBigQueryExportRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::securitycenter::v2::CreateBigQueryExportRequest const&
              request) {
        return child_->CreateBigQueryExport(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::securitycenter::v2::Finding>
SecurityCenterLogging::CreateFinding(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::CreateFindingRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::securitycenter::v2::CreateFindingRequest const&
                 request) {
        return child_->CreateFinding(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::securitycenter::v2::MuteConfig>
SecurityCenterLogging::CreateMuteConfig(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::CreateMuteConfigRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::securitycenter::v2::CreateMuteConfigRequest const&
                 request) {
        return child_->CreateMuteConfig(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::securitycenter::v2::NotificationConfig>
SecurityCenterLogging::CreateNotificationConfig(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::CreateNotificationConfigRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::securitycenter::v2::
                 CreateNotificationConfigRequest const& request) {
        return child_->CreateNotificationConfig(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::securitycenter::v2::Source>
SecurityCenterLogging::CreateSource(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::CreateSourceRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::securitycenter::v2::CreateSourceRequest const&
                 request) {
        return child_->CreateSource(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

Status SecurityCenterLogging::DeleteBigQueryExport(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::DeleteBigQueryExportRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::securitycenter::v2::DeleteBigQueryExportRequest const&
              request) {
        return child_->DeleteBigQueryExport(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

Status SecurityCenterLogging::DeleteMuteConfig(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::DeleteMuteConfigRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::securitycenter::v2::DeleteMuteConfigRequest const&
                 request) {
        return child_->DeleteMuteConfig(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

Status SecurityCenterLogging::DeleteNotificationConfig(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::DeleteNotificationConfigRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::securitycenter::v2::
                 DeleteNotificationConfigRequest const& request) {
        return child_->DeleteNotificationConfig(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

Status SecurityCenterLogging::DeleteResourceValueConfig(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::DeleteResourceValueConfigRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::securitycenter::v2::
                 DeleteResourceValueConfigRequest const& request) {
        return child_->DeleteResourceValueConfig(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::securitycenter::v2::BigQueryExport>
SecurityCenterLogging::GetBigQueryExport(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::GetBigQueryExportRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::securitycenter::v2::GetBigQueryExportRequest const&
                 request) {
        return child_->GetBigQueryExport(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::securitycenter::v2::Simulation>
SecurityCenterLogging::GetSimulation(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::GetSimulationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::securitycenter::v2::GetSimulationRequest const&
                 request) {
        return child_->GetSimulation(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::securitycenter::v2::ValuedResource>
SecurityCenterLogging::GetValuedResource(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::GetValuedResourceRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::securitycenter::v2::GetValuedResourceRequest const&
                 request) {
        return child_->GetValuedResource(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::iam::v1::Policy> SecurityCenterLogging::GetIamPolicy(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::GetIamPolicyRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::iam::v1::GetIamPolicyRequest const& request) {
        return child_->GetIamPolicy(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::securitycenter::v2::MuteConfig>
SecurityCenterLogging::GetMuteConfig(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::GetMuteConfigRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::securitycenter::v2::GetMuteConfigRequest const&
                 request) {
        return child_->GetMuteConfig(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::securitycenter::v2::NotificationConfig>
SecurityCenterLogging::GetNotificationConfig(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::GetNotificationConfigRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::securitycenter::v2::GetNotificationConfigRequest const&
              request) {
        return child_->GetNotificationConfig(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::securitycenter::v2::ResourceValueConfig>
SecurityCenterLogging::GetResourceValueConfig(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::GetResourceValueConfigRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::securitycenter::v2::
                 GetResourceValueConfigRequest const& request) {
        return child_->GetResourceValueConfig(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::securitycenter::v2::Source>
SecurityCenterLogging::GetSource(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::GetSourceRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::securitycenter::v2::GetSourceRequest const& request) {
        return child_->GetSource(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::securitycenter::v2::GroupFindingsResponse>
SecurityCenterLogging::GroupFindings(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::GroupFindingsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::securitycenter::v2::GroupFindingsRequest const&
                 request) {
        return child_->GroupFindings(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::securitycenter::v2::ListAttackPathsResponse>
SecurityCenterLogging::ListAttackPaths(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::ListAttackPathsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::securitycenter::v2::ListAttackPathsRequest const&
                 request) {
        return child_->ListAttackPaths(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::securitycenter::v2::ListBigQueryExportsResponse>
SecurityCenterLogging::ListBigQueryExports(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::ListBigQueryExportsRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::securitycenter::v2::ListBigQueryExportsRequest const&
              request) {
        return child_->ListBigQueryExports(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::securitycenter::v2::ListFindingsResponse>
SecurityCenterLogging::ListFindings(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::ListFindingsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::securitycenter::v2::ListFindingsRequest const&
                 request) {
        return child_->ListFindings(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::securitycenter::v2::ListMuteConfigsResponse>
SecurityCenterLogging::ListMuteConfigs(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::ListMuteConfigsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::securitycenter::v2::ListMuteConfigsRequest const&
                 request) {
        return child_->ListMuteConfigs(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::securitycenter::v2::ListNotificationConfigsResponse>
SecurityCenterLogging::ListNotificationConfigs(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::ListNotificationConfigsRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::securitycenter::v2::
                 ListNotificationConfigsRequest const& request) {
        return child_->ListNotificationConfigs(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::securitycenter::v2::ListResourceValueConfigsResponse>
SecurityCenterLogging::ListResourceValueConfigs(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::ListResourceValueConfigsRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::securitycenter::v2::
                 ListResourceValueConfigsRequest const& request) {
        return child_->ListResourceValueConfigs(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::securitycenter::v2::ListSourcesResponse>
SecurityCenterLogging::ListSources(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::ListSourcesRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::securitycenter::v2::ListSourcesRequest const&
                 request) {
        return child_->ListSources(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::securitycenter::v2::ListValuedResourcesResponse>
SecurityCenterLogging::ListValuedResources(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::ListValuedResourcesRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::securitycenter::v2::ListValuedResourcesRequest const&
              request) {
        return child_->ListValuedResources(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::securitycenter::v2::Finding>
SecurityCenterLogging::SetFindingState(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::SetFindingStateRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::securitycenter::v2::SetFindingStateRequest const&
                 request) {
        return child_->SetFindingState(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::iam::v1::Policy> SecurityCenterLogging::SetIamPolicy(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::SetIamPolicyRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::iam::v1::SetIamPolicyRequest const& request) {
        return child_->SetIamPolicy(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::securitycenter::v2::Finding>
SecurityCenterLogging::SetMute(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::SetMuteRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::securitycenter::v2::SetMuteRequest const& request) {
        return child_->SetMute(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
SecurityCenterLogging::TestIamPermissions(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::TestIamPermissionsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::iam::v1::TestIamPermissionsRequest const& request) {
        return child_->TestIamPermissions(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::securitycenter::v2::BigQueryExport>
SecurityCenterLogging::UpdateBigQueryExport(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::UpdateBigQueryExportRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::securitycenter::v2::UpdateBigQueryExportRequest const&
              request) {
        return child_->UpdateBigQueryExport(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::securitycenter::v2::ExternalSystem>
SecurityCenterLogging::UpdateExternalSystem(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::UpdateExternalSystemRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::securitycenter::v2::UpdateExternalSystemRequest const&
              request) {
        return child_->UpdateExternalSystem(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::securitycenter::v2::Finding>
SecurityCenterLogging::UpdateFinding(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::UpdateFindingRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::securitycenter::v2::UpdateFindingRequest const&
                 request) {
        return child_->UpdateFinding(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::securitycenter::v2::MuteConfig>
SecurityCenterLogging::UpdateMuteConfig(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::UpdateMuteConfigRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::securitycenter::v2::UpdateMuteConfigRequest const&
                 request) {
        return child_->UpdateMuteConfig(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::securitycenter::v2::NotificationConfig>
SecurityCenterLogging::UpdateNotificationConfig(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::UpdateNotificationConfigRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::securitycenter::v2::
                 UpdateNotificationConfigRequest const& request) {
        return child_->UpdateNotificationConfig(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::securitycenter::v2::ResourceValueConfig>
SecurityCenterLogging::UpdateResourceValueConfig(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::UpdateResourceValueConfigRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::securitycenter::v2::
                 UpdateResourceValueConfigRequest const& request) {
        return child_->UpdateResourceValueConfig(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::securitycenter::v2::SecurityMarks>
SecurityCenterLogging::UpdateSecurityMarks(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::UpdateSecurityMarksRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::securitycenter::v2::UpdateSecurityMarksRequest const&
              request) {
        return child_->UpdateSecurityMarks(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::securitycenter::v2::Source>
SecurityCenterLogging::UpdateSource(
    grpc::ClientContext& context, Options const& options,
    google::cloud::securitycenter::v2::UpdateSourceRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::securitycenter::v2::UpdateSourceRequest const&
                 request) {
        return child_->UpdateSource(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::longrunning::ListOperationsResponse>
SecurityCenterLogging::ListOperations(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::ListOperationsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::longrunning::ListOperationsRequest const& request) {
        return child_->ListOperations(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::longrunning::Operation> SecurityCenterLogging::GetOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::GetOperationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::longrunning::GetOperationRequest const& request) {
        return child_->GetOperation(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

Status SecurityCenterLogging::DeleteOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::DeleteOperationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::longrunning::DeleteOperationRequest const& request) {
        return child_->DeleteOperation(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

Status SecurityCenterLogging::CancelOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::CancelOperationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::longrunning::CancelOperationRequest const& request) {
        return child_->CancelOperation(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
SecurityCenterLogging::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::longrunning::GetOperationRequest const& request) {
        return child_->AsyncGetOperation(cq, std::move(context),
                                         std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

future<Status> SecurityCenterLogging::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::longrunning::CancelOperationRequest const& request) {
        return child_->AsyncCancelOperation(cq, std::move(context),
                                            std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace securitycenter_v2_internal
}  // namespace cloud
}  // namespace google
