// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/secretmanager/v1/service.proto

#include "google/cloud/secretmanager/v1/secret_manager_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace secretmanager_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

SecretManagerServiceConnectionIdempotencyPolicy::
    ~SecretManagerServiceConnectionIdempotencyPolicy() = default;

std::unique_ptr<SecretManagerServiceConnectionIdempotencyPolicy>
SecretManagerServiceConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<SecretManagerServiceConnectionIdempotencyPolicy>(
      *this);
}

Idempotency SecretManagerServiceConnectionIdempotencyPolicy::ListSecrets(
    google::cloud::secretmanager::v1::ListSecretsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency SecretManagerServiceConnectionIdempotencyPolicy::CreateSecret(
    google::cloud::secretmanager::v1::CreateSecretRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SecretManagerServiceConnectionIdempotencyPolicy::AddSecretVersion(
    google::cloud::secretmanager::v1::AddSecretVersionRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SecretManagerServiceConnectionIdempotencyPolicy::GetSecret(
    google::cloud::secretmanager::v1::GetSecretRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency SecretManagerServiceConnectionIdempotencyPolicy::UpdateSecret(
    google::cloud::secretmanager::v1::UpdateSecretRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SecretManagerServiceConnectionIdempotencyPolicy::DeleteSecret(
    google::cloud::secretmanager::v1::DeleteSecretRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SecretManagerServiceConnectionIdempotencyPolicy::ListSecretVersions(
    google::cloud::secretmanager::v1::ListSecretVersionsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency SecretManagerServiceConnectionIdempotencyPolicy::GetSecretVersion(
    google::cloud::secretmanager::v1::GetSecretVersionRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency
SecretManagerServiceConnectionIdempotencyPolicy::AccessSecretVersion(
    google::cloud::secretmanager::v1::AccessSecretVersionRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency
SecretManagerServiceConnectionIdempotencyPolicy::DisableSecretVersion(
    google::cloud::secretmanager::v1::DisableSecretVersionRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
SecretManagerServiceConnectionIdempotencyPolicy::EnableSecretVersion(
    google::cloud::secretmanager::v1::EnableSecretVersionRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
SecretManagerServiceConnectionIdempotencyPolicy::DestroySecretVersion(
    google::cloud::secretmanager::v1::DestroySecretVersionRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SecretManagerServiceConnectionIdempotencyPolicy::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request) {
  return request.policy().etag().empty() ? Idempotency::kNonIdempotent
                                         : Idempotency::kIdempotent;
}

Idempotency SecretManagerServiceConnectionIdempotencyPolicy::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency SecretManagerServiceConnectionIdempotencyPolicy::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency SecretManagerServiceConnectionIdempotencyPolicy::ListLocations(
    google::cloud::location::ListLocationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency SecretManagerServiceConnectionIdempotencyPolicy::GetLocation(
    google::cloud::location::GetLocationRequest const&) {
  return Idempotency::kIdempotent;
}

std::unique_ptr<SecretManagerServiceConnectionIdempotencyPolicy>
MakeDefaultSecretManagerServiceConnectionIdempotencyPolicy() {
  return std::make_unique<SecretManagerServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace secretmanager_v1
}  // namespace cloud
}  // namespace google
