// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/secretmanager/v1/service.proto

#include "google/cloud/secretmanager/v1/internal/secret_manager_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace secretmanager_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

SecretManagerServiceTracingConnection::SecretManagerServiceTracingConnection(
    std::shared_ptr<secretmanager_v1::SecretManagerServiceConnection> child)
    : child_(std::move(child)) {}

StreamRange<google::cloud::secretmanager::v1::Secret>
SecretManagerServiceTracingConnection::ListSecrets(
    google::cloud::secretmanager::v1::ListSecretsRequest request) {
  auto span = internal::MakeSpan(
      "secretmanager_v1::SecretManagerServiceConnection::ListSecrets");
  internal::OTelScope scope(span);
  auto sr = child_->ListSecrets(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::secretmanager::v1::Secret>(std::move(span), std::move(sr));
}

StatusOr<google::cloud::secretmanager::v1::Secret>
SecretManagerServiceTracingConnection::CreateSecret(
    google::cloud::secretmanager::v1::CreateSecretRequest const& request) {
  auto span = internal::MakeSpan(
      "secretmanager_v1::SecretManagerServiceConnection::CreateSecret");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateSecret(request));
}

StatusOr<google::cloud::secretmanager::v1::SecretVersion>
SecretManagerServiceTracingConnection::AddSecretVersion(
    google::cloud::secretmanager::v1::AddSecretVersionRequest const& request) {
  auto span = internal::MakeSpan(
      "secretmanager_v1::SecretManagerServiceConnection::AddSecretVersion");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->AddSecretVersion(request));
}

StatusOr<google::cloud::secretmanager::v1::Secret>
SecretManagerServiceTracingConnection::GetSecret(
    google::cloud::secretmanager::v1::GetSecretRequest const& request) {
  auto span = internal::MakeSpan(
      "secretmanager_v1::SecretManagerServiceConnection::GetSecret");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetSecret(request));
}

StatusOr<google::cloud::secretmanager::v1::Secret>
SecretManagerServiceTracingConnection::UpdateSecret(
    google::cloud::secretmanager::v1::UpdateSecretRequest const& request) {
  auto span = internal::MakeSpan(
      "secretmanager_v1::SecretManagerServiceConnection::UpdateSecret");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateSecret(request));
}

Status SecretManagerServiceTracingConnection::DeleteSecret(
    google::cloud::secretmanager::v1::DeleteSecretRequest const& request) {
  auto span = internal::MakeSpan(
      "secretmanager_v1::SecretManagerServiceConnection::DeleteSecret");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteSecret(request));
}

StreamRange<google::cloud::secretmanager::v1::SecretVersion>
SecretManagerServiceTracingConnection::ListSecretVersions(
    google::cloud::secretmanager::v1::ListSecretVersionsRequest request) {
  auto span = internal::MakeSpan(
      "secretmanager_v1::SecretManagerServiceConnection::ListSecretVersions");
  internal::OTelScope scope(span);
  auto sr = child_->ListSecretVersions(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::secretmanager::v1::SecretVersion>(std::move(span),
                                                       std::move(sr));
}

StatusOr<google::cloud::secretmanager::v1::SecretVersion>
SecretManagerServiceTracingConnection::GetSecretVersion(
    google::cloud::secretmanager::v1::GetSecretVersionRequest const& request) {
  auto span = internal::MakeSpan(
      "secretmanager_v1::SecretManagerServiceConnection::GetSecretVersion");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetSecretVersion(request));
}

StatusOr<google::cloud::secretmanager::v1::AccessSecretVersionResponse>
SecretManagerServiceTracingConnection::AccessSecretVersion(
    google::cloud::secretmanager::v1::AccessSecretVersionRequest const&
        request) {
  auto span = internal::MakeSpan(
      "secretmanager_v1::SecretManagerServiceConnection::AccessSecretVersion");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->AccessSecretVersion(request));
}

StatusOr<google::cloud::secretmanager::v1::SecretVersion>
SecretManagerServiceTracingConnection::DisableSecretVersion(
    google::cloud::secretmanager::v1::DisableSecretVersionRequest const&
        request) {
  auto span = internal::MakeSpan(
      "secretmanager_v1::SecretManagerServiceConnection::DisableSecretVersion");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DisableSecretVersion(request));
}

StatusOr<google::cloud::secretmanager::v1::SecretVersion>
SecretManagerServiceTracingConnection::EnableSecretVersion(
    google::cloud::secretmanager::v1::EnableSecretVersionRequest const&
        request) {
  auto span = internal::MakeSpan(
      "secretmanager_v1::SecretManagerServiceConnection::EnableSecretVersion");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->EnableSecretVersion(request));
}

StatusOr<google::cloud::secretmanager::v1::SecretVersion>
SecretManagerServiceTracingConnection::DestroySecretVersion(
    google::cloud::secretmanager::v1::DestroySecretVersionRequest const&
        request) {
  auto span = internal::MakeSpan(
      "secretmanager_v1::SecretManagerServiceConnection::DestroySecretVersion");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DestroySecretVersion(request));
}

StatusOr<google::iam::v1::Policy>
SecretManagerServiceTracingConnection::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request) {
  auto span = internal::MakeSpan(
      "secretmanager_v1::SecretManagerServiceConnection::SetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->SetIamPolicy(request));
}

StatusOr<google::iam::v1::Policy>
SecretManagerServiceTracingConnection::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const& request) {
  auto span = internal::MakeSpan(
      "secretmanager_v1::SecretManagerServiceConnection::GetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetIamPolicy(request));
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
SecretManagerServiceTracingConnection::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const& request) {
  auto span = internal::MakeSpan(
      "secretmanager_v1::SecretManagerServiceConnection::TestIamPermissions");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->TestIamPermissions(request));
}

StreamRange<google::cloud::location::Location>
SecretManagerServiceTracingConnection::ListLocations(
    google::cloud::location::ListLocationsRequest request) {
  auto span = internal::MakeSpan(
      "secretmanager_v1::SecretManagerServiceConnection::ListLocations");
  internal::OTelScope scope(span);
  auto sr = child_->ListLocations(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::location::Location>(
      std::move(span), std::move(sr));
}

StatusOr<google::cloud::location::Location>
SecretManagerServiceTracingConnection::GetLocation(
    google::cloud::location::GetLocationRequest const& request) {
  auto span = internal::MakeSpan(
      "secretmanager_v1::SecretManagerServiceConnection::GetLocation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetLocation(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<secretmanager_v1::SecretManagerServiceConnection>
MakeSecretManagerServiceTracingConnection(
    std::shared_ptr<secretmanager_v1::SecretManagerServiceConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<SecretManagerServiceTracingConnection>(
        std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace secretmanager_v1_internal
}  // namespace cloud
}  // namespace google
