// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/secretmanager/v1/service.proto

#include "google/cloud/secretmanager/v1/internal/secret_manager_metadata_decorator.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/absl_str_cat_quiet.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/internal/url_encode.h"
#include "google/cloud/status_or.h"
#include <google/cloud/secretmanager/v1/service.grpc.pb.h>
#include <memory>
#include <string>
#include <utility>
#include <vector>

namespace google {
namespace cloud {
namespace secretmanager_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

SecretManagerServiceMetadata::SecretManagerServiceMetadata(
    std::shared_ptr<SecretManagerServiceStub> child,
    std::multimap<std::string, std::string> fixed_metadata,
    std::string api_client_header)
    : child_(std::move(child)),
      fixed_metadata_(std::move(fixed_metadata)),
      api_client_header_(
          api_client_header.empty()
              ? google::cloud::internal::GeneratedLibClientHeader()
              : std::move(api_client_header)) {}

StatusOr<google::cloud::secretmanager::v1::ListSecretsResponse>
SecretManagerServiceMetadata::ListSecrets(
    grpc::ClientContext& context, Options const& options,
    google::cloud::secretmanager::v1::ListSecretsRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListSecrets(context, options, request);
}

StatusOr<google::cloud::secretmanager::v1::Secret>
SecretManagerServiceMetadata::CreateSecret(
    grpc::ClientContext& context, Options const& options,
    google::cloud::secretmanager::v1::CreateSecretRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->CreateSecret(context, options, request);
}

StatusOr<google::cloud::secretmanager::v1::SecretVersion>
SecretManagerServiceMetadata::AddSecretVersion(
    grpc::ClientContext& context, Options const& options,
    google::cloud::secretmanager::v1::AddSecretVersionRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->AddSecretVersion(context, options, request);
}

StatusOr<google::cloud::secretmanager::v1::Secret>
SecretManagerServiceMetadata::GetSecret(
    grpc::ClientContext& context, Options const& options,
    google::cloud::secretmanager::v1::GetSecretRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetSecret(context, options, request);
}

StatusOr<google::cloud::secretmanager::v1::Secret>
SecretManagerServiceMetadata::UpdateSecret(
    grpc::ClientContext& context, Options const& options,
    google::cloud::secretmanager::v1::UpdateSecretRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("secret.name=",
                           internal::UrlEncode(request.secret().name())));
  return child_->UpdateSecret(context, options, request);
}

Status SecretManagerServiceMetadata::DeleteSecret(
    grpc::ClientContext& context, Options const& options,
    google::cloud::secretmanager::v1::DeleteSecretRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteSecret(context, options, request);
}

StatusOr<google::cloud::secretmanager::v1::ListSecretVersionsResponse>
SecretManagerServiceMetadata::ListSecretVersions(
    grpc::ClientContext& context, Options const& options,
    google::cloud::secretmanager::v1::ListSecretVersionsRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListSecretVersions(context, options, request);
}

StatusOr<google::cloud::secretmanager::v1::SecretVersion>
SecretManagerServiceMetadata::GetSecretVersion(
    grpc::ClientContext& context, Options const& options,
    google::cloud::secretmanager::v1::GetSecretVersionRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetSecretVersion(context, options, request);
}

StatusOr<google::cloud::secretmanager::v1::AccessSecretVersionResponse>
SecretManagerServiceMetadata::AccessSecretVersion(
    grpc::ClientContext& context, Options const& options,
    google::cloud::secretmanager::v1::AccessSecretVersionRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AccessSecretVersion(context, options, request);
}

StatusOr<google::cloud::secretmanager::v1::SecretVersion>
SecretManagerServiceMetadata::DisableSecretVersion(
    grpc::ClientContext& context, Options const& options,
    google::cloud::secretmanager::v1::DisableSecretVersionRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DisableSecretVersion(context, options, request);
}

StatusOr<google::cloud::secretmanager::v1::SecretVersion>
SecretManagerServiceMetadata::EnableSecretVersion(
    grpc::ClientContext& context, Options const& options,
    google::cloud::secretmanager::v1::EnableSecretVersionRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->EnableSecretVersion(context, options, request);
}

StatusOr<google::cloud::secretmanager::v1::SecretVersion>
SecretManagerServiceMetadata::DestroySecretVersion(
    grpc::ClientContext& context, Options const& options,
    google::cloud::secretmanager::v1::DestroySecretVersionRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DestroySecretVersion(context, options, request);
}

StatusOr<google::iam::v1::Policy> SecretManagerServiceMetadata::SetIamPolicy(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::SetIamPolicyRequest const& request) {
  SetMetadata(
      context, options,
      absl::StrCat("resource=", internal::UrlEncode(request.resource())));
  return child_->SetIamPolicy(context, options, request);
}

StatusOr<google::iam::v1::Policy> SecretManagerServiceMetadata::GetIamPolicy(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::GetIamPolicyRequest const& request) {
  SetMetadata(
      context, options,
      absl::StrCat("resource=", internal::UrlEncode(request.resource())));
  return child_->GetIamPolicy(context, options, request);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
SecretManagerServiceMetadata::TestIamPermissions(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::TestIamPermissionsRequest const& request) {
  SetMetadata(
      context, options,
      absl::StrCat("resource=", internal::UrlEncode(request.resource())));
  return child_->TestIamPermissions(context, options, request);
}

StatusOr<google::cloud::location::ListLocationsResponse>
SecretManagerServiceMetadata::ListLocations(
    grpc::ClientContext& context, Options const& options,
    google::cloud::location::ListLocationsRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->ListLocations(context, options, request);
}

StatusOr<google::cloud::location::Location>
SecretManagerServiceMetadata::GetLocation(
    grpc::ClientContext& context, Options const& options,
    google::cloud::location::GetLocationRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetLocation(context, options, request);
}

void SecretManagerServiceMetadata::SetMetadata(
    grpc::ClientContext& context, Options const& options,
    std::string const& request_params) {
  context.AddMetadata("x-goog-request-params", request_params);
  SetMetadata(context, options);
}

void SecretManagerServiceMetadata::SetMetadata(grpc::ClientContext& context,
                                               Options const& options) {
  google::cloud::internal::SetMetadata(context, options, fixed_metadata_,
                                       api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace secretmanager_v1_internal
}  // namespace cloud
}  // namespace google
