// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/scheduler/v1/cloudscheduler.proto

#include "google/cloud/scheduler/v1/internal/cloud_scheduler_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace scheduler_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

CloudSchedulerTracingStub::CloudSchedulerTracingStub(
    std::shared_ptr<CloudSchedulerStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::cloud::scheduler::v1::ListJobsResponse>
CloudSchedulerTracingStub::ListJobs(
    grpc::ClientContext& context, Options const& options,
    google::cloud::scheduler::v1::ListJobsRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.scheduler.v1.CloudScheduler",
                                     "ListJobs");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListJobs(context, options, request));
}

StatusOr<google::cloud::scheduler::v1::Job> CloudSchedulerTracingStub::GetJob(
    grpc::ClientContext& context, Options const& options,
    google::cloud::scheduler::v1::GetJobRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.scheduler.v1.CloudScheduler",
                                     "GetJob");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetJob(context, options, request));
}

StatusOr<google::cloud::scheduler::v1::Job>
CloudSchedulerTracingStub::CreateJob(
    grpc::ClientContext& context, Options const& options,
    google::cloud::scheduler::v1::CreateJobRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.scheduler.v1.CloudScheduler",
                                     "CreateJob");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateJob(context, options, request));
}

StatusOr<google::cloud::scheduler::v1::Job>
CloudSchedulerTracingStub::UpdateJob(
    grpc::ClientContext& context, Options const& options,
    google::cloud::scheduler::v1::UpdateJobRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.scheduler.v1.CloudScheduler",
                                     "UpdateJob");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateJob(context, options, request));
}

Status CloudSchedulerTracingStub::DeleteJob(
    grpc::ClientContext& context, Options const& options,
    google::cloud::scheduler::v1::DeleteJobRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.scheduler.v1.CloudScheduler",
                                     "DeleteJob");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteJob(context, options, request));
}

StatusOr<google::cloud::scheduler::v1::Job> CloudSchedulerTracingStub::PauseJob(
    grpc::ClientContext& context, Options const& options,
    google::cloud::scheduler::v1::PauseJobRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.scheduler.v1.CloudScheduler",
                                     "PauseJob");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->PauseJob(context, options, request));
}

StatusOr<google::cloud::scheduler::v1::Job>
CloudSchedulerTracingStub::ResumeJob(
    grpc::ClientContext& context, Options const& options,
    google::cloud::scheduler::v1::ResumeJobRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.scheduler.v1.CloudScheduler",
                                     "ResumeJob");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ResumeJob(context, options, request));
}

StatusOr<google::cloud::scheduler::v1::Job> CloudSchedulerTracingStub::RunJob(
    grpc::ClientContext& context, Options const& options,
    google::cloud::scheduler::v1::RunJobRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.scheduler.v1.CloudScheduler",
                                     "RunJob");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->RunJob(context, options, request));
}

StatusOr<google::cloud::location::ListLocationsResponse>
CloudSchedulerTracingStub::ListLocations(
    grpc::ClientContext& context, Options const& options,
    google::cloud::location::ListLocationsRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.scheduler.v1.CloudScheduler",
                                     "ListLocations");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListLocations(context, options, request));
}

StatusOr<google::cloud::location::Location>
CloudSchedulerTracingStub::GetLocation(
    grpc::ClientContext& context, Options const& options,
    google::cloud::location::GetLocationRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.scheduler.v1.CloudScheduler",
                                     "GetLocation");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetLocation(context, options, request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<CloudSchedulerStub> MakeCloudSchedulerTracingStub(
    std::shared_ptr<CloudSchedulerStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<CloudSchedulerTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace scheduler_v1_internal
}  // namespace cloud
}  // namespace google
