// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/scheduler/v1/cloudscheduler.proto

#include "google/cloud/scheduler/v1/internal/cloud_scheduler_connection_impl.h"
#include "google/cloud/scheduler/v1/internal/cloud_scheduler_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace scheduler_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<scheduler_v1::CloudSchedulerRetryPolicy> retry_policy(
    Options const& options) {
  return options.get<scheduler_v1::CloudSchedulerRetryPolicyOption>()->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options.get<scheduler_v1::CloudSchedulerBackoffPolicyOption>()
      ->clone();
}

std::unique_ptr<scheduler_v1::CloudSchedulerConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options
      .get<scheduler_v1::CloudSchedulerConnectionIdempotencyPolicyOption>()
      ->clone();
}

}  // namespace

CloudSchedulerConnectionImpl::CloudSchedulerConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<scheduler_v1_internal::CloudSchedulerStub> stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(std::move(options),
                                      CloudSchedulerConnection::options())) {}

StreamRange<google::cloud::scheduler::v1::Job>
CloudSchedulerConnectionImpl::ListJobs(
    google::cloud::scheduler::v1::ListJobsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListJobs(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::scheduler::v1::Job>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<scheduler_v1::CloudSchedulerRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::scheduler::v1::ListJobsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context, Options const& options,
                google::cloud::scheduler::v1::ListJobsRequest const& request) {
              return stub->ListJobs(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::scheduler::v1::ListJobsResponse r) {
        std::vector<google::cloud::scheduler::v1::Job> result(r.jobs().size());
        auto& messages = *r.mutable_jobs();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::scheduler::v1::Job>
CloudSchedulerConnectionImpl::GetJob(
    google::cloud::scheduler::v1::GetJobRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetJob(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::scheduler::v1::GetJobRequest const& request) {
        return stub_->GetJob(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::scheduler::v1::Job>
CloudSchedulerConnectionImpl::CreateJob(
    google::cloud::scheduler::v1::CreateJobRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateJob(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::scheduler::v1::CreateJobRequest const& request) {
        return stub_->CreateJob(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::scheduler::v1::Job>
CloudSchedulerConnectionImpl::UpdateJob(
    google::cloud::scheduler::v1::UpdateJobRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateJob(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::scheduler::v1::UpdateJobRequest const& request) {
        return stub_->UpdateJob(context, options, request);
      },
      *current, request, __func__);
}

Status CloudSchedulerConnectionImpl::DeleteJob(
    google::cloud::scheduler::v1::DeleteJobRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteJob(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::scheduler::v1::DeleteJobRequest const& request) {
        return stub_->DeleteJob(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::scheduler::v1::Job>
CloudSchedulerConnectionImpl::PauseJob(
    google::cloud::scheduler::v1::PauseJobRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->PauseJob(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::scheduler::v1::PauseJobRequest const& request) {
        return stub_->PauseJob(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::scheduler::v1::Job>
CloudSchedulerConnectionImpl::ResumeJob(
    google::cloud::scheduler::v1::ResumeJobRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->ResumeJob(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::scheduler::v1::ResumeJobRequest const& request) {
        return stub_->ResumeJob(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::scheduler::v1::Job>
CloudSchedulerConnectionImpl::RunJob(
    google::cloud::scheduler::v1::RunJobRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->RunJob(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::scheduler::v1::RunJobRequest const& request) {
        return stub_->RunJob(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::cloud::location::Location>
CloudSchedulerConnectionImpl::ListLocations(
    google::cloud::location::ListLocationsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListLocations(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::location::Location>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<scheduler_v1::CloudSchedulerRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::location::ListLocationsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context, Options const& options,
                google::cloud::location::ListLocationsRequest const& request) {
              return stub->ListLocations(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::location::ListLocationsResponse r) {
        std::vector<google::cloud::location::Location> result(
            r.locations().size());
        auto& messages = *r.mutable_locations();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::location::Location>
CloudSchedulerConnectionImpl::GetLocation(
    google::cloud::location::GetLocationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetLocation(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::location::GetLocationRequest const& request) {
        return stub_->GetLocation(context, options, request);
      },
      *current, request, __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace scheduler_v1_internal
}  // namespace cloud
}  // namespace google
