// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/run/v2/revision.proto

#include "google/cloud/run/v2/revisions_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace run_v2 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

RevisionsConnectionIdempotencyPolicy::~RevisionsConnectionIdempotencyPolicy() =
    default;

std::unique_ptr<RevisionsConnectionIdempotencyPolicy>
RevisionsConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<RevisionsConnectionIdempotencyPolicy>(*this);
}

Idempotency RevisionsConnectionIdempotencyPolicy::GetRevision(
    google::cloud::run::v2::GetRevisionRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency RevisionsConnectionIdempotencyPolicy::ListRevisions(
    google::cloud::run::v2::ListRevisionsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency RevisionsConnectionIdempotencyPolicy::DeleteRevision(
    google::cloud::run::v2::DeleteRevisionRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency RevisionsConnectionIdempotencyPolicy::ListOperations(
    google::longrunning::ListOperationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency RevisionsConnectionIdempotencyPolicy::GetOperation(
    google::longrunning::GetOperationRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency RevisionsConnectionIdempotencyPolicy::DeleteOperation(
    google::longrunning::DeleteOperationRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency RevisionsConnectionIdempotencyPolicy::WaitOperation(
    google::longrunning::WaitOperationRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<RevisionsConnectionIdempotencyPolicy>
MakeDefaultRevisionsConnectionIdempotencyPolicy() {
  return std::make_unique<RevisionsConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace run_v2
}  // namespace cloud
}  // namespace google
