// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/run/v2/job.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RUN_V2_JOBS_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RUN_V2_JOBS_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/version.h"
#include <google/cloud/run/v2/job.grpc.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace run_v2 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class JobsConnectionIdempotencyPolicy {
 public:
  virtual ~JobsConnectionIdempotencyPolicy();

  /// Create a new copy of this object.
  virtual std::unique_ptr<JobsConnectionIdempotencyPolicy> clone() const;

  virtual google::cloud::Idempotency CreateJob(
      google::cloud::run::v2::CreateJobRequest const& request);

  virtual google::cloud::Idempotency GetJob(
      google::cloud::run::v2::GetJobRequest const& request);

  virtual google::cloud::Idempotency ListJobs(
      google::cloud::run::v2::ListJobsRequest request);

  virtual google::cloud::Idempotency UpdateJob(
      google::cloud::run::v2::UpdateJobRequest const& request);

  virtual google::cloud::Idempotency DeleteJob(
      google::cloud::run::v2::DeleteJobRequest const& request);

  virtual google::cloud::Idempotency RunJob(
      google::cloud::run::v2::RunJobRequest const& request);

  virtual google::cloud::Idempotency GetIamPolicy(
      google::iam::v1::GetIamPolicyRequest const& request);

  virtual google::cloud::Idempotency SetIamPolicy(
      google::iam::v1::SetIamPolicyRequest const& request);

  virtual google::cloud::Idempotency TestIamPermissions(
      google::iam::v1::TestIamPermissionsRequest const& request);

  virtual google::cloud::Idempotency ListOperations(
      google::longrunning::ListOperationsRequest request);

  virtual google::cloud::Idempotency GetOperation(
      google::longrunning::GetOperationRequest const& request);

  virtual google::cloud::Idempotency DeleteOperation(
      google::longrunning::DeleteOperationRequest const& request);

  virtual google::cloud::Idempotency WaitOperation(
      google::longrunning::WaitOperationRequest const& request);
};

std::unique_ptr<JobsConnectionIdempotencyPolicy>
MakeDefaultJobsConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace run_v2
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RUN_V2_JOBS_CONNECTION_IDEMPOTENCY_POLICY_H
