// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/run/v2/job.proto

#include "google/cloud/run/v2/jobs_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace run_v2 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

JobsConnectionIdempotencyPolicy::~JobsConnectionIdempotencyPolicy() = default;

std::unique_ptr<JobsConnectionIdempotencyPolicy>
JobsConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<JobsConnectionIdempotencyPolicy>(*this);
}

Idempotency JobsConnectionIdempotencyPolicy::CreateJob(
    google::cloud::run::v2::CreateJobRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency JobsConnectionIdempotencyPolicy::GetJob(
    google::cloud::run::v2::GetJobRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency JobsConnectionIdempotencyPolicy::ListJobs(
    google::cloud::run::v2::ListJobsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency JobsConnectionIdempotencyPolicy::UpdateJob(
    google::cloud::run::v2::UpdateJobRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency JobsConnectionIdempotencyPolicy::DeleteJob(
    google::cloud::run::v2::DeleteJobRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency JobsConnectionIdempotencyPolicy::RunJob(
    google::cloud::run::v2::RunJobRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency JobsConnectionIdempotencyPolicy::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency JobsConnectionIdempotencyPolicy::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request) {
  return request.policy().etag().empty() ? Idempotency::kNonIdempotent
                                         : Idempotency::kIdempotent;
}

Idempotency JobsConnectionIdempotencyPolicy::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency JobsConnectionIdempotencyPolicy::ListOperations(
    google::longrunning::ListOperationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency JobsConnectionIdempotencyPolicy::GetOperation(
    google::longrunning::GetOperationRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency JobsConnectionIdempotencyPolicy::DeleteOperation(
    google::longrunning::DeleteOperationRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency JobsConnectionIdempotencyPolicy::WaitOperation(
    google::longrunning::WaitOperationRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<JobsConnectionIdempotencyPolicy>
MakeDefaultJobsConnectionIdempotencyPolicy() {
  return std::make_unique<JobsConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace run_v2
}  // namespace cloud
}  // namespace google
