// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/retail/v2/serving_config_service.proto

#include "google/cloud/retail/v2/internal/serving_config_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace retail_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

ServingConfigServiceTracingStub::ServingConfigServiceTracingStub(
    std::shared_ptr<ServingConfigServiceStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::cloud::retail::v2::ServingConfig>
ServingConfigServiceTracingStub::CreateServingConfig(
    grpc::ClientContext& context, Options const& options,
    google::cloud::retail::v2::CreateServingConfigRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.retail.v2.ServingConfigService", "CreateServingConfig");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->CreateServingConfig(context, options, request));
}

Status ServingConfigServiceTracingStub::DeleteServingConfig(
    grpc::ClientContext& context, Options const& options,
    google::cloud::retail::v2::DeleteServingConfigRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.retail.v2.ServingConfigService", "DeleteServingConfig");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->DeleteServingConfig(context, options, request));
}

StatusOr<google::cloud::retail::v2::ServingConfig>
ServingConfigServiceTracingStub::UpdateServingConfig(
    grpc::ClientContext& context, Options const& options,
    google::cloud::retail::v2::UpdateServingConfigRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.retail.v2.ServingConfigService", "UpdateServingConfig");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->UpdateServingConfig(context, options, request));
}

StatusOr<google::cloud::retail::v2::ServingConfig>
ServingConfigServiceTracingStub::GetServingConfig(
    grpc::ClientContext& context, Options const& options,
    google::cloud::retail::v2::GetServingConfigRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.retail.v2.ServingConfigService", "GetServingConfig");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetServingConfig(context, options, request));
}

StatusOr<google::cloud::retail::v2::ListServingConfigsResponse>
ServingConfigServiceTracingStub::ListServingConfigs(
    grpc::ClientContext& context, Options const& options,
    google::cloud::retail::v2::ListServingConfigsRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.retail.v2.ServingConfigService", "ListServingConfigs");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->ListServingConfigs(context, options, request));
}

StatusOr<google::cloud::retail::v2::ServingConfig>
ServingConfigServiceTracingStub::AddControl(
    grpc::ClientContext& context, Options const& options,
    google::cloud::retail::v2::AddControlRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.retail.v2.ServingConfigService", "AddControl");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->AddControl(context, options, request));
}

StatusOr<google::cloud::retail::v2::ServingConfig>
ServingConfigServiceTracingStub::RemoveControl(
    grpc::ClientContext& context, Options const& options,
    google::cloud::retail::v2::RemoveControlRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.retail.v2.ServingConfigService", "RemoveControl");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->RemoveControl(context, options, request));
}

StatusOr<google::longrunning::ListOperationsResponse>
ServingConfigServiceTracingStub::ListOperations(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::ListOperationsRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.retail.v2.ServingConfigService", "ListOperations");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListOperations(context, options, request));
}

StatusOr<google::longrunning::Operation>
ServingConfigServiceTracingStub::GetOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::GetOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.retail.v2.ServingConfigService", "GetOperation");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetOperation(context, options, request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<ServingConfigServiceStub> MakeServingConfigServiceTracingStub(
    std::shared_ptr<ServingConfigServiceStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<ServingConfigServiceTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace retail_v2_internal
}  // namespace cloud
}  // namespace google
