// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/retail/v2/product_service.proto

#include "google/cloud/retail/v2/internal/product_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace retail_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

ProductServiceTracingStub::ProductServiceTracingStub(
    std::shared_ptr<ProductServiceStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::cloud::retail::v2::Product>
ProductServiceTracingStub::CreateProduct(
    grpc::ClientContext& context, Options const& options,
    google::cloud::retail::v2::CreateProductRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.retail.v2.ProductService",
                                     "CreateProduct");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateProduct(context, options, request));
}

StatusOr<google::cloud::retail::v2::Product>
ProductServiceTracingStub::GetProduct(
    grpc::ClientContext& context, Options const& options,
    google::cloud::retail::v2::GetProductRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.retail.v2.ProductService",
                                     "GetProduct");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetProduct(context, options, request));
}

StatusOr<google::cloud::retail::v2::ListProductsResponse>
ProductServiceTracingStub::ListProducts(
    grpc::ClientContext& context, Options const& options,
    google::cloud::retail::v2::ListProductsRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.retail.v2.ProductService",
                                     "ListProducts");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListProducts(context, options, request));
}

StatusOr<google::cloud::retail::v2::Product>
ProductServiceTracingStub::UpdateProduct(
    grpc::ClientContext& context, Options const& options,
    google::cloud::retail::v2::UpdateProductRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.retail.v2.ProductService",
                                     "UpdateProduct");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateProduct(context, options, request));
}

Status ProductServiceTracingStub::DeleteProduct(
    grpc::ClientContext& context, Options const& options,
    google::cloud::retail::v2::DeleteProductRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.retail.v2.ProductService",
                                     "DeleteProduct");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteProduct(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
ProductServiceTracingStub::AsyncPurgeProducts(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::retail::v2::PurgeProductsRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.retail.v2.ProductService",
                                     "PurgeProducts");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncPurgeProducts(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
ProductServiceTracingStub::PurgeProducts(
    grpc::ClientContext& context, Options options,
    google::cloud::retail::v2::PurgeProductsRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.retail.v2.ProductService",
                                     "PurgeProducts");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->PurgeProducts(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
ProductServiceTracingStub::AsyncImportProducts(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::retail::v2::ImportProductsRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.retail.v2.ProductService",
                                     "ImportProducts");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncImportProducts(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
ProductServiceTracingStub::ImportProducts(
    grpc::ClientContext& context, Options options,
    google::cloud::retail::v2::ImportProductsRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.retail.v2.ProductService",
                                     "ImportProducts");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ImportProducts(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
ProductServiceTracingStub::AsyncSetInventory(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::retail::v2::SetInventoryRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.retail.v2.ProductService",
                                     "SetInventory");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncSetInventory(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
ProductServiceTracingStub::SetInventory(
    grpc::ClientContext& context, Options options,
    google::cloud::retail::v2::SetInventoryRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.retail.v2.ProductService",
                                     "SetInventory");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->SetInventory(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
ProductServiceTracingStub::AsyncAddFulfillmentPlaces(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::retail::v2::AddFulfillmentPlacesRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.retail.v2.ProductService",
                                     "AddFulfillmentPlaces");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncAddFulfillmentPlaces(cq, context, std::move(options),
                                             request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
ProductServiceTracingStub::AddFulfillmentPlaces(
    grpc::ClientContext& context, Options options,
    google::cloud::retail::v2::AddFulfillmentPlacesRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.retail.v2.ProductService",
                                     "AddFulfillmentPlaces");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->AddFulfillmentPlaces(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
ProductServiceTracingStub::AsyncRemoveFulfillmentPlaces(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::retail::v2::RemoveFulfillmentPlacesRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.retail.v2.ProductService",
                                     "RemoveFulfillmentPlaces");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncRemoveFulfillmentPlaces(cq, context, std::move(options),
                                                request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
ProductServiceTracingStub::RemoveFulfillmentPlaces(
    grpc::ClientContext& context, Options options,
    google::cloud::retail::v2::RemoveFulfillmentPlacesRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.retail.v2.ProductService",
                                     "RemoveFulfillmentPlaces");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->RemoveFulfillmentPlaces(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
ProductServiceTracingStub::AsyncAddLocalInventories(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::retail::v2::AddLocalInventoriesRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.retail.v2.ProductService",
                                     "AddLocalInventories");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncAddLocalInventories(cq, context, std::move(options),
                                            request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
ProductServiceTracingStub::AddLocalInventories(
    grpc::ClientContext& context, Options options,
    google::cloud::retail::v2::AddLocalInventoriesRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.retail.v2.ProductService",
                                     "AddLocalInventories");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->AddLocalInventories(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
ProductServiceTracingStub::AsyncRemoveLocalInventories(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::retail::v2::RemoveLocalInventoriesRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.retail.v2.ProductService",
                                     "RemoveLocalInventories");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncRemoveLocalInventories(cq, context, std::move(options),
                                               request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
ProductServiceTracingStub::RemoveLocalInventories(
    grpc::ClientContext& context, Options options,
    google::cloud::retail::v2::RemoveLocalInventoriesRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.retail.v2.ProductService",
                                     "RemoveLocalInventories");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->RemoveLocalInventories(context, options, request));
}

StatusOr<google::longrunning::ListOperationsResponse>
ProductServiceTracingStub::ListOperations(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::ListOperationsRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.retail.v2.ProductService",
                                     "ListOperations");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListOperations(context, options, request));
}

StatusOr<google::longrunning::Operation>
ProductServiceTracingStub::GetOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::GetOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.retail.v2.ProductService",
                                     "GetOperation");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetOperation(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
ProductServiceTracingStub::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.longrunning.Operations", "GetOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncGetOperation(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<Status> ProductServiceTracingStub::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.longrunning.Operations",
                                     "CancelOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncCancelOperation(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<ProductServiceStub> MakeProductServiceTracingStub(
    std::shared_ptr<ProductServiceStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<ProductServiceTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace retail_v2_internal
}  // namespace cloud
}  // namespace google
